% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram.R
\name{histogram}
\alias{histogram}
\title{Histogram}
\usage{
histogram(
  vector = NULL,
  breaks = NULL,
  counts = NULL,
  percent = TRUE,
  bin_fill_color = "green4",
  bin_border_color = "black",
  bin_border_thickness = 1,
  notify_na_count = NULL,
  x_axis_tick_marks = NULL,
  y_axis_tick_marks = NULL,
  cap_axis_lines = TRUE,
  x_axis_title = "Value",
  y_axis_title = NULL,
  y_axis_title_vjust = 0.85
)
}
\arguments{
\item{vector}{a numeric vector}

\item{breaks}{a numeric vector indicating breaks for the bins.
By default, no input is required for this argument.}

\item{counts}{a numeric vector containing counts for the bins
(i.e., heights of the bins). By default, no input is required
for this argument.}

\item{percent}{logical. If \code{percent = TRUE}, relative frequency
in percentages will be plotted rather than frequencies (default = TRUE).}

\item{bin_fill_color}{color of the area inside each bin
(default = "green4")}

\item{bin_border_color}{color of the border around each bin
(default = "black")}

\item{bin_border_thickness}{thickness of the border around each bin
(default = 1)}

\item{notify_na_count}{if \code{TRUE}, notify how many observations
were removed due to missing values. By default, NA count will be printed
only if there are any NA values.}

\item{x_axis_tick_marks}{a vector of values at which to place tick marks
on the x axis (e.g., setting \code{x_axis_tick_marks = seq(0, 10, 5)} will
put tick marks at 0, 5, and 10.)}

\item{y_axis_tick_marks}{a vector of values at which to place tick marks
on the y axis (e.g., setting \code{y_axis_tick_marks = seq(0, 10, 5)} will
put tick marks at 0, 5, and 10.)}

\item{cap_axis_lines}{logical. Should the axis lines be capped at the
outer tick marks? (default = FALSE)}

\item{x_axis_title}{title for x axis (default = "Value")}

\item{y_axis_title}{title for y axis (default = "Count" or "Percentage",
depending on the value of \code{percent})}

\item{y_axis_title_vjust}{position of the y axis title (default = 0.85).}
}
\value{
the output will be a histogram, a ggplot object.
}
\description{
Create a histogram based on the output of the \code{hist} function
in the \code{graphics} package.
}
\examples{
\donttest{
histogram(1:100)
histogram(c(1:100, NA))
histogram(vector = mtcars[["mpg"]])
histogram(vector = mtcars[["mpg"]], percent = FALSE)
histogram(vector = mtcars[["mpg"]],
x_axis_tick_marks = c(10, 25, 35), y_axis_title_vjust = 0.5,
y_axis_title = "Freq", x_axis_title = "Values of mpg")
}
}
