% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuzu_load_data.R
\name{kuzu_copy_from_parquet}
\alias{kuzu_copy_from_parquet}
\title{Load Data from a Parquet File into a Kuzu Table}
\usage{
kuzu_copy_from_parquet(conn, file_path, table_name)
}
\arguments{
\item{conn}{A Kuzu connection object.}

\item{file_path}{A string specifying the path to the Parquet file.}

\item{table_name}{A string specifying the name of the destination table in
Kuzu.}
}
\value{
This function is called for its side effect of loading data and does
not return a value.
}
\description{
Loads data from a Parquet file into a specified table in the Kuzu database.
}
\examples{
\donttest{
  if (requireNamespace("arrow", quietly = TRUE)) {
    conn <- kuzu_connection(":memory:")
    kuzu_execute(conn, "CREATE NODE TABLE Country(name STRING, code STRING, 
    PRIMARY KEY (name))")

    # Create a temporary Parquet file
    parquet_file <- tempfile(fileext = ".parquet")
    country_df <- data.frame(name = c("USA", "Canada"), code = c("US", "CA"))
    arrow::write_parquet(country_df, parquet_file)

    # Load data from Parquet
    kuzu_copy_from_parquet(conn, parquet_file, "Country")

    # Verify the data
    result <- kuzu_execute(conn, "MATCH (c:Country) RETURN c.name, c.code")
    print(as.data.frame(result))

    # Clean up the temporary file
    unlink(parquet_file)
  }
}
}
\seealso{
\href{https://kuzudb.github.io/docs/import/parquet/}{Kuzu Parquet Import}
}
