% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hopper_plot.R
\name{hopper_plot}
\alias{hopper_plot}
\title{Hopper plot of the largest residual correlations}
\usage{
hopper_plot(fit, title = NULL, n_max = 15, sep = "___")
}
\arguments{
\item{fit}{A fitted \code{lavaan} object.}

\item{title}{Optional plot title.}

\item{n_max}{Number of variable pairs to show (per group when multi-group).}

\item{sep}{Separator used by \code{.reorder_within()} for multi-group axis
labeling. You usually don't need to change this.}
}
\value{
A \code{ggplot2} object.
}
\description{
Draws a "hopper" plot of the top-\code{n_max} absolute residual correlations
(Bentler type) computed by \code{resid_cor()} — either for a single group or
per-group facets for multi-group models.
}
\examples{
HS.model <- '
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'
fit <- lavaan::cfa(HS.model,
                   data = lavaan::HolzingerSwineford1939)
hopper_plot(fit, n_max = 10)

}
\seealso{
\link{resid_cor}, \link{resid_corrplot}

Other lavDiag-visualization: 
\code{\link{item_plot}()}
}
\concept{lavDiag-visualization}
