% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_data.R
\name{item_data}
\alias{item_data}
\title{Compute Empirical and Model-Based Item Curves with Fit Diagnostics}
\usage{
item_data(
  fit,
  data = NULL,
  info = NULL,
  level = 0.95,
  fam_cont = mgcv::betar(link = "logit"),
  fam_ord = "ocat",
  gam_args_cont = list(method = "REML"),
  gam_args_ord = list(method = "REML", select = TRUE),
  plan = c("auto", "multisession", "multicore", "sequential", "cluster", "none"),
  workers = NULL,
  cluster = NULL,
  progress = FALSE,
  verbose = TRUE,
  store_fits = TRUE
)
}
\arguments{
\item{fit}{A fitted \code{lavaan} or \code{blavaan} model object. Must include latent variables.}

\item{data}{Optional data frame with observed indicators used in the model.
If \code{NULL}, data are taken from the fitted model.}

\item{info}{Optional output of \code{\link{model_info}}. If \code{NULL}, it will be computed automatically.}

\item{level}{Numeric; confidence level for prediction intervals (default = 0.95).}

\item{fam_cont}{A \code{mgcv} family object for continuous indicators
(default = \code{mgcv::betar(link = "logit")}).}

\item{fam_ord}{Accepts either the string \code{"ocat"} or any valid \code{mgcv} family object for ordinal indicators.
In mixed models, the function automatically selects the appropriate branch for each indicator type.}

\item{gam_args_cont}{A named list of arguments passed to GAM fitting for continuous items.}

\item{gam_args_ord}{A named list of arguments passed to GAM fitting for ordinal items.}

\item{plan}{Parallelization backend; one of \code{"auto"}, \code{"multisession"}, \code{"multicore"},
\code{"sequential"}, \code{"cluster"}, or \code{"none"}.}

\item{workers}{Optional integer; number of parallel workers to use.}

\item{cluster}{Optional external cluster object (e.g., from \code{parallel::makeCluster()}).}

\item{progress}{Logical; whether to display a progress bar (default = \code{FALSE}).}

\item{verbose}{Logical; whether to print progress messages (default = \code{TRUE}).}

\item{store_fits}{Logical; whether to store fitted GAM models and use them to compute
predictions for latent grids via \code{prepare()} (default = \code{TRUE}).}
}
\value{
A list with three elements:
\describe{
\item{\code{original_data}}{A \code{tibble} containing the augmented original dataset with both
model-based (\verb{m_est_yhat_*}) and empirical (\verb{e_est_yhat_*}) predictions for each item.}
\item{\code{metrics}}{A \code{tibble} summarizing item-level fit indices for each group and item:
\itemize{
\item \code{r2}, \code{rmse}, \code{mae}: agreement between model and empirical fits.
\item \code{r2_pen}, \code{rmse_pen}, \code{mae_pen}: penalized variants accounting for model complexity.
\item \code{c_m}, \code{c_e}, \code{k_eff}: effective model and empirical complexity measures.
}}
\item{\code{new_data}}{Optional \code{tibble} of latent-grid predictions including empirical
estimates (\verb{e_est_*} etc.); present only when \code{store_fits = TRUE}.}
}
}
\description{
High-level wrapper that combines model-based (from \code{augment()}) and empirical
(from GAM fits) item-level predictions for continuous and ordinal indicators.
For each item, smooth GAM curves are estimated as functions of the latent
variables on which the item loads, optionally in a multi-group setup.

The function returns both the augmented dataset containing model-based and
empirical predictions (\code{original_data}), a table of item-level fit metrics
(\code{metrics}), and optionally predicted empirical values for latent grids
(\code{new_data}).
}
\details{
Internally, the function:
\enumerate{
\item Verifies that the input \code{lavaan}/\code{blavaan} model converged and
contains latent variables.
\item Extracts factor loadings and thresholds per group.
\item Runs parallelized GAM fitting (\code{mgcv::gam}) for each item and group,
using either Gaussian, Beta, or ordinal (\code{ocat}) families.
\item Produces empirical item curves and agreement metrics between
model-based and empirical predictions (R², RMSE, MAE, and penalized variants).
\item Optionally, predicts empirical curves for latent grids produced by \code{prepare()}.
}
}
\section{Parallelization}{

Parallel execution is handled via \code{furrr::future_map()} and controlled by \code{plan},
\code{workers}, and \code{cluster}. Default is \code{"auto"}, which attempts to use an optimal backend
based on the operating system.
}

\section{Agreement Metrics}{

\itemize{
\item \deqn{R^2 = \mathrm{cor}^2(m, e)}
\item \deqn{\mathrm{RMSE} = \sqrt{\frac{1}{n}\sum_{i=1}^{n} (m_i - e_i)^2}}
\item \deqn{\mathrm{MAE} = \frac{1}{n}\sum_{i=1}^{n} |m_i - e_i|}
}
}

\examples{
\donttest{
HS.model <- '
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'
fit <- lavaan::cfa(HS.model,
                   data = lavaan::HolzingerSwineford1939,
                   meanstructure = TRUE)
item_data(fit)
}
}
\seealso{
\code{\link{augment}}, \code{\link{prepare}}, \code{\link{model_info}},
\code{\link[mgcv]{gam}}, \code{\link[furrr]{future_map}}

Other lavDiag-augmenters: 
\code{\link{augment}()},
\code{\link{prepare}()}
}
\concept{lavDiag-augmenters}
