% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bootstrap3}
\alias{bootstrap3}
\title{Bootstrap Standardized hfv_data Datasets}
\usage{
bootstrap3(
  data,
  by_pop = NULL,
  by_patch = NULL,
  by_indiv = NULL,
  prop_size = NULL,
  max_limit = NULL,
  reps = NULL,
  popcol = NULL,
  patchcol = NULL,
  indivcol = NULL,
  rename = NULL
)
}
\arguments{
\item{data}{A data frame of class \code{hfvdata}.}

\item{by_pop}{A logical value indicating whether to sample the data frame
by population. If \code{TRUE}, then the number of individuals sampled for
each population will be set to the respective population's actual number of
individuals; otherwise, population identity is ignored. Defaults to
\code{TRUE}.}

\item{by_patch}{A logical value indicating whether to sample the data frame
by patch. If \code{TRUE}, then the number of individuals sampled for each
patch will be set to the respective patch's actual number of individuals;
otherwise, patch identity is ignored. Defaults to \code{TRUE}.}

\item{by_indiv}{A logical value indicating whether to sample the data frame
by individual identity, or by row. If \code{TRUE}, then samples by
individual identity. Defaults to \code{TRUE}.}

\item{prop_size}{A logical value indicating whether to keep the proportions
of individuals (if \code{by_indiv = TRUE}) or of rows (if \code{by_indiv =
FALSE}) in each bootstrapped dataset to the same proportions across
populations (if \code{by_pop = TRUE}, and patches (if
\code{by_patch = TRUE}, as in the original dataset. If \code{FALSE}, then
allows the specific proportions to be set by argument \code{max_limit}.
Defaults to \code{TRUE}.}

\item{max_limit}{Sets the sample size to pull from the original data frame,
if \code{prop_size = FALSE}. Defaults to the size of the original dataset if
\code{prop_size = TRUE}, and to 100 if if \code{prop_size = FALSE}. Can also
be input as an integer vector giving the number of samples to take by
population (if \code{by_pop = TRUE}), patch (if \code{by_patch = TRUE}), or
population-patch (if \code{by_pop = TRUE} and \code{by_patch = TRUE}).}

\item{reps}{The number of bootstrap replicates to produce. Defaults to
\code{100}.}

\item{popcol}{A string denoting the variable name coding for population
identity in the data frame. Defaults to \code{"popid"}.}

\item{patchcol}{A string denoting the variable name coding for patch
identity in the data frame. Defaults to \code{"patchid"}.}

\item{indivcol}{A string denoting the variable name coding for individual
identity in the data frame. Defaults to \code{"individ"}.}

\item{rename}{A logical value indicating whether to rename individuals as
unique when bootstrapping by individual, even if that individual had been
previously chosen. Defaults to \code{FALSE}, and can only be set to
 \code{TRUE} if \code{by_indiv = TRUE}.}
}
\value{
A list of class \code{hfvlist}, which is composed of data frames of
class \code{hfvdata}.
}
\description{
Function \code{bootstrap3()} takes already standardized \code{hfvdata}
datasets and bootstraps them by individual identity, or by row.
}
\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathboot <- bootstrap3(lathvert, reps = 3)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl"), 
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep"),
  stage1 = c("Sd", "rep", "Sd", "rep", "all", "all"), 
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054),
  type = c(1, 1, 1, 1, 3, 3), type_t12 = c(1, 2, 1, 2, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3_boot <- rlefko3(data = lathboot, stageframe = lathframe,
  year = c(1989, 1990), stages = c("stage3", "stage2", "stage1"),
  supplement = lathsupp3, yearcol = "year2", indivcol = "individ")

}
