# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# mastigouche_poly


library(testthat)

# Test 1: Confirm the object is a list
test_that("mastigouche_poly is a list", {
  expect_type(mastigouche_poly, "list")
})

# Test 2: Confirm it has exactly 2 elements
test_that("mastigouche_poly has 2 elements", {
  expect_equal(length(mastigouche_poly), 2)
})

# Test 3: Confirm element names are correct
test_that("mastigouche_poly has correct element names", {
  expect_named(mastigouche_poly, c("xy", "siteEdge"))
})

# Test 4: Confirm 'xy' element is a data.frame with 2 numeric columns
test_that("mastigouche_poly$xy is a data.frame with numeric coordinates", {
  expect_s3_class(mastigouche_poly$xy, "data.frame")
  expect_named(mastigouche_poly$xy, c("X", "Y"))
  expect_type(mastigouche_poly$xy$X, "double")
  expect_type(mastigouche_poly$xy$Y, "double")
})

# Test 5: Confirm 'xy' has exactly 42 rows
test_that("mastigouche_poly$xy has 42 rows", {
  expect_equal(nrow(mastigouche_poly$xy), 42)
})

# Test 6: Confirm 'siteEdge' is integer
test_that("mastigouche_poly$siteEdge is integer", {
  expect_type(mastigouche_poly$siteEdge, "integer")
})
