% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-fisherian.R
\name{support}
\alias{support}
\alias{support.fisher_mle}
\title{Support Function (Log Relative Likelihood)}
\usage{
support(x, ...)

\method{support}{fisher_mle}(x, theta, data, model, ...)
}
\arguments{
\item{x}{A fisher_mle object}

\item{...}{Additional arguments passed to loglik}

\item{theta}{Parameter value(s) to evaluate}

\item{data}{Data frame used for likelihood computation}

\item{model}{The likelihood model used for fitting}
}
\value{
Support value(s): logL(theta) - logL(theta_hat)
}
\description{
Computes the support for parameter value theta relative to the MLE:
S(theta) = logL(theta) - logL(theta_hat)
}
\details{
The support function is always <= 0, with maximum at the MLE.
Values of theta with support > -2 are considered well-supported.
Values with support > -log(8) ~ -2.08 correspond roughly to a
95\% likelihood interval.
}
