% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsirmgrm.R
\name{lsirmgrm_o}
\alias{lsirmgrm_o}
\title{Fit a single-chain ordinal LSIRM (GRM)}
\usage{
lsirmgrm_o(
  data,
  ncat = NULL,
  missing_data = NA,
  missing.val = 99,
  ndim = 2,
  niter = 15000,
  nburn = 2500,
  nthin = 5,
  nprint = 500,
  jump_beta = 0.4,
  jump_theta = 1,
  jump_gamma = 0.2,
  jump_z = 0.5,
  jump_w = 0.5,
  pr_mean_beta = 0,
  pr_sd_beta = 1,
  pr_mean_theta = 0,
  pr_sd_theta = 1,
  pr_mean_gamma = 0.5,
  pr_sd_gamma = 1,
  pr_a_theta = 0.001,
  pr_b_theta = 0.001,
  fixed_gamma = FALSE,
  spikenslab = FALSE,
  pr_spike_mean = -3,
  pr_spike_sd = 1,
  pr_slab_mean = 0.5,
  pr_slab_sd = 1,
  pr_xi_a = 1,
  pr_xi_b = 1,
  adapt = NULL,
  verbose = FALSE,
  fix_theta_sd = FALSE
)
}
\arguments{
\item{data}{Matrix; an ordinal (ordered categorical) item response matrix. Each row represents a respondent, and
each column represents an item. Values can be either \code{0:(K-1)} or \code{1:K}. Missing values can be \code{NA}.}

\item{ncat}{Integer; number of categories \eqn{K}. If \code{NULL}, it is inferred from the observed data.}

\item{missing_data}{Character; the type of missing data assumed. Options are \code{NA}, \code{"mar"}, or
\code{"mcar"}. If \code{NA} and \code{data} contains missing values, it is set to \code{"mcar"} internally.}

\item{missing.val}{Numeric; numeric code used to represent missing values in the C++ sampler. Default is 99.}

\item{ndim}{Integer; latent space dimension. Default is 2.}

\item{niter}{Integer; total MCMC iterations. Default is 15000.}

\item{nburn}{Integer; burn-in iterations. Default is 2500.}

\item{nthin}{Integer; thinning interval. Default is 5.}

\item{nprint}{Integer; print interval if \code{verbose=TRUE}. Default is 500.}

\item{jump_beta}{Numeric; proposal SD for GRM thresholds. Default is 0.4. During MCMC sampling, threshold proposals are constrained to maintain the ordering \eqn{\beta_{i,1} > \beta_{i,2} > \cdots > \beta_{i,K-1}} for each item.}

\item{jump_theta}{Numeric; proposal SD for theta. Default is 1.}

\item{jump_gamma}{Numeric; proposal SD on log-scale for gamma. Default is 0.2.}

\item{jump_z}{Numeric; proposal SD for z. Default is 0.5.}

\item{jump_w}{Numeric; proposal SD for w. Default is 0.5.}

\item{pr_mean_beta}{Numeric; prior mean for thresholds. Default is 0.}

\item{pr_sd_beta}{Numeric; prior SD for thresholds. Default is 1.}

\item{pr_mean_theta}{Numeric; prior mean for theta. Default is 0.}

\item{pr_sd_theta}{Numeric; prior SD for theta. Default is 1.}

\item{pr_mean_gamma}{Numeric; log-normal prior mean for gamma. Default is 0.5.}

\item{pr_sd_gamma}{Numeric; log-normal prior SD for gamma. Default is 1.}

\item{pr_a_theta}{Numeric; shape for inverse-gamma prior on var(theta). Default is 0.001.}

\item{pr_b_theta}{Numeric; scale for inverse-gamma prior on var(theta). Default is 0.001.}

\item{fixed_gamma}{Logical; if TRUE, fixes \eqn{\gamma = 1} (no sampling). Default is FALSE.}

\item{spikenslab}{Logical; if TRUE, uses spike-and-slab priors for \eqn{\gamma}. Default is FALSE.}

\item{pr_spike_mean}{Numeric; prior mean for the spike component (on log-scale). Default is -3.}

\item{pr_spike_sd}{Numeric; prior SD for the spike component (on log-scale). Default is 1.}

\item{pr_slab_mean}{Numeric; prior mean for the slab component (on log-scale). Default is 0.5.}

\item{pr_slab_sd}{Numeric; prior SD for the slab component (on log-scale). Default is 1.}

\item{pr_xi_a}{Numeric; Beta prior shape a for mixing weight \eqn{\xi}. Default is 1.}

\item{pr_xi_b}{Numeric; Beta prior shape b for mixing weight \eqn{\xi}. Default is 1.}

\item{adapt}{List; optional adaptive MCMC control. If not \code{NULL}, proposal standard deviations are adapted during the burn-in period to reach a target acceptance rate and are held fixed during the main MCMC sampling.
When adaptation is enabled, the reported acceptance ratios in the output (\code{accept_beta}, \code{accept_theta}, etc.) are computed only from iterations after burn-in, reflecting the performance of the adapted proposal distributions.
Elements of the list can include:
\itemize{
  \item \code{use_adapt}: Logical; if \code{TRUE}, adaptive MCMC is used. Default is \code{FALSE}.
  \item \code{adapt_interval}: Integer; the number of iterations between each update of the proposal SDs. Default is \code{100}.
  \item \code{adapt_rate}: Numeric; Robbins-Monro scaling constant (c) in step size formula: adapt_rate / iteration^decay_rate. Default is \code{1.0}. Valid range: any positive value. Recommended: 0.5-2.0.
  \item \code{decay_rate}: Numeric; Robbins-Monro decay exponent (alpha) in step size formula. Default is \code{0.5}. Valid range: (0.5, 1]. Recommended: 0.5-0.8.
  \item \code{target_accept}: Numeric; target acceptance rate for scalar parameters (beta, theta, gamma). Default is \code{0.44}.
  \item \code{target_accept_zw}: Numeric; target acceptance rate for latent positions z and w. Default is \code{0.234}.
  \item \code{target_accept_beta/theta/gamma}: Numeric; (optional) parameter-specific target acceptance rates to override \code{target_accept}.
}}

\item{verbose}{Logical; If TRUE, MCMC progress and parameter samples are printed to the console during execution. Default is FALSE.}

\item{fix_theta_sd}{Logical; If TRUE, the standard deviation of the respondent latent positions \eqn{\theta} is fixed at 1 instead of being sampled. Default is FALSE.}
}
\value{
A list containing MCMC draws and posterior summaries, including:
\itemize{
  \item \code{beta}, \code{theta}, \code{gamma}, \code{z}, \code{w}: MCMC draws.
  \item \code{beta_estimate}, \code{theta_estimate}, \code{gamma_estimate}, \code{z_estimate}, \code{w_estimate}:
  posterior means.
}

If \code{missing_data = "mar"}, the list additionally includes \code{imp} (imputed responses per iteration for each
missing cell) and \code{imp_estimate} (posterior mean imputation for each missing cell).
}
\description{
\code{\link{lsirmgrm_o}} is the single-chain fitting function used internally by \code{\link{lsirmgrm}}.
}
