% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_functions.R
\name{quick_analysis}
\alias{quick_analysis}
\title{Quick Analysis with Visualization}
\usage{
quick_analysis(
  scale = "huc8",
  year = 2016,
  nutrients = c("nitrogen", "phosphorus"),
  include_wwtp = TRUE,
  output_dir = tempdir(),
  create_maps = TRUE,
  create_networks = TRUE,
  create_comparisons = TRUE,
  create_wwtp_maps = TRUE,
  wwtp_load_units = "kg",
  map_resolution = "medium",
  generate_report = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{scale}{Character. Spatial scale: "county", "huc8", or "huc2"}

\item{year}{Numeric. Year to analyze}

\item{nutrients}{Character vector. Nutrients to analyze: c("nitrogen", "phosphorus") or subset}

\item{include_wwtp}{Logical. Whether to include WWTP analysis (default: TRUE)}

\item{output_dir}{Character. Output directory (default: tempdir())}

\item{create_maps}{Logical. Whether to create classification maps (default: TRUE)}

\item{create_networks}{Logical. Whether to create network plots (default: TRUE)}

\item{create_comparisons}{Logical. Whether to create comparison plots (default: TRUE)}

\item{create_wwtp_maps}{Logical. Whether to create WWTP facility maps (default: TRUE)}

\item{wwtp_load_units}{Character. Units for WWTP loads if using custom data (default: "kg")}

\item{map_resolution}{Character. Map resolution: "low", "medium", "high" (default: "medium")}

\item{generate_report}{Logical. Whether to generate HTML report (default: FALSE)}

\item{verbose}{Logical. Whether to print progress messages (default: TRUE)}

\item{...}{Additional arguments passed to run_builtin_analysis}
}
\value{
List with results and file paths of created visualizations
}
\description{
Run analysis and automatically generate key visualizations for specified nutrients.
This is a convenience function that combines run_builtin_analysis with automatic
visualization generation.
}
\examples{
\donttest{
# Quick analysis with all visualizations (2007-2016 WWTP available)
results <- quick_analysis(
  scale = "huc8",
  year = 2012,  # Use valid year
  nutrients = c("nitrogen", "phosphorus"),
  include_wwtp = TRUE,
  generate_report = TRUE
)

# Agricultural only analysis for pre-WWTP year
results <- quick_analysis(
  scale = "county",
  year = 2005,  # Before WWTP data
  nutrients = "nitrogen",
  include_wwtp = FALSE,
  create_networks = FALSE
)

# High-resolution analysis with expanded year range
results <- quick_analysis(
  scale = "huc8",
  year = 2008,  # Use valid WWTP year
  nutrients = "phosphorus",
  include_wwtp = TRUE,
  map_resolution = "high"
)
}
}
