% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{carbon}
\alias{carbon}
\alias{carbon_sugarStarchDynamicsLeaf}
\alias{carbon_sugarStarchDynamicsStem}
\alias{carbon_osmoticWaterPotential}
\alias{carbon_sugarConcentration}
\alias{carbon_relativeSapViscosity}
\alias{carbon_leafStructuralBiomass}
\alias{carbon_leafStarchCapacity}
\alias{carbon_sapwoodStructuralBiomass}
\alias{carbon_sapwoodStructuralLivingBiomass}
\alias{carbon_sapwoodStarchCapacity}
\alias{carbon_carbonCompartments}
\title{Carbon-related functions}
\usage{
carbon_sugarStarchDynamicsLeaf(sugarConc, starchConc, eqSugarConc)

carbon_sugarStarchDynamicsStem(sugarConc, starchConc, eqSugarConc)

carbon_osmoticWaterPotential(sugarConc, temp, nonSugarConc)

carbon_sugarConcentration(osmoticWP, temp, nonSugarConc)

carbon_relativeSapViscosity(sugarConc, temp)

carbon_leafStructuralBiomass(LAI, N, SLA)

carbon_leafStarchCapacity(LAI, N, SLA, leafDensity)

carbon_sapwoodStructuralBiomass(SA, H, L, V, woodDensity)

carbon_sapwoodStructuralLivingBiomass(
  SA,
  H,
  L,
  V,
  woodDensity,
  conduit2sapwood
)

carbon_sapwoodStarchCapacity(SA, H, L, V, woodDensity, conduit2sapwood)

carbon_carbonCompartments(x, biomassUnits = "g_m2")
}
\arguments{
\item{sugarConc}{Concentration of soluble sugars (mol/l).}

\item{starchConc}{Concentration of starch (mol/l)}

\item{eqSugarConc}{Equilibrium concentration of soluble sugars (mol/l).}

\item{temp}{Temperature (degrees Celsius).}

\item{nonSugarConc}{Concentration of inorganic solutes (mol/l).}

\item{osmoticWP}{Osmotic water potential (MPa).}

\item{LAI}{Leaf area index.}

\item{N}{Density (ind·ha-1).}

\item{SLA}{Specific leaf area (mm2/mg = m2/kg).}

\item{leafDensity}{Density of leaf tissue (dry weight over volume).}

\item{SA}{Sapwood area (cm2).}

\item{H}{Plant height (cm).}

\item{L}{Coarse root length (mm) for each soil layer.}

\item{V}{Proportion of fine roots in each soil layer.}

\item{woodDensity}{Wood density (dry weight over volume).}

\item{conduit2sapwood}{Proportion of sapwood corresponding to conducive elements (vessels or tracheids) as opposed to parenchymatic tissue.}

\item{x}{An object of class \code{\link{growthInput}}.}

\item{biomassUnits}{A string for output biomass units, either "g_ind" (g per individual) or "g_m2" (g per square meter).}
}
\value{
Values returned for each function are:
\itemize{
\item{\code{carbon_leafStarchCapacity}: Capacity of storing starch in the leaf compartment (mol gluc/ind.).}
\item{\code{carbon_leafStructuralBiomass}: Leaf structural biomass (g dry/ind.)}
\item{\code{carbon_sapwoodStarchCapacity}: Capacity of storing starch in the sapwood compartment (mol gluc/ind.).}
\item{\code{carbon_sapwoodStructuralBiomass}: Sapwood structural biomass (g dry/ind.)}
\item{\code{carbon_sapwoodStructuralLivingBiomass}: Living sapwood (parenchyma) structural biomass (g dry/ind.)}
\item{\code{carbon_sugarConcentration}: Sugar concentration (mol gluc/l)}
\item{\code{carbon_osmoticWaterPotential}: Osmotic component of water potential (MPa)}
\item{\code{carbon_relativeSapViscosity}: Relative viscosity of sapwood with respect to pure water (according to Forst et al. (2002)).}
\item{\code{carbon_sugarStarchDynamicsLeaf}: Rate of conversion from sugar to starch in leaf (mol gluc/l/s).}
\item{\code{carbon_sugarStarchDynamicsStem}: Rate of conversion from sugar to starch in leaf (mol gluc/l/s).}
\item{\code{carbon_carbonCompartments}: A data frame with the size of compartments for each plant cohort, in the specified units.}
}
}
\description{
Low-level functions used in the calculation of carbon balance.
}
\references{
Forst P, Wermer F, Delgado A (2002). On the pressure dependence of the viscosity of aqueous sugar solutions. Rheol Acta 41: 369–374 DOI 10.1007/s00397-002-0238-y
}
\seealso{
\code{\link{growth}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
\keyword{internal}
