% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-group.R
\name{get_group_members}
\alias{get_group_members}
\title{Get the members from a meetup group}
\usage{
get_group_members(
  urlname,
  max_results = NULL,
  handle_multiples = "list",
  extra_graphql = NULL,
  asis = FALSE,
  ...
)
}
\arguments{
\item{urlname}{Character. The name of the group as indicated in the
\url{https://www.meetup.com/} url.}

\item{max_results}{Maximum number of results to return. If set to NULL,
will return all available results (may take a long time).}

\item{handle_multiples}{Character. How to handle multiple matches. One of
"list" or "first", or "error".
If "list", return a list-column with all matches.
If "first", return only the first match.}

\item{extra_graphql}{A graphql object. Extra objects to return}

\item{asis}{Return the raw API response as-is without processing}

\item{...}{Should be empty. Used for parameter expansion}
}
\value{
A tibble with group members
}
\description{
Get the members from a meetup group
}
\examples{
\dontshow{
vcr::insert_example_cassette("get_group_members", package = "meetupr")
meetupr:::mock_if_no_auth()
}
get_group_members("rladies-lagos")
\dontshow{
vcr::eject_cassette()
}
}
