% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{tree}
\alias{tree}
\title{Print the Structure of a Directory Tree}
\usage{
tree(path, max.level = 2, level = 0, prefix = "")
}
\arguments{
\item{path}{The root path from which to start listing the directory
structure.}

\item{max.level}{The maximum depth of directories to list.}

\item{level}{Internal parameter used for recursion, indicating the current
level of depth.}

\item{prefix}{Internal parameter used for formatting the printed tree
structure.}
}
\value{
NULL, called for its side effect of printing the directory structure.
}
\description{
Prints the structure of a directory tree up to a specified maximum level of
depth. It lists all files and directories under the specified path,
displaying them in a tree-like structure.
}
\examples{
metabodecon_dir <- system.file(package = "metabodecon")
tree(metabodecon_dir, max.level = 1)
}
\author{
2024-2025 Tobias Schmidt: initial version.
}
