% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScalorFixedProjections.R
\name{scalarizer_chebyshev}
\alias{scalarizer_chebyshev}
\title{Chebyshev Scalarizer}
\usage{
scalarizer_chebyshev(rho = 0.05)
}
\arguments{
\item{rho}{(\code{numeric(1)})\cr
Small positive value.}
}
\value{
a \code{\link{Scalarizer}} object.
}
\description{
Constructs a \code{\link{Scalarizer}} that does Chebyshev scalarization, as employed in ParEGO by Knowles (2006).

The Chebyshev scalarization for a single individual with
fitness values \code{f} and given weight vector \code{w} is
\code{min(w * f) + rho * sum(w * f)}, where \code{rho} is a hyperparameter
given during construction.
}
\examples{
# fitnesses: three rows (i.e. thee indivs) with two objective values each
fitnesses <- matrix(0:5, ncol = 2)

# weights: contains one matrix for each row of 'fitnesses' (i.e. each indiv)
# which get multiplied with their respective row.
weights <- list(
 matrix(c(1, 0, 0, 1), ncol = 2),
 matrix(c(1, 2, 0, 0), ncol = 2),
 matrix(c(0, 1, 0, 1), ncol = 2)
)

sc <- scalarizer_chebyshev()

# The resulting row-vectors are the different scalarizations according to the
# columns in the 'weights' matrices.
sc(fitnesses, weights)

sc <- scalarizer_chebyshev(rho = 0.1)
sc(fitnesses, weights)
}
\references{
Knowles, Joshua (2006).
\dQuote{ParEGO: A hybrid algorithm with on-line landscape approximation for expensive multiobjective optimization problems.}
\emph{IEEE Transactions on Evolutionary Computation}, \bold{10}(1), 50--66.
}
\seealso{
Other Scalarizers: 
\code{\link{Scalarizer}},
\code{\link{scalarizer_linear}()}
}
\concept{Scalarizers}
