% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promises.R
\name{as.promise.mirai}
\alias{as.promise.mirai}
\title{Make mirai Promise}
\usage{
\method{as.promise}{mirai}(x)
}
\arguments{
\item{x}{(mirai) object to convert to promise.}
}
\value{
A 'promise' object.
}
\description{
Creates a 'promise' from a 'mirai'. S3 method for \code{promises::as.promise()}.
}
\details{
Allows a 'mirai' to be used with the promise pipe \verb{\%...>\%}, scheduling a
function to run upon resolution.

Requires the \pkg{promises} package.
}
\examples{
\dontshow{if (interactive() && requireNamespace("promises", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(promises)

p <- as.promise(mirai("example"))
print(p)
is.promise(p)

p2 <- mirai("completed") \%...>\% identity()
p2$then(cat)
is.promise(p2)
\dontshow{\}) # examplesIf}
}
