% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_utils.R
\name{validate_approximation}
\alias{validate_approximation}
\title{Validate Moment-Matching Approximation}
\usage{
validate_approximation(mm_result, n_sim = 10000, seed = NULL)
}
\arguments{
\item{mm_result}{Result from any mm_tdiff function}

\item{n_sim}{Number of simulations for validation (default: 10000)}

\item{seed}{Random seed for reproducibility}
}
\value{
A list containing validation metrics
}
\description{
Validates the approximation quality by comparing moments of the
approximated distribution with the theoretical moments.
}
\examples{
result <- mm_tdiff_univariate(0, 1, 10, 0, 1.5, 15)
validation <- validate_approximation(result)
print(validation)

}
