% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-adam_params.R
\name{adam_params}
\alias{adam_params}
\alias{ets_model}
\alias{loss}
\alias{use_constant}
\alias{regressors_treatment}
\alias{outliers_treatment}
\alias{probability_model}
\alias{distribution}
\alias{information_criteria}
\alias{select_order}
\title{Tuning Parameters for ADAM Models}
\usage{
ets_model(values = c("ZZZ", "XXX", "YYY", "CCC", "PPP", "FFF"))

loss(
  values = c("likelihood", "MSE", "MAE", "HAM", "LASSO", "RIDGE", "TMSE", "GTMSE",
    "MSEh", "MSCE")
)

use_constant(values = c(FALSE, TRUE))

regressors_treatment(values = c("use", "select", "adapt"))

outliers_treatment(values = c("ignore", "use", "select"))

probability_model(
  values = c("none", "auto", "fixed", "general", "odds-ratio", "inverse-odds-ratio",
    "direct")
)

distribution(
  values = c("default", "dnorm", "dlaplace", "ds", "dgnorm", "dlnorm", "dinvgauss",
    "dgamma")
)

information_criteria(values = c("AICc", "AIC", "BICc", "BIC"))

select_order(values = c(FALSE, TRUE))
}
\arguments{
\item{values}{A character string of possible values.}
}
\value{
A \code{dials} parameter

A parameter

A parameter

A parameter

A parameter

A parameter

A parameter

A parameter

A parameter

A parameter
}
\description{
Tuning Parameters for ADAM Models
}
\details{
The main parameters for ADAM models are:
\itemize{
\item \code{ets_model}:
\itemize{
\item model="ZZZ" means that the model will be selected based on the chosen information criteria type. The Branch and Bound is used in the process.
\item model="XXX" means that only additive components are tested, using Branch and Bound.
\item model="YYY" implies selecting between multiplicative components.
\item model="CCC" triggers the combination of forecasts of models using information criteria weights (Kolassa, 2011).
\item combinations between these four and the classical components are also accepted. For example, model="CAY" will combine models with additive trend and either none or multiplicative seasonality.
\item model="PPP" will produce the selection between pure additive and pure multiplicative models. "P" stands for "Pure". This cannot be mixed with other types of components.
\item model="FFF" will select between all the 30 types of models. "F" stands for "Full". This cannot be mixed with other types of components.
\item The parameter model can also be a vector of names of models for a finer tuning (pool of models). For example, model=c("ANN","AAA") will estimate only two models and select the best of them.
}
\item \code{loss}:
\itemize{
\item likelihood - the model is estimated via the maximization of the likelihood of the function specified in distribution;
\item MSE (Mean Squared Error),
\item MAE (Mean Absolute Error),
\item HAM (Half Absolute Moment),
\item LASSO - use LASSO to shrink the parameters of the model;
\item RIDGE - use RIDGE to shrink the parameters of the model;
\item TMSE - Trace Mean Squared Error,
\item GTMSE - Geometric Trace Mean Squared Error,
\item MSEh - optimisation using only h-steps ahead error,
\item MSCE - Mean Squared Cumulative Error.
}
\item \code{non_seasonal_ar}: The order of the non-seasonal auto-regressive (AR) terms.
\item \code{non_seasonal_differences}: The order of integration for non-seasonal differencing.
\item \code{non_seasonal_ma}: The order of the non-seasonal moving average (MA) terms.
\item \code{seasonal_ar}: The order of the seasonal auto-regressive (SAR) terms.
\item \code{seasonal_differences}: The order of integration for seasonal differencing.
\item \code{seasonal_ma}: The order of the seasonal moving average (SMA) terms.
\item \code{use_constant}: Logical, determining, whether the constant is needed in the model or not.
\item \code{regressors_treatment}: The variable defines what to do with the provided explanatory variables.
\item \code{outliers_treatment}: Defines what to do with outliers.
\item \code{probability_model}: The type of model used in probability estimation.
\item \code{distribution}: What density function to assume for the error term.
\item \code{information_criteria}: The information criterion to use in the model selection / combination procedure.
\item \code{select_order}: If TRUE, then the function will select the most appropriate order.
}
}
\examples{
use_constant()

regressors_treatment()

distribution()


}
