% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_insource_ions}
\alias{filter_insource_ions}
\title{Filter Insource ions}
\usage{
filter_insource_ions(
  mpactr_object,
  cluster_threshold = 0.95,
  copy_object = FALSE
)
}
\arguments{
\item{mpactr_object}{An \code{mpactr_object}. See \code{\link[=import_data]{import_data()}}.}

\item{cluster_threshold}{Cluster threshold for ion deconvolution.
Default = 0.95.}

\item{copy_object}{A \code{boolean} parameter that allows users to return
a copied object instead of modifying the object.}
}
\value{
an \code{mpactr_object}
}
\description{
\code{filter_insource_ions()} identifies and removes in-source ion clusters based
on a Pearson correlation threshold. Groups of co-eluting features with
identical retention time are identified and used to generate Pearson
correlation matrices. Clusters with self-similarity greater than the
user-defined \code{cluster_threshold} within these matrices are identified as
likely belonging to a single precursor ion and is associated insource ion.
Highly correlated ions are identified and removed.

\code{copy_object}: mpactr is built on an R6 class-system, meaning it operates on
reference semantics in which data is updated \emph{in-place}. Compared to a
shallow copy, where only data pointers are copied, or a deep copy, where
the entire data object is copied in memory, any changes to the original
data object, regardless if they are assigned to a new object, result in
changes to the original data object. We recommend using the default
\code{copy_object = FALSE} as this makes for an extremely fast and
memory-efficient way to chain mpactr filters together; however, if you
would like to run the filters individually with traditional R style objects,
you can set \code{copy_object} to \code{TRUE} as shown in the filter examples.
}
\examples{
 \dontshow{
limit_cores()
}
data <- import_data(
  example_path("coculture_peak_table.csv"),
  example_path("metadata.csv"),
  format = "Progenesis"
)

data_filter <- filter_insource_ions(data,
  cluster_threshold = 0.95
)

}
