% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_theory.R
\name{primeform}
\alias{primeform}
\title{Prime form of a set using Rahn's algorithm}
\usage{
primeform(set, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric vector of same length as \code{set}
}
\description{
Takes a set (in any order, inversion, and transposition) and returns the
canonical ("prime") form that represents the \eqn{T_n /T_n I}-type to which the
set belongs. Uses the algorithm from Rahn 1980 rather than Forte 1973.
}
\details{
In principle this should work for sets in continuous pitch-class space,
not just those in a mod k universe. But watch out for rounding errors:
if you can manage to work with integer values, that's probably safer.
Otherwise, try rounding your set to various decimal places to test for
consistency of result.
}
\examples{
primeform(c(0, 3, 4, 8))
primeform(c(0, 1, 3, 7, 8))
primeform(c(0, 3, 6, 9, 12, 14), edo=16)
}
