% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_automatic.R
\name{Separate_Multi_FMVMR_twosample_simple}
\alias{Separate_Multi_FMVMR_twosample_simple}
\title{Separate univariable two-sample FMR (internal)}
\usage{
Separate_Multi_FMVMR_twosample_simple(
  Gmatrix1,
  Gmatrix2 = NULL,
  res1,
  res2,
  by_used1,
  by_used2 = NULL,
  sy_used1,
  sy_used2 = NULL,
  ny_used,
  max_nPC1 = NA,
  max_nPC2 = NA,
  X1Ymodel = NA,
  X2Ymodel = NA,
  basis = "eigenfunction"
)
}
\arguments{
\item{Gmatrix1}{Genetic instrument matrix from exposure 1 (N × J1)}

\item{Gmatrix2}{Genetic instrument matrix from exposure 2 (N × J2) or NULL}

\item{res1}{FPCA result for exposure 1}

\item{res2}{FPCA result for exposure 2}

\item{by_used1}{Vector of SNP-outcome effect estimates (betas for X1) from the outcome GWAS, length J}

\item{by_used2}{Vector of SNP-outcome effect estimates (betas for X2) from the outcome GWAS, length J or NULL}

\item{sy_used1}{Vector of standard errors for SNP-outcome effects for X1, length J}

\item{sy_used2}{Vector of standard errors for SNP-outcome effects for X2, length J or NULL}

\item{ny_used}{Sample size of the outcome GWAS}

\item{max_nPC1}{Maximum number of principal components to retain for exposure 1 (NA = select automatically)}

\item{max_nPC2}{Maximum number of principal components to retain for exposure 2 (NA = select automatically)}

\item{X1Ymodel}{True effect model for X1 on Y (for simulation only)}

\item{X2Ymodel}{True effect model for X2 on Y (for simulation only)}

\item{basis}{Basis type for functional representation: "eigenfunction" or "polynomial"}
}
\value{
List with separate estimation results for both exposures
}
\description{
Separate univariable two-sample FMR (internal)
}
