% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_composition.R
\name{cc_composition}
\alias{cc_composition}
\title{Get peptides and peptide-to-protein mappings for each connected component}
\usage{
cc_composition(cc.proteins, incM)
}
\arguments{
\item{cc.proteins}{a \code{list} of \code{vectors} (one for each connected
component), each enumerating the proteins members of a connected component.}

\item{incM}{a \code{logical} \code{matrix} containing the incidence matrix
with its column and row names (respectively, protein and peptide identifiers)
names and 0 or 1 values indicating whether or not the peptide maps on the
corresponding protein.}
}
\value{
a \code{list} of two elements: i. a \code{list} of \code{vectors}
(one for each connected component) enumerating peptides mapping on protein
members of each connected component; ii. a \code{list} of \code{matrices} or
\code{vectors} (one for each connected component) representing
peptide-to-protein mappings for each connected component; matrices are used
if multiple peptides identify protein members of that connected component,
vectors if only a single peptide.
}
\description{
Get peptides and peptide-to-protein mappings for each connected component.
For each connected component, first extract its protein members; then,
extract all specific and shared peptides mapping on those protein; finally,
extract the subset of incidence matrix representing peptide-to-protein
mappings.
}
\examples{
# Read the tab-delimited file containing the proteome incidence matrix
incM_filename <- system.file("extdata"
                             , "incM_example"
                             , package = "net4pg"
                             , mustWork = TRUE)
rownames_filename <- system.file("extdata"
                                  , "peptideIDs_incM_example"
                                  , package = "net4pg"
                                  , mustWork = TRUE)
colnames_filename <- system.file("extdata"
                                 , "proteinIDs_incM_example"
                                 , package = "net4pg"
                                 , mustWork = TRUE)
incM <- read_inc_matrix(incM_filename = incM_filename
                 , colnames_filename = colnames_filename
                 , rownames_filename = rownames_filename)
# Only retain proteins with at least one shared peptide and all peptides
# mapping on such proteins.
incM_reduced <- reduce_inc_matrix(incM)
# Generate adjacency matrix describing protein-to-protein mappings
adjM <- get_adj_matrix(incM_reduced)
# Generate graph of protein-to-protein connections and calculate its
# connected component
multProteinCC <- get_cc(adjM)
# For each connected component, extract peptides mapping on its protein
# members and the subset of the incidence matrix describing peptide-to-protein
# mapping
cc.peptides.incM <- cc_composition(cc.proteins = multProteinCC$cc
                                  , incM = incM)

}
\author{
Laura Fancello
}
