% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNestedApprox.R
\name{approxSummary}
\alias{approxSummary}
\title{Main class for nested approximation information}
\description{
This class holds the result of \code{runNestedApprox} and provides
methods for improving and extending inference using the nested approximation.
}
\details{
See \code{\link{runNestedApprox}} for an overview of usage, including
example usage of the methods. Each method has an accompanying wrapper
function (with the same name)  that takes the \code{approxSummary}
object as its first argument, with the remaining arguments the same
as for the method. See the help information on the accompanying function
for more detailed information, e.g., \code{\link{improveParamMarginals}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-approxSummary-new}{\code{approxSummary$new()}}
\item \href{#method-approxSummary-generateParamsMatrix}{\code{approxSummary$generateParamsMatrix()}}
\item \href{#method-approxSummary-print}{\code{approxSummary$print()}}
\item \href{#method-approxSummary-setParamGrid}{\code{approxSummary$setParamGrid()}}
\item \href{#method-approxSummary-improveParamMarginals}{\code{approxSummary$improveParamMarginals()}}
\item \href{#method-approxSummary-calcMarginalLogLikImproved}{\code{approxSummary$calcMarginalLogLikImproved()}}
\item \href{#method-approxSummary-sampleParams}{\code{approxSummary$sampleParams()}}
\item \href{#method-approxSummary-sampleLatents}{\code{approxSummary$sampleLatents()}}
\item \href{#method-approxSummary-qmarginal}{\code{approxSummary$qmarginal()}}
\item \href{#method-approxSummary-rmarginal}{\code{approxSummary$rmarginal()}}
\item \href{#method-approxSummary-dmarginal}{\code{approxSummary$dmarginal()}}
\item \href{#method-approxSummary-emarginal}{\code{approxSummary$emarginal()}}
\item \href{#method-approxSummary-plotMarginal}{\code{approxSummary$plotMarginal()}}
\item \href{#method-approxSummary-clone}{\code{approxSummary$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-new"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$new(
  approx,
  quantiles,
  expectations,
  marginalsApprox,
  marginalsRaw,
  indivParamTransforms,
  originalScale,
  marginalLogLik,
  marginalLogLikImproved,
  samples,
  paramSamples
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-generateParamsMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-generateParamsMatrix}{}}}
\subsection{Method \code{generateParamsMatrix()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$generateParamsMatrix()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-print"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-setParamGrid"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-setParamGrid}{}}}
\subsection{Method \code{setParamGrid()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$setParamGrid(summary, quadRule = "NULL", nQuad = -1, prune = -1)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-improveParamMarginals"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-improveParamMarginals}{}}}
\subsection{Method \code{improveParamMarginals()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$improveParamMarginals(
  nodes,
  nMarginalGrid = 5,
  nQuad = 3,
  quadRule = "NULL",
  prune = -1,
  transform = "spectral"
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-calcMarginalLogLikImproved"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-calcMarginalLogLikImproved}{}}}
\subsection{Method \code{calcMarginalLogLikImproved()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$calcMarginalLogLikImproved()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-sampleParams"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-sampleParams}{}}}
\subsection{Method \code{sampleParams()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$sampleParams(n = 1000, matchMarginals = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-sampleLatents"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-sampleLatents}{}}}
\subsection{Method \code{sampleLatents()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$sampleLatents(n = 1000, includeParams = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-qmarginal"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-qmarginal}{}}}
\subsection{Method \code{qmarginal()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$qmarginal(node, quantiles = c(0.025, 0.25, 0.5, 0.75, 0.975))}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-rmarginal"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-rmarginal}{}}}
\subsection{Method \code{rmarginal()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$rmarginal(node, n = 1000)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-dmarginal"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-dmarginal}{}}}
\subsection{Method \code{dmarginal()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$dmarginal(node, x, log = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-emarginal"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-emarginal}{}}}
\subsection{Method \code{emarginal()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$emarginal(node, functional, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-plotMarginal"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-plotMarginal}{}}}
\subsection{Method \code{plotMarginal()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$plotMarginal(
  node,
  log = FALSE,
  xlim = NULL,
  ngrid = 200,
  add = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-approxSummary-clone"></a>}}
\if{latex}{\out{\hypertarget{method-approxSummary-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{approxSummary$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
