% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{poa_lhd_concordance}
\alias{poa_lhd_concordance}
\title{Concordance between postal areas and local health districts.}
\format{
An object of class \code{data.frame} with 825 rows and 5 columns.
}
\source{
Computed using the same source datasets as \code{lhd} and \code{poa_nsw}.
}
\usage{
poa_lhd_concordance
}
\description{
Contains the other administrative geometries which intersect with the local
health district boundaries, along with the size of the intersection.
}
\details{
For geographic regions used by the Australian Bureau of Statistics (ABS), the
ABS publishes \href{https://www.abs.gov.au/statistics/standards/australian-statistical-geography-standard-asgs-edition-3/jul2021-jun2026/access-and-downloads/correspondences}{correspondence files}.
These files compare how two different types of regions align with each other.
The Australian Government Department of Health and Aged Care published
analogous \href{https://www.health.gov.au/resources/collections/primary-health-networks-phns-collection-of-concordance-files}{concordance files}
for primary health networks (PHNs).
These are useful for mapping between different types of administrative
districts.
There does not appear to be a publicly available set of concordance files for
New South Wales local health district geographies.

The concordance was computed here by intersecting the ABS geometries with the
local health district geometries. The fraction of the ABS geometry's area
included in the intersection is reported in the column \code{FRAC_INCLUDED}.
Any intersection with \code{FRAC_INCLUDED} at least 0.01\% was retained.
Area computations were performed in \code{crs_gda2020_albers()} (EPSG 9473 equal
area Albers) coordinates at the original reolution of the source data.

Note that \href{https://www.abs.gov.au/ausstats/abs@.nsf/Lookup/by\%20Subject/1270.0.55.003~July\%202016~Main\%20Features~Postal\%20Areas\%20(POA)~8}{postal areas}
are not precisely the same as postcodes used by Australia Post, however they
are very similar.
}
\examples{
library(dplyr)

# postcodes that overlap with Murrumbidgee LHD
poa_lhd_concordance |>
  filter(lhd_name == "Murrumbidgee", FRAC_INCLUDED > 0.005) |>
  arrange(desc(FRAC_INCLUDED)) |>
  pull(POA_NAME_2021)

# extract the main LHD for each postcode
poa_lhd_concordance |>
  arrange(desc(FRAC_INCLUDED)) |>
  slice_head(n = 1, by = POA_NAME_2021) |>
  mutate(postcode = POA_NAME_2021, lhd = lhd_name, .keep = "none") |>
  as_tibble()
}
\keyword{datasets}
