% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation_test.R
\name{permutation_test}
\alias{permutation_test}
\title{Run permutation test on PCA analysis.}
\usage{
permutation_test(
  pca_data,
  pc_n = 5,
  n = 100,
  scale = TRUE,
  cor.method = "pearson"
)
}
\arguments{
\item{pca_data}{data fed to the \code{prcomp} function. Remove non-continuous variables.}

\item{pc_n}{the number of PCs to collect variance explained from.}

\item{n}{the number of times to permute that data. \strong{Warning:} high values
will take a long time to compute.}

\item{scale}{whether the PCA variables should be scaled (default = TRUE).}

\item{cor.method}{method to use for correlations (default = "pearson").
Alternative is "spearman".}
}
\value{
object of class \code{permutation_test}
\itemize{
\item \verb{$permuted_variances} n x pc_no matrix of variances explained by first
pc_no PCs in n permutations of original data.
\item \verb{$permuted_correlations} list of length n of significant pairwise
correlations in n permutations of the data (<= 0.05).
\item \verb{$actual_variances} pc_n x 2 tibble of variances explained by first pc_n
PCs with original data.
\item \verb{$actual_correlations} the number of significant pairwise correlations (<=
0.05) in the original data.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} Permute data fed to PCA a given number of times, collecting the number of
significant pairwise correlations in the permuted data and the variances
explained for a given number of PCs.
}
\details{
This function is now superseded. Use \code{\link[=correlation_test]{correlation_test()}} for pairwise
correlations and \code{\link[=pca_test]{pca_test()}} for variance explained and loadings.
}
\examples{
permutation_test(
  onze_intercepts |> dplyr::select(-speaker),
  pc_n = 5,
  n = 10,
  scale = TRUE,
  cor.method = 'pearson'
 )

}
