% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odiff_run.R
\name{ignore_region}
\alias{ignore_region}
\title{Create an Ignore Region}
\usage{
ignore_region(x1, y1, x2, y2)
}
\arguments{
\item{x1}{Integer; x-coordinate of the top-left corner.}

\item{y1}{Integer; y-coordinate of the top-left corner.}

\item{x2}{Integer; x-coordinate of the bottom-right corner.}

\item{y2}{Integer; y-coordinate of the bottom-right corner.}
}
\value{
A list with components \code{x1}, \code{y1}, \code{x2}, \code{y2}.
}
\description{
Helper function to create a region specification for use with
\code{\link[=odiff_run]{odiff_run()}} and \code{\link[=compare_images]{compare_images()}}.
}
\examples{
# Create a region to ignore
region <- ignore_region(10, 10, 100, 50)

# Use with odiff_run
\dontrun{
result <- odiff_run("img1.png", "img2.png",
                    ignore_regions = list(region))
}
}
