% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-person.R
\name{orcid_bio}
\alias{orcid_bio}
\title{Retrieve biography from ORCID}
\usage{
orcid_bio(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{biography}{Biography text}
\item{visibility}{Visibility setting (public, limited, private)}
}
Returns a data.table with NA biography if not available.
}
\description{
Fetches just the biography/about text for an ORCID record. This is a
simplified alternative to \code{\link{orcid_person}} when you only need
the biography text.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/biography}
}
\examples{
\dontrun{
# Fetch biography only
bio <- orcid_bio("0000-0002-1825-0097")
print(bio$biography)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_person}}
}
