% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/root.R
\name{orderly_init}
\alias{orderly_init}
\title{Initialise an orderly repository}
\usage{
orderly_init(
  root = ".",
  path_archive = "archive",
  use_file_store = FALSE,
  require_complete_tree = FALSE,
  force = FALSE
)
}
\arguments{
\item{root}{The path to initialise the repository root at.  If the
repository is already initialised, this operation checks that
the options passed in are the same as those set in the
repository (erroring if not), but otherwise does nothing.  The
default path is the current working directory.}

\item{path_archive}{Path to the archive directory, used to store
human-readable copies of packets.  If \code{NULL}, no such copy is
made, and \code{file_store} must be \code{TRUE}}

\item{use_file_store}{Logical, indicating if we should use a
content-addressable file-store as the source of truth for
packets.  If \code{archive} is non-\code{NULL}, the file-store will be
used as the source of truth and the duplicated files in archive
exist only for convenience.}

\item{require_complete_tree}{Logical, indicating if we require a
complete tree of packets.  This currently affects
\code{\link[=orderly_location_pull]{orderly_location_pull()}}, by requiring that it
always operates in recursive mode.  This is \code{FALSE} by default,
but set to \code{TRUE} if you want your archive to behave well as a
location; if \code{TRUE} you will always have all the packets that
you hold metadata about.}

\item{force}{Logical, indicating if we should initialise orderly
even if the directory is not empty.}
}
\value{
The full, normalised, path to the root,
invisibly. Typically this is called only for its side effect.
}
\description{
Initialise an empty orderly repository, or initialise a source
copy of an orderly repository (see Details). An orderly repository
is defined by the presence of a file \code{orderly_config.json} (or
\code{orderly_config.yml}) at its root, along with a directory
\verb{.outpack/} at the same level.
}
\details{
It is expected that \code{orderly_config.json} will be saved in version
control, but that \code{.outpack} will be excluded from version
control; this means that for every clone of your project you will
need to call \code{orderly_init()} to initialise the
\code{.outpack} directory. If you forget to do this, an error will be
thrown reminding you of what you need to do.

You can safely call \code{orderly_init()} on an
already-initialised directory, however, any arguments passed
through must exactly match the configuration of the current root,
otherwise an error will be thrown. Please use
\code{\link[=orderly_config_set]{orderly_config_set()}} to change the configuration within
\code{.outpack}, as this ensures that the change in configuration is
possible. If configuration options are given but match those that
the directory already uses, then nothing happens.  You can safely
edit \code{orderly_config.json} yourself, at least for now.

If the repository that you call \code{orderly_init()} on is
already initialised with an \code{.outpack} directory but not an
\code{orderly_config.json} file, then we will write that file too.
}
\examples{
# We'll use an automatically cleaned-up directory for the root:
path <- withr::local_tempdir()

# Initialise a new repository, setting an option:
orderly_init(path, use_file_store = TRUE)

fs::dir_tree(path, all = TRUE)
}
