% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udfs.R
\docType{data}
\name{Equivalence}
\alias{Equivalence}
\title{Concept map equivalence types}
\format{
An object of class \code{list} of length 10.
}
\usage{
Equivalence
}
\description{
The following values are supported:
\itemize{
  \item \code{RELATEDTO} - The concepts are related to each other, and have at least some overlap in meaning, but the exact relationship is not known.
  \item \code{EQUIVALENT} - The definitions of the concepts mean the same thing (including when structural implications of meaning are considered) (i.e. extensionally identical).
  \item \code{EQUAL} - The definitions of the concepts are exactly the same (i.e. only grammatical differences) and structural implications of meaning are identical or irrelevant (i.e. intentionally identical).
  \item \code{WIDER} - The target mapping is wider in meaning than the source concept.
  \item \code{SUBSUMES} - The target mapping subsumes the meaning of the source concept (e.g. the source is-a target).
  \item \code{NARROWER} - The target mapping is narrower in meaning than the source concept. The sense in which the mapping is narrower SHALL be described in the comments in this case, and applications should be careful when attempting to use these mappings operationally.
  \item \code{SPECIALIZES} - The target mapping specializes the meaning of the source concept (e.g. the target is-a source).
  \item \code{INEXACT} - There is some similarity between the concepts, but the exact relationship is not known.
  \item \code{UNMATCHED} - This is an explicit assertion that there is no mapping between the source and target concept.
  \item \code{DISJOINT} - This is an explicit assertion that the target concept is not in any way related to the source concept.
}
}
\seealso{
\href{https://hl7.org/fhir/R4/valueset-concept-map-equivalence.html}{FHIR R4 - ConceptMapEquivalence}
}
\keyword{datasets}
