# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include eks_service.R
NULL

#' Associates an access policy and its scope to an access entry
#'
#' @description
#' Associates an access policy and its scope to an access entry. For more information about associating access policies, see [Associating and disassociating access policies to and from access entries](https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html) in the *Amazon EKS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_associate_access_policy/](https://www.paws-r-sdk.com/docs/eks_associate_access_policy/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param principalArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM user or role for the
#' `AccessEntry` that you're associating the access policy to.
#' @param policyArn &#91;required&#93; The ARN of the `AccessPolicy` that you're associating. For a list of
#' ARNs, use [`list_access_policies`][eks_list_access_policies].
#' @param accessScope &#91;required&#93; The scope for the `AccessPolicy`. You can scope access policies to an
#' entire cluster or to specific Kubernetes namespaces.
#'
#' @keywords internal
#'
#' @rdname eks_associate_access_policy
eks_associate_access_policy <- function(clusterName, principalArn, policyArn, accessScope) {
  op <- new_operation(
    name = "AssociateAccessPolicy",
    http_method = "POST",
    http_path = "/clusters/{name}/access-entries/{principalArn}/access-policies",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$associate_access_policy_input(clusterName = clusterName, principalArn = principalArn, policyArn = policyArn, accessScope = accessScope)
  output <- .eks$associate_access_policy_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$associate_access_policy <- eks_associate_access_policy

#' Associates an encryption configuration to an existing cluster
#'
#' @description
#' Associates an encryption configuration to an existing cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_associate_encryption_config/](https://www.paws-r-sdk.com/docs/eks_associate_encryption_config/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param encryptionConfig &#91;required&#93; The configuration you are using for encryption.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_associate_encryption_config
eks_associate_encryption_config <- function(clusterName, encryptionConfig, clientRequestToken = NULL) {
  op <- new_operation(
    name = "AssociateEncryptionConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/encryption-config/associate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$associate_encryption_config_input(clusterName = clusterName, encryptionConfig = encryptionConfig, clientRequestToken = clientRequestToken)
  output <- .eks$associate_encryption_config_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$associate_encryption_config <- eks_associate_encryption_config

#' Associates an identity provider configuration to a cluster
#'
#' @description
#' Associates an identity provider configuration to a cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_associate_identity_provider_config/](https://www.paws-r-sdk.com/docs/eks_associate_identity_provider_config/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param oidc &#91;required&#93; An object representing an OpenID Connect (OIDC) identity provider
#' configuration.
#' @param tags Metadata that assists with categorization and organization. Each tag
#' consists of a key and an optional value. You define both. Tags don't
#' propagate to any other cluster or Amazon Web Services resources.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_associate_identity_provider_config
eks_associate_identity_provider_config <- function(clusterName, oidc, tags = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "AssociateIdentityProviderConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/identity-provider-configs/associate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$associate_identity_provider_config_input(clusterName = clusterName, oidc = oidc, tags = tags, clientRequestToken = clientRequestToken)
  output <- .eks$associate_identity_provider_config_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$associate_identity_provider_config <- eks_associate_identity_provider_config

#' Creates an access entry
#'
#' @description
#' Creates an access entry.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_create_access_entry/](https://www.paws-r-sdk.com/docs/eks_create_access_entry/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param principalArn &#91;required&#93; The ARN of the IAM principal for the `AccessEntry`. You can specify one
#' ARN for each access entry. You can't specify the same ARN in more than
#' one access entry. This value can't be changed after access entry
#' creation.
#' 
#' The valid principals differ depending on the type of the access entry in
#' the `type` field. For `STANDARD` access entries, you can use every IAM
#' principal type. For nodes (`EC2` (for EKS Auto Mode), `EC2_LINUX`,
#' `EC2_WINDOWS`, `FARGATE_LINUX`, and `HYBRID_LINUX`), the only valid ARN
#' is IAM roles. You can't use the STS session principal type with access
#' entries because this is a temporary principal for each session and not a
#' permanent identity that can be assigned permissions.
#' 
#' [IAM best
#' practices](https://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html#bp-users-federation-idp)
#' recommend using IAM roles with temporary credentials, rather than IAM
#' users with long-term credentials.
#' @param kubernetesGroups The value for `name` that you've specified for `kind: Group` as a
#' `subject` in a Kubernetes `RoleBinding` or `ClusterRoleBinding` object.
#' Amazon EKS doesn't confirm that the value for `name` exists in any
#' bindings on your cluster. You can specify one or more names.
#' 
#' Kubernetes authorizes the `principalArn` of the access entry to access
#' any cluster objects that you've specified in a Kubernetes `Role` or
#' `ClusterRole` object that is also specified in a binding's `roleRef`.
#' For more information about creating Kubernetes `RoleBinding`,
#' `ClusterRoleBinding`, `Role`, or `ClusterRole` objects, see [Using RBAC
#' Authorization in the Kubernetes
#' documentation](https://kubernetes.io/docs/reference/access-authn-authz/rbac/).
#' 
#' If you want Amazon EKS to authorize the `principalArn` (instead of, or
#' in addition to Kubernetes authorizing the `principalArn`), you can
#' associate one or more access policies to the access entry using
#' [`associate_access_policy`][eks_associate_access_policy]. If you
#' associate any access policies, the `principalARN` has all permissions
#' assigned in the associated access policies and all permissions in any
#' Kubernetes `Role` or `ClusterRole` objects that the group names are
#' bound to.
#' @param tags Metadata that assists with categorization and organization. Each tag
#' consists of a key and an optional value. You define both. Tags don't
#' propagate to any other cluster or Amazon Web Services resources.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param username The username to authenticate to Kubernetes with. We recommend not
#' specifying a username and letting Amazon EKS specify it for you. For
#' more information about the value Amazon EKS specifies for you, or
#' constraints before specifying your own username, see [Creating access
#' entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries)
#' in the *Amazon EKS User Guide*.
#' @param type The type of the new access entry. Valid values are `STANDARD`,
#' `FARGATE_LINUX`, `EC2_LINUX`, `EC2_WINDOWS`, `EC2` (for EKS Auto Mode),
#' `HYBRID_LINUX`, and `HYPERPOD_LINUX`.
#' 
#' If the `principalArn` is for an IAM role that's used for self-managed
#' Amazon EC2 nodes, specify `EC2_LINUX` or `EC2_WINDOWS`. Amazon EKS
#' grants the necessary permissions to the node for you. If the
#' `principalArn` is for any other purpose, specify `STANDARD`. If you
#' don't specify a value, Amazon EKS sets the value to `STANDARD`. If you
#' have the access mode of the cluster set to `API_AND_CONFIG_MAP`, it's
#' unnecessary to create access entries for IAM roles used with Fargate
#' profiles or managed Amazon EC2 nodes, because Amazon EKS creates entries
#' in the `aws-auth` `ConfigMap` for the roles. You can't change this value
#' once you've created the access entry.
#' 
#' If you set the value to `EC2_LINUX` or `EC2_WINDOWS`, you can't specify
#' values for `kubernetesGroups`, or associate an `AccessPolicy` to the
#' access entry.
#'
#' @keywords internal
#'
#' @rdname eks_create_access_entry
eks_create_access_entry <- function(clusterName, principalArn, kubernetesGroups = NULL, tags = NULL, clientRequestToken = NULL, username = NULL, type = NULL) {
  op <- new_operation(
    name = "CreateAccessEntry",
    http_method = "POST",
    http_path = "/clusters/{name}/access-entries",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$create_access_entry_input(clusterName = clusterName, principalArn = principalArn, kubernetesGroups = kubernetesGroups, tags = tags, clientRequestToken = clientRequestToken, username = username, type = type)
  output <- .eks$create_access_entry_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_access_entry <- eks_create_access_entry

#' Creates an Amazon EKS add-on
#'
#' @description
#' Creates an Amazon EKS add-on.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_create_addon/](https://www.paws-r-sdk.com/docs/eks_create_addon/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`describe_addon_versions`][eks_describe_addon_versions].
#' @param addonVersion The version of the add-on. The version must match one of the versions
#' returned by
#' [`describe_addon_versions`](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html)
#' .
#' @param serviceAccountRoleArn The Amazon Resource Name (ARN) of an existing IAM role to bind to the
#' add-on's service account. The role must be assigned the IAM permissions
#' required by the add-on. If you don't specify an existing IAM role, then
#' the add-on uses the permissions assigned to the node IAM role. For more
#' information, see [Amazon EKS node IAM
#' role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
#' in the *Amazon EKS User Guide*.
#' 
#' To specify an existing IAM role, you must have an IAM OpenID Connect
#' (OIDC) provider created for your cluster. For more information, see
#' [Enabling IAM roles for service accounts on your
#' cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
#' in the *Amazon EKS User Guide*.
#' @param resolveConflicts How to resolve field value conflicts for an Amazon EKS add-on. Conflicts
#' are handled based on the value you choose:
#' 
#' -   **None** – If the self-managed version of the add-on is installed on
#'     your cluster, Amazon EKS doesn't change the value. Creation of the
#'     add-on might fail.
#' 
#' -   **Overwrite** – If the self-managed version of the add-on is
#'     installed on your cluster and the Amazon EKS default value is
#'     different than the existing value, Amazon EKS changes the value to
#'     the Amazon EKS default value.
#' 
#' -   **Preserve** – This is similar to the NONE option. If the
#'     self-managed version of the add-on is installed on your cluster
#'     Amazon EKS doesn't change the add-on resource properties. Creation
#'     of the add-on might fail if conflicts are detected. This option
#'     works differently during the update operation. For more information,
#'     see
#'     [`update_addon`](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html)
#'     .
#' 
#' If you don't currently have the self-managed version of the add-on
#' installed on your cluster, the Amazon EKS add-on is installed. Amazon
#' EKS sets all values to default values, regardless of the option that you
#' specify.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags Metadata that assists with categorization and organization. Each tag
#' consists of a key and an optional value. You define both. Tags don't
#' propagate to any other cluster or Amazon Web Services resources.
#' @param configurationValues The set of configuration values for the add-on that's created. The
#' values that you provide are validated against the schema returned by
#' [`describe_addon_configuration`][eks_describe_addon_configuration].
#' @param podIdentityAssociations An array of Pod Identity Assocations to be created. Each EKS Pod
#' Identity association maps a Kubernetes service account to an IAM Role.
#' 
#' For more information, see [Attach an IAM Role to an Amazon EKS add-on
#' using Pod
#' Identity](https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html)
#' in the *Amazon EKS User Guide*.
#'
#' @keywords internal
#'
#' @rdname eks_create_addon
eks_create_addon <- function(clusterName, addonName, addonVersion = NULL, serviceAccountRoleArn = NULL, resolveConflicts = NULL, clientRequestToken = NULL, tags = NULL, configurationValues = NULL, podIdentityAssociations = NULL) {
  op <- new_operation(
    name = "CreateAddon",
    http_method = "POST",
    http_path = "/clusters/{name}/addons",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$create_addon_input(clusterName = clusterName, addonName = addonName, addonVersion = addonVersion, serviceAccountRoleArn = serviceAccountRoleArn, resolveConflicts = resolveConflicts, clientRequestToken = clientRequestToken, tags = tags, configurationValues = configurationValues, podIdentityAssociations = podIdentityAssociations)
  output <- .eks$create_addon_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_addon <- eks_create_addon

#' Creates an Amazon EKS control plane
#'
#' @description
#' Creates an Amazon EKS control plane.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_create_cluster/](https://www.paws-r-sdk.com/docs/eks_create_cluster/) for full documentation.
#'
#' @param name &#91;required&#93; The unique name to give to your cluster. The name can contain only
#' alphanumeric characters (case-sensitive), hyphens, and underscores. It
#' must start with an alphanumeric character and can't be longer than 100
#' characters. The name must be unique within the Amazon Web Services
#' Region and Amazon Web Services account that you're creating the cluster
#' in.
#' @param version The desired Kubernetes version for your cluster. If you don't specify a
#' value here, the default version available in Amazon EKS is used.
#' 
#' The default version might not be the latest version available.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that provides permissions
#' for the Kubernetes control plane to make calls to Amazon Web Services
#' API operations on your behalf. For more information, see [Amazon EKS
#' Service IAM
#' Role](https://docs.aws.amazon.com/eks/latest/userguide/cluster-iam-role.html)
#' in the *Amazon EKS User Guide* .
#' @param resourcesVpcConfig &#91;required&#93; The VPC configuration that's used by the cluster control plane. Amazon
#' EKS VPC resources have specific requirements to work properly with
#' Kubernetes. For more information, see [Cluster VPC
#' Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network-reqs.html)
#' and [Cluster Security Group
#' Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
#' in the *Amazon EKS User Guide*. You must specify at least two subnets.
#' You can specify up to five security groups. However, we recommend that
#' you use a dedicated security group for your cluster control plane.
#' @param kubernetesNetworkConfig The Kubernetes network configuration for the cluster.
#' @param logging Enable or disable exporting the Kubernetes control plane logs for your
#' cluster to CloudWatch Logs . By default, cluster control plane logs
#' aren't exported to CloudWatch Logs . For more information, see [Amazon
#' EKS Cluster control plane
#' logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the *Amazon EKS User Guide* .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see
#' [CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags Metadata that assists with categorization and organization. Each tag
#' consists of a key and an optional value. You define both. Tags don't
#' propagate to any other cluster or Amazon Web Services resources.
#' @param encryptionConfig The encryption configuration for the cluster.
#' @param outpostConfig An object representing the configuration of your local Amazon EKS
#' cluster on an Amazon Web Services Outpost. Before creating a local
#' cluster on an Outpost, review [Local clusters for Amazon EKS on Amazon
#' Web Services
#' Outposts](https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html)
#' in the *Amazon EKS User Guide*. This object isn't available for creating
#' Amazon EKS clusters on the Amazon Web Services cloud.
#' @param accessConfig The access configuration for the cluster.
#' @param bootstrapSelfManagedAddons If you set this value to `False` when creating a cluster, the default
#' networking add-ons will not be installed.
#' 
#' The default networking addons include vpc-cni, coredns, and kube-proxy.
#' 
#' Use this option when you plan to install third-party alternative add-ons
#' or self-manage the default networking add-ons.
#' @param upgradePolicy New clusters, by default, have extended support enabled. You can disable
#' extended support when creating a cluster by setting this value to
#' `STANDARD`.
#' @param zonalShiftConfig Enable or disable ARC zonal shift for the cluster. If zonal shift is
#' enabled, Amazon Web Services configures zonal autoshift for the cluster.
#' 
#' Zonal shift is a feature of Amazon Application Recovery Controller
#' (ARC). ARC zonal shift is designed to be a temporary measure that allows
#' you to move traffic for a resource away from an impaired AZ until the
#' zonal shift expires or you cancel it. You can extend the zonal shift if
#' necessary.
#' 
#' You can start a zonal shift for an Amazon EKS cluster, or you can allow
#' Amazon Web Services to do it for you by enabling *zonal autoshift*. This
#' shift updates the flow of east-to-west network traffic in your cluster
#' to only consider network endpoints for Pods running on worker nodes in
#' healthy AZs. Additionally, any ALB or NLB handling ingress traffic for
#' applications in your Amazon EKS cluster will automatically route traffic
#' to targets in the healthy AZs. For more information about zonal shift in
#' EKS, see [Learn about Amazon Application Recovery Controller (ARC) Zonal
#' Shift in Amazon
#' EKS](https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html)
#' in the *Amazon EKS User Guide* .
#' @param remoteNetworkConfig The configuration in the cluster for EKS Hybrid Nodes. You can't change
#' or update this configuration after the cluster is created.
#' @param computeConfig Enable or disable the compute capability of EKS Auto Mode when creating
#' your EKS Auto Mode cluster. If the compute capability is enabled, EKS
#' Auto Mode will create and delete EC2 Managed Instances in your Amazon
#' Web Services account
#' @param storageConfig Enable or disable the block storage capability of EKS Auto Mode when
#' creating your EKS Auto Mode cluster. If the block storage capability is
#' enabled, EKS Auto Mode will create and delete EBS volumes in your Amazon
#' Web Services account.
#'
#' @keywords internal
#'
#' @rdname eks_create_cluster
eks_create_cluster <- function(name, version = NULL, roleArn, resourcesVpcConfig, kubernetesNetworkConfig = NULL, logging = NULL, clientRequestToken = NULL, tags = NULL, encryptionConfig = NULL, outpostConfig = NULL, accessConfig = NULL, bootstrapSelfManagedAddons = NULL, upgradePolicy = NULL, zonalShiftConfig = NULL, remoteNetworkConfig = NULL, computeConfig = NULL, storageConfig = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/clusters",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$create_cluster_input(name = name, version = version, roleArn = roleArn, resourcesVpcConfig = resourcesVpcConfig, kubernetesNetworkConfig = kubernetesNetworkConfig, logging = logging, clientRequestToken = clientRequestToken, tags = tags, encryptionConfig = encryptionConfig, outpostConfig = outpostConfig, accessConfig = accessConfig, bootstrapSelfManagedAddons = bootstrapSelfManagedAddons, upgradePolicy = upgradePolicy, zonalShiftConfig = zonalShiftConfig, remoteNetworkConfig = remoteNetworkConfig, computeConfig = computeConfig, storageConfig = storageConfig)
  output <- .eks$create_cluster_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_cluster <- eks_create_cluster

#' Creates an EKS Anywhere subscription
#'
#' @description
#' Creates an EKS Anywhere subscription. When a subscription is created, it is a contract agreement for the length of the term specified in the request. Licenses that are used to validate support are provisioned in Amazon Web Services License Manager and the caller account is granted access to EKS Anywhere Curated Packages.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_create_eks_anywhere_subscription/](https://www.paws-r-sdk.com/docs/eks_create_eks_anywhere_subscription/) for full documentation.
#'
#' @param name &#91;required&#93; The unique name for your subscription. It must be unique in your Amazon
#' Web Services account in the Amazon Web Services Region you're creating
#' the subscription in. The name can contain only alphanumeric characters
#' (case-sensitive), hyphens, and underscores. It must start with an
#' alphabetic character and can't be longer than 100 characters.
#' @param term &#91;required&#93; An object representing the term duration and term unit type of your
#' subscription. This determines the term length of your subscription.
#' Valid values are MONTHS for term unit and 12 or 36 for term duration,
#' indicating a 12 month or 36 month subscription. This value cannot be
#' changed after creating the subscription.
#' @param licenseQuantity The number of licenses to purchase with the subscription. Valid values
#' are between 1 and 100. This value can't be changed after creating the
#' subscription.
#' @param licenseType The license type for all licenses in the subscription. Valid value is
#' CLUSTER. With the CLUSTER license type, each license covers support for
#' a single EKS Anywhere cluster.
#' @param autoRenew A boolean indicating whether the subscription auto renews at the end of
#' the term.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags The metadata for a subscription to assist with categorization and
#' organization. Each tag consists of a key and an optional value.
#' Subscription tags don't propagate to any other resources associated with
#' the subscription.
#'
#' @keywords internal
#'
#' @rdname eks_create_eks_anywhere_subscription
eks_create_eks_anywhere_subscription <- function(name, term, licenseQuantity = NULL, licenseType = NULL, autoRenew = NULL, clientRequestToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateEksAnywhereSubscription",
    http_method = "POST",
    http_path = "/eks-anywhere-subscriptions",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$create_eks_anywhere_subscription_input(name = name, term = term, licenseQuantity = licenseQuantity, licenseType = licenseType, autoRenew = autoRenew, clientRequestToken = clientRequestToken, tags = tags)
  output <- .eks$create_eks_anywhere_subscription_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_eks_anywhere_subscription <- eks_create_eks_anywhere_subscription

#' Creates an Fargate profile for your Amazon EKS cluster
#'
#' @description
#' Creates an Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_create_fargate_profile/](https://www.paws-r-sdk.com/docs/eks_create_fargate_profile/) for full documentation.
#'
#' @param fargateProfileName &#91;required&#93; The name of the Fargate profile.
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param podExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the `Pod` execution role to use for a
#' `Pod` that matches the selectors in the Fargate profile. The `Pod`
#' execution role allows Fargate infrastructure to register with your
#' cluster as a node, and it provides read access to Amazon ECR image
#' repositories. For more information, see [`Pod` execution
#' role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
#' in the *Amazon EKS User Guide*.
#' @param subnets The IDs of subnets to launch a `Pod` into. A `Pod` running on Fargate
#' isn't assigned a public IP address, so only private subnets (with no
#' direct route to an Internet Gateway) are accepted for this parameter.
#' @param selectors The selectors to match for a `Pod` to use this Fargate profile. Each
#' selector must have an associated Kubernetes `namespace`. Optionally, you
#' can also specify `labels` for a `namespace`. You may specify up to five
#' selectors in a Fargate profile.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags Metadata that assists with categorization and organization. Each tag
#' consists of a key and an optional value. You define both. Tags don't
#' propagate to any other cluster or Amazon Web Services resources.
#'
#' @keywords internal
#'
#' @rdname eks_create_fargate_profile
eks_create_fargate_profile <- function(fargateProfileName, clusterName, podExecutionRoleArn, subnets = NULL, selectors = NULL, clientRequestToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateFargateProfile",
    http_method = "POST",
    http_path = "/clusters/{name}/fargate-profiles",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$create_fargate_profile_input(fargateProfileName = fargateProfileName, clusterName = clusterName, podExecutionRoleArn = podExecutionRoleArn, subnets = subnets, selectors = selectors, clientRequestToken = clientRequestToken, tags = tags)
  output <- .eks$create_fargate_profile_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_fargate_profile <- eks_create_fargate_profile

#' Creates a managed node group for an Amazon EKS cluster
#'
#' @description
#' Creates a managed node group for an Amazon EKS cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_create_nodegroup/](https://www.paws-r-sdk.com/docs/eks_create_nodegroup/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param nodegroupName &#91;required&#93; The unique name to give your node group.
#' @param scalingConfig The scaling configuration details for the Auto Scaling group that is
#' created for your node group.
#' @param diskSize The root device disk size (in GiB) for your node group instances. The
#' default disk size is 20 GiB for Linux and Bottlerocket. The default disk
#' size is 50 GiB for Windows. If you specify `launchTemplate`, then don't
#' specify `diskSize`, or the node group deployment will fail. For more
#' information about using launch templates with Amazon EKS, see
#' [Customizing managed nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param subnets &#91;required&#93; The subnets to use for the Auto Scaling group that is created for your
#' node group. If you specify `launchTemplate`, then don't specify
#' ` SubnetId ` in your launch template, or the node group deployment will
#' fail. For more information about using launch templates with Amazon EKS,
#' see [Customizing managed nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param instanceTypes Specify the instance types for a node group. If you specify a GPU
#' instance type, make sure to also specify an applicable GPU AMI type with
#' the `amiType` parameter. If you specify `launchTemplate`, then you can
#' specify zero or one instance type in your launch template *or* you can
#' specify 0-20 instance types for `instanceTypes`. If however, you specify
#' an instance type in your launch template *and* specify any
#' `instanceTypes`, the node group deployment will fail. If you don't
#' specify an instance type in a launch template or for `instanceTypes`,
#' then `t3.medium` is used, by default. If you specify `Spot` for
#' `capacityType`, then we recommend specifying multiple values for
#' `instanceTypes`. For more information, see [Managed node group capacity
#' types](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types)
#' and [Customizing managed nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param amiType The AMI type for your node group. If you specify `launchTemplate`, and
#' your launch template uses a custom AMI, then don't specify `amiType`, or
#' the node group deployment will fail. If your launch template uses a
#' Windows custom AMI, then add `eks:kube-proxy-windows` to your Windows
#' nodes `rolearn` in the `aws-auth` `ConfigMap`. For more information
#' about using launch templates with Amazon EKS, see [Customizing managed
#' nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param remoteAccess The remote access configuration to use with your node group. For Linux,
#' the protocol is SSH. For Windows, the protocol is RDP. If you specify
#' `launchTemplate`, then don't specify `remoteAccess`, or the node group
#' deployment will fail. For more information about using launch templates
#' with Amazon EKS, see [Customizing managed nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param nodeRole &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to associate with your
#' node group. The Amazon EKS worker node `kubelet` daemon makes calls to
#' Amazon Web Services APIs on your behalf. Nodes receive permissions for
#' these API calls through an IAM instance profile and associated policies.
#' Before you can launch nodes and register them into a cluster, you must
#' create an IAM role for those nodes to use when they are launched. For
#' more information, see [Amazon EKS node IAM
#' role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
#' in the *Amazon EKS User Guide* . If you specify `launchTemplate`, then
#' don't specify ` IamInstanceProfile ` in your launch template, or the
#' node group deployment will fail. For more information about using launch
#' templates with Amazon EKS, see [Customizing managed nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param labels The Kubernetes `labels` to apply to the nodes in the node group when
#' they are created.
#' @param taints The Kubernetes taints to be applied to the nodes in the node group. For
#' more information, see [Node taints on managed node
#' groups](https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
#' @param tags Metadata that assists with categorization and organization. Each tag
#' consists of a key and an optional value. You define both. Tags don't
#' propagate to any other cluster or Amazon Web Services resources.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param launchTemplate An object representing a node group's launch template specification.
#' When using this object, don't directly specify `instanceTypes`,
#' `diskSize`, or `remoteAccess`. Make sure that the launch template meets
#' the requirements in `launchTemplateSpecification`. Also refer to
#' [Customizing managed nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param updateConfig The node group update configuration.
#' @param nodeRepairConfig The node auto repair configuration for the node group.
#' @param capacityType The capacity type for your node group.
#' @param version The Kubernetes version to use for your managed nodes. By default, the
#' Kubernetes version of the cluster is used, and this is the only accepted
#' specified value. If you specify `launchTemplate`, and your launch
#' template uses a custom AMI, then don't specify `version`, or the node
#' group deployment will fail. For more information about using launch
#' templates with Amazon EKS, see [Customizing managed nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param releaseVersion The AMI version of the Amazon EKS optimized AMI to use with your node
#' group. By default, the latest available AMI version for the node group's
#' current Kubernetes version is used. For information about Linux
#' versions, see [Amazon EKS optimized Amazon Linux AMI
#' versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
#' in the *Amazon EKS User Guide*. Amazon EKS managed node groups support
#' the November 2022 and later releases of the Windows AMIs. For
#' information about Windows versions, see [Amazon EKS optimized Windows
#' AMI
#' versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html)
#' in the *Amazon EKS User Guide*.
#' 
#' If you specify `launchTemplate`, and your launch template uses a custom
#' AMI, then don't specify `releaseVersion`, or the node group deployment
#' will fail. For more information about using launch templates with Amazon
#' EKS, see [Customizing managed nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#'
#' @keywords internal
#'
#' @rdname eks_create_nodegroup
eks_create_nodegroup <- function(clusterName, nodegroupName, scalingConfig = NULL, diskSize = NULL, subnets, instanceTypes = NULL, amiType = NULL, remoteAccess = NULL, nodeRole, labels = NULL, taints = NULL, tags = NULL, clientRequestToken = NULL, launchTemplate = NULL, updateConfig = NULL, nodeRepairConfig = NULL, capacityType = NULL, version = NULL, releaseVersion = NULL) {
  op <- new_operation(
    name = "CreateNodegroup",
    http_method = "POST",
    http_path = "/clusters/{name}/node-groups",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$create_nodegroup_input(clusterName = clusterName, nodegroupName = nodegroupName, scalingConfig = scalingConfig, diskSize = diskSize, subnets = subnets, instanceTypes = instanceTypes, amiType = amiType, remoteAccess = remoteAccess, nodeRole = nodeRole, labels = labels, taints = taints, tags = tags, clientRequestToken = clientRequestToken, launchTemplate = launchTemplate, updateConfig = updateConfig, nodeRepairConfig = nodeRepairConfig, capacityType = capacityType, version = version, releaseVersion = releaseVersion)
  output <- .eks$create_nodegroup_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_nodegroup <- eks_create_nodegroup

#' Creates an EKS Pod Identity association between a service account in an
#' Amazon EKS cluster and an IAM role with EKS Pod Identity
#'
#' @description
#' Creates an EKS Pod Identity association between a service account in an Amazon EKS cluster and an IAM role with *EKS Pod Identity*. Use EKS Pod Identity to give temporary IAM credentials to pods and the credentials are rotated automatically.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_create_pod_identity_association/](https://www.paws-r-sdk.com/docs/eks_create_pod_identity_association/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster to create the association in.
#' @param namespace &#91;required&#93; The name of the Kubernetes namespace inside the cluster to create the
#' association in. The service account and the pods that use the service
#' account must be in this namespace.
#' @param serviceAccount &#91;required&#93; The name of the Kubernetes service account inside the cluster to
#' associate the IAM credentials with.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to associate with the
#' service account. The EKS Pod Identity agent manages credentials to
#' assume this role for applications in the containers in the pods that use
#' this service account.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags Metadata that assists with categorization and organization. Each tag
#' consists of a key and an optional value. You define both. Tags don't
#' propagate to any other cluster or Amazon Web Services resources.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource – 50
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length – 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length – 256 Unicode characters in UTF-8
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case-sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for either keys or values as it is reserved for
#'     Amazon Web Services use. You cannot edit or delete tag keys or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname eks_create_pod_identity_association
eks_create_pod_identity_association <- function(clusterName, namespace, serviceAccount, roleArn, clientRequestToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreatePodIdentityAssociation",
    http_method = "POST",
    http_path = "/clusters/{name}/pod-identity-associations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$create_pod_identity_association_input(clusterName = clusterName, namespace = namespace, serviceAccount = serviceAccount, roleArn = roleArn, clientRequestToken = clientRequestToken, tags = tags)
  output <- .eks$create_pod_identity_association_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_pod_identity_association <- eks_create_pod_identity_association

#' Deletes an access entry
#'
#' @description
#' Deletes an access entry.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_delete_access_entry/](https://www.paws-r-sdk.com/docs/eks_delete_access_entry/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param principalArn &#91;required&#93; The ARN of the IAM principal for the `AccessEntry`.
#'
#' @keywords internal
#'
#' @rdname eks_delete_access_entry
eks_delete_access_entry <- function(clusterName, principalArn) {
  op <- new_operation(
    name = "DeleteAccessEntry",
    http_method = "DELETE",
    http_path = "/clusters/{name}/access-entries/{principalArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$delete_access_entry_input(clusterName = clusterName, principalArn = principalArn)
  output <- .eks$delete_access_entry_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_access_entry <- eks_delete_access_entry

#' Deletes an Amazon EKS add-on
#'
#' @description
#' Deletes an Amazon EKS add-on.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_delete_addon/](https://www.paws-r-sdk.com/docs/eks_delete_addon/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`list_addons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#' @param preserve Specifying this option preserves the add-on software on your cluster but
#' Amazon EKS stops managing any settings for the add-on. If an IAM account
#' is associated with the add-on, it isn't removed.
#'
#' @keywords internal
#'
#' @rdname eks_delete_addon
eks_delete_addon <- function(clusterName, addonName, preserve = NULL) {
  op <- new_operation(
    name = "DeleteAddon",
    http_method = "DELETE",
    http_path = "/clusters/{name}/addons/{addonName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$delete_addon_input(clusterName = clusterName, addonName = addonName, preserve = preserve)
  output <- .eks$delete_addon_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_addon <- eks_delete_addon

#' Deletes an Amazon EKS cluster control plane
#'
#' @description
#' Deletes an Amazon EKS cluster control plane.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_delete_cluster/](https://www.paws-r-sdk.com/docs/eks_delete_cluster/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the cluster to delete.
#'
#' @keywords internal
#'
#' @rdname eks_delete_cluster
eks_delete_cluster <- function(name) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "DELETE",
    http_path = "/clusters/{name}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$delete_cluster_input(name = name)
  output <- .eks$delete_cluster_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_cluster <- eks_delete_cluster

#' Deletes an expired or inactive subscription
#'
#' @description
#' Deletes an expired or inactive subscription. Deleting inactive subscriptions removes them from the Amazon Web Services Management Console view and from list/describe API responses. Subscriptions can only be cancelled within 7 days of creation and are cancelled by creating a ticket in the Amazon Web Services Support Center.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_delete_eks_anywhere_subscription/](https://www.paws-r-sdk.com/docs/eks_delete_eks_anywhere_subscription/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the subscription.
#'
#' @keywords internal
#'
#' @rdname eks_delete_eks_anywhere_subscription
eks_delete_eks_anywhere_subscription <- function(id) {
  op <- new_operation(
    name = "DeleteEksAnywhereSubscription",
    http_method = "DELETE",
    http_path = "/eks-anywhere-subscriptions/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$delete_eks_anywhere_subscription_input(id = id)
  output <- .eks$delete_eks_anywhere_subscription_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_eks_anywhere_subscription <- eks_delete_eks_anywhere_subscription

#' Deletes an Fargate profile
#'
#' @description
#' Deletes an Fargate profile.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_delete_fargate_profile/](https://www.paws-r-sdk.com/docs/eks_delete_fargate_profile/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param fargateProfileName &#91;required&#93; The name of the Fargate profile to delete.
#'
#' @keywords internal
#'
#' @rdname eks_delete_fargate_profile
eks_delete_fargate_profile <- function(clusterName, fargateProfileName) {
  op <- new_operation(
    name = "DeleteFargateProfile",
    http_method = "DELETE",
    http_path = "/clusters/{name}/fargate-profiles/{fargateProfileName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$delete_fargate_profile_input(clusterName = clusterName, fargateProfileName = fargateProfileName)
  output <- .eks$delete_fargate_profile_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_fargate_profile <- eks_delete_fargate_profile

#' Deletes a managed node group
#'
#' @description
#' Deletes a managed node group.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_delete_nodegroup/](https://www.paws-r-sdk.com/docs/eks_delete_nodegroup/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param nodegroupName &#91;required&#93; The name of the node group to delete.
#'
#' @keywords internal
#'
#' @rdname eks_delete_nodegroup
eks_delete_nodegroup <- function(clusterName, nodegroupName) {
  op <- new_operation(
    name = "DeleteNodegroup",
    http_method = "DELETE",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$delete_nodegroup_input(clusterName = clusterName, nodegroupName = nodegroupName)
  output <- .eks$delete_nodegroup_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_nodegroup <- eks_delete_nodegroup

#' Deletes a EKS Pod Identity association
#'
#' @description
#' Deletes a EKS Pod Identity association.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_delete_pod_identity_association/](https://www.paws-r-sdk.com/docs/eks_delete_pod_identity_association/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The cluster name that
#' @param associationId &#91;required&#93; The ID of the association to be deleted.
#'
#' @keywords internal
#'
#' @rdname eks_delete_pod_identity_association
eks_delete_pod_identity_association <- function(clusterName, associationId) {
  op <- new_operation(
    name = "DeletePodIdentityAssociation",
    http_method = "DELETE",
    http_path = "/clusters/{name}/pod-identity-associations/{associationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$delete_pod_identity_association_input(clusterName = clusterName, associationId = associationId)
  output <- .eks$delete_pod_identity_association_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_pod_identity_association <- eks_delete_pod_identity_association

#' Deregisters a connected cluster to remove it from the Amazon EKS control
#' plane
#'
#' @description
#' Deregisters a connected cluster to remove it from the Amazon EKS control plane.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_deregister_cluster/](https://www.paws-r-sdk.com/docs/eks_deregister_cluster/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the connected cluster to deregister.
#'
#' @keywords internal
#'
#' @rdname eks_deregister_cluster
eks_deregister_cluster <- function(name) {
  op <- new_operation(
    name = "DeregisterCluster",
    http_method = "DELETE",
    http_path = "/cluster-registrations/{name}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$deregister_cluster_input(name = name)
  output <- .eks$deregister_cluster_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$deregister_cluster <- eks_deregister_cluster

#' Describes an access entry
#'
#' @description
#' Describes an access entry.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_access_entry/](https://www.paws-r-sdk.com/docs/eks_describe_access_entry/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param principalArn &#91;required&#93; The ARN of the IAM principal for the `AccessEntry`.
#'
#' @keywords internal
#'
#' @rdname eks_describe_access_entry
eks_describe_access_entry <- function(clusterName, principalArn) {
  op <- new_operation(
    name = "DescribeAccessEntry",
    http_method = "GET",
    http_path = "/clusters/{name}/access-entries/{principalArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_access_entry_input(clusterName = clusterName, principalArn = principalArn)
  output <- .eks$describe_access_entry_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_access_entry <- eks_describe_access_entry

#' Describes an Amazon EKS add-on
#'
#' @description
#' Describes an Amazon EKS add-on.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_addon/](https://www.paws-r-sdk.com/docs/eks_describe_addon/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`list_addons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#'
#' @keywords internal
#'
#' @rdname eks_describe_addon
eks_describe_addon <- function(clusterName, addonName) {
  op <- new_operation(
    name = "DescribeAddon",
    http_method = "GET",
    http_path = "/clusters/{name}/addons/{addonName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_addon_input(clusterName = clusterName, addonName = addonName)
  output <- .eks$describe_addon_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_addon <- eks_describe_addon

#' Returns configuration options
#'
#' @description
#' Returns configuration options.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_addon_configuration/](https://www.paws-r-sdk.com/docs/eks_describe_addon_configuration/) for full documentation.
#'
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`describe_addon_versions`][eks_describe_addon_versions].
#' @param addonVersion &#91;required&#93; The version of the add-on. The version must match one of the versions
#' returned by
#' [`describe_addon_versions`](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html)
#' .
#'
#' @keywords internal
#'
#' @rdname eks_describe_addon_configuration
eks_describe_addon_configuration <- function(addonName, addonVersion) {
  op <- new_operation(
    name = "DescribeAddonConfiguration",
    http_method = "GET",
    http_path = "/addons/configuration-schemas",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_addon_configuration_input(addonName = addonName, addonVersion = addonVersion)
  output <- .eks$describe_addon_configuration_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_addon_configuration <- eks_describe_addon_configuration

#' Describes the versions for an add-on
#'
#' @description
#' Describes the versions for an add-on.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_addon_versions/](https://www.paws-r-sdk.com/docs/eks_describe_addon_versions/) for full documentation.
#'
#' @param kubernetesVersion The Kubernetes versions that you can use the add-on with.
#' @param maxResults The maximum number of results, returned in paginated output. You receive
#' `maxResults` in a single page, along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another request with the returned `nextToken` value. This value
#' can be between 1 and 100. If you don't use this parameter, 100 results
#' and a `nextToken` value, if applicable, are returned.
#' @param nextToken The `nextToken` value returned from a previous paginated request, where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is null when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param addonName The name of the add-on. The name must match one of the names returned by
#' [`list_addons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#' @param types The type of the add-on. For valid `types`, don't specify a value for
#' this property.
#' @param publishers The publisher of the add-on. For valid `publishers`, don't specify a
#' value for this property.
#' @param owners The owner of the add-on. For valid `owners`, don't specify a value for
#' this property.
#'
#' @keywords internal
#'
#' @rdname eks_describe_addon_versions
eks_describe_addon_versions <- function(kubernetesVersion = NULL, maxResults = NULL, nextToken = NULL, addonName = NULL, types = NULL, publishers = NULL, owners = NULL) {
  op <- new_operation(
    name = "DescribeAddonVersions",
    http_method = "GET",
    http_path = "/addons/supported-versions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "addons"),
    stream_api = FALSE
  )
  input <- .eks$describe_addon_versions_input(kubernetesVersion = kubernetesVersion, maxResults = maxResults, nextToken = nextToken, addonName = addonName, types = types, publishers = publishers, owners = owners)
  output <- .eks$describe_addon_versions_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_addon_versions <- eks_describe_addon_versions

#' Describes an Amazon EKS cluster
#'
#' @description
#' Describes an Amazon EKS cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_cluster/](https://www.paws-r-sdk.com/docs/eks_describe_cluster/) for full documentation.
#'
#' @param name &#91;required&#93; The name of your cluster.
#'
#' @keywords internal
#'
#' @rdname eks_describe_cluster
eks_describe_cluster <- function(name) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "GET",
    http_path = "/clusters/{name}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_cluster_input(name = name)
  output <- .eks$describe_cluster_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_cluster <- eks_describe_cluster

#' Lists available Kubernetes versions for Amazon EKS clusters
#'
#' @description
#' Lists available Kubernetes versions for Amazon EKS clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_cluster_versions/](https://www.paws-r-sdk.com/docs/eks_describe_cluster_versions/) for full documentation.
#'
#' @param clusterType The type of cluster to filter versions by.
#' @param maxResults Maximum number of results to return.
#' @param nextToken Pagination token for the next set of results.
#' @param defaultOnly Filter to show only default versions.
#' @param includeAll Include all available versions in the response.
#' @param clusterVersions List of specific cluster versions to describe.
#' @param status This field is deprecated. Use `versionStatus` instead, as that field
#' matches for input and output of this action.
#' 
#' Filter versions by their current status.
#' @param versionStatus Filter versions by their current status.
#'
#' @keywords internal
#'
#' @rdname eks_describe_cluster_versions
eks_describe_cluster_versions <- function(clusterType = NULL, maxResults = NULL, nextToken = NULL, defaultOnly = NULL, includeAll = NULL, clusterVersions = NULL, status = NULL, versionStatus = NULL) {
  op <- new_operation(
    name = "DescribeClusterVersions",
    http_method = "GET",
    http_path = "/cluster-versions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "clusterVersions"),
    stream_api = FALSE
  )
  input <- .eks$describe_cluster_versions_input(clusterType = clusterType, maxResults = maxResults, nextToken = nextToken, defaultOnly = defaultOnly, includeAll = includeAll, clusterVersions = clusterVersions, status = status, versionStatus = versionStatus)
  output <- .eks$describe_cluster_versions_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_cluster_versions <- eks_describe_cluster_versions

#' Returns descriptive information about a subscription
#'
#' @description
#' Returns descriptive information about a subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_eks_anywhere_subscription/](https://www.paws-r-sdk.com/docs/eks_describe_eks_anywhere_subscription/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the subscription.
#'
#' @keywords internal
#'
#' @rdname eks_describe_eks_anywhere_subscription
eks_describe_eks_anywhere_subscription <- function(id) {
  op <- new_operation(
    name = "DescribeEksAnywhereSubscription",
    http_method = "GET",
    http_path = "/eks-anywhere-subscriptions/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_eks_anywhere_subscription_input(id = id)
  output <- .eks$describe_eks_anywhere_subscription_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_eks_anywhere_subscription <- eks_describe_eks_anywhere_subscription

#' Describes an Fargate profile
#'
#' @description
#' Describes an Fargate profile.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_fargate_profile/](https://www.paws-r-sdk.com/docs/eks_describe_fargate_profile/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param fargateProfileName &#91;required&#93; The name of the Fargate profile to describe.
#'
#' @keywords internal
#'
#' @rdname eks_describe_fargate_profile
eks_describe_fargate_profile <- function(clusterName, fargateProfileName) {
  op <- new_operation(
    name = "DescribeFargateProfile",
    http_method = "GET",
    http_path = "/clusters/{name}/fargate-profiles/{fargateProfileName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_fargate_profile_input(clusterName = clusterName, fargateProfileName = fargateProfileName)
  output <- .eks$describe_fargate_profile_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_fargate_profile <- eks_describe_fargate_profile

#' Describes an identity provider configuration
#'
#' @description
#' Describes an identity provider configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_identity_provider_config/](https://www.paws-r-sdk.com/docs/eks_describe_identity_provider_config/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param identityProviderConfig &#91;required&#93; An object representing an identity provider configuration.
#'
#' @keywords internal
#'
#' @rdname eks_describe_identity_provider_config
eks_describe_identity_provider_config <- function(clusterName, identityProviderConfig) {
  op <- new_operation(
    name = "DescribeIdentityProviderConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/identity-provider-configs/describe",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_identity_provider_config_input(clusterName = clusterName, identityProviderConfig = identityProviderConfig)
  output <- .eks$describe_identity_provider_config_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_identity_provider_config <- eks_describe_identity_provider_config

#' Returns details about an insight that you specify using its ID
#'
#' @description
#' Returns details about an insight that you specify using its ID.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_insight/](https://www.paws-r-sdk.com/docs/eks_describe_insight/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster to describe the insight for.
#' @param id &#91;required&#93; The identity of the insight to describe.
#'
#' @keywords internal
#'
#' @rdname eks_describe_insight
eks_describe_insight <- function(clusterName, id) {
  op <- new_operation(
    name = "DescribeInsight",
    http_method = "GET",
    http_path = "/clusters/{name}/insights/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_insight_input(clusterName = clusterName, id = id)
  output <- .eks$describe_insight_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_insight <- eks_describe_insight

#' Describes a managed node group
#'
#' @description
#' Describes a managed node group.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_nodegroup/](https://www.paws-r-sdk.com/docs/eks_describe_nodegroup/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param nodegroupName &#91;required&#93; The name of the node group to describe.
#'
#' @keywords internal
#'
#' @rdname eks_describe_nodegroup
eks_describe_nodegroup <- function(clusterName, nodegroupName) {
  op <- new_operation(
    name = "DescribeNodegroup",
    http_method = "GET",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_nodegroup_input(clusterName = clusterName, nodegroupName = nodegroupName)
  output <- .eks$describe_nodegroup_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_nodegroup <- eks_describe_nodegroup

#' Returns descriptive information about an EKS Pod Identity association
#'
#' @description
#' Returns descriptive information about an EKS Pod Identity association.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_pod_identity_association/](https://www.paws-r-sdk.com/docs/eks_describe_pod_identity_association/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster that the association is in.
#' @param associationId &#91;required&#93; The ID of the association that you want the description of.
#'
#' @keywords internal
#'
#' @rdname eks_describe_pod_identity_association
eks_describe_pod_identity_association <- function(clusterName, associationId) {
  op <- new_operation(
    name = "DescribePodIdentityAssociation",
    http_method = "GET",
    http_path = "/clusters/{name}/pod-identity-associations/{associationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_pod_identity_association_input(clusterName = clusterName, associationId = associationId)
  output <- .eks$describe_pod_identity_association_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_pod_identity_association <- eks_describe_pod_identity_association

#' Describes an update to an Amazon EKS resource
#'
#' @description
#' Describes an update to an Amazon EKS resource.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_describe_update/](https://www.paws-r-sdk.com/docs/eks_describe_update/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster associated with the update.
#' @param updateId &#91;required&#93; The ID of the update to describe.
#' @param nodegroupName The name of the Amazon EKS node group associated with the update. This
#' parameter is required if the update is a node group update.
#' @param addonName The name of the add-on. The name must match one of the names returned by
#' [`list_addons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' . This parameter is required if the update is an add-on update.
#'
#' @keywords internal
#'
#' @rdname eks_describe_update
eks_describe_update <- function(name, updateId, nodegroupName = NULL, addonName = NULL) {
  op <- new_operation(
    name = "DescribeUpdate",
    http_method = "GET",
    http_path = "/clusters/{name}/updates/{updateId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$describe_update_input(name = name, updateId = updateId, nodegroupName = nodegroupName, addonName = addonName)
  output <- .eks$describe_update_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_update <- eks_describe_update

#' Disassociates an access policy from an access entry
#'
#' @description
#' Disassociates an access policy from an access entry.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_disassociate_access_policy/](https://www.paws-r-sdk.com/docs/eks_disassociate_access_policy/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param principalArn &#91;required&#93; The ARN of the IAM principal for the `AccessEntry`.
#' @param policyArn &#91;required&#93; The ARN of the policy to disassociate from the access entry. For a list
#' of associated policies ARNs, use
#' [`list_associated_access_policies`][eks_list_associated_access_policies].
#'
#' @keywords internal
#'
#' @rdname eks_disassociate_access_policy
eks_disassociate_access_policy <- function(clusterName, principalArn, policyArn) {
  op <- new_operation(
    name = "DisassociateAccessPolicy",
    http_method = "DELETE",
    http_path = "/clusters/{name}/access-entries/{principalArn}/access-policies/{policyArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$disassociate_access_policy_input(clusterName = clusterName, principalArn = principalArn, policyArn = policyArn)
  output <- .eks$disassociate_access_policy_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$disassociate_access_policy <- eks_disassociate_access_policy

#' Disassociates an identity provider configuration from a cluster
#'
#' @description
#' Disassociates an identity provider configuration from a cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_disassociate_identity_provider_config/](https://www.paws-r-sdk.com/docs/eks_disassociate_identity_provider_config/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param identityProviderConfig &#91;required&#93; An object representing an identity provider configuration.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_disassociate_identity_provider_config
eks_disassociate_identity_provider_config <- function(clusterName, identityProviderConfig, clientRequestToken = NULL) {
  op <- new_operation(
    name = "DisassociateIdentityProviderConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/identity-provider-configs/disassociate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$disassociate_identity_provider_config_input(clusterName = clusterName, identityProviderConfig = identityProviderConfig, clientRequestToken = clientRequestToken)
  output <- .eks$disassociate_identity_provider_config_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$disassociate_identity_provider_config <- eks_disassociate_identity_provider_config

#' Lists the access entries for your cluster
#'
#' @description
#' Lists the access entries for your cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_access_entries/](https://www.paws-r-sdk.com/docs/eks_list_access_entries/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param associatedPolicyArn The ARN of an `AccessPolicy`. When you specify an access policy ARN,
#' only the access entries associated to that access policy are returned.
#' For a list of available policy ARNs, use
#' [`list_access_policies`][eks_list_access_policies].
#' @param maxResults The maximum number of results, returned in paginated output. You receive
#' `maxResults` in a single page, along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another request with the returned `nextToken` value. This value
#' can be between 1 and 100. If you don't use this parameter, 100 results
#' and a `nextToken` value, if applicable, are returned.
#' @param nextToken The `nextToken` value returned from a previous paginated request, where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is null when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname eks_list_access_entries
eks_list_access_entries <- function(clusterName, associatedPolicyArn = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAccessEntries",
    http_method = "GET",
    http_path = "/clusters/{name}/access-entries",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "accessEntries"),
    stream_api = FALSE
  )
  input <- .eks$list_access_entries_input(clusterName = clusterName, associatedPolicyArn = associatedPolicyArn, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_access_entries_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_access_entries <- eks_list_access_entries

#' Lists the available access policies
#'
#' @description
#' Lists the available access policies.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_access_policies/](https://www.paws-r-sdk.com/docs/eks_list_access_policies/) for full documentation.
#'
#' @param maxResults The maximum number of results, returned in paginated output. You receive
#' `maxResults` in a single page, along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another request with the returned `nextToken` value. This value
#' can be between 1 and 100. If you don't use this parameter, 100 results
#' and a `nextToken` value, if applicable, are returned.
#' @param nextToken The `nextToken` value returned from a previous paginated request, where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is null when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname eks_list_access_policies
eks_list_access_policies <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAccessPolicies",
    http_method = "GET",
    http_path = "/access-policies",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "accessPolicies"),
    stream_api = FALSE
  )
  input <- .eks$list_access_policies_input(maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_access_policies_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_access_policies <- eks_list_access_policies

#' Lists the installed add-ons
#'
#' @description
#' Lists the installed add-ons.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_addons/](https://www.paws-r-sdk.com/docs/eks_list_addons/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param maxResults The maximum number of results, returned in paginated output. You receive
#' `maxResults` in a single page, along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another request with the returned `nextToken` value. This value
#' can be between 1 and 100. If you don't use this parameter, 100 results
#' and a `nextToken` value, if applicable, are returned.
#' @param nextToken The `nextToken` value returned from a previous paginated request, where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is null when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname eks_list_addons
eks_list_addons <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAddons",
    http_method = "GET",
    http_path = "/clusters/{name}/addons",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "addons"),
    stream_api = FALSE
  )
  input <- .eks$list_addons_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_addons_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_addons <- eks_list_addons

#' Lists the access policies associated with an access entry
#'
#' @description
#' Lists the access policies associated with an access entry.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_associated_access_policies/](https://www.paws-r-sdk.com/docs/eks_list_associated_access_policies/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param principalArn &#91;required&#93; The ARN of the IAM principal for the `AccessEntry`.
#' @param maxResults The maximum number of results, returned in paginated output. You receive
#' `maxResults` in a single page, along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another request with the returned `nextToken` value. This value
#' can be between 1 and 100. If you don't use this parameter, 100 results
#' and a `nextToken` value, if applicable, are returned.
#' @param nextToken The `nextToken` value returned from a previous paginated request, where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is null when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname eks_list_associated_access_policies
eks_list_associated_access_policies <- function(clusterName, principalArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAssociatedAccessPolicies",
    http_method = "GET",
    http_path = "/clusters/{name}/access-entries/{principalArn}/access-policies",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", non_aggregate_keys = list( "clusterName", "principalArn"), output_token = "nextToken", result_key = "associatedAccessPolicies"),
    stream_api = FALSE
  )
  input <- .eks$list_associated_access_policies_input(clusterName = clusterName, principalArn = principalArn, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_associated_access_policies_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_associated_access_policies <- eks_list_associated_access_policies

#' Lists the Amazon EKS clusters in your Amazon Web Services account in the
#' specified Amazon Web Services Region
#'
#' @description
#' Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_clusters/](https://www.paws-r-sdk.com/docs/eks_list_clusters/) for full documentation.
#'
#' @param maxResults The maximum number of results, returned in paginated output. You receive
#' `maxResults` in a single page, along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another request with the returned `nextToken` value. This value
#' can be between 1 and 100. If you don't use this parameter, 100 results
#' and a `nextToken` value, if applicable, are returned.
#' @param nextToken The `nextToken` value returned from a previous paginated request, where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is null when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param include Indicates whether external clusters are included in the returned list.
#' Use '`all`' to return
#' <https://docs.aws.amazon.com/eks/latest/userguide/eks-connector.html>connected
#' clusters, or blank to return only Amazon EKS clusters. '`all`' must be
#' in lowercase otherwise an error occurs.
#'
#' @keywords internal
#'
#' @rdname eks_list_clusters
eks_list_clusters <- function(maxResults = NULL, nextToken = NULL, include = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "GET",
    http_path = "/clusters",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "clusters"),
    stream_api = FALSE
  )
  input <- .eks$list_clusters_input(maxResults = maxResults, nextToken = nextToken, include = include)
  output <- .eks$list_clusters_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_clusters <- eks_list_clusters

#' Displays the full description of the subscription
#'
#' @description
#' Displays the full description of the subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_eks_anywhere_subscriptions/](https://www.paws-r-sdk.com/docs/eks_list_eks_anywhere_subscriptions/) for full documentation.
#'
#' @param maxResults The maximum number of cluster results returned by
#' ListEksAnywhereSubscriptions in paginated output. When you use this
#' parameter, ListEksAnywhereSubscriptions returns only maxResults results
#' in a single page along with a nextToken response element. You can see
#' the remaining results of the initial request by sending another
#' ListEksAnywhereSubscriptions request with the returned nextToken value.
#' This value can be between 1 and 100. If you don't use this parameter,
#' ListEksAnywhereSubscriptions returns up to 10 results and a nextToken
#' value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_eks_anywhere_subscriptions`][eks_list_eks_anywhere_subscriptions]
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value.
#' @param includeStatus An array of subscription statuses to filter on.
#'
#' @keywords internal
#'
#' @rdname eks_list_eks_anywhere_subscriptions
eks_list_eks_anywhere_subscriptions <- function(maxResults = NULL, nextToken = NULL, includeStatus = NULL) {
  op <- new_operation(
    name = "ListEksAnywhereSubscriptions",
    http_method = "GET",
    http_path = "/eks-anywhere-subscriptions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "subscriptions"),
    stream_api = FALSE
  )
  input <- .eks$list_eks_anywhere_subscriptions_input(maxResults = maxResults, nextToken = nextToken, includeStatus = includeStatus)
  output <- .eks$list_eks_anywhere_subscriptions_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_eks_anywhere_subscriptions <- eks_list_eks_anywhere_subscriptions

#' Lists the Fargate profiles associated with the specified cluster in your
#' Amazon Web Services account in the specified Amazon Web Services Region
#'
#' @description
#' Lists the Fargate profiles associated with the specified cluster in your Amazon Web Services account in the specified Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_fargate_profiles/](https://www.paws-r-sdk.com/docs/eks_list_fargate_profiles/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param maxResults The maximum number of results, returned in paginated output. You receive
#' `maxResults` in a single page, along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another request with the returned `nextToken` value. This value
#' can be between 1 and 100. If you don't use this parameter, 100 results
#' and a `nextToken` value, if applicable, are returned.
#' @param nextToken The `nextToken` value returned from a previous paginated request, where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is null when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname eks_list_fargate_profiles
eks_list_fargate_profiles <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFargateProfiles",
    http_method = "GET",
    http_path = "/clusters/{name}/fargate-profiles",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "fargateProfileNames"),
    stream_api = FALSE
  )
  input <- .eks$list_fargate_profiles_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_fargate_profiles_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_fargate_profiles <- eks_list_fargate_profiles

#' Lists the identity provider configurations for your cluster
#'
#' @description
#' Lists the identity provider configurations for your cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_identity_provider_configs/](https://www.paws-r-sdk.com/docs/eks_list_identity_provider_configs/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param maxResults The maximum number of results, returned in paginated output. You receive
#' `maxResults` in a single page, along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another request with the returned `nextToken` value. This value
#' can be between 1 and 100. If you don't use this parameter, 100 results
#' and a `nextToken` value, if applicable, are returned.
#' @param nextToken The `nextToken` value returned from a previous paginated request, where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is null when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname eks_list_identity_provider_configs
eks_list_identity_provider_configs <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIdentityProviderConfigs",
    http_method = "GET",
    http_path = "/clusters/{name}/identity-provider-configs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "identityProviderConfigs"),
    stream_api = FALSE
  )
  input <- .eks$list_identity_provider_configs_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_identity_provider_configs_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_identity_provider_configs <- eks_list_identity_provider_configs

#' Returns a list of all insights checked for against the specified cluster
#'
#' @description
#' Returns a list of all insights checked for against the specified cluster. You can filter which insights are returned by category, associated Kubernetes version, and status.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_insights/](https://www.paws-r-sdk.com/docs/eks_list_insights/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster associated with the insights.
#' @param filter The criteria to filter your list of insights for your cluster. You can
#' filter which insights are returned by category, associated Kubernetes
#' version, and status.
#' @param maxResults The maximum number of identity provider configurations returned by
#' [`list_insights`][eks_list_insights] in paginated output. When you use
#' this parameter, [`list_insights`][eks_list_insights] returns only
#' `maxResults` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_insights`][eks_list_insights] request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter, [`list_insights`][eks_list_insights] returns
#' up to 100 results and a `nextToken` value, if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_insights`][eks_list_insights] request. When the results of a
#' [`list_insights`][eks_list_insights] request exceed `maxResults`, you
#' can use this value to retrieve the next page of results. This value is
#' `null` when there are no more results to return.
#'
#' @keywords internal
#'
#' @rdname eks_list_insights
eks_list_insights <- function(clusterName, filter = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListInsights",
    http_method = "POST",
    http_path = "/clusters/{name}/insights",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "insights"),
    stream_api = FALSE
  )
  input <- .eks$list_insights_input(clusterName = clusterName, filter = filter, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_insights_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_insights <- eks_list_insights

#' Lists the managed node groups associated with the specified cluster in
#' your Amazon Web Services account in the specified Amazon Web Services
#' Region
#'
#' @description
#' Lists the managed node groups associated with the specified cluster in your Amazon Web Services account in the specified Amazon Web Services Region. Self-managed node groups aren't listed.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_nodegroups/](https://www.paws-r-sdk.com/docs/eks_list_nodegroups/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param maxResults The maximum number of results, returned in paginated output. You receive
#' `maxResults` in a single page, along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another request with the returned `nextToken` value. This value
#' can be between 1 and 100. If you don't use this parameter, 100 results
#' and a `nextToken` value, if applicable, are returned.
#' @param nextToken The `nextToken` value returned from a previous paginated request, where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is null when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname eks_list_nodegroups
eks_list_nodegroups <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListNodegroups",
    http_method = "GET",
    http_path = "/clusters/{name}/node-groups",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "nodegroups"),
    stream_api = FALSE
  )
  input <- .eks$list_nodegroups_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_nodegroups_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_nodegroups <- eks_list_nodegroups

#' List the EKS Pod Identity associations in a cluster
#'
#' @description
#' List the EKS Pod Identity associations in a cluster. You can filter the list by the namespace that the association is in or the service account that the association uses.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_pod_identity_associations/](https://www.paws-r-sdk.com/docs/eks_list_pod_identity_associations/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster that the associations are in.
#' @param namespace The name of the Kubernetes namespace inside the cluster that the
#' associations are in.
#' @param serviceAccount The name of the Kubernetes service account that the associations use.
#' @param maxResults The maximum number of EKS Pod Identity association results returned by
#' [`list_pod_identity_associations`][eks_list_pod_identity_associations]
#' in paginated output. When you use this parameter,
#' [`list_pod_identity_associations`][eks_list_pod_identity_associations]
#' returns only `maxResults` results in a single page along with a
#' `nextToken` response element. You can see the remaining results of the
#' initial request by sending another
#' [`list_pod_identity_associations`][eks_list_pod_identity_associations]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_pod_identity_associations`][eks_list_pod_identity_associations]
#' returns up to 100 results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_updates`][eks_list_updates] request where `maxResults` was used
#' and the results exceeded the value of that parameter. Pagination
#' continues from the end of the previous results that returned the
#' `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname eks_list_pod_identity_associations
eks_list_pod_identity_associations <- function(clusterName, namespace = NULL, serviceAccount = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListPodIdentityAssociations",
    http_method = "GET",
    http_path = "/clusters/{name}/pod-identity-associations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "associations"),
    stream_api = FALSE
  )
  input <- .eks$list_pod_identity_associations_input(clusterName = clusterName, namespace = namespace, serviceAccount = serviceAccount, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_pod_identity_associations_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_pod_identity_associations <- eks_list_pod_identity_associations

#' List the tags for an Amazon EKS resource
#'
#' @description
#' List the tags for an Amazon EKS resource.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/eks_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource to list tags
#' for.
#'
#' @keywords internal
#'
#' @rdname eks_list_tags_for_resource
eks_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .eks$list_tags_for_resource_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_tags_for_resource <- eks_list_tags_for_resource

#' Lists the updates associated with an Amazon EKS resource in your Amazon
#' Web Services account, in the specified Amazon Web Services Region
#'
#' @description
#' Lists the updates associated with an Amazon EKS resource in your Amazon Web Services account, in the specified Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_list_updates/](https://www.paws-r-sdk.com/docs/eks_list_updates/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to list updates for.
#' @param nodegroupName The name of the Amazon EKS managed node group to list updates for.
#' @param addonName The names of the installed add-ons that have available updates.
#' @param nextToken The `nextToken` value returned from a previous paginated request, where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is null when there are
#' no more results to return.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of results, returned in paginated output. You receive
#' `maxResults` in a single page, along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another request with the returned `nextToken` value. This value
#' can be between 1 and 100. If you don't use this parameter, 100 results
#' and a `nextToken` value, if applicable, are returned.
#'
#' @keywords internal
#'
#' @rdname eks_list_updates
eks_list_updates <- function(name, nodegroupName = NULL, addonName = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListUpdates",
    http_method = "GET",
    http_path = "/clusters/{name}/updates",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "updateIds"),
    stream_api = FALSE
  )
  input <- .eks$list_updates_input(name = name, nodegroupName = nodegroupName, addonName = addonName, nextToken = nextToken, maxResults = maxResults)
  output <- .eks$list_updates_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_updates <- eks_list_updates

#' Connects a Kubernetes cluster to the Amazon EKS control plane
#'
#' @description
#' Connects a Kubernetes cluster to the Amazon EKS control plane.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_register_cluster/](https://www.paws-r-sdk.com/docs/eks_register_cluster/) for full documentation.
#'
#' @param name &#91;required&#93; A unique name for this cluster in your Amazon Web Services Region.
#' @param connectorConfig &#91;required&#93; The configuration settings required to connect the Kubernetes cluster to
#' the Amazon EKS control plane.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags Metadata that assists with categorization and organization. Each tag
#' consists of a key and an optional value. You define both. Tags don't
#' propagate to any other cluster or Amazon Web Services resources.
#'
#' @keywords internal
#'
#' @rdname eks_register_cluster
eks_register_cluster <- function(name, connectorConfig, clientRequestToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "RegisterCluster",
    http_method = "POST",
    http_path = "/cluster-registrations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$register_cluster_input(name = name, connectorConfig = connectorConfig, clientRequestToken = clientRequestToken, tags = tags)
  output <- .eks$register_cluster_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$register_cluster <- eks_register_cluster

#' Associates the specified tags to an Amazon EKS resource with the
#' specified resourceArn
#'
#' @description
#' Associates the specified tags to an Amazon EKS resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they aren't changed. When a resource is deleted, the tags associated with that resource are also deleted. Tags that you create for Amazon EKS resources don't propagate to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that tag doesn't automatically propagate to the subnets and nodes associated with the cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_tag_resource/](https://www.paws-r-sdk.com/docs/eks_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to add tags to.
#' @param tags &#91;required&#93; Metadata that assists with categorization and organization. Each tag
#' consists of a key and an optional value. You define both. Tags don't
#' propagate to any other cluster or Amazon Web Services resources.
#'
#' @keywords internal
#'
#' @rdname eks_tag_resource
eks_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .eks$tag_resource_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$tag_resource <- eks_tag_resource

#' Deletes specified tags from an Amazon EKS resource
#'
#' @description
#' Deletes specified tags from an Amazon EKS resource.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_untag_resource/](https://www.paws-r-sdk.com/docs/eks_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to delete tags from.
#' @param tagKeys &#91;required&#93; The keys of the tags to remove.
#'
#' @keywords internal
#'
#' @rdname eks_untag_resource
eks_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .eks$untag_resource_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$untag_resource <- eks_untag_resource

#' Updates an access entry
#'
#' @description
#' Updates an access entry.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_update_access_entry/](https://www.paws-r-sdk.com/docs/eks_update_access_entry/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param principalArn &#91;required&#93; The ARN of the IAM principal for the `AccessEntry`.
#' @param kubernetesGroups The value for `name` that you've specified for `kind: Group` as a
#' `subject` in a Kubernetes `RoleBinding` or `ClusterRoleBinding` object.
#' Amazon EKS doesn't confirm that the value for `name` exists in any
#' bindings on your cluster. You can specify one or more names.
#' 
#' Kubernetes authorizes the `principalArn` of the access entry to access
#' any cluster objects that you've specified in a Kubernetes `Role` or
#' `ClusterRole` object that is also specified in a binding's `roleRef`.
#' For more information about creating Kubernetes `RoleBinding`,
#' `ClusterRoleBinding`, `Role`, or `ClusterRole` objects, see [Using RBAC
#' Authorization in the Kubernetes
#' documentation](https://kubernetes.io/docs/reference/access-authn-authz/rbac/).
#' 
#' If you want Amazon EKS to authorize the `principalArn` (instead of, or
#' in addition to Kubernetes authorizing the `principalArn`), you can
#' associate one or more access policies to the access entry using
#' [`associate_access_policy`][eks_associate_access_policy]. If you
#' associate any access policies, the `principalARN` has all permissions
#' assigned in the associated access policies and all permissions in any
#' Kubernetes `Role` or `ClusterRole` objects that the group names are
#' bound to.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param username The username to authenticate to Kubernetes with. We recommend not
#' specifying a username and letting Amazon EKS specify it for you. For
#' more information about the value Amazon EKS specifies for you, or
#' constraints before specifying your own username, see [Creating access
#' entries](https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries)
#' in the *Amazon EKS User Guide*.
#'
#' @keywords internal
#'
#' @rdname eks_update_access_entry
eks_update_access_entry <- function(clusterName, principalArn, kubernetesGroups = NULL, clientRequestToken = NULL, username = NULL) {
  op <- new_operation(
    name = "UpdateAccessEntry",
    http_method = "POST",
    http_path = "/clusters/{name}/access-entries/{principalArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$update_access_entry_input(clusterName = clusterName, principalArn = principalArn, kubernetesGroups = kubernetesGroups, clientRequestToken = clientRequestToken, username = username)
  output <- .eks$update_access_entry_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_access_entry <- eks_update_access_entry

#' Updates an Amazon EKS add-on
#'
#' @description
#' Updates an Amazon EKS add-on.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_update_addon/](https://www.paws-r-sdk.com/docs/eks_update_addon/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`list_addons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#' @param addonVersion The version of the add-on. The version must match one of the versions
#' returned by
#' [`describe_addon_versions`](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html)
#' .
#' @param serviceAccountRoleArn The Amazon Resource Name (ARN) of an existing IAM role to bind to the
#' add-on's service account. The role must be assigned the IAM permissions
#' required by the add-on. If you don't specify an existing IAM role, then
#' the add-on uses the permissions assigned to the node IAM role. For more
#' information, see [Amazon EKS node IAM
#' role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
#' in the *Amazon EKS User Guide*.
#' 
#' To specify an existing IAM role, you must have an IAM OpenID Connect
#' (OIDC) provider created for your cluster. For more information, see
#' [Enabling IAM roles for service accounts on your
#' cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
#' in the *Amazon EKS User Guide*.
#' @param resolveConflicts How to resolve field value conflicts for an Amazon EKS add-on if you've
#' changed a value from the Amazon EKS default value. Conflicts are handled
#' based on the option you choose:
#' 
#' -   **None** – Amazon EKS doesn't change the value. The update might
#'     fail.
#' 
#' -   **Overwrite** – Amazon EKS overwrites the changed value back to the
#'     Amazon EKS default value.
#' 
#' -   **Preserve** – Amazon EKS preserves the value. If you choose this
#'     option, we recommend that you test any field and value changes on a
#'     non-production cluster before updating the add-on on your production
#'     cluster.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param configurationValues The set of configuration values for the add-on that's created. The
#' values that you provide are validated against the schema returned by
#' [`describe_addon_configuration`][eks_describe_addon_configuration].
#' @param podIdentityAssociations An array of Pod Identity Assocations to be updated. Each EKS Pod
#' Identity association maps a Kubernetes service account to an IAM Role.
#' If this value is left blank, no change. If an empty array is provided,
#' existing Pod Identity Assocations owned by the Addon are deleted.
#' 
#' For more information, see [Attach an IAM Role to an Amazon EKS add-on
#' using Pod
#' Identity](https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html)
#' in the *Amazon EKS User Guide*.
#'
#' @keywords internal
#'
#' @rdname eks_update_addon
eks_update_addon <- function(clusterName, addonName, addonVersion = NULL, serviceAccountRoleArn = NULL, resolveConflicts = NULL, clientRequestToken = NULL, configurationValues = NULL, podIdentityAssociations = NULL) {
  op <- new_operation(
    name = "UpdateAddon",
    http_method = "POST",
    http_path = "/clusters/{name}/addons/{addonName}/update",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$update_addon_input(clusterName = clusterName, addonName = addonName, addonVersion = addonVersion, serviceAccountRoleArn = serviceAccountRoleArn, resolveConflicts = resolveConflicts, clientRequestToken = clientRequestToken, configurationValues = configurationValues, podIdentityAssociations = podIdentityAssociations)
  output <- .eks$update_addon_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_addon <- eks_update_addon

#' Updates an Amazon EKS cluster configuration
#'
#' @description
#' Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with [`describe_update`][eks_describe_update]"/\>.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_update_cluster_config/](https://www.paws-r-sdk.com/docs/eks_update_cluster_config/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to update.
#' @param resourcesVpcConfig 
#' @param logging Enable or disable exporting the Kubernetes control plane logs for your
#' cluster to CloudWatch Logs . By default, cluster control plane logs
#' aren't exported to CloudWatch Logs . For more information, see [Amazon
#' EKS cluster control plane
#' logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the *Amazon EKS User Guide* .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see
#' [CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param accessConfig The access configuration for the cluster.
#' @param upgradePolicy You can enable or disable extended support for clusters currently on
#' standard support. You cannot disable extended support once it starts.
#' You must enable extended support before your cluster exits standard
#' support.
#' @param zonalShiftConfig Enable or disable ARC zonal shift for the cluster. If zonal shift is
#' enabled, Amazon Web Services configures zonal autoshift for the cluster.
#' 
#' Zonal shift is a feature of Amazon Application Recovery Controller
#' (ARC). ARC zonal shift is designed to be a temporary measure that allows
#' you to move traffic for a resource away from an impaired AZ until the
#' zonal shift expires or you cancel it. You can extend the zonal shift if
#' necessary.
#' 
#' You can start a zonal shift for an EKS cluster, or you can allow Amazon
#' Web Services to do it for you by enabling *zonal autoshift*. This shift
#' updates the flow of east-to-west network traffic in your cluster to only
#' consider network endpoints for Pods running on worker nodes in healthy
#' AZs. Additionally, any ALB or NLB handling ingress traffic for
#' applications in your EKS cluster will automatically route traffic to
#' targets in the healthy AZs. For more information about zonal shift in
#' EKS, see [Learn about Amazon Application Recovery Controller (ARC) Zonal
#' Shift in Amazon
#' EKS](https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html)
#' in the *Amazon EKS User Guide* .
#' @param computeConfig Update the configuration of the compute capability of your EKS Auto Mode
#' cluster. For example, enable the capability.
#' @param kubernetesNetworkConfig 
#' @param storageConfig Update the configuration of the block storage capability of your EKS
#' Auto Mode cluster. For example, enable the capability.
#'
#' @keywords internal
#'
#' @rdname eks_update_cluster_config
eks_update_cluster_config <- function(name, resourcesVpcConfig = NULL, logging = NULL, clientRequestToken = NULL, accessConfig = NULL, upgradePolicy = NULL, zonalShiftConfig = NULL, computeConfig = NULL, kubernetesNetworkConfig = NULL, storageConfig = NULL) {
  op <- new_operation(
    name = "UpdateClusterConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/update-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$update_cluster_config_input(name = name, resourcesVpcConfig = resourcesVpcConfig, logging = logging, clientRequestToken = clientRequestToken, accessConfig = accessConfig, upgradePolicy = upgradePolicy, zonalShiftConfig = zonalShiftConfig, computeConfig = computeConfig, kubernetesNetworkConfig = kubernetesNetworkConfig, storageConfig = storageConfig)
  output <- .eks$update_cluster_config_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_cluster_config <- eks_update_cluster_config

#' Updates an Amazon EKS cluster to the specified Kubernetes version
#'
#' @description
#' Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the [`describe_update`](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeUpdate.html) API operation.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_update_cluster_version/](https://www.paws-r-sdk.com/docs/eks_update_cluster_version/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to update.
#' @param version &#91;required&#93; The desired Kubernetes version following a successful update.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_update_cluster_version
eks_update_cluster_version <- function(name, version, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateClusterVersion",
    http_method = "POST",
    http_path = "/clusters/{name}/updates",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$update_cluster_version_input(name = name, version = version, clientRequestToken = clientRequestToken)
  output <- .eks$update_cluster_version_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_cluster_version <- eks_update_cluster_version

#' Update an EKS Anywhere Subscription
#'
#' @description
#' Update an EKS Anywhere Subscription. Only auto renewal and tags can be updated after subscription creation.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_update_eks_anywhere_subscription/](https://www.paws-r-sdk.com/docs/eks_update_eks_anywhere_subscription/) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the subscription.
#' @param autoRenew &#91;required&#93; A boolean indicating whether or not to automatically renew the
#' subscription.
#' @param clientRequestToken Unique, case-sensitive identifier to ensure the idempotency of the
#' request.
#'
#' @keywords internal
#'
#' @rdname eks_update_eks_anywhere_subscription
eks_update_eks_anywhere_subscription <- function(id, autoRenew, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateEksAnywhereSubscription",
    http_method = "POST",
    http_path = "/eks-anywhere-subscriptions/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$update_eks_anywhere_subscription_input(id = id, autoRenew = autoRenew, clientRequestToken = clientRequestToken)
  output <- .eks$update_eks_anywhere_subscription_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_eks_anywhere_subscription <- eks_update_eks_anywhere_subscription

#' Updates an Amazon EKS managed node group configuration
#'
#' @description
#' Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update. The response output includes an update ID that you can use to track the status of your node group update with the [`describe_update`](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeUpdate.html) API operation. You can update the Kubernetes labels and taints for a node group and the scaling and version update configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_update_nodegroup_config/](https://www.paws-r-sdk.com/docs/eks_update_nodegroup_config/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param nodegroupName &#91;required&#93; The name of the managed node group to update.
#' @param labels The Kubernetes `labels` to apply to the nodes in the node group after
#' the update.
#' @param taints The Kubernetes taints to be applied to the nodes in the node group after
#' the update. For more information, see [Node taints on managed node
#' groups](https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
#' @param scalingConfig The scaling configuration details for the Auto Scaling group after the
#' update.
#' @param updateConfig The node group update configuration.
#' @param nodeRepairConfig The node auto repair configuration for the node group.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_update_nodegroup_config
eks_update_nodegroup_config <- function(clusterName, nodegroupName, labels = NULL, taints = NULL, scalingConfig = NULL, updateConfig = NULL, nodeRepairConfig = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateNodegroupConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}/update-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$update_nodegroup_config_input(clusterName = clusterName, nodegroupName = nodegroupName, labels = labels, taints = taints, scalingConfig = scalingConfig, updateConfig = updateConfig, nodeRepairConfig = nodeRepairConfig, clientRequestToken = clientRequestToken)
  output <- .eks$update_nodegroup_config_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_nodegroup_config <- eks_update_nodegroup_config

#' Updates the Kubernetes version or AMI version of an Amazon EKS managed
#' node group
#'
#' @description
#' Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_update_nodegroup_version/](https://www.paws-r-sdk.com/docs/eks_update_nodegroup_version/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of your cluster.
#' @param nodegroupName &#91;required&#93; The name of the managed node group to update.
#' @param version The Kubernetes version to update to. If no version is specified, then
#' the Kubernetes version of the node group does not change. You can
#' specify the Kubernetes version of the cluster to update the node group
#' to the latest AMI version of the cluster's Kubernetes version. If you
#' specify `launchTemplate`, and your launch template uses a custom AMI,
#' then don't specify `version`, or the node group update will fail. For
#' more information about using launch templates with Amazon EKS, see
#' [Customizing managed nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param releaseVersion The AMI version of the Amazon EKS optimized AMI to use for the update.
#' By default, the latest available AMI version for the node group's
#' Kubernetes version is used. For information about Linux versions, see
#' [Amazon EKS optimized Amazon Linux AMI
#' versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
#' in the *Amazon EKS User Guide*. Amazon EKS managed node groups support
#' the November 2022 and later releases of the Windows AMIs. For
#' information about Windows versions, see [Amazon EKS optimized Windows
#' AMI
#' versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html)
#' in the *Amazon EKS User Guide*.
#' 
#' If you specify `launchTemplate`, and your launch template uses a custom
#' AMI, then don't specify `releaseVersion`, or the node group update will
#' fail. For more information about using launch templates with Amazon EKS,
#' see [Customizing managed nodes with launch
#' templates](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param launchTemplate An object representing a node group's launch template specification. You
#' can only update a node group using a launch template if the node group
#' was originally deployed with a launch template.
#' @param force Force the update if any `Pod` on the existing node group can't be
#' drained due to a `Pod` disruption budget issue. If an update fails
#' because all Pods can't be drained, you can force the update after it
#' fails to terminate the old node whether or not any `Pod` is running on
#' the node.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_update_nodegroup_version
eks_update_nodegroup_version <- function(clusterName, nodegroupName, version = NULL, releaseVersion = NULL, launchTemplate = NULL, force = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateNodegroupVersion",
    http_method = "POST",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}/update-version",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$update_nodegroup_version_input(clusterName = clusterName, nodegroupName = nodegroupName, version = version, releaseVersion = releaseVersion, launchTemplate = launchTemplate, force = force, clientRequestToken = clientRequestToken)
  output <- .eks$update_nodegroup_version_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_nodegroup_version <- eks_update_nodegroup_version

#' Updates a EKS Pod Identity association
#'
#' @description
#' Updates a EKS Pod Identity association. Only the IAM role can be changed; an association can't be moved between clusters, namespaces, or service accounts. If you need to edit the namespace or service account, you need to delete the association and then create a new association with your desired settings.
#'
#' See [https://www.paws-r-sdk.com/docs/eks_update_pod_identity_association/](https://www.paws-r-sdk.com/docs/eks_update_pod_identity_association/) for full documentation.
#'
#' @param clusterName &#91;required&#93; The name of the cluster that you want to update the association in.
#' @param associationId &#91;required&#93; The ID of the association to be updated.
#' @param roleArn The new IAM role to change the
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname eks_update_pod_identity_association
eks_update_pod_identity_association <- function(clusterName, associationId, roleArn = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdatePodIdentityAssociation",
    http_method = "POST",
    http_path = "/clusters/{name}/pod-identity-associations/{associationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .eks$update_pod_identity_association_input(clusterName = clusterName, associationId = associationId, roleArn = roleArn, clientRequestToken = clientRequestToken)
  output <- .eks$update_pod_identity_association_output()
  config <- get_config()
  svc <- .eks$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_pod_identity_association <- eks_update_pod_identity_association
