% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_egress_only_internet_gateway}
\alias{ec2_create_egress_only_internet_gateway}
\title{[IPv6 only] Creates an egress-only internet gateway for your VPC}
\usage{
ec2_create_egress_only_internet_gateway(
  ClientToken = NULL,
  DryRun = NULL,
  VpcId,
  TagSpecifications = NULL
)
}
\arguments{
\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcId}{[required] The ID of the VPC for which to create the egress-only internet gateway.}

\item{TagSpecifications}{The tags to assign to the egress-only internet gateway.}
}
\description{
[IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6 connection with your instance.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_egress_only_internet_gateway/} for full documentation.
}
\keyword{internal}
