% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_launch_template}
\alias{ec2_create_launch_template}
\title{Creates a launch template}
\usage{
ec2_create_launch_template(
  DryRun = NULL,
  ClientToken = NULL,
  LaunchTemplateName,
  VersionDescription = NULL,
  LaunchTemplateData,
  Operator = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.

Constraint: Maximum 128 ASCII characters.}

\item{LaunchTemplateName}{[required] A name for the launch template.}

\item{VersionDescription}{A description for the first version of the launch template.}

\item{LaunchTemplateData}{[required] The information for the launch template.}

\item{Operator}{Reserved for internal use.}

\item{TagSpecifications}{The tags to apply to the launch template on creation. To tag the launch
template, the resource type must be \code{launch-template}.

To specify the tags for the resources that are created when an instance
is launched, you must use the \code{TagSpecifications} parameter in the
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestLaunchTemplateData.html}{launch template data}
structure.}
}
\description{
Creates a launch template.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_launch_template/} for full documentation.
}
\keyword{internal}
