% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_provision_ipam_pool_cidr}
\alias{ec2_provision_ipam_pool_cidr}
\title{Provision a CIDR to an IPAM pool}
\usage{
ec2_provision_ipam_pool_cidr(
  DryRun = NULL,
  IpamPoolId,
  Cidr = NULL,
  CidrAuthorizationContext = NULL,
  NetmaskLength = NULL,
  ClientToken = NULL,
  VerificationMethod = NULL,
  IpamExternalResourceVerificationTokenId = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamPoolId}{[required] The ID of the IPAM pool to which you want to assign a CIDR.}

\item{Cidr}{The CIDR you want to assign to the IPAM pool. Either "NetmaskLength" or
"Cidr" is required. This value will be null if you specify
"NetmaskLength" and will be filled in during the provisioning process.}

\item{CidrAuthorizationContext}{A signed document that proves that you are authorized to bring a
specified IP address range to Amazon using BYOIP. This option only
applies to IPv4 and IPv6 pools in the public scope.}

\item{NetmaskLength}{The netmask length of the CIDR you'd like to provision to a pool. Can be
used for provisioning Amazon-provided IPv6 CIDRs to top-level pools and
for provisioning CIDRs to pools with source pools. Cannot be used to
provision BYOIP CIDRs to top-level pools. Either "NetmaskLength" or
"Cidr" is required.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{VerificationMethod}{The method for verifying control of a public IP address range. Defaults
to \code{remarks-x509} if not specified. This option only applies to IPv4 and
IPv6 pools in the public scope.}

\item{IpamExternalResourceVerificationTokenId}{Verification token ID. This option only applies to IPv4 and IPv6 pools
in the public scope.}
}
\description{
Provision a CIDR to an IPAM pool. You can use this action to provision new CIDRs to a top-level pool or to transfer a CIDR from a top-level pool to a pool within it.

See \url{https://www.paws-r-sdk.com/docs/ec2_provision_ipam_pool_cidr/} for full documentation.
}
\keyword{internal}
