% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing_operations.R
\name{pricing_list_price_lists}
\alias{pricing_list_price_lists}
\title{This feature is in preview release and is subject to change}
\usage{
pricing_list_price_lists(
  ServiceCode,
  EffectiveDate,
  RegionCode = NULL,
  CurrencyCode,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{ServiceCode}{[required] The service code or the Savings Plan service code for the attributes
that you want to retrieve. For example, to get the list of applicable
Amazon EC2 price lists, use \code{AmazonEC2}. For a full list of service
codes containing On-Demand and Reserved Instance (RI) pricing, use the
\code{\link[=pricing_describe_services]{describe_services}} API.

To retrieve the Reserved Instance and Compute Savings Plan price lists,
use \code{ComputeSavingsPlans}.

To retrieve Machine Learning Savings Plans price lists, use
\code{MachineLearningSavingsPlans}.}

\item{EffectiveDate}{[required] The date that the Price List file prices are effective from.}

\item{RegionCode}{This is used to filter the Price List by Amazon Web Services Region. For
example, to get the price list only for the \verb{US East (N. Virginia)}
Region, use \code{us-east-1}. If nothing is specified, you retrieve price
lists for all applicable Regions. The available \code{RegionCode} list can be
retrieved from \code{\link[=pricing_get_attribute_values]{get_attribute_values}}
API.}

\item{CurrencyCode}{[required] The three alphabetical character ISO-4217 currency code that the Price
List files are denominated in.}

\item{NextToken}{The pagination token that indicates the next set of results that you
want to retrieve.}

\item{MaxResults}{The maximum number of results to return in the response.}
}
\description{
\emph{This feature is in preview release and is subject to change. Your use of Amazon Web Services Price List API is subject to the Beta Service Participation terms of the \href{https://aws.amazon.com/service-terms/}{Amazon Web Services Service Terms} (Section 1.10).}

See \url{https://www.paws-r-sdk.com/docs/pricing_list_price_lists/} for full documentation.
}
\keyword{internal}
