# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Bedrock
#'
#' @description
#' Describes the API operations for creating, managing, fine-turning, and
#' evaluating Amazon Bedrock models.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- bedrock(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- bedrock()
#' svc$batch_delete_evaluation_job(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=bedrock_batch_delete_evaluation_job]{batch_delete_evaluation_job} \tab Deletes a batch of evaluation jobs\cr
#'  \link[=bedrock_create_evaluation_job]{create_evaluation_job} \tab Creates an evaluation job\cr
#'  \link[=bedrock_create_guardrail]{create_guardrail} \tab Creates a guardrail to block topics and to implement safeguards for your generative AI applications\cr
#'  \link[=bedrock_create_guardrail_version]{create_guardrail_version} \tab Creates a version of the guardrail\cr
#'  \link[=bedrock_create_inference_profile]{create_inference_profile} \tab Creates an application inference profile to track metrics and costs when invoking a model\cr
#'  \link[=bedrock_create_marketplace_model_endpoint]{create_marketplace_model_endpoint} \tab Creates an endpoint for a model from Amazon Bedrock Marketplace\cr
#'  \link[=bedrock_create_model_copy_job]{create_model_copy_job} \tab Copies a model to another region so that it can be used there\cr
#'  \link[=bedrock_create_model_customization_job]{create_model_customization_job} \tab Creates a fine-tuning job to customize a base model\cr
#'  \link[=bedrock_create_model_import_job]{create_model_import_job} \tab Creates a model import job to import model that you have customized in other environments, such as Amazon SageMaker\cr
#'  \link[=bedrock_create_model_invocation_job]{create_model_invocation_job} \tab Creates a batch inference job to invoke a model on multiple prompts\cr
#'  \link[=bedrock_create_provisioned_model_throughput]{create_provisioned_model_throughput} \tab Creates dedicated throughput for a base or custom model with the model units and for the duration that you specify\cr
#'  \link[=bedrock_delete_custom_model]{delete_custom_model} \tab Deletes a custom model that you created earlier\cr
#'  \link[=bedrock_delete_guardrail]{delete_guardrail} \tab Deletes a guardrail\cr
#'  \link[=bedrock_delete_imported_model]{delete_imported_model} \tab Deletes a custom model that you imported earlier\cr
#'  \link[=bedrock_delete_inference_profile]{delete_inference_profile} \tab Deletes an application inference profile\cr
#'  \link[=bedrock_delete_marketplace_model_endpoint]{delete_marketplace_model_endpoint} \tab Deletes an endpoint for a model from Amazon Bedrock Marketplace\cr
#'  \link[=bedrock_delete_model_invocation_logging_configuration]{delete_model_invocation_logging_configuration} \tab Delete the invocation logging\cr
#'  \link[=bedrock_delete_provisioned_model_throughput]{delete_provisioned_model_throughput} \tab Deletes a Provisioned Throughput\cr
#'  \link[=bedrock_deregister_marketplace_model_endpoint]{deregister_marketplace_model_endpoint} \tab Deregisters an endpoint for a model from Amazon Bedrock Marketplace\cr
#'  \link[=bedrock_get_custom_model]{get_custom_model} \tab Get the properties associated with a Amazon Bedrock custom model that you have created\cr
#'  \link[=bedrock_get_evaluation_job]{get_evaluation_job} \tab Gets information about an evaluation job, such as the status of the job\cr
#'  \link[=bedrock_get_foundation_model]{get_foundation_model} \tab Get details about a Amazon Bedrock foundation model\cr
#'  \link[=bedrock_get_guardrail]{get_guardrail} \tab Gets details about a guardrail\cr
#'  \link[=bedrock_get_imported_model]{get_imported_model} \tab Gets properties associated with a customized model you imported\cr
#'  \link[=bedrock_get_inference_profile]{get_inference_profile} \tab Gets information about an inference profile\cr
#'  \link[=bedrock_get_marketplace_model_endpoint]{get_marketplace_model_endpoint} \tab Retrieves details about a specific endpoint for a model from Amazon Bedrock Marketplace\cr
#'  \link[=bedrock_get_model_copy_job]{get_model_copy_job} \tab Retrieves information about a model copy job\cr
#'  \link[=bedrock_get_model_customization_job]{get_model_customization_job} \tab Retrieves the properties associated with a model-customization job, including the status of the job\cr
#'  \link[=bedrock_get_model_import_job]{get_model_import_job} \tab Retrieves the properties associated with import model job, including the status of the job\cr
#'  \link[=bedrock_get_model_invocation_job]{get_model_invocation_job} \tab Gets details about a batch inference job\cr
#'  \link[=bedrock_get_model_invocation_logging_configuration]{get_model_invocation_logging_configuration} \tab Get the current configuration values for model invocation logging\cr
#'  \link[=bedrock_get_prompt_router]{get_prompt_router} \tab Retrieves details about a prompt router\cr
#'  \link[=bedrock_get_provisioned_model_throughput]{get_provisioned_model_throughput} \tab Returns details for a Provisioned Throughput\cr
#'  \link[=bedrock_list_custom_models]{list_custom_models} \tab Returns a list of the custom models that you have created with the CreateModelCustomizationJob operation\cr
#'  \link[=bedrock_list_evaluation_jobs]{list_evaluation_jobs} \tab Lists all existing evaluation jobs\cr
#'  \link[=bedrock_list_foundation_models]{list_foundation_models} \tab Lists Amazon Bedrock foundation models that you can use\cr
#'  \link[=bedrock_list_guardrails]{list_guardrails} \tab Lists details about all the guardrails in an account\cr
#'  \link[=bedrock_list_imported_models]{list_imported_models} \tab Returns a list of models you've imported\cr
#'  \link[=bedrock_list_inference_profiles]{list_inference_profiles} \tab Returns a list of inference profiles that you can use\cr
#'  \link[=bedrock_list_marketplace_model_endpoints]{list_marketplace_model_endpoints} \tab Lists the endpoints for models from Amazon Bedrock Marketplace in your Amazon Web Services account\cr
#'  \link[=bedrock_list_model_copy_jobs]{list_model_copy_jobs} \tab Returns a list of model copy jobs that you have submitted\cr
#'  \link[=bedrock_list_model_customization_jobs]{list_model_customization_jobs} \tab Returns a list of model customization jobs that you have submitted\cr
#'  \link[=bedrock_list_model_import_jobs]{list_model_import_jobs} \tab Returns a list of import jobs you've submitted\cr
#'  \link[=bedrock_list_model_invocation_jobs]{list_model_invocation_jobs} \tab Lists all batch inference jobs in the account\cr
#'  \link[=bedrock_list_prompt_routers]{list_prompt_routers} \tab Retrieves a list of prompt routers\cr
#'  \link[=bedrock_list_provisioned_model_throughputs]{list_provisioned_model_throughputs} \tab Lists the Provisioned Throughputs in the account\cr
#'  \link[=bedrock_list_tags_for_resource]{list_tags_for_resource} \tab List the tags associated with the specified resource\cr
#'  \link[=bedrock_put_model_invocation_logging_configuration]{put_model_invocation_logging_configuration} \tab Set the configuration values for model invocation logging\cr
#'  \link[=bedrock_register_marketplace_model_endpoint]{register_marketplace_model_endpoint} \tab Registers an existing Amazon SageMaker endpoint with Amazon Bedrock Marketplace, allowing it to be used with Amazon Bedrock APIs\cr
#'  \link[=bedrock_stop_evaluation_job]{stop_evaluation_job} \tab Stops an evaluation job that is current being created or running\cr
#'  \link[=bedrock_stop_model_customization_job]{stop_model_customization_job} \tab Stops an active model customization job\cr
#'  \link[=bedrock_stop_model_invocation_job]{stop_model_invocation_job} \tab Stops a batch inference job\cr
#'  \link[=bedrock_tag_resource]{tag_resource} \tab Associate tags with a resource\cr
#'  \link[=bedrock_untag_resource]{untag_resource} \tab Remove one or more tags from a resource\cr
#'  \link[=bedrock_update_guardrail]{update_guardrail} \tab Updates a guardrail with the values you specify\cr
#'  \link[=bedrock_update_marketplace_model_endpoint]{update_marketplace_model_endpoint} \tab Updates the configuration of an existing endpoint for a model from Amazon Bedrock Marketplace\cr
#'  \link[=bedrock_update_provisioned_model_throughput]{update_provisioned_model_throughput} \tab Updates the name or associated model for a Provisioned Throughput
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname bedrock
#' @export
bedrock <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .bedrock$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.bedrock <- list()

.bedrock$operations <- list()

.bedrock$metadata <- list(
  service_name = "bedrock",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "bedrock.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "bedrock.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "bedrock.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "bedrock.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "bedrock.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "bedrock.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "bedrock.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Bedrock",
  api_version = "2023-04-20",
  signing_name = "bedrock",
  json_version = "",
  target_prefix = ""
)

.bedrock$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.bedrock$metadata, handlers, config, op)
}
