# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sagemaker_service.R
NULL

#' Creates an association between the source and the destination
#'
#' @description
#' Creates an *association* between the source and the destination. A source can be associated with multiple destinations, and a destination can be associated with multiple sources. An association is a lineage tracking entity. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_add_association/](https://www.paws-r-sdk.com/docs/sagemaker_add_association/) for full documentation.
#'
#' @param SourceArn &#91;required&#93; The ARN of the source.
#' @param DestinationArn &#91;required&#93; The Amazon Resource Name (ARN) of the destination.
#' @param AssociationType The type of association. The following are suggested uses for each type.
#' Amazon SageMaker places no restrictions on their use.
#' 
#' -   ContributedTo - The source contributed to the destination or had a
#'     part in enabling the destination. For example, the training data
#'     contributed to the training job.
#' 
#' -   AssociatedWith - The source is connected to the destination. For
#'     example, an approval workflow is associated with a model deployment.
#' 
#' -   DerivedFrom - The destination is a modification of the source. For
#'     example, a digest output of a channel input for a processing job is
#'     derived from the original inputs.
#' 
#' -   Produced - The source generated the destination. For example, a
#'     training job produced a model artifact.
#'
#' @keywords internal
#'
#' @rdname sagemaker_add_association
sagemaker_add_association <- function(SourceArn, DestinationArn, AssociationType = NULL) {
  op <- new_operation(
    name = "AddAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$add_association_input(SourceArn = SourceArn, DestinationArn = DestinationArn, AssociationType = AssociationType)
  output <- .sagemaker$add_association_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$add_association <- sagemaker_add_association

#' Adds or overwrites one or more tags for the specified SageMaker resource
#'
#' @description
#' Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_add_tags/](https://www.paws-r-sdk.com/docs/sagemaker_add_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to tag.
#' @param Tags &#91;required&#93; An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_add_tags
sagemaker_add_tags <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$add_tags_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .sagemaker$add_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$add_tags <- sagemaker_add_tags

#' Associates a trial component with a trial
#'
#' @description
#' Associates a trial component with a trial. A trial component can be associated with multiple trials. To disassociate a trial component from a trial, call the [`disassociate_trial_component`][sagemaker_disassociate_trial_component] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_associate_trial_component/](https://www.paws-r-sdk.com/docs/sagemaker_associate_trial_component/) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to associated with the trial.
#' @param TrialName &#91;required&#93; The name of the trial to associate with.
#'
#' @keywords internal
#'
#' @rdname sagemaker_associate_trial_component
sagemaker_associate_trial_component <- function(TrialComponentName, TrialName) {
  op <- new_operation(
    name = "AssociateTrialComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$associate_trial_component_input(TrialComponentName = TrialComponentName, TrialName = TrialName)
  output <- .sagemaker$associate_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$associate_trial_component <- sagemaker_associate_trial_component

#' Deletes specific nodes within a SageMaker HyperPod cluster
#'
#' @description
#' Deletes specific nodes within a SageMaker HyperPod cluster. [`batch_delete_cluster_nodes`][sagemaker_batch_delete_cluster_nodes] accepts a cluster name and a list of node IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_batch_delete_cluster_nodes/](https://www.paws-r-sdk.com/docs/sagemaker_batch_delete_cluster_nodes/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The name of the SageMaker HyperPod cluster from which to delete the
#' specified nodes.
#' @param NodeIds &#91;required&#93; A list of node IDs to be deleted from the specified cluster.
#' 
#' For SageMaker HyperPod clusters using the Slurm workload manager, you
#' cannot remove instances that are configured as Slurm controller nodes.
#'
#' @keywords internal
#'
#' @rdname sagemaker_batch_delete_cluster_nodes
sagemaker_batch_delete_cluster_nodes <- function(ClusterName, NodeIds) {
  op <- new_operation(
    name = "BatchDeleteClusterNodes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$batch_delete_cluster_nodes_input(ClusterName = ClusterName, NodeIds = NodeIds)
  output <- .sagemaker$batch_delete_cluster_nodes_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$batch_delete_cluster_nodes <- sagemaker_batch_delete_cluster_nodes

#' This action batch describes a list of versioned model packages
#'
#' @description
#' This action batch describes a list of versioned model packages
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_batch_describe_model_package/](https://www.paws-r-sdk.com/docs/sagemaker_batch_describe_model_package/) for full documentation.
#'
#' @param ModelPackageArnList &#91;required&#93; The list of Amazon Resource Name (ARN) of the model package groups.
#'
#' @keywords internal
#'
#' @rdname sagemaker_batch_describe_model_package
sagemaker_batch_describe_model_package <- function(ModelPackageArnList) {
  op <- new_operation(
    name = "BatchDescribeModelPackage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$batch_describe_model_package_input(ModelPackageArnList = ModelPackageArnList)
  output <- .sagemaker$batch_describe_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$batch_describe_model_package <- sagemaker_batch_describe_model_package

#' Creates an action
#'
#' @description
#' Creates an *action*. An action is a lineage tracking entity that represents an action or activity. For example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_action/](https://www.paws-r-sdk.com/docs/sagemaker_create_action/) for full documentation.
#'
#' @param ActionName &#91;required&#93; The name of the action. Must be unique to your account in an Amazon Web
#' Services Region.
#' @param Source &#91;required&#93; The source type, ID, and URI.
#' @param ActionType &#91;required&#93; The action type.
#' @param Description The description of the action.
#' @param Status The status of the action.
#' @param Properties A list of properties to add to the action.
#' @param MetadataProperties 
#' @param Tags A list of tags to apply to the action.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_action
sagemaker_create_action <- function(ActionName, Source, ActionType, Description = NULL, Status = NULL, Properties = NULL, MetadataProperties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_action_input(ActionName = ActionName, Source = Source, ActionType = ActionType, Description = Description, Status = Status, Properties = Properties, MetadataProperties = MetadataProperties, Tags = Tags)
  output <- .sagemaker$create_action_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_action <- sagemaker_create_action

#' Create a machine learning algorithm that you can use in SageMaker and
#' list in the Amazon Web Services Marketplace
#'
#' @description
#' Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services Marketplace.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_algorithm/](https://www.paws-r-sdk.com/docs/sagemaker_create_algorithm/) for full documentation.
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm.
#' @param AlgorithmDescription A description of the algorithm.
#' @param TrainingSpecification &#91;required&#93; Specifies details about training jobs run by this algorithm, including
#' the following:
#' 
#' -   The Amazon ECR path of the container and the version digest of the
#'     algorithm.
#' 
#' -   The hyperparameters that the algorithm supports.
#' 
#' -   The instance types that the algorithm supports for training.
#' 
#' -   Whether the algorithm supports distributed training.
#' 
#' -   The metrics that the algorithm emits to Amazon CloudWatch.
#' 
#' -   Which metrics that the algorithm emits can be used as the objective
#'     metric for hyperparameter tuning jobs.
#' 
#' -   The input channels that the algorithm supports for training data.
#'     For example, an algorithm might support `train`, `validation`, and
#'     `test` channels.
#' @param InferenceSpecification Specifies details about inference jobs that the algorithm runs,
#' including the following:
#' 
#' -   The Amazon ECR paths of containers that contain the inference code
#'     and model artifacts.
#' 
#' -   The instance types that the algorithm supports for transform jobs
#'     and real-time endpoints used for inference.
#' 
#' -   The input and output content formats that the algorithm supports for
#'     inference.
#' @param ValidationSpecification Specifies configurations for one or more training jobs and that
#' SageMaker runs to test the algorithm's training code and, optionally,
#' one or more batch transform jobs that SageMaker runs to test the
#' algorithm's inference code.
#' @param CertifyForMarketplace Whether to certify the algorithm so that it can be listed in Amazon Web
#' Services Marketplace.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_algorithm
sagemaker_create_algorithm <- function(AlgorithmName, AlgorithmDescription = NULL, TrainingSpecification, InferenceSpecification = NULL, ValidationSpecification = NULL, CertifyForMarketplace = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAlgorithm",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_algorithm_input(AlgorithmName = AlgorithmName, AlgorithmDescription = AlgorithmDescription, TrainingSpecification = TrainingSpecification, InferenceSpecification = InferenceSpecification, ValidationSpecification = ValidationSpecification, CertifyForMarketplace = CertifyForMarketplace, Tags = Tags)
  output <- .sagemaker$create_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_algorithm <- sagemaker_create_algorithm

#' Creates a running app for the specified UserProfile
#'
#' @description
#' Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker AI upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_app/](https://www.paws-r-sdk.com/docs/sagemaker_create_app/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName The user profile name. If this value is not set, then `SpaceName` must
#' be set.
#' @param SpaceName The name of the space. If this value is not set, then `UserProfileName`
#' must be set.
#' @param AppType &#91;required&#93; The type of app.
#' @param AppName &#91;required&#93; The name of the app.
#' @param Tags Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource.
#' @param ResourceSpec The instance type and the Amazon Resource Name (ARN) of the SageMaker AI
#' image created on the instance.
#' 
#' The value of `InstanceType` passed as part of the `ResourceSpec` in the
#' [`create_app`][sagemaker_create_app] call overrides the value passed as
#' part of the `ResourceSpec` configured for the user profile or the
#' domain. If `InstanceType` is not specified in any of those three
#' `ResourceSpec` values for a `KernelGateway` app, the
#' [`create_app`][sagemaker_create_app] call fails with a request
#' validation error.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_app
sagemaker_create_app <- function(DomainId, UserProfileName = NULL, SpaceName = NULL, AppType, AppName, Tags = NULL, ResourceSpec = NULL) {
  op <- new_operation(
    name = "CreateApp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_app_input(DomainId = DomainId, UserProfileName = UserProfileName, SpaceName = SpaceName, AppType = AppType, AppName = AppName, Tags = Tags, ResourceSpec = ResourceSpec)
  output <- .sagemaker$create_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_app <- sagemaker_create_app

#' Creates a configuration for running a SageMaker AI image as a
#' KernelGateway app
#'
#' @description
#' Creates a configuration for running a SageMaker AI image as a KernelGateway app. The configuration specifies the Amazon Elastic File System storage volume on the image, and a list of the kernels in the image.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_app_image_config/](https://www.paws-r-sdk.com/docs/sagemaker_create_app_image_config/) for full documentation.
#'
#' @param AppImageConfigName &#91;required&#93; The name of the AppImageConfig. Must be unique to your account.
#' @param Tags A list of tags to apply to the AppImageConfig.
#' @param KernelGatewayImageConfig The KernelGatewayImageConfig. You can only specify one image kernel in
#' the AppImageConfig API. This kernel will be shown to users before the
#' image starts. Once the image runs, all kernels are visible in
#' JupyterLab.
#' @param JupyterLabAppImageConfig The `JupyterLabAppImageConfig`. You can only specify one image kernel in
#' the `AppImageConfig` API. This kernel is shown to users before the image
#' starts. After the image runs, all kernels are visible in JupyterLab.
#' @param CodeEditorAppImageConfig The `CodeEditorAppImageConfig`. You can only specify one image kernel in
#' the AppImageConfig API. This kernel is shown to users before the image
#' starts. After the image runs, all kernels are visible in Code Editor.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_app_image_config
sagemaker_create_app_image_config <- function(AppImageConfigName, Tags = NULL, KernelGatewayImageConfig = NULL, JupyterLabAppImageConfig = NULL, CodeEditorAppImageConfig = NULL) {
  op <- new_operation(
    name = "CreateAppImageConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_app_image_config_input(AppImageConfigName = AppImageConfigName, Tags = Tags, KernelGatewayImageConfig = KernelGatewayImageConfig, JupyterLabAppImageConfig = JupyterLabAppImageConfig, CodeEditorAppImageConfig = CodeEditorAppImageConfig)
  output <- .sagemaker$create_app_image_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_app_image_config <- sagemaker_create_app_image_config

#' Creates an artifact
#'
#' @description
#' Creates an *artifact*. An artifact is a lineage tracking entity that represents a URI addressable object or data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_artifact/](https://www.paws-r-sdk.com/docs/sagemaker_create_artifact/) for full documentation.
#'
#' @param ArtifactName The name of the artifact. Must be unique to your account in an Amazon
#' Web Services Region.
#' @param Source &#91;required&#93; The ID, ID type, and URI of the source.
#' @param ArtifactType &#91;required&#93; The artifact type.
#' @param Properties A list of properties to add to the artifact.
#' @param MetadataProperties 
#' @param Tags A list of tags to apply to the artifact.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_artifact
sagemaker_create_artifact <- function(ArtifactName = NULL, Source, ArtifactType, Properties = NULL, MetadataProperties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateArtifact",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_artifact_input(ArtifactName = ArtifactName, Source = Source, ArtifactType = ArtifactType, Properties = Properties, MetadataProperties = MetadataProperties, Tags = Tags)
  output <- .sagemaker$create_artifact_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_artifact <- sagemaker_create_artifact

#' Creates an Autopilot job also referred to as Autopilot experiment or
#' AutoML job
#'
#' @description
#' Creates an Autopilot job also referred to as Autopilot experiment or AutoML job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_auto_ml_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_auto_ml_job/) for full documentation.
#'
#' @param AutoMLJobName &#91;required&#93; Identifies an Autopilot job. The name must be unique to your account and
#' is case insensitive.
#' @param InputDataConfig &#91;required&#93; An array of channel objects that describes the input data and its
#' location. Each channel is a named input source. Similar to
#' `InputDataConfig` supported by
#' [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html).
#' Format(s) supported: CSV, Parquet. A minimum of 500 rows is required for
#' the training dataset. There is not a minimum number of rows required for
#' the validation dataset.
#' @param OutputDataConfig &#91;required&#93; Provides information about encryption and the Amazon S3 output path
#' needed to store artifacts from an AutoML job. Format(s) supported: CSV.
#' @param ProblemType Defines the type of supervised learning problem available for the
#' candidates. For more information, see [SageMaker Autopilot problem
#' types](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types).
#' @param AutoMLJobObjective Specifies a metric to minimize or maximize as the objective of a job. If
#' not specified, the default objective metric depends on the problem type.
#' See
#' [AutoMLJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html)
#' for the default values.
#' @param AutoMLJobConfig A collection of settings used to configure an AutoML job.
#' @param RoleArn &#91;required&#93; The ARN of the role that is used to access the data.
#' @param GenerateCandidateDefinitionsOnly Generates possible candidates without training the models. A candidate
#' is a combination of data preprocessors, algorithms, and algorithm
#' parameter settings.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' ServicesResources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' Tag keys must be unique per resource.
#' @param ModelDeployConfig Specifies how to generate the endpoint name for an automatic one-click
#' Autopilot model deployment.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_auto_ml_job
sagemaker_create_auto_ml_job <- function(AutoMLJobName, InputDataConfig, OutputDataConfig, ProblemType = NULL, AutoMLJobObjective = NULL, AutoMLJobConfig = NULL, RoleArn, GenerateCandidateDefinitionsOnly = NULL, Tags = NULL, ModelDeployConfig = NULL) {
  op <- new_operation(
    name = "CreateAutoMLJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_auto_ml_job_input(AutoMLJobName = AutoMLJobName, InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, ProblemType = ProblemType, AutoMLJobObjective = AutoMLJobObjective, AutoMLJobConfig = AutoMLJobConfig, RoleArn = RoleArn, GenerateCandidateDefinitionsOnly = GenerateCandidateDefinitionsOnly, Tags = Tags, ModelDeployConfig = ModelDeployConfig)
  output <- .sagemaker$create_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_auto_ml_job <- sagemaker_create_auto_ml_job

#' Creates an Autopilot job also referred to as Autopilot experiment or
#' AutoML job V2
#'
#' @description
#' Creates an Autopilot job also referred to as Autopilot experiment or AutoML job V2.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_auto_ml_job_v2/](https://www.paws-r-sdk.com/docs/sagemaker_create_auto_ml_job_v2/) for full documentation.
#'
#' @param AutoMLJobName &#91;required&#93; Identifies an Autopilot job. The name must be unique to your account and
#' is case insensitive.
#' @param AutoMLJobInputDataConfig &#91;required&#93; An array of channel objects describing the input data and their
#' location. Each channel is a named input source. Similar to the
#' [InputDataConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig)
#' attribute in the [`create_auto_ml_job`][sagemaker_create_auto_ml_job]
#' input parameters. The supported formats depend on the problem type:
#' 
#' -   For tabular problem types: `S3Prefix`, `ManifestFile`.
#' 
#' -   For image classification: `S3Prefix`, `ManifestFile`,
#'     `AugmentedManifestFile`.
#' 
#' -   For text classification: `S3Prefix`.
#' 
#' -   For time-series forecasting: `S3Prefix`.
#' 
#' -   For text generation (LLMs fine-tuning): `S3Prefix`.
#' @param OutputDataConfig &#91;required&#93; Provides information about encryption and the Amazon S3 output path
#' needed to store artifacts from an AutoML job.
#' @param AutoMLProblemTypeConfig &#91;required&#93; Defines the configuration settings of one of the supported problem
#' types.
#' @param RoleArn &#91;required&#93; The ARN of the role that is used to access the data.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, such as by purpose, owner, or
#' environment. For more information, see [Tagging Amazon Web
#' ServicesResources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' Tag keys must be unique per resource.
#' @param SecurityConfig The security configuration for traffic encryption or Amazon VPC
#' settings.
#' @param AutoMLJobObjective Specifies a metric to minimize or maximize as the objective of a job. If
#' not specified, the default objective metric depends on the problem type.
#' For the list of default values per problem type, see
#' [AutoMLJobObjective](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html).
#' 
#' -   For tabular problem types: You must either provide both the
#'     `AutoMLJobObjective` and indicate the type of supervised learning
#'     problem in `AutoMLProblemTypeConfig`
#'     (`TabularJobConfig.ProblemType`), or none at all.
#' 
#' -   For text generation problem types (LLMs fine-tuning): Fine-tuning
#'     language models in Autopilot does not require setting the
#'     `AutoMLJobObjective` field. Autopilot fine-tunes LLMs without
#'     requiring multiple candidates to be trained and evaluated. Instead,
#'     using your dataset, Autopilot directly fine-tunes your target model
#'     to enhance a default objective metric, the cross-entropy loss. After
#'     fine-tuning a language model, you can evaluate the quality of its
#'     generated text using different metrics. For a list of the available
#'     metrics, see [Metrics for fine-tuning LLMs in
#'     Autopilot](https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-metrics.html).
#' @param ModelDeployConfig Specifies how to generate the endpoint name for an automatic one-click
#' Autopilot model deployment.
#' @param DataSplitConfig This structure specifies how to split the data into train and validation
#' datasets.
#' 
#' The validation and training datasets must contain the same headers. For
#' jobs created by calling
#' [`create_auto_ml_job`][sagemaker_create_auto_ml_job], the validation
#' dataset must be less than 2 GB in size.
#' 
#' This attribute must not be set for the time-series forecasting problem
#' type, as Autopilot automatically splits the input dataset into training
#' and validation sets.
#' @param AutoMLComputeConfig Specifies the compute configuration for the AutoML job V2.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_auto_ml_job_v2
sagemaker_create_auto_ml_job_v2 <- function(AutoMLJobName, AutoMLJobInputDataConfig, OutputDataConfig, AutoMLProblemTypeConfig, RoleArn, Tags = NULL, SecurityConfig = NULL, AutoMLJobObjective = NULL, ModelDeployConfig = NULL, DataSplitConfig = NULL, AutoMLComputeConfig = NULL) {
  op <- new_operation(
    name = "CreateAutoMLJobV2",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_auto_ml_job_v2_input(AutoMLJobName = AutoMLJobName, AutoMLJobInputDataConfig = AutoMLJobInputDataConfig, OutputDataConfig = OutputDataConfig, AutoMLProblemTypeConfig = AutoMLProblemTypeConfig, RoleArn = RoleArn, Tags = Tags, SecurityConfig = SecurityConfig, AutoMLJobObjective = AutoMLJobObjective, ModelDeployConfig = ModelDeployConfig, DataSplitConfig = DataSplitConfig, AutoMLComputeConfig = AutoMLComputeConfig)
  output <- .sagemaker$create_auto_ml_job_v2_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_auto_ml_job_v2 <- sagemaker_create_auto_ml_job_v2

#' Creates a SageMaker HyperPod cluster
#'
#' @description
#' Creates a SageMaker HyperPod cluster. SageMaker HyperPod is a capability of SageMaker for creating and managing persistent clusters for developing large machine learning models, such as large language models (LLMs) and diffusion models. To learn more, see [Amazon SageMaker HyperPod](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html) in the *Amazon SageMaker Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_cluster/](https://www.paws-r-sdk.com/docs/sagemaker_create_cluster/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The name for the new SageMaker HyperPod cluster.
#' @param InstanceGroups &#91;required&#93; The instance groups to be created in the SageMaker HyperPod cluster.
#' @param VpcConfig Specifies the Amazon Virtual Private Cloud (VPC) that is associated with
#' the Amazon SageMaker HyperPod cluster. You can control access to and
#' from your resources by configuring your VPC. For more information, see
#' [Give SageMaker access to resources in your Amazon
#' VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
#' 
#' When your Amazon VPC and subnets support IPv6, network communications
#' differ based on the cluster orchestration platform:
#' 
#' -   Slurm-orchestrated clusters automatically configure nodes with dual
#'     IPv6 and IPv4 addresses, allowing immediate IPv6 network
#'     communications.
#' 
#' -   In Amazon EKS-orchestrated clusters, nodes receive dual-stack
#'     addressing, but pods can only use IPv6 when the Amazon EKS cluster
#'     is explicitly IPv6-enabled. For information about deploying an IPv6
#'     Amazon EKS cluster, see [Amazon EKS IPv6 Cluster
#'     Deployment](https://docs.aws.amazon.com/eks/latest/userguide/deploy-ipv6-cluster.html#_deploy_an_ipv6_cluster_with_eksctl).
#' 
#' Additional resources for IPv6 configuration:
#' 
#' -   For information about adding IPv6 support to your VPC, see to [IPv6
#'     Support for
#'     VPC](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-migrate-ipv6.html).
#' 
#' -   For information about creating a new IPv6-compatible VPC, see
#'     [Amazon VPC Creation
#'     Guide](https://docs.aws.amazon.com/vpc/latest/userguide/create-vpc.html).
#' 
#' -   To configure SageMaker HyperPod with a custom Amazon VPC, see
#'     [Custom Amazon VPC Setup for SageMaker
#'     HyperPod](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-optional-vpc).
#' @param Tags Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web
#' Services resource. You can add tags to your cluster in the same way you
#' add them in other Amazon Web Services services that support tagging. To
#' learn more about tagging Amazon Web Services resources in general, see
#' [Tagging Amazon Web Services Resources User
#' Guide](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' @param Orchestrator The type of orchestrator to use for the SageMaker HyperPod cluster.
#' Currently, the only supported value is `"eks"`, which is to use an
#' Amazon Elastic Kubernetes Service (EKS) cluster as the orchestrator.
#' @param NodeRecovery The node recovery mode for the SageMaker HyperPod cluster. When set to
#' `Automatic`, SageMaker HyperPod will automatically reboot or replace
#' faulty nodes when issues are detected. When set to `None`, cluster
#' administrators will need to manually manage any faulty cluster
#' instances.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_cluster
sagemaker_create_cluster <- function(ClusterName, InstanceGroups, VpcConfig = NULL, Tags = NULL, Orchestrator = NULL, NodeRecovery = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_cluster_input(ClusterName = ClusterName, InstanceGroups = InstanceGroups, VpcConfig = VpcConfig, Tags = Tags, Orchestrator = Orchestrator, NodeRecovery = NodeRecovery)
  output <- .sagemaker$create_cluster_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_cluster <- sagemaker_create_cluster

#' Create cluster policy configuration
#'
#' @description
#' Create cluster policy configuration. This policy is used for task prioritization and fair-share allocation of idle compute. This helps prioritize critical workloads and distributes idle compute across entities.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_cluster_scheduler_config/](https://www.paws-r-sdk.com/docs/sagemaker_create_cluster_scheduler_config/) for full documentation.
#'
#' @param Name &#91;required&#93; Name for the cluster policy.
#' @param ClusterArn &#91;required&#93; ARN of the cluster.
#' @param SchedulerConfig &#91;required&#93; Configuration about the monitoring schedule.
#' @param Description Description of the cluster policy.
#' @param Tags Tags of the cluster policy.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_cluster_scheduler_config
sagemaker_create_cluster_scheduler_config <- function(Name, ClusterArn, SchedulerConfig, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateClusterSchedulerConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_cluster_scheduler_config_input(Name = Name, ClusterArn = ClusterArn, SchedulerConfig = SchedulerConfig, Description = Description, Tags = Tags)
  output <- .sagemaker$create_cluster_scheduler_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_cluster_scheduler_config <- sagemaker_create_cluster_scheduler_config

#' Creates a Git repository as a resource in your SageMaker AI account
#'
#' @description
#' Creates a Git repository as a resource in your SageMaker AI account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker AI account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_code_repository/](https://www.paws-r-sdk.com/docs/sagemaker_create_code_repository/) for full documentation.
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository. The name must have 1 to 63 characters.
#' Valid characters are a-z, A-Z, 0-9, and - (hyphen).
#' @param GitConfig &#91;required&#93; Specifies details about the repository, including the URL where the
#' repository is located, the default branch, and credentials to use to
#' access the repository.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_code_repository
sagemaker_create_code_repository <- function(CodeRepositoryName, GitConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateCodeRepository",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_code_repository_input(CodeRepositoryName = CodeRepositoryName, GitConfig = GitConfig, Tags = Tags)
  output <- .sagemaker$create_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_code_repository <- sagemaker_create_code_repository

#' Starts a model compilation job
#'
#' @description
#' Starts a model compilation job. After the model has been compiled, Amazon SageMaker AI saves the resulting model artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_compilation_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_compilation_job/) for full documentation.
#'
#' @param CompilationJobName &#91;required&#93; A name for the model compilation job. The name must be unique within the
#' Amazon Web Services Region and within your Amazon Web Services account.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that enables Amazon
#' SageMaker AI to perform tasks on your behalf.
#' 
#' During model compilation, Amazon SageMaker AI needs your permission to:
#' 
#' -   Read input data from an S3 bucket
#' 
#' -   Write model artifacts to an S3 bucket
#' 
#' -   Write logs to Amazon CloudWatch Logs
#' 
#' -   Publish metrics to Amazon CloudWatch
#' 
#' You grant permissions for all of these tasks to an IAM role. To pass
#' this role to Amazon SageMaker AI, the caller of this API must have the
#' `iam:PassRole` permission. For more information, see [Amazon SageMaker
#' AI
#' Roles.](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html)
#' @param ModelPackageVersionArn The Amazon Resource Name (ARN) of a versioned model package. Provide
#' either a `ModelPackageVersionArn` or an `InputConfig` object in the
#' request syntax. The presence of both objects in the
#' [`create_compilation_job`][sagemaker_create_compilation_job] request
#' will return an exception.
#' @param InputConfig Provides information about the location of input model artifacts, the
#' name and shape of the expected data inputs, and the framework in which
#' the model was trained.
#' @param OutputConfig &#91;required&#93; Provides information about the output location for the compiled model
#' and the target device the model runs on.
#' @param VpcConfig A
#' [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html)
#' object that specifies the VPC that you want your compilation job to
#' connect to. Control access to your models by configuring the VPC. For
#' more information, see [Protect Compilation Jobs by Using an Amazon
#' Virtual Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html).
#' @param StoppingCondition &#91;required&#93; Specifies a limit to how long a model compilation job can run. When the
#' job reaches the time limit, Amazon SageMaker AI ends the compilation
#' job. Use this API to cap model training costs.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_compilation_job
sagemaker_create_compilation_job <- function(CompilationJobName, RoleArn, ModelPackageVersionArn = NULL, InputConfig = NULL, OutputConfig, VpcConfig = NULL, StoppingCondition, Tags = NULL) {
  op <- new_operation(
    name = "CreateCompilationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_compilation_job_input(CompilationJobName = CompilationJobName, RoleArn = RoleArn, ModelPackageVersionArn = ModelPackageVersionArn, InputConfig = InputConfig, OutputConfig = OutputConfig, VpcConfig = VpcConfig, StoppingCondition = StoppingCondition, Tags = Tags)
  output <- .sagemaker$create_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_compilation_job <- sagemaker_create_compilation_job

#' Create compute allocation definition
#'
#' @description
#' Create compute allocation definition. This defines how compute is allocated, shared, and borrowed for specified entities. Specifically, how to lend and borrow idle compute and assign a fair-share weight to the specified entities.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_compute_quota/](https://www.paws-r-sdk.com/docs/sagemaker_create_compute_quota/) for full documentation.
#'
#' @param Name &#91;required&#93; Name to the compute allocation definition.
#' @param Description Description of the compute allocation definition.
#' @param ClusterArn &#91;required&#93; ARN of the cluster.
#' @param ComputeQuotaConfig &#91;required&#93; Configuration of the compute allocation definition. This includes the
#' resource sharing option, and the setting to preempt low priority tasks.
#' @param ComputeQuotaTarget &#91;required&#93; The target entity to allocate compute resources to.
#' @param ActivationState The state of the compute allocation being described. Use to enable or
#' disable compute allocation.
#' 
#' Default is `Enabled`.
#' @param Tags Tags of the compute allocation definition.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_compute_quota
sagemaker_create_compute_quota <- function(Name, Description = NULL, ClusterArn, ComputeQuotaConfig, ComputeQuotaTarget, ActivationState = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateComputeQuota",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_compute_quota_input(Name = Name, Description = Description, ClusterArn = ClusterArn, ComputeQuotaConfig = ComputeQuotaConfig, ComputeQuotaTarget = ComputeQuotaTarget, ActivationState = ActivationState, Tags = Tags)
  output <- .sagemaker$create_compute_quota_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_compute_quota <- sagemaker_create_compute_quota

#' Creates a context
#'
#' @description
#' Creates a *context*. A context is a lineage tracking entity that represents a logical grouping of other tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_context/](https://www.paws-r-sdk.com/docs/sagemaker_create_context/) for full documentation.
#'
#' @param ContextName &#91;required&#93; The name of the context. Must be unique to your account in an Amazon Web
#' Services Region.
#' @param Source &#91;required&#93; The source type, ID, and URI.
#' @param ContextType &#91;required&#93; The context type.
#' @param Description The description of the context.
#' @param Properties A list of properties to add to the context.
#' @param Tags A list of tags to apply to the context.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_context
sagemaker_create_context <- function(ContextName, Source, ContextType, Description = NULL, Properties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateContext",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_context_input(ContextName = ContextName, Source = Source, ContextType = ContextType, Description = Description, Properties = Properties, Tags = Tags)
  output <- .sagemaker$create_context_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_context <- sagemaker_create_context

#' Creates a definition for a job that monitors data quality and drift
#'
#' @description
#' Creates a definition for a job that monitors data quality and drift. For information about model monitor, see [Amazon SageMaker AI Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_data_quality_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_create_data_quality_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name for the monitoring job definition.
#' @param DataQualityBaselineConfig Configures the constraints and baselines for the monitoring job.
#' @param DataQualityAppSpecification &#91;required&#93; Specifies the container that runs the monitoring job.
#' @param DataQualityJobInput &#91;required&#93; A list of inputs for the monitoring job. Currently endpoints are
#' supported as monitoring inputs.
#' @param DataQualityJobOutputConfig &#91;required&#93; 
#' @param JobResources &#91;required&#93; 
#' @param NetworkConfig Specifies networking configuration for the monitoring job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI
#' can assume to perform tasks on your behalf.
#' @param StoppingCondition 
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_data_quality_job_definition
sagemaker_create_data_quality_job_definition <- function(JobDefinitionName, DataQualityBaselineConfig = NULL, DataQualityAppSpecification, DataQualityJobInput, DataQualityJobOutputConfig, JobResources, NetworkConfig = NULL, RoleArn, StoppingCondition = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDataQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_data_quality_job_definition_input(JobDefinitionName = JobDefinitionName, DataQualityBaselineConfig = DataQualityBaselineConfig, DataQualityAppSpecification = DataQualityAppSpecification, DataQualityJobInput = DataQualityJobInput, DataQualityJobOutputConfig = DataQualityJobOutputConfig, JobResources = JobResources, NetworkConfig = NetworkConfig, RoleArn = RoleArn, StoppingCondition = StoppingCondition, Tags = Tags)
  output <- .sagemaker$create_data_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_data_quality_job_definition <- sagemaker_create_data_quality_job_definition

#' Creates a device fleet
#'
#' @description
#' Creates a device fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_device_fleet/](https://www.paws-r-sdk.com/docs/sagemaker_create_device_fleet/) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet that the device belongs to.
#' @param RoleArn The Amazon Resource Name (ARN) that has access to Amazon Web Services
#' Internet of Things (IoT).
#' @param Description A description of the fleet.
#' @param OutputConfig &#91;required&#93; The output configuration for storing sample data collected by the fleet.
#' @param Tags Creates tags for the specified fleet.
#' @param EnableIotRoleAlias Whether to create an Amazon Web Services IoT Role Alias during device
#' fleet creation. The name of the role alias generated will match this
#' pattern: "SageMakerEdge-\{DeviceFleetName\}".
#' 
#' For example, if your device fleet is called "demo-fleet", the name of
#' the role alias will be "SageMakerEdge-demo-fleet".
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_device_fleet
sagemaker_create_device_fleet <- function(DeviceFleetName, RoleArn = NULL, Description = NULL, OutputConfig, Tags = NULL, EnableIotRoleAlias = NULL) {
  op <- new_operation(
    name = "CreateDeviceFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_device_fleet_input(DeviceFleetName = DeviceFleetName, RoleArn = RoleArn, Description = Description, OutputConfig = OutputConfig, Tags = Tags, EnableIotRoleAlias = EnableIotRoleAlias)
  output <- .sagemaker$create_device_fleet_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_device_fleet <- sagemaker_create_device_fleet

#' Creates a Domain
#'
#' @description
#' Creates a `Domain`. A domain consists of an associated Amazon Elastic File System volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. Users within a domain can share notebook files and other artifacts with each other.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_domain/](https://www.paws-r-sdk.com/docs/sagemaker_create_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; A name for the domain.
#' @param AuthMode &#91;required&#93; The mode of authentication that members use to access the domain.
#' @param DefaultUserSettings &#91;required&#93; The default settings to use to create a user profile when `UserSettings`
#' isn't specified in the call to the
#' [`create_user_profile`][sagemaker_create_user_profile] API.
#' 
#' `SecurityGroups` is aggregated when specified in both calls. For all
#' other settings in `UserSettings`, the values specified in
#' [`create_user_profile`][sagemaker_create_user_profile] take precedence
#' over those specified in [`create_domain`][sagemaker_create_domain].
#' @param DomainSettings A collection of `Domain` settings.
#' @param SubnetIds &#91;required&#93; The VPC subnets that the domain uses for communication.
#' @param VpcId &#91;required&#93; The ID of the Amazon Virtual Private Cloud (VPC) that the domain uses
#' for communication.
#' @param Tags Tags to associated with the Domain. Each tag consists of a key and an
#' optional value. Tag keys must be unique per resource. Tags are
#' searchable using the [`search`][sagemaker_search] API.
#' 
#' Tags that you specify for the Domain are also added to all Apps that the
#' Domain launches.
#' @param AppNetworkAccessType Specifies the VPC used for non-EFS traffic. The default value is
#' `PublicInternetOnly`.
#' 
#' -   `PublicInternetOnly` - Non-EFS traffic is through a VPC managed by
#'     Amazon SageMaker AI, which allows direct internet access
#' 
#' -   `VpcOnly` - All traffic is through the specified VPC and subnets
#' @param HomeEfsFileSystemKmsKeyId Use `KmsKeyId`.
#' @param KmsKeyId SageMaker AI uses Amazon Web Services KMS to encrypt EFS and EBS volumes
#' attached to the domain with an Amazon Web Services managed key by
#' default. For more control, specify a customer managed key.
#' @param AppSecurityGroupManagement The entity that creates and manages the required security groups for
#' inter-app communication in `VPCOnly` mode. Required when
#' `CreateDomain.AppNetworkAccessType` is `VPCOnly` and
#' `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`
#' is provided. If setting up the domain for use with RStudio, this value
#' must be set to `Service`.
#' @param TagPropagation Indicates whether custom tag propagation is supported for the domain.
#' Defaults to `DISABLED`.
#' @param DefaultSpaceSettings The default settings for shared spaces that users create in the domain.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_domain
sagemaker_create_domain <- function(DomainName, AuthMode, DefaultUserSettings, DomainSettings = NULL, SubnetIds, VpcId, Tags = NULL, AppNetworkAccessType = NULL, HomeEfsFileSystemKmsKeyId = NULL, KmsKeyId = NULL, AppSecurityGroupManagement = NULL, TagPropagation = NULL, DefaultSpaceSettings = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_domain_input(DomainName = DomainName, AuthMode = AuthMode, DefaultUserSettings = DefaultUserSettings, DomainSettings = DomainSettings, SubnetIds = SubnetIds, VpcId = VpcId, Tags = Tags, AppNetworkAccessType = AppNetworkAccessType, HomeEfsFileSystemKmsKeyId = HomeEfsFileSystemKmsKeyId, KmsKeyId = KmsKeyId, AppSecurityGroupManagement = AppSecurityGroupManagement, TagPropagation = TagPropagation, DefaultSpaceSettings = DefaultSpaceSettings)
  output <- .sagemaker$create_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_domain <- sagemaker_create_domain

#' Creates an edge deployment plan, consisting of multiple stages
#'
#' @description
#' Creates an edge deployment plan, consisting of multiple stages. Each stage may have a different deployment configuration and devices.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_edge_deployment_plan/](https://www.paws-r-sdk.com/docs/sagemaker_create_edge_deployment_plan/) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan.
#' @param ModelConfigs &#91;required&#93; List of models associated with the edge deployment plan.
#' @param DeviceFleetName &#91;required&#93; The device fleet used for this edge deployment plan.
#' @param Stages List of stages of the edge deployment plan. The number of stages is
#' limited to 10 per deployment.
#' @param Tags List of tags with which to tag the edge deployment plan.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_edge_deployment_plan
sagemaker_create_edge_deployment_plan <- function(EdgeDeploymentPlanName, ModelConfigs, DeviceFleetName, Stages = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEdgeDeploymentPlan",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_edge_deployment_plan_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, ModelConfigs = ModelConfigs, DeviceFleetName = DeviceFleetName, Stages = Stages, Tags = Tags)
  output <- .sagemaker$create_edge_deployment_plan_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_edge_deployment_plan <- sagemaker_create_edge_deployment_plan

#' Creates a new stage in an existing edge deployment plan
#'
#' @description
#' Creates a new stage in an existing edge deployment plan.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_edge_deployment_stage/](https://www.paws-r-sdk.com/docs/sagemaker_create_edge_deployment_stage/) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan.
#' @param Stages &#91;required&#93; List of stages to be added to the edge deployment plan.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_edge_deployment_stage
sagemaker_create_edge_deployment_stage <- function(EdgeDeploymentPlanName, Stages) {
  op <- new_operation(
    name = "CreateEdgeDeploymentStage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_edge_deployment_stage_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, Stages = Stages)
  output <- .sagemaker$create_edge_deployment_stage_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_edge_deployment_stage <- sagemaker_create_edge_deployment_stage

#' Starts a SageMaker Edge Manager model packaging job
#'
#' @description
#' Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the resulting artifacts to an S3 bucket that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_edge_packaging_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_edge_packaging_job/) for full documentation.
#'
#' @param EdgePackagingJobName &#91;required&#93; The name of the edge packaging job.
#' @param CompilationJobName &#91;required&#93; The name of the SageMaker Neo compilation job that will be used to
#' locate model artifacts for packaging.
#' @param ModelName &#91;required&#93; The name of the model.
#' @param ModelVersion &#91;required&#93; The version of the model.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that enables Amazon
#' SageMaker to download and upload the model, and to contact SageMaker
#' Neo.
#' @param OutputConfig &#91;required&#93; Provides information about the output location for the packaged model.
#' @param ResourceKey The Amazon Web Services KMS key to use when encrypting the EBS volume
#' the edge packaging job runs on.
#' @param Tags Creates tags for the packaging job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_edge_packaging_job
sagemaker_create_edge_packaging_job <- function(EdgePackagingJobName, CompilationJobName, ModelName, ModelVersion, RoleArn, OutputConfig, ResourceKey = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEdgePackagingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_edge_packaging_job_input(EdgePackagingJobName = EdgePackagingJobName, CompilationJobName = CompilationJobName, ModelName = ModelName, ModelVersion = ModelVersion, RoleArn = RoleArn, OutputConfig = OutputConfig, ResourceKey = ResourceKey, Tags = Tags)
  output <- .sagemaker$create_edge_packaging_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_edge_packaging_job <- sagemaker_create_edge_packaging_job

#' Creates an endpoint using the endpoint configuration specified in the
#' request
#'
#' @description
#' Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the [`create_endpoint_config`][sagemaker_create_endpoint_config] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_endpoint/](https://www.paws-r-sdk.com/docs/sagemaker_create_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint.The name must be unique within an Amazon Web
#' Services Region in your Amazon Web Services account. The name is
#' case-insensitive in [`create_endpoint`][sagemaker_create_endpoint], but
#' the case is preserved and must be matched in
#' [InvokeEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html).
#' @param EndpointConfigName &#91;required&#93; The name of an endpoint configuration. For more information, see
#' [`create_endpoint_config`][sagemaker_create_endpoint_config].
#' @param DeploymentConfig 
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_endpoint
sagemaker_create_endpoint <- function(EndpointName, EndpointConfigName, DeploymentConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_endpoint_input(EndpointName = EndpointName, EndpointConfigName = EndpointConfigName, DeploymentConfig = DeploymentConfig, Tags = Tags)
  output <- .sagemaker$create_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_endpoint <- sagemaker_create_endpoint

#' Creates an endpoint configuration that SageMaker hosting services uses
#' to deploy models
#'
#' @description
#' Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration, you identify one or more models, created using the [`create_model`][sagemaker_create_model] API, to deploy and the resources that you want SageMaker to provision. Then you call the [`create_endpoint`][sagemaker_create_endpoint] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_endpoint_config/](https://www.paws-r-sdk.com/docs/sagemaker_create_endpoint_config/) for full documentation.
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration. You specify this name in a
#' [`create_endpoint`][sagemaker_create_endpoint] request.
#' @param ProductionVariants &#91;required&#93; An array of `ProductionVariant` objects, one for each model that you
#' want to host at this endpoint.
#' @param DataCaptureConfig 
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' @param KmsKeyId The Amazon Resource Name (ARN) of a Amazon Web Services Key Management
#' Service key that SageMaker uses to encrypt data on the storage volume
#' attached to the ML compute instance that hosts the endpoint.
#' 
#' The KmsKeyId can be any of the following formats:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias name ARN:
#'     `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
#' 
#' The KMS key policy must grant permission to the IAM role that you
#' specify in your [`create_endpoint`][sagemaker_create_endpoint],
#' [`update_endpoint`][sagemaker_update_endpoint] requests. For more
#' information, refer to the Amazon Web Services Key Management Service
#' section [Using Key Policies in Amazon Web Services
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
#' 
#' Certain Nitro-based instances include local storage, dependent on the
#' instance type. Local storage volumes are encrypted using a hardware
#' module on the instance. You can't request a `KmsKeyId` when using an
#' instance type with local storage. If any of the models that you specify
#' in the `ProductionVariants` parameter use nitro-based instances with
#' local storage, do not specify a value for the `KmsKeyId` parameter. If
#' you specify a value for `KmsKeyId` when using any nitro-based instances
#' with local storage, the call to
#' [`create_endpoint_config`][sagemaker_create_endpoint_config] fails.
#' 
#' For a list of instance types that support local instance storage, see
#' [Instance Store
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
#' 
#' For more information about local instance storage encryption, see [SSD
#' Instance Store
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
#' @param AsyncInferenceConfig Specifies configuration for how an endpoint performs asynchronous
#' inference. This is a required field in order for your Endpoint to be
#' invoked using
#' [InvokeEndpointAsync](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpointAsync.html).
#' @param ExplainerConfig A member of [`create_endpoint_config`][sagemaker_create_endpoint_config]
#' that enables explainers.
#' @param ShadowProductionVariants An array of `ProductionVariant` objects, one for each model that you
#' want to host at this endpoint in shadow mode with production traffic
#' replicated from the model specified on `ProductionVariants`. If you use
#' this field, you can only specify one variant for `ProductionVariants`
#' and one variant for `ShadowProductionVariants`.
#' @param ExecutionRoleArn The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI
#' can assume to perform actions on your behalf. For more information, see
#' [SageMaker AI
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to Amazon SageMaker AI, the caller of this
#' action must have the `iam:PassRole` permission.
#' @param VpcConfig 
#' @param EnableNetworkIsolation Sets whether all model containers deployed to the endpoint are isolated.
#' If they are, no inbound or outbound network calls can be made to or from
#' the model containers.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_endpoint_config
sagemaker_create_endpoint_config <- function(EndpointConfigName, ProductionVariants, DataCaptureConfig = NULL, Tags = NULL, KmsKeyId = NULL, AsyncInferenceConfig = NULL, ExplainerConfig = NULL, ShadowProductionVariants = NULL, ExecutionRoleArn = NULL, VpcConfig = NULL, EnableNetworkIsolation = NULL) {
  op <- new_operation(
    name = "CreateEndpointConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_endpoint_config_input(EndpointConfigName = EndpointConfigName, ProductionVariants = ProductionVariants, DataCaptureConfig = DataCaptureConfig, Tags = Tags, KmsKeyId = KmsKeyId, AsyncInferenceConfig = AsyncInferenceConfig, ExplainerConfig = ExplainerConfig, ShadowProductionVariants = ShadowProductionVariants, ExecutionRoleArn = ExecutionRoleArn, VpcConfig = VpcConfig, EnableNetworkIsolation = EnableNetworkIsolation)
  output <- .sagemaker$create_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_endpoint_config <- sagemaker_create_endpoint_config

#' Creates a SageMaker experiment
#'
#' @description
#' Creates a SageMaker *experiment*. An experiment is a collection of *trials* that are observed, compared and evaluated as a group. A trial is a set of steps, called *trial components*, that produce a machine learning model.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_experiment/](https://www.paws-r-sdk.com/docs/sagemaker_create_experiment/) for full documentation.
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment. The name must be unique in your Amazon Web
#' Services account and is not case-sensitive.
#' @param DisplayName The name of the experiment as displayed. The name doesn't need to be
#' unique. If you don't specify `DisplayName`, the value in
#' `ExperimentName` is displayed.
#' @param Description The description of the experiment.
#' @param Tags A list of tags to associate with the experiment. You can use
#' [`search`][sagemaker_search] API to search on the tags.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_experiment
sagemaker_create_experiment <- function(ExperimentName, DisplayName = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateExperiment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_experiment_input(ExperimentName = ExperimentName, DisplayName = DisplayName, Description = Description, Tags = Tags)
  output <- .sagemaker$create_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_experiment <- sagemaker_create_experiment

#' Create a new FeatureGroup
#'
#' @description
#' Create a new `FeatureGroup`. A `FeatureGroup` is a group of `Features` defined in the `FeatureStore` to describe a `Record`.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_feature_group/](https://www.paws-r-sdk.com/docs/sagemaker_create_feature_group/) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the `FeatureGroup`. The name must be unique within an Amazon
#' Web Services Region in an Amazon Web Services account.
#' 
#' The name:
#' 
#' -   Must start with an alphanumeric character.
#' 
#' -   Can only include alphanumeric characters, underscores, and hyphens.
#'     Spaces are not allowed.
#' @param RecordIdentifierFeatureName &#91;required&#93; The name of the `Feature` whose value uniquely identifies a `Record`
#' defined in the `FeatureStore`. Only the latest record per identifier
#' value will be stored in the `OnlineStore`. `RecordIdentifierFeatureName`
#' must be one of feature definitions' names.
#' 
#' You use the `RecordIdentifierFeatureName` to access data in a
#' `FeatureStore`.
#' 
#' This name:
#' 
#' -   Must start with an alphanumeric character.
#' 
#' -   Can only contains alphanumeric characters, hyphens, underscores.
#'     Spaces are not allowed.
#' @param EventTimeFeatureName &#91;required&#93; The name of the feature that stores the `EventTime` of a `Record` in a
#' `FeatureGroup`.
#' 
#' An `EventTime` is a point in time when a new event occurs that
#' corresponds to the creation or update of a `Record` in a `FeatureGroup`.
#' All `Records` in the `FeatureGroup` must have a corresponding
#' `EventTime`.
#' 
#' An `EventTime` can be a `String` or `Fractional`.
#' 
#' -   `Fractional`: `EventTime` feature values must be a Unix timestamp in
#'     seconds.
#' 
#' -   `String`: `EventTime` feature values must be an ISO-8601 string in
#'     the format. The following formats are supported
#'     `yyyy-MM-dd'T'HH:mm:ssZ` and `yyyy-MM-dd'T'HH:mm:ss.SSSZ` where
#'     `yyyy`, `MM`, and `dd` represent the year, month, and day
#'     respectively and `HH`, `mm`, `ss`, and if applicable, `SSS`
#'     represent the hour, month, second and milliseconds respsectively.
#'     `'T'` and `Z` are constants.
#' @param FeatureDefinitions &#91;required&#93; A list of `Feature` names and types. `Name` and `Type` is compulsory per
#' `Feature`.
#' 
#' Valid feature `FeatureType`s are `Integral`, `Fractional` and `String`.
#' 
#' `FeatureName`s cannot be any of the following: `is_deleted`,
#' `write_time`, `api_invocation_time`
#' 
#' You can create up to 2,500 `FeatureDefinition`s per `FeatureGroup`.
#' @param OnlineStoreConfig You can turn the `OnlineStore` on or off by specifying `True` for the
#' `EnableOnlineStore` flag in `OnlineStoreConfig`.
#' 
#' You can also include an Amazon Web Services KMS key ID (`KMSKeyId`) for
#' at-rest encryption of the `OnlineStore`.
#' 
#' The default value is `False`.
#' @param OfflineStoreConfig Use this to configure an `OfflineFeatureStore`. This parameter allows
#' you to specify:
#' 
#' -   The Amazon Simple Storage Service (Amazon S3) location of an
#'     `OfflineStore`.
#' 
#' -   A configuration for an Amazon Web Services Glue or Amazon Web
#'     Services Hive data catalog.
#' 
#' -   An KMS encryption key to encrypt the Amazon S3 location used for
#'     `OfflineStore`. If KMS encryption key is not specified, by default
#'     we encrypt all data at rest using Amazon Web Services KMS key. By
#'     defining your [bucket-level
#'     key](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html)
#'     for SSE, you can reduce Amazon Web Services KMS requests costs by up
#'     to 99 percent.
#' 
#' -   Format for the offline store table. Supported formats are Glue
#'     (Default) and [Apache Iceberg](https://iceberg.apache.org/).
#' 
#' To learn more about this parameter, see
#' [OfflineStoreConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OfflineStoreConfig.html).
#' @param ThroughputConfig 
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM execution role used to persist
#' data into the `OfflineStore` if an `OfflineStoreConfig` is provided.
#' @param Description A free-form description of a `FeatureGroup`.
#' @param Tags Tags used to identify `Features` in each `FeatureGroup`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_feature_group
sagemaker_create_feature_group <- function(FeatureGroupName, RecordIdentifierFeatureName, EventTimeFeatureName, FeatureDefinitions, OnlineStoreConfig = NULL, OfflineStoreConfig = NULL, ThroughputConfig = NULL, RoleArn = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFeatureGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_feature_group_input(FeatureGroupName = FeatureGroupName, RecordIdentifierFeatureName = RecordIdentifierFeatureName, EventTimeFeatureName = EventTimeFeatureName, FeatureDefinitions = FeatureDefinitions, OnlineStoreConfig = OnlineStoreConfig, OfflineStoreConfig = OfflineStoreConfig, ThroughputConfig = ThroughputConfig, RoleArn = RoleArn, Description = Description, Tags = Tags)
  output <- .sagemaker$create_feature_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_feature_group <- sagemaker_create_feature_group

#' Creates a flow definition
#'
#' @description
#' Creates a flow definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_flow_definition/](https://www.paws-r-sdk.com/docs/sagemaker_create_flow_definition/) for full documentation.
#'
#' @param FlowDefinitionName &#91;required&#93; The name of your flow definition.
#' @param HumanLoopRequestSource Container for configuring the source of human task requests. Use to
#' specify if Amazon Rekognition or Amazon Textract is used as an
#' integration source.
#' @param HumanLoopActivationConfig An object containing information about the events that trigger a human
#' workflow.
#' @param HumanLoopConfig An object containing information about the tasks the human reviewers
#' will perform.
#' @param OutputConfig &#91;required&#93; An object containing information about where the human review results
#' will be uploaded.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role needed to call other services
#' on your behalf. For example,
#' `arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298`.
#' @param Tags An array of key-value pairs that contain metadata to help you categorize
#' and organize a flow definition. Each tag consists of a key and a value,
#' both of which you define.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_flow_definition
sagemaker_create_flow_definition <- function(FlowDefinitionName, HumanLoopRequestSource = NULL, HumanLoopActivationConfig = NULL, HumanLoopConfig = NULL, OutputConfig, RoleArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateFlowDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_flow_definition_input(FlowDefinitionName = FlowDefinitionName, HumanLoopRequestSource = HumanLoopRequestSource, HumanLoopActivationConfig = HumanLoopActivationConfig, HumanLoopConfig = HumanLoopConfig, OutputConfig = OutputConfig, RoleArn = RoleArn, Tags = Tags)
  output <- .sagemaker$create_flow_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_flow_definition <- sagemaker_create_flow_definition

#' Create a hub
#'
#' @description
#' Create a hub.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_hub/](https://www.paws-r-sdk.com/docs/sagemaker_create_hub/) for full documentation.
#'
#' @param HubName &#91;required&#93; The name of the hub to create.
#' @param HubDescription &#91;required&#93; A description of the hub.
#' @param HubDisplayName The display name of the hub.
#' @param HubSearchKeywords The searchable keywords for the hub.
#' @param S3StorageConfig The Amazon S3 storage configuration for the hub.
#' @param Tags Any tags to associate with the hub.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_hub
sagemaker_create_hub <- function(HubName, HubDescription, HubDisplayName = NULL, HubSearchKeywords = NULL, S3StorageConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateHub",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_hub_input(HubName = HubName, HubDescription = HubDescription, HubDisplayName = HubDisplayName, HubSearchKeywords = HubSearchKeywords, S3StorageConfig = S3StorageConfig, Tags = Tags)
  output <- .sagemaker$create_hub_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_hub <- sagemaker_create_hub

#' Create a hub content reference in order to add a model in the JumpStart
#' public hub to a private hub
#'
#' @description
#' Create a hub content reference in order to add a model in the JumpStart public hub to a private hub.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_hub_content_reference/](https://www.paws-r-sdk.com/docs/sagemaker_create_hub_content_reference/) for full documentation.
#'
#' @param HubName &#91;required&#93; The name of the hub to add the hub content reference to.
#' @param SageMakerPublicHubContentArn &#91;required&#93; The ARN of the public hub content to reference.
#' @param HubContentName The name of the hub content to reference.
#' @param MinVersion The minimum version of the hub content to reference.
#' @param Tags Any tags associated with the hub content to reference.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_hub_content_reference
sagemaker_create_hub_content_reference <- function(HubName, SageMakerPublicHubContentArn, HubContentName = NULL, MinVersion = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateHubContentReference",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_hub_content_reference_input(HubName = HubName, SageMakerPublicHubContentArn = SageMakerPublicHubContentArn, HubContentName = HubContentName, MinVersion = MinVersion, Tags = Tags)
  output <- .sagemaker$create_hub_content_reference_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_hub_content_reference <- sagemaker_create_hub_content_reference

#' Defines the settings you will use for the human review workflow user
#' interface
#'
#' @description
#' Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel interface with an instruction area, the item to review, and an input area.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_human_task_ui/](https://www.paws-r-sdk.com/docs/sagemaker_create_human_task_ui/) for full documentation.
#'
#' @param HumanTaskUiName &#91;required&#93; The name of the user interface you are creating.
#' @param UiTemplate &#91;required&#93; 
#' @param Tags An array of key-value pairs that contain metadata to help you categorize
#' and organize a human review workflow user interface. Each tag consists
#' of a key and a value, both of which you define.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_human_task_ui
sagemaker_create_human_task_ui <- function(HumanTaskUiName, UiTemplate, Tags = NULL) {
  op <- new_operation(
    name = "CreateHumanTaskUi",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_human_task_ui_input(HumanTaskUiName = HumanTaskUiName, UiTemplate = UiTemplate, Tags = Tags)
  output <- .sagemaker$create_human_task_ui_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_human_task_ui <- sagemaker_create_human_task_ui

#' Starts a hyperparameter tuning job
#'
#' @description
#' Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured by an objective metric that you choose.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_hyper_parameter_tuning_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_hyper_parameter_tuning_job/) for full documentation.
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job. This name is the prefix for the names of all
#' training jobs that this tuning job launches. The name must be unique
#' within the same Amazon Web Services account and Amazon Web Services
#' Region. The name must have 1 to 32 characters. Valid characters are a-z,
#' A-Z, 0-9, and : + = @@ _ % - (hyphen). The name is not case sensitive.
#' @param HyperParameterTuningJobConfig &#91;required&#93; The
#' [HyperParameterTuningJobConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html)
#' object that describes the tuning job, including the search strategy, the
#' objective metric used to evaluate training jobs, ranges of parameters to
#' search, and resource limits for the tuning job. For more information,
#' see [How Hyperparameter Tuning
#' Works](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
#' @param TrainingJobDefinition The
#' [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html)
#' object that describes the training jobs that this tuning job launches,
#' including static hyperparameters, input data configuration, output data
#' configuration, resource configuration, and stopping condition.
#' @param TrainingJobDefinitions A list of the
#' [HyperParameterTrainingJobDefinition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html)
#' objects launched for this tuning job.
#' @param WarmStartConfig Specifies the configuration for starting the hyperparameter tuning job
#' using one or more previous tuning jobs as a starting point. The results
#' of previous tuning jobs are used to inform which combinations of
#' hyperparameters to search over in the new tuning job.
#' 
#' All training jobs launched by the new hyperparameter tuning job are
#' evaluated by using the objective metric. If you specify
#' `IDENTICAL_DATA_AND_ALGORITHM` as the `WarmStartType` value for the warm
#' start configuration, the training job that performs the best in the new
#' tuning job is compared to the best training jobs from the parent tuning
#' jobs. From these, the training job that performs the best as measured by
#' the objective metric is returned as the overall best training job.
#' 
#' All training jobs launched by parent hyperparameter tuning jobs and the
#' new hyperparameter tuning jobs count against the limit of training jobs
#' for the tuning job.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' 
#' Tags that you specify for the tuning job are also added to all training
#' jobs that the tuning job launches.
#' @param Autotune Configures SageMaker Automatic model tuning (AMT) to automatically find
#' optimal parameters for the following fields:
#' 
#' -   [ParameterRanges](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-ParameterRanges):
#'     The names and ranges of parameters that a hyperparameter tuning job
#'     can optimize.
#' 
#' -   [ResourceLimits](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html):
#'     The maximum resources that can be used for a training job. These
#'     resources include the maximum number of training jobs, the maximum
#'     runtime of a tuning job, and the maximum number of training jobs to
#'     run at the same time.
#' 
#' -   [TrainingJobEarlyStoppingType](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-TrainingJobEarlyStoppingType):
#'     A flag that specifies whether or not to use early stopping for
#'     training jobs launched by a hyperparameter tuning job.
#' 
#' -   [RetryStrategy](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-RetryStrategy):
#'     The number of times to retry a training job.
#' 
#' -   [Strategy](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html):
#'     Specifies how hyperparameter tuning chooses the combinations of
#'     hyperparameter values to use for the training jobs that it launches.
#' 
#' -   [ConvergenceDetected](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ConvergenceDetected.html):
#'     A flag to indicate that Automatic model tuning (AMT) has detected
#'     model convergence.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_hyper_parameter_tuning_job
sagemaker_create_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName, HyperParameterTuningJobConfig, TrainingJobDefinition = NULL, TrainingJobDefinitions = NULL, WarmStartConfig = NULL, Tags = NULL, Autotune = NULL) {
  op <- new_operation(
    name = "CreateHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName, HyperParameterTuningJobConfig = HyperParameterTuningJobConfig, TrainingJobDefinition = TrainingJobDefinition, TrainingJobDefinitions = TrainingJobDefinitions, WarmStartConfig = WarmStartConfig, Tags = Tags, Autotune = Autotune)
  output <- .sagemaker$create_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_hyper_parameter_tuning_job <- sagemaker_create_hyper_parameter_tuning_job

#' Creates a custom SageMaker AI image
#'
#' @description
#' Creates a custom SageMaker AI image. A SageMaker AI image is a set of image versions. Each image version represents a container image stored in Amazon ECR. For more information, see [Bring your own SageMaker AI image](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_image/](https://www.paws-r-sdk.com/docs/sagemaker_create_image/) for full documentation.
#'
#' @param Description The description of the image.
#' @param DisplayName The display name of the image. If not provided, `ImageName` is
#' displayed.
#' @param ImageName &#91;required&#93; The name of the image. Must be unique to your account.
#' @param RoleArn &#91;required&#93; The ARN of an IAM role that enables Amazon SageMaker AI to perform tasks
#' on your behalf.
#' @param Tags A list of tags to apply to the image.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_image
sagemaker_create_image <- function(Description = NULL, DisplayName = NULL, ImageName, RoleArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_image_input(Description = Description, DisplayName = DisplayName, ImageName = ImageName, RoleArn = RoleArn, Tags = Tags)
  output <- .sagemaker$create_image_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_image <- sagemaker_create_image

#' Creates a version of the SageMaker AI image specified by ImageName
#'
#' @description
#' Creates a version of the SageMaker AI image specified by `ImageName`. The version represents the Amazon ECR container image specified by `BaseImage`.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_image_version/](https://www.paws-r-sdk.com/docs/sagemaker_create_image_version/) for full documentation.
#'
#' @param BaseImage &#91;required&#93; The registry path of the container image to use as the starting point
#' for this version. The path is an Amazon ECR URI in the following format:
#' 
#' `<acct-id>.dkr.ecr.<region>.amazonaws.com/<repo-name[:tag] or [@@digest]>`
#' @param ClientToken &#91;required&#93; A unique ID. If not specified, the Amazon Web Services CLI and Amazon
#' Web Services SDKs, such as the SDK for Python (Boto3), add a unique
#' value to the call.
#' @param ImageName &#91;required&#93; The `ImageName` of the `Image` to create a version of.
#' @param Aliases A list of aliases created with the image version.
#' @param VendorGuidance The stability of the image version, specified by the maintainer.
#' 
#' -   `NOT_PROVIDED`: The maintainers did not provide a status for image
#'     version stability.
#' 
#' -   `STABLE`: The image version is stable.
#' 
#' -   `TO_BE_ARCHIVED`: The image version is set to be archived. Custom
#'     image versions that are set to be archived are automatically
#'     archived after three months.
#' 
#' -   `ARCHIVED`: The image version is archived. Archived image versions
#'     are not searchable and are no longer actively supported.
#' @param JobType Indicates SageMaker AI job type compatibility.
#' 
#' -   `TRAINING`: The image version is compatible with SageMaker AI
#'     training jobs.
#' 
#' -   `INFERENCE`: The image version is compatible with SageMaker AI
#'     inference jobs.
#' 
#' -   `NOTEBOOK_KERNEL`: The image version is compatible with SageMaker AI
#'     notebook kernels.
#' @param MLFramework The machine learning framework vended in the image version.
#' @param ProgrammingLang The supported programming language and its version.
#' @param Processor Indicates CPU or GPU compatibility.
#' 
#' -   `CPU`: The image version is compatible with CPU.
#' 
#' -   `GPU`: The image version is compatible with GPU.
#' @param Horovod Indicates Horovod compatibility.
#' @param ReleaseNotes The maintainer description of the image version.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_image_version
sagemaker_create_image_version <- function(BaseImage, ClientToken, ImageName, Aliases = NULL, VendorGuidance = NULL, JobType = NULL, MLFramework = NULL, ProgrammingLang = NULL, Processor = NULL, Horovod = NULL, ReleaseNotes = NULL) {
  op <- new_operation(
    name = "CreateImageVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_image_version_input(BaseImage = BaseImage, ClientToken = ClientToken, ImageName = ImageName, Aliases = Aliases, VendorGuidance = VendorGuidance, JobType = JobType, MLFramework = MLFramework, ProgrammingLang = ProgrammingLang, Processor = Processor, Horovod = Horovod, ReleaseNotes = ReleaseNotes)
  output <- .sagemaker$create_image_version_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_image_version <- sagemaker_create_image_version

#' Creates an inference component, which is a SageMaker AI hosting object
#' that you can use to deploy a model to an endpoint
#'
#' @description
#' Creates an inference component, which is a SageMaker AI hosting object that you can use to deploy a model to an endpoint. In the inference component settings, you specify the model, the endpoint, and how the model utilizes the resources that the endpoint hosts. You can optimize resource utilization by tailoring how the required CPU cores, accelerators, and memory are allocated. You can deploy multiple inference components to an endpoint, where each inference component contains one model and the resource utilization needs for that individual model. After you deploy an inference component, you can directly invoke the associated model when you use the InvokeEndpoint API action.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_inference_component/](https://www.paws-r-sdk.com/docs/sagemaker_create_inference_component/) for full documentation.
#'
#' @param InferenceComponentName &#91;required&#93; A unique name to assign to the inference component.
#' @param EndpointName &#91;required&#93; The name of an existing endpoint where you host the inference component.
#' @param VariantName The name of an existing production variant where you host the inference
#' component.
#' @param Specification &#91;required&#93; Details about the resources to deploy with this inference component,
#' including the model, container, and compute resources.
#' @param RuntimeConfig Runtime settings for a model that is deployed with an inference
#' component.
#' @param Tags A list of key-value pairs associated with the model. For more
#' information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_inference_component
sagemaker_create_inference_component <- function(InferenceComponentName, EndpointName, VariantName = NULL, Specification, RuntimeConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateInferenceComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_inference_component_input(InferenceComponentName = InferenceComponentName, EndpointName = EndpointName, VariantName = VariantName, Specification = Specification, RuntimeConfig = RuntimeConfig, Tags = Tags)
  output <- .sagemaker$create_inference_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_inference_component <- sagemaker_create_inference_component

#' Creates an inference experiment using the configurations specified in
#' the request
#'
#' @description
#' Creates an inference experiment using the configurations specified in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_inference_experiment/](https://www.paws-r-sdk.com/docs/sagemaker_create_inference_experiment/) for full documentation.
#'
#' @param Name &#91;required&#93; The name for the inference experiment.
#' @param Type &#91;required&#93; The type of the inference experiment that you want to run. The following
#' types of experiments are possible:
#' 
#' -   `ShadowMode`: You can use this type to validate a shadow variant.
#'     For more information, see [Shadow
#'     tests](https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html).
#' @param Schedule The duration for which you want the inference experiment to run. If you
#' don't specify this field, the experiment automatically starts
#' immediately upon creation and concludes after 7 days.
#' @param Description A description for the inference experiment.
#' @param RoleArn &#91;required&#93; The ARN of the IAM role that Amazon SageMaker can assume to access model
#' artifacts and container images, and manage Amazon SageMaker Inference
#' endpoints for model deployment.
#' @param EndpointName &#91;required&#93; The name of the Amazon SageMaker endpoint on which you want to run the
#' inference experiment.
#' @param ModelVariants &#91;required&#93; An array of `ModelVariantConfig` objects. There is one for each variant
#' in the inference experiment. Each `ModelVariantConfig` object in the
#' array describes the infrastructure configuration for the corresponding
#' variant.
#' @param DataStorageConfig The Amazon S3 location and configuration for storing inference request
#' and response data.
#' 
#' This is an optional parameter that you can use for data capture. For
#' more information, see [Capture
#' data](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-data-capture.html).
#' @param ShadowModeConfig &#91;required&#93; The configuration of `ShadowMode` inference experiment type. Use this
#' field to specify a production variant which takes all the inference
#' requests, and a shadow variant to which Amazon SageMaker replicates a
#' percentage of the inference requests. For the shadow variant also
#' specify the percentage of requests that Amazon SageMaker replicates.
#' @param KmsKey The Amazon Web Services Key Management Service (Amazon Web Services KMS)
#' key that Amazon SageMaker uses to encrypt data on the storage volume
#' attached to the ML compute instance that hosts the endpoint. The
#' `KmsKey` can be any of the following formats:
#' 
#' -   KMS key ID
#' 
#'     `"1234abcd-12ab-34cd-56ef-1234567890ab"`
#' 
#' -   Amazon Resource Name (ARN) of a KMS key
#' 
#'     `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
#' 
#' -   KMS key Alias
#' 
#'     `"alias/ExampleAlias"`
#' 
#' -   Amazon Resource Name (ARN) of a KMS key Alias
#' 
#'     `"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"`
#' 
#' If you use a KMS key ID or an alias of your KMS key, the Amazon
#' SageMaker execution role must include permissions to call `kms:Encrypt`.
#' If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS
#' key for Amazon S3 for your role's account. Amazon SageMaker uses
#' server-side encryption with KMS managed keys for `OutputDataConfig`. If
#' you use a bucket policy with an `s3:PutObject` permission that only
#' allows objects with server-side encryption, set the condition key of
#' `s3:x-amz-server-side-encryption` to `"aws:kms"`. For more information,
#' see [KMS managed Encryption
#' Keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html)
#' in the *Amazon Simple Storage Service Developer Guide.*
#' 
#' The KMS key policy must grant permission to the IAM role that you
#' specify in your [`create_endpoint`][sagemaker_create_endpoint] and
#' [`update_endpoint`][sagemaker_update_endpoint] requests. For more
#' information, see [Using Key Policies in Amazon Web Services
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
#' in the *Amazon Web Services Key Management Service Developer Guide*.
#' @param Tags Array of key-value pairs. You can use tags to categorize your Amazon Web
#' Services resources in different ways, for example, by purpose, owner, or
#' environment. For more information, see [Tagging your Amazon Web Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_inference_experiment
sagemaker_create_inference_experiment <- function(Name, Type, Schedule = NULL, Description = NULL, RoleArn, EndpointName, ModelVariants, DataStorageConfig = NULL, ShadowModeConfig, KmsKey = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateInferenceExperiment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_inference_experiment_input(Name = Name, Type = Type, Schedule = Schedule, Description = Description, RoleArn = RoleArn, EndpointName = EndpointName, ModelVariants = ModelVariants, DataStorageConfig = DataStorageConfig, ShadowModeConfig = ShadowModeConfig, KmsKey = KmsKey, Tags = Tags)
  output <- .sagemaker$create_inference_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_inference_experiment <- sagemaker_create_inference_experiment

#' Starts a recommendation job
#'
#' @description
#' Starts a recommendation job. You can create either an instance recommendation or load test job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_inference_recommendations_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_inference_recommendations_job/) for full documentation.
#'
#' @param JobName &#91;required&#93; A name for the recommendation job. The name must be unique within the
#' Amazon Web Services Region and within your Amazon Web Services account.
#' The job name is passed down to the resources created by the
#' recommendation job. The names of resources (such as the model, endpoint
#' configuration, endpoint, and compilation) that are prefixed with the job
#' name are truncated at 40 characters.
#' @param JobType &#91;required&#93; Defines the type of recommendation job. Specify `Default` to initiate an
#' instance recommendation and `Advanced` to initiate a load test. If left
#' unspecified, Amazon SageMaker Inference Recommender will run an instance
#' recommendation (`DEFAULT`) job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that enables Amazon
#' SageMaker to perform tasks on your behalf.
#' @param InputConfig &#91;required&#93; Provides information about the versioned model package Amazon Resource
#' Name (ARN), the traffic pattern, and endpoint configurations.
#' @param JobDescription Description of the recommendation job.
#' @param StoppingConditions A set of conditions for stopping a recommendation job. If any of the
#' conditions are met, the job is automatically stopped.
#' @param OutputConfig Provides information about the output artifacts and the KMS key to use
#' for Amazon S3 server-side encryption.
#' @param Tags The metadata that you apply to Amazon Web Services resources to help you
#' categorize and organize them. Each tag consists of a key and a value,
#' both of which you define. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in the Amazon Web Services General Reference.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_inference_recommendations_job
sagemaker_create_inference_recommendations_job <- function(JobName, JobType, RoleArn, InputConfig, JobDescription = NULL, StoppingConditions = NULL, OutputConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateInferenceRecommendationsJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_inference_recommendations_job_input(JobName = JobName, JobType = JobType, RoleArn = RoleArn, InputConfig = InputConfig, JobDescription = JobDescription, StoppingConditions = StoppingConditions, OutputConfig = OutputConfig, Tags = Tags)
  output <- .sagemaker$create_inference_recommendations_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_inference_recommendations_job <- sagemaker_create_inference_recommendations_job

#' Creates a job that uses workers to label the data objects in your input
#' dataset
#'
#' @description
#' Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to train machine learning models.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_labeling_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_labeling_job/) for full documentation.
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job. This name is used to identify the job in a
#' list of labeling jobs. Labeling job names must be unique within an
#' Amazon Web Services account and region. `LabelingJobName` is not case
#' sensitive. For example, Example-job and example-job are considered the
#' same labeling job name by Ground Truth.
#' @param LabelAttributeName &#91;required&#93; The attribute name to use for the label in the output manifest file.
#' This is the key for the key/value pair formed with the label that a
#' worker assigns to the object. The `LabelAttributeName` must meet the
#' following requirements.
#' 
#' -   The name can't end with "-metadata".
#' 
#' -   If you are using one of the following [built-in task
#'     types](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html),
#'     the attribute name *must* end with "-ref". If the task type you are
#'     using is not listed below, the attribute name *must not* end with
#'     "-ref".
#' 
#'     -   Image semantic segmentation (`SemanticSegmentation)`, and
#'         adjustment (`AdjustmentSemanticSegmentation`) and verification
#'         (`VerificationSemanticSegmentation`) labeling jobs for this task
#'         type.
#' 
#'     -   Video frame object detection (`VideoObjectDetection`), and
#'         adjustment and verification (`AdjustmentVideoObjectDetection`)
#'         labeling jobs for this task type.
#' 
#'     -   Video frame object tracking (`VideoObjectTracking`), and
#'         adjustment and verification (`AdjustmentVideoObjectTracking`)
#'         labeling jobs for this task type.
#' 
#'     -   3D point cloud semantic segmentation
#'         (`3DPointCloudSemanticSegmentation`), and adjustment and
#'         verification (`Adjustment3DPointCloudSemanticSegmentation`)
#'         labeling jobs for this task type.
#' 
#'     -   3D point cloud object tracking (`3DPointCloudObjectTracking`),
#'         and adjustment and verification
#'         (`Adjustment3DPointCloudObjectTracking`) labeling jobs for this
#'         task type.
#' 
#' If you are creating an adjustment or verification labeling job, you must
#' use a *different* `LabelAttributeName` than the one used in the original
#' labeling job. The original labeling job is the Ground Truth labeling job
#' that produced the labels that you want verified or adjusted. To learn
#' more about adjustment and verification labeling jobs, see [Verify and
#' Adjust
#' Labels](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html).
#' @param InputConfig &#91;required&#93; Input data for the labeling job, such as the Amazon S3 location of the
#' data objects and the location of the manifest file that describes the
#' data objects.
#' 
#' You must specify at least one of the following: `S3DataSource` or
#' `SnsDataSource`.
#' 
#' -   Use `SnsDataSource` to specify an SNS input topic for a streaming
#'     labeling job. If you do not specify and SNS input topic ARN, Ground
#'     Truth will create a one-time labeling job that stops after all data
#'     objects in the input manifest file have been labeled.
#' 
#' -   Use `S3DataSource` to specify an input manifest file for both
#'     streaming and one-time labeling jobs. Adding an `S3DataSource` is
#'     optional if you use `SnsDataSource` to create a streaming labeling
#'     job.
#' 
#' If you use the Amazon Mechanical Turk workforce, your input data should
#' not include confidential information, personal information or protected
#' health information. Use `ContentClassifiers` to specify that your data
#' is free of personally identifiable information and adult content.
#' @param OutputConfig &#91;required&#93; The location of the output data and the Amazon Web Services Key
#' Management Service key ID for the key used to encrypt the output data,
#' if any.
#' @param RoleArn &#91;required&#93; The Amazon Resource Number (ARN) that Amazon SageMaker assumes to
#' perform tasks on your behalf during data labeling. You must grant this
#' role the necessary permissions so that Amazon SageMaker can successfully
#' complete data labeling.
#' @param LabelCategoryConfigS3Uri The S3 URI of the file, referred to as a *label category configuration
#' file*, that defines the categories used to label the data objects.
#' 
#' For 3D point cloud and video frame task types, you can add label
#' category attributes and frame attributes to your label category
#' configuration file. To learn how, see [Create a Labeling Category
#' Configuration File for 3D Point Cloud Labeling
#' Jobs](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-cat-config-attributes.html).
#' 
#' For named entity recognition jobs, in addition to `"labels"`, you must
#' provide worker instructions in the label category configuration file
#' using the `"instructions"` parameter:
#' `"instructions": {"shortInstruction":"<h1>Add header</h1><p>Add Instructions</p>", "fullInstruction":"<p>Add additional instructions.</p>"}`.
#' For details and an example, see [Create a Named Entity Recognition
#' Labeling Job
#' (API)](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api)
#' .
#' 
#' For all other [built-in task
#' types](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html)
#' and [custom
#' tasks](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html),
#' your label category configuration file must be a JSON file in the
#' following format. Identify the labels you want to use by replacing
#' `label_1`, `label_2`,`...`,`label_n` with your label categories.
#' 
#' `\{ `
#' 
#' `"document-version": "2018-11-28",`
#' 
#' `"labels": [{"label": "label_1"},{"label": "label_2"},...{"label": "label_n"}]`
#' 
#' `\}`
#' 
#' Note the following about the label category configuration file:
#' 
#' -   For image classification and text classification (single and
#'     multi-label) you must specify at least two label categories. For all
#'     other task types, the minimum number of label categories required is
#'     one.
#' 
#' -   Each label category must be unique, you cannot specify duplicate
#'     label categories.
#' 
#' -   If you create a 3D point cloud or video frame adjustment or
#'     verification labeling job, you must include
#'     `auditLabelAttributeName` in the label category configuration. Use
#'     this parameter to enter the
#'     [`LabelAttributeName`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName)
#'     of the labeling job you want to adjust or verify annotations of.
#' @param StoppingConditions A set of conditions for stopping the labeling job. If any of the
#' conditions are met, the job is automatically stopped. You can use these
#' conditions to control the cost of data labeling.
#' @param LabelingJobAlgorithmsConfig Configures the information required to perform automated data labeling.
#' @param HumanTaskConfig &#91;required&#93; Configures the labeling task and how it is presented to workers;
#' including, but not limited to price, keywords, and batch size (task
#' count).
#' @param Tags An array of key/value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_labeling_job
sagemaker_create_labeling_job <- function(LabelingJobName, LabelAttributeName, InputConfig, OutputConfig, RoleArn, LabelCategoryConfigS3Uri = NULL, StoppingConditions = NULL, LabelingJobAlgorithmsConfig = NULL, HumanTaskConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateLabelingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_labeling_job_input(LabelingJobName = LabelingJobName, LabelAttributeName = LabelAttributeName, InputConfig = InputConfig, OutputConfig = OutputConfig, RoleArn = RoleArn, LabelCategoryConfigS3Uri = LabelCategoryConfigS3Uri, StoppingConditions = StoppingConditions, LabelingJobAlgorithmsConfig = LabelingJobAlgorithmsConfig, HumanTaskConfig = HumanTaskConfig, Tags = Tags)
  output <- .sagemaker$create_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_labeling_job <- sagemaker_create_labeling_job

#' Creates an MLflow Tracking Server using a general purpose Amazon S3
#' bucket as the artifact store
#'
#' @description
#' Creates an MLflow Tracking Server using a general purpose Amazon S3 bucket as the artifact store. For more information, see [Create an MLflow Tracking Server](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_mlflow_tracking_server/](https://www.paws-r-sdk.com/docs/sagemaker_create_mlflow_tracking_server/) for full documentation.
#'
#' @param TrackingServerName &#91;required&#93; A unique string identifying the tracking server name. This string is
#' part of the tracking server ARN.
#' @param ArtifactStoreUri &#91;required&#93; The S3 URI for a general purpose bucket to use as the MLflow Tracking
#' Server artifact store.
#' @param TrackingServerSize The size of the tracking server you want to create. You can choose
#' between `"Small"`, `"Medium"`, and `"Large"`. The default MLflow
#' Tracking Server configuration size is `"Small"`. You can choose a size
#' depending on the projected use of the tracking server such as the volume
#' of data logged, number of users, and frequency of use.
#' 
#' We recommend using a small tracking server for teams of up to 25 users,
#' a medium tracking server for teams of up to 50 users, and a large
#' tracking server for teams of up to 100 users.
#' @param MlflowVersion The version of MLflow that the tracking server uses. To see which MLflow
#' versions are available to use, see [How it
#' works](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works).
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) for an IAM role in your account that the
#' MLflow Tracking Server uses to access the artifact store in Amazon S3.
#' The role should have `AmazonS3FullAccess` permissions. For more
#' information on IAM permissions for tracking server creation, see [Set up
#' IAM permissions for
#' MLflow](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html).
#' @param AutomaticModelRegistration Whether to enable or disable automatic registration of new MLflow models
#' to the SageMaker Model Registry. To enable automatic model registration,
#' set this value to `True`. To disable automatic model registration, set
#' this value to `False`. If not specified, `AutomaticModelRegistration`
#' defaults to `False`.
#' @param WeeklyMaintenanceWindowStart The day and time of the week in Coordinated Universal Time (UTC) 24-hour
#' standard time that weekly maintenance updates are scheduled. For
#' example: TUE:03:30.
#' @param Tags Tags consisting of key-value pairs used to manage metadata for the
#' tracking server.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_mlflow_tracking_server
sagemaker_create_mlflow_tracking_server <- function(TrackingServerName, ArtifactStoreUri, TrackingServerSize = NULL, MlflowVersion = NULL, RoleArn, AutomaticModelRegistration = NULL, WeeklyMaintenanceWindowStart = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateMlflowTrackingServer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_mlflow_tracking_server_input(TrackingServerName = TrackingServerName, ArtifactStoreUri = ArtifactStoreUri, TrackingServerSize = TrackingServerSize, MlflowVersion = MlflowVersion, RoleArn = RoleArn, AutomaticModelRegistration = AutomaticModelRegistration, WeeklyMaintenanceWindowStart = WeeklyMaintenanceWindowStart, Tags = Tags)
  output <- .sagemaker$create_mlflow_tracking_server_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_mlflow_tracking_server <- sagemaker_create_mlflow_tracking_server

#' Creates a model in SageMaker
#'
#' @description
#' Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the primary container, you specify the Docker image that contains inference code, artifacts (from prior training), and a custom environment map that the inference code uses when you deploy the model for predictions.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_model/](https://www.paws-r-sdk.com/docs/sagemaker_create_model/) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the new model.
#' @param PrimaryContainer The location of the primary docker image containing inference code,
#' associated artifacts, and custom environment map that the inference code
#' uses when the model is deployed for predictions.
#' @param Containers Specifies the containers in the inference pipeline.
#' @param InferenceExecutionConfig Specifies details of how containers in a multi-container endpoint are
#' called.
#' @param ExecutionRoleArn The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume
#' to access model artifacts and docker image for deployment on ML compute
#' instances or for batch transform jobs. Deploying on ML compute instances
#' is part of model hosting. For more information, see [SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to SageMaker, the caller of this API must
#' have the `iam:PassRole` permission.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' @param VpcConfig A
#' [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html)
#' object that specifies the VPC that you want your model to connect to.
#' Control access to and from your model container by configuring the VPC.
#' `VpcConfig` is used in hosting services and in batch transform. For more
#' information, see [Protect Endpoints by Using an Amazon Virtual Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
#' and [Protect Data in Batch Transform Jobs by Using an Amazon Virtual
#' Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html).
#' @param EnableNetworkIsolation Isolates the model container. No inbound or outbound network calls can
#' be made to or from the model container.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model
sagemaker_create_model <- function(ModelName, PrimaryContainer = NULL, Containers = NULL, InferenceExecutionConfig = NULL, ExecutionRoleArn = NULL, Tags = NULL, VpcConfig = NULL, EnableNetworkIsolation = NULL) {
  op <- new_operation(
    name = "CreateModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_model_input(ModelName = ModelName, PrimaryContainer = PrimaryContainer, Containers = Containers, InferenceExecutionConfig = InferenceExecutionConfig, ExecutionRoleArn = ExecutionRoleArn, Tags = Tags, VpcConfig = VpcConfig, EnableNetworkIsolation = EnableNetworkIsolation)
  output <- .sagemaker$create_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model <- sagemaker_create_model

#' Creates the definition for a model bias job
#'
#' @description
#' Creates the definition for a model bias job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_model_bias_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_create_model_bias_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the bias job definition. The name must be unique within an
#' Amazon Web Services Region in the Amazon Web Services account.
#' @param ModelBiasBaselineConfig The baseline configuration for a model bias job.
#' @param ModelBiasAppSpecification &#91;required&#93; Configures the model bias job to run a specified Docker container image.
#' @param ModelBiasJobInput &#91;required&#93; Inputs for the model bias job.
#' @param ModelBiasJobOutputConfig &#91;required&#93; 
#' @param JobResources &#91;required&#93; 
#' @param NetworkConfig Networking options for a model bias job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI
#' can assume to perform tasks on your behalf.
#' @param StoppingCondition 
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_bias_job_definition
sagemaker_create_model_bias_job_definition <- function(JobDefinitionName, ModelBiasBaselineConfig = NULL, ModelBiasAppSpecification, ModelBiasJobInput, ModelBiasJobOutputConfig, JobResources, NetworkConfig = NULL, RoleArn, StoppingCondition = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateModelBiasJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_model_bias_job_definition_input(JobDefinitionName = JobDefinitionName, ModelBiasBaselineConfig = ModelBiasBaselineConfig, ModelBiasAppSpecification = ModelBiasAppSpecification, ModelBiasJobInput = ModelBiasJobInput, ModelBiasJobOutputConfig = ModelBiasJobOutputConfig, JobResources = JobResources, NetworkConfig = NetworkConfig, RoleArn = RoleArn, StoppingCondition = StoppingCondition, Tags = Tags)
  output <- .sagemaker$create_model_bias_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_bias_job_definition <- sagemaker_create_model_bias_job_definition

#' Creates an Amazon SageMaker Model Card
#'
#' @description
#' Creates an Amazon SageMaker Model Card.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_model_card/](https://www.paws-r-sdk.com/docs/sagemaker_create_model_card/) for full documentation.
#'
#' @param ModelCardName &#91;required&#93; The unique name of the model card.
#' @param SecurityConfig An optional Key Management Service key to encrypt, decrypt, and
#' re-encrypt model card content for regulated workloads with highly
#' sensitive data.
#' @param Content &#91;required&#93; The content of the model card. Content must be in [model card JSON
#' schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema)
#' and provided as a string.
#' @param ModelCardStatus &#91;required&#93; The approval status of the model card within your organization.
#' Different organizations might have different criteria for model card
#' review and approval.
#' 
#' -   `Draft`: The model card is a work in progress.
#' 
#' -   `PendingReview`: The model card is pending review.
#' 
#' -   `Approved`: The model card is approved.
#' 
#' -   `Archived`: The model card is archived. No more updates should be
#'     made to the model card, but it can still be exported.
#' @param Tags Key-value pairs used to manage metadata for model cards.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_card
sagemaker_create_model_card <- function(ModelCardName, SecurityConfig = NULL, Content, ModelCardStatus, Tags = NULL) {
  op <- new_operation(
    name = "CreateModelCard",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_model_card_input(ModelCardName = ModelCardName, SecurityConfig = SecurityConfig, Content = Content, ModelCardStatus = ModelCardStatus, Tags = Tags)
  output <- .sagemaker$create_model_card_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_card <- sagemaker_create_model_card

#' Creates an Amazon SageMaker Model Card export job
#'
#' @description
#' Creates an Amazon SageMaker Model Card export job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_model_card_export_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_model_card_export_job/) for full documentation.
#'
#' @param ModelCardName &#91;required&#93; The name or Amazon Resource Name (ARN) of the model card to export.
#' @param ModelCardVersion The version of the model card to export. If a version is not provided,
#' then the latest version of the model card is exported.
#' @param ModelCardExportJobName &#91;required&#93; The name of the model card export job.
#' @param OutputConfig &#91;required&#93; The model card output configuration that specifies the Amazon S3 path
#' for exporting.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_card_export_job
sagemaker_create_model_card_export_job <- function(ModelCardName, ModelCardVersion = NULL, ModelCardExportJobName, OutputConfig) {
  op <- new_operation(
    name = "CreateModelCardExportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_model_card_export_job_input(ModelCardName = ModelCardName, ModelCardVersion = ModelCardVersion, ModelCardExportJobName = ModelCardExportJobName, OutputConfig = OutputConfig)
  output <- .sagemaker$create_model_card_export_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_card_export_job <- sagemaker_create_model_card_export_job

#' Creates the definition for a model explainability job
#'
#' @description
#' Creates the definition for a model explainability job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_model_explainability_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_create_model_explainability_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model explainability job definition. The name must be
#' unique within an Amazon Web Services Region in the Amazon Web Services
#' account.
#' @param ModelExplainabilityBaselineConfig The baseline configuration for a model explainability job.
#' @param ModelExplainabilityAppSpecification &#91;required&#93; Configures the model explainability job to run a specified Docker
#' container image.
#' @param ModelExplainabilityJobInput &#91;required&#93; Inputs for the model explainability job.
#' @param ModelExplainabilityJobOutputConfig &#91;required&#93; 
#' @param JobResources &#91;required&#93; 
#' @param NetworkConfig Networking options for a model explainability job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI
#' can assume to perform tasks on your behalf.
#' @param StoppingCondition 
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_explainability_job_definition
sagemaker_create_model_explainability_job_definition <- function(JobDefinitionName, ModelExplainabilityBaselineConfig = NULL, ModelExplainabilityAppSpecification, ModelExplainabilityJobInput, ModelExplainabilityJobOutputConfig, JobResources, NetworkConfig = NULL, RoleArn, StoppingCondition = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateModelExplainabilityJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_model_explainability_job_definition_input(JobDefinitionName = JobDefinitionName, ModelExplainabilityBaselineConfig = ModelExplainabilityBaselineConfig, ModelExplainabilityAppSpecification = ModelExplainabilityAppSpecification, ModelExplainabilityJobInput = ModelExplainabilityJobInput, ModelExplainabilityJobOutputConfig = ModelExplainabilityJobOutputConfig, JobResources = JobResources, NetworkConfig = NetworkConfig, RoleArn = RoleArn, StoppingCondition = StoppingCondition, Tags = Tags)
  output <- .sagemaker$create_model_explainability_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_explainability_job_definition <- sagemaker_create_model_explainability_job_definition

#' Creates a model package that you can use to create SageMaker models or
#' list on Amazon Web Services Marketplace, or a versioned model that is
#' part of a model group
#'
#' @description
#' Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace, or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_model_package/](https://www.paws-r-sdk.com/docs/sagemaker_create_model_package/) for full documentation.
#'
#' @param ModelPackageName The name of the model package. The name must have 1 to 63 characters.
#' Valid characters are a-z, A-Z, 0-9, and - (hyphen).
#' 
#' This parameter is required for unversioned models. It is not applicable
#' to versioned models.
#' @param ModelPackageGroupName The name or Amazon Resource Name (ARN) of the model package group that
#' this model version belongs to.
#' 
#' This parameter is required for versioned models, and does not apply to
#' unversioned models.
#' @param ModelPackageDescription A description of the model package.
#' @param InferenceSpecification Specifies details about inference jobs that you can run with models
#' based on this model package, including the following information:
#' 
#' -   The Amazon ECR paths of containers that contain the inference code
#'     and model artifacts.
#' 
#' -   The instance types that the model package supports for transform
#'     jobs and real-time endpoints used for inference.
#' 
#' -   The input and output content formats that the model package supports
#'     for inference.
#' @param ValidationSpecification Specifies configurations for one or more transform jobs that SageMaker
#' runs to test the model package.
#' @param SourceAlgorithmSpecification Details about the algorithm that was used to create the model package.
#' @param CertifyForMarketplace Whether to certify the model package for listing on Amazon Web Services
#' Marketplace.
#' 
#' This parameter is optional for unversioned models, and does not apply to
#' versioned models.
#' @param Tags A list of key value pairs associated with the model. For more
#' information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in the *Amazon Web Services General Reference Guide*.
#' 
#' If you supply `ModelPackageGroupName`, your model package belongs to the
#' model group you specify and uses the tags associated with the model
#' group. In this case, you cannot supply a `tag` argument.
#' @param ModelApprovalStatus Whether the model is approved for deployment.
#' 
#' This parameter is optional for versioned models, and does not apply to
#' unversioned models.
#' 
#' For versioned models, the value of this parameter must be set to
#' `Approved` to deploy the model.
#' @param MetadataProperties 
#' @param ModelMetrics A structure that contains model metrics reports.
#' @param ClientToken A unique token that guarantees that the call to this API is idempotent.
#' @param Domain The machine learning domain of your model package and its components.
#' Common machine learning domains include computer vision and natural
#' language processing.
#' @param Task The machine learning task your model package accomplishes. Common
#' machine learning tasks include object detection and image
#' classification. The following tasks are supported by Inference
#' Recommender: `"IMAGE_CLASSIFICATION"` | `"OBJECT_DETECTION"` |
#' `"TEXT_GENERATION"` |`"IMAGE_SEGMENTATION"` | `"FILL_MASK"` |
#' `"CLASSIFICATION"` | `"REGRESSION"` | `"OTHER"`.
#' 
#' Specify "OTHER" if none of the tasks listed fit your use case.
#' @param SamplePayloadUrl The Amazon Simple Storage Service (Amazon S3) path where the sample
#' payload is stored. This path must point to a single gzip compressed tar
#' archive (.tar.gz suffix). This archive can hold multiple files that are
#' all equally used in the load test. Each file in the archive must satisfy
#' the size constraints of the
#' [InvokeEndpoint](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html#API_runtime_InvokeEndpoint_RequestSyntax)
#' call.
#' @param CustomerMetadataProperties The metadata properties associated with the model package versions.
#' @param DriftCheckBaselines Represents the drift check baselines that can be used when the model
#' monitor is set using the model package. For more information, see the
#' topic on [Drift Detection against Previous Baselines in SageMaker
#' Pipelines](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection)
#' in the *Amazon SageMaker Developer Guide*.
#' @param AdditionalInferenceSpecifications An array of additional Inference Specification objects. Each additional
#' Inference Specification specifies artifacts based on this model package
#' that can be used on inference endpoints. Generally used with SageMaker
#' Neo to store the compiled artifacts.
#' @param SkipModelValidation Indicates if you want to skip model validation.
#' @param SourceUri The URI of the source for the model package. If you want to clone a
#' model package, set it to the model package Amazon Resource Name (ARN).
#' If you want to register a model, set it to the model ARN.
#' @param SecurityConfig The KMS Key ID (`KMSKeyId`) used for encryption of model package
#' information.
#' @param ModelCard The model card associated with the model package. Since
#' `ModelPackageModelCard` is tied to a model package, it is a specific
#' usage of a model card and its schema is simplified compared to the
#' schema of `ModelCard`. The `ModelPackageModelCard` schema does not
#' include `model_package_details`, and `model_overview` is composed of the
#' `model_creator` and `model_artifact` properties. For more information
#' about the model package model card schema, see [Model package model card
#' schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema).
#' For more information about the model card associated with the model
#' package, see [View the Details of a Model
#' Version](https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html).
#' @param ModelLifeCycle A structure describing the current state of the model in its life cycle.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_package
sagemaker_create_model_package <- function(ModelPackageName = NULL, ModelPackageGroupName = NULL, ModelPackageDescription = NULL, InferenceSpecification = NULL, ValidationSpecification = NULL, SourceAlgorithmSpecification = NULL, CertifyForMarketplace = NULL, Tags = NULL, ModelApprovalStatus = NULL, MetadataProperties = NULL, ModelMetrics = NULL, ClientToken = NULL, Domain = NULL, Task = NULL, SamplePayloadUrl = NULL, CustomerMetadataProperties = NULL, DriftCheckBaselines = NULL, AdditionalInferenceSpecifications = NULL, SkipModelValidation = NULL, SourceUri = NULL, SecurityConfig = NULL, ModelCard = NULL, ModelLifeCycle = NULL) {
  op <- new_operation(
    name = "CreateModelPackage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_model_package_input(ModelPackageName = ModelPackageName, ModelPackageGroupName = ModelPackageGroupName, ModelPackageDescription = ModelPackageDescription, InferenceSpecification = InferenceSpecification, ValidationSpecification = ValidationSpecification, SourceAlgorithmSpecification = SourceAlgorithmSpecification, CertifyForMarketplace = CertifyForMarketplace, Tags = Tags, ModelApprovalStatus = ModelApprovalStatus, MetadataProperties = MetadataProperties, ModelMetrics = ModelMetrics, ClientToken = ClientToken, Domain = Domain, Task = Task, SamplePayloadUrl = SamplePayloadUrl, CustomerMetadataProperties = CustomerMetadataProperties, DriftCheckBaselines = DriftCheckBaselines, AdditionalInferenceSpecifications = AdditionalInferenceSpecifications, SkipModelValidation = SkipModelValidation, SourceUri = SourceUri, SecurityConfig = SecurityConfig, ModelCard = ModelCard, ModelLifeCycle = ModelLifeCycle)
  output <- .sagemaker$create_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_package <- sagemaker_create_model_package

#' Creates a model group
#'
#' @description
#' Creates a model group. A model group contains a group of model versions.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_model_package_group/](https://www.paws-r-sdk.com/docs/sagemaker_create_model_package_group/) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group.
#' @param ModelPackageGroupDescription A description for the model group.
#' @param Tags A list of key value pairs associated with the model group. For more
#' information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in the *Amazon Web Services General Reference Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_package_group
sagemaker_create_model_package_group <- function(ModelPackageGroupName, ModelPackageGroupDescription = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateModelPackageGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_model_package_group_input(ModelPackageGroupName = ModelPackageGroupName, ModelPackageGroupDescription = ModelPackageGroupDescription, Tags = Tags)
  output <- .sagemaker$create_model_package_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_package_group <- sagemaker_create_model_package_group

#' Creates a definition for a job that monitors model quality and drift
#'
#' @description
#' Creates a definition for a job that monitors model quality and drift. For information about model monitor, see [Amazon SageMaker AI Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_model_quality_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_create_model_quality_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the monitoring job definition.
#' @param ModelQualityBaselineConfig Specifies the constraints and baselines for the monitoring job.
#' @param ModelQualityAppSpecification &#91;required&#93; The container that runs the monitoring job.
#' @param ModelQualityJobInput &#91;required&#93; A list of the inputs that are monitored. Currently endpoints are
#' supported.
#' @param ModelQualityJobOutputConfig &#91;required&#93; 
#' @param JobResources &#91;required&#93; 
#' @param NetworkConfig Specifies the network configuration for the monitoring job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI
#' can assume to perform tasks on your behalf.
#' @param StoppingCondition 
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_quality_job_definition
sagemaker_create_model_quality_job_definition <- function(JobDefinitionName, ModelQualityBaselineConfig = NULL, ModelQualityAppSpecification, ModelQualityJobInput, ModelQualityJobOutputConfig, JobResources, NetworkConfig = NULL, RoleArn, StoppingCondition = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateModelQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_model_quality_job_definition_input(JobDefinitionName = JobDefinitionName, ModelQualityBaselineConfig = ModelQualityBaselineConfig, ModelQualityAppSpecification = ModelQualityAppSpecification, ModelQualityJobInput = ModelQualityJobInput, ModelQualityJobOutputConfig = ModelQualityJobOutputConfig, JobResources = JobResources, NetworkConfig = NetworkConfig, RoleArn = RoleArn, StoppingCondition = StoppingCondition, Tags = Tags)
  output <- .sagemaker$create_model_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_quality_job_definition <- sagemaker_create_model_quality_job_definition

#' Creates a schedule that regularly starts Amazon SageMaker AI Processing
#' Jobs to monitor the data captured for an Amazon SageMaker AI Endpoint
#'
#' @description
#' Creates a schedule that regularly starts Amazon SageMaker AI Processing Jobs to monitor the data captured for an Amazon SageMaker AI Endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_monitoring_schedule/](https://www.paws-r-sdk.com/docs/sagemaker_create_monitoring_schedule/) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the monitoring schedule. The name must be unique within an
#' Amazon Web Services Region within an Amazon Web Services account.
#' @param MonitoringScheduleConfig &#91;required&#93; The configuration object that specifies the monitoring schedule and
#' defines the monitoring job.
#' @param Tags (Optional) An array of key-value pairs. For more information, see Using
#' Cost Allocation Tags in the *Amazon Web Services Billing and Cost
#' Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_monitoring_schedule
sagemaker_create_monitoring_schedule <- function(MonitoringScheduleName, MonitoringScheduleConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName, MonitoringScheduleConfig = MonitoringScheduleConfig, Tags = Tags)
  output <- .sagemaker$create_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_monitoring_schedule <- sagemaker_create_monitoring_schedule

#' Creates an SageMaker AI notebook instance
#'
#' @description
#' Creates an SageMaker AI notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_notebook_instance/](https://www.paws-r-sdk.com/docs/sagemaker_create_notebook_instance/) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the new notebook instance.
#' @param InstanceType &#91;required&#93; The type of ML compute instance to launch for the notebook instance.
#' @param SubnetId The ID of the subnet in a VPC to which you would like to have a
#' connectivity from your ML compute instance.
#' @param SecurityGroupIds The VPC security group IDs, in the form sg-xxxxxxxx. The security groups
#' must be for the same VPC as specified in the subnet.
#' @param RoleArn &#91;required&#93; When you send any requests to Amazon Web Services resources from the
#' notebook instance, SageMaker AI assumes this role to perform tasks on
#' your behalf. You must grant this role necessary permissions so SageMaker
#' AI can perform these tasks. The policy must allow the SageMaker AI
#' service principal (sagemaker.amazonaws.com) permissions to assume this
#' role. For more information, see [SageMaker AI
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to SageMaker AI, the caller of this API
#' must have the `iam:PassRole` permission.
#' @param KmsKeyId The Amazon Resource Name (ARN) of a Amazon Web Services Key Management
#' Service key that SageMaker AI uses to encrypt data on the storage volume
#' attached to your notebook instance. The KMS key you provide must be
#' enabled. For information, see [Enabling and Disabling
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html)
#' in the *Amazon Web Services Key Management Service Developer Guide*.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' @param LifecycleConfigName The name of a lifecycle configuration to associate with the notebook
#' instance. For information about lifestyle configurations, see [Step 2.1:
#' (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#' @param DirectInternetAccess Sets whether SageMaker AI provides internet access to the notebook
#' instance. If you set this to `Disabled` this notebook instance is able
#' to access resources only in your VPC, and is not be able to connect to
#' SageMaker AI training and endpoint services unless you configure a NAT
#' Gateway in your VPC.
#' 
#' For more information, see [Notebook Instances Are Internet-Enabled by
#' Default](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-interface-endpoint.html#appendix-notebook-and-internet-access).
#' You can set the value of this parameter to `Disabled` only if you set a
#' value for the `SubnetId` parameter.
#' @param VolumeSizeInGB The size, in GB, of the ML storage volume to attach to the notebook
#' instance. The default value is 5 GB.
#' @param AcceleratorTypes This parameter is no longer supported. Elastic Inference (EI) is no
#' longer available.
#' 
#' This parameter was used to specify a list of EI instance types to
#' associate with this notebook instance.
#' @param DefaultCodeRepository A Git repository to associate with the notebook instance as its default
#' code repository. This can be either the name of a Git repository stored
#' as a resource in your account, or the URL of a Git repository in [Amazon
#' Web Services
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. When you open a notebook instance, it
#' opens in the directory that contains this repository. For more
#' information, see [Associating Git Repositories with SageMaker AI
#' Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AdditionalCodeRepositories An array of up to three Git repositories to associate with the notebook
#' instance. These can be either the names of Git repositories stored as
#' resources in your account, or the URL of Git repositories in [Amazon Web
#' Services
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. These repositories are cloned at the
#' same level as the default repository of your notebook instance. For more
#' information, see [Associating Git Repositories with SageMaker AI
#' Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param RootAccess Whether root access is enabled or disabled for users of the notebook
#' instance. The default value is `Enabled`.
#' 
#' Lifecycle configurations need root access to be able to set up a
#' notebook instance. Because of this, lifecycle configurations associated
#' with a notebook instance always run with root access even if you disable
#' root access for users.
#' @param PlatformIdentifier The platform identifier of the notebook instance runtime environment.
#' @param InstanceMetadataServiceConfiguration Information on the IMDS configuration of the notebook instance
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_notebook_instance
sagemaker_create_notebook_instance <- function(NotebookInstanceName, InstanceType, SubnetId = NULL, SecurityGroupIds = NULL, RoleArn, KmsKeyId = NULL, Tags = NULL, LifecycleConfigName = NULL, DirectInternetAccess = NULL, VolumeSizeInGB = NULL, AcceleratorTypes = NULL, DefaultCodeRepository = NULL, AdditionalCodeRepositories = NULL, RootAccess = NULL, PlatformIdentifier = NULL, InstanceMetadataServiceConfiguration = NULL) {
  op <- new_operation(
    name = "CreateNotebookInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_notebook_instance_input(NotebookInstanceName = NotebookInstanceName, InstanceType = InstanceType, SubnetId = SubnetId, SecurityGroupIds = SecurityGroupIds, RoleArn = RoleArn, KmsKeyId = KmsKeyId, Tags = Tags, LifecycleConfigName = LifecycleConfigName, DirectInternetAccess = DirectInternetAccess, VolumeSizeInGB = VolumeSizeInGB, AcceleratorTypes = AcceleratorTypes, DefaultCodeRepository = DefaultCodeRepository, AdditionalCodeRepositories = AdditionalCodeRepositories, RootAccess = RootAccess, PlatformIdentifier = PlatformIdentifier, InstanceMetadataServiceConfiguration = InstanceMetadataServiceConfiguration)
  output <- .sagemaker$create_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_notebook_instance <- sagemaker_create_notebook_instance

#' Creates a lifecycle configuration that you can associate with a notebook
#' instance
#'
#' @description
#' Creates a lifecycle configuration that you can associate with a notebook instance. A *lifecycle configuration* is a collection of shell scripts that run when you create or start a notebook instance.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_notebook_instance_lifecycle_config/](https://www.paws-r-sdk.com/docs/sagemaker_create_notebook_instance_lifecycle_config/) for full documentation.
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration.
#' @param OnCreate A shell script that runs only once, when you create a notebook instance.
#' The shell script must be a base64-encoded string.
#' @param OnStart A shell script that runs every time you start a notebook instance,
#' including when you create the notebook instance. The shell script must
#' be a base64-encoded string.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_notebook_instance_lifecycle_config
sagemaker_create_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName, OnCreate = NULL, OnStart = NULL) {
  op <- new_operation(
    name = "CreateNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName, OnCreate = OnCreate, OnStart = OnStart)
  output <- .sagemaker$create_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_notebook_instance_lifecycle_config <- sagemaker_create_notebook_instance_lifecycle_config

#' Creates a job that optimizes a model for inference performance
#'
#' @description
#' Creates a job that optimizes a model for inference performance. To create the job, you provide the location of a source model, and you provide the settings for the optimization techniques that you want the job to apply. When the job completes successfully, SageMaker uploads the new optimized model to the output destination that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_optimization_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_optimization_job/) for full documentation.
#'
#' @param OptimizationJobName &#91;required&#93; A custom name for the new optimization job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that enables Amazon
#' SageMaker AI to perform tasks on your behalf.
#' 
#' During model optimization, Amazon SageMaker AI needs your permission to:
#' 
#' -   Read input data from an S3 bucket
#' 
#' -   Write model artifacts to an S3 bucket
#' 
#' -   Write logs to Amazon CloudWatch Logs
#' 
#' -   Publish metrics to Amazon CloudWatch
#' 
#' You grant permissions for all of these tasks to an IAM role. To pass
#' this role to Amazon SageMaker AI, the caller of this API must have the
#' `iam:PassRole` permission. For more information, see [Amazon SageMaker
#' AI
#' Roles.](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html)
#' @param ModelSource &#91;required&#93; The location of the source model to optimize with an optimization job.
#' @param DeploymentInstanceType &#91;required&#93; The type of instance that hosts the optimized model that you create with
#' the optimization job.
#' @param OptimizationEnvironment The environment variables to set in the model container.
#' @param OptimizationConfigs &#91;required&#93; Settings for each of the optimization techniques that the job applies.
#' @param OutputConfig &#91;required&#93; Details for where to store the optimized model that you create with the
#' optimization job.
#' @param StoppingCondition &#91;required&#93; 
#' @param Tags A list of key-value pairs associated with the optimization job. For more
#' information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in the *Amazon Web Services General Reference Guide*.
#' @param VpcConfig A VPC in Amazon VPC that your optimized model has access to.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_optimization_job
sagemaker_create_optimization_job <- function(OptimizationJobName, RoleArn, ModelSource, DeploymentInstanceType, OptimizationEnvironment = NULL, OptimizationConfigs, OutputConfig, StoppingCondition, Tags = NULL, VpcConfig = NULL) {
  op <- new_operation(
    name = "CreateOptimizationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_optimization_job_input(OptimizationJobName = OptimizationJobName, RoleArn = RoleArn, ModelSource = ModelSource, DeploymentInstanceType = DeploymentInstanceType, OptimizationEnvironment = OptimizationEnvironment, OptimizationConfigs = OptimizationConfigs, OutputConfig = OutputConfig, StoppingCondition = StoppingCondition, Tags = Tags, VpcConfig = VpcConfig)
  output <- .sagemaker$create_optimization_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_optimization_job <- sagemaker_create_optimization_job

#' Creates an Amazon SageMaker Partner AI App
#'
#' @description
#' Creates an Amazon SageMaker Partner AI App.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_partner_app/](https://www.paws-r-sdk.com/docs/sagemaker_create_partner_app/) for full documentation.
#'
#' @param Name &#91;required&#93; The name to give the SageMaker Partner AI App.
#' @param Type &#91;required&#93; The type of SageMaker Partner AI App to create. Must be one of the
#' following: `lakera-guard`, `comet`, `deepchecks-llm-evaluation`, or
#' `fiddler`.
#' @param ExecutionRoleArn &#91;required&#93; The ARN of the IAM role that the partner application uses.
#' @param MaintenanceConfig Maintenance configuration settings for the SageMaker Partner AI App.
#' @param Tier &#91;required&#93; Indicates the instance type and size of the cluster attached to the
#' SageMaker Partner AI App.
#' @param ApplicationConfig Configuration settings for the SageMaker Partner AI App.
#' @param AuthType &#91;required&#93; The authorization type that users use to access the SageMaker Partner AI
#' App.
#' @param EnableIamSessionBasedIdentity When set to `TRUE`, the SageMaker Partner AI App sets the Amazon Web
#' Services IAM session name or the authenticated IAM user as the identity
#' of the SageMaker Partner AI App user.
#' @param ClientToken A unique token that guarantees that the call to this API is idempotent.
#' @param Tags Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_partner_app
sagemaker_create_partner_app <- function(Name, Type, ExecutionRoleArn, MaintenanceConfig = NULL, Tier, ApplicationConfig = NULL, AuthType, EnableIamSessionBasedIdentity = NULL, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePartnerApp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_partner_app_input(Name = Name, Type = Type, ExecutionRoleArn = ExecutionRoleArn, MaintenanceConfig = MaintenanceConfig, Tier = Tier, ApplicationConfig = ApplicationConfig, AuthType = AuthType, EnableIamSessionBasedIdentity = EnableIamSessionBasedIdentity, ClientToken = ClientToken, Tags = Tags)
  output <- .sagemaker$create_partner_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_partner_app <- sagemaker_create_partner_app

#' Creates a presigned URL to access an Amazon SageMaker Partner AI App
#'
#' @description
#' Creates a presigned URL to access an Amazon SageMaker Partner AI App.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_partner_app_presigned_url/](https://www.paws-r-sdk.com/docs/sagemaker_create_partner_app_presigned_url/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the SageMaker Partner AI App to create the presigned URL for.
#' @param ExpiresInSeconds The time that will pass before the presigned URL expires.
#' @param SessionExpirationDurationInSeconds Indicates how long the Amazon SageMaker Partner AI App session can be
#' accessed for after logging in.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_partner_app_presigned_url
sagemaker_create_partner_app_presigned_url <- function(Arn, ExpiresInSeconds = NULL, SessionExpirationDurationInSeconds = NULL) {
  op <- new_operation(
    name = "CreatePartnerAppPresignedUrl",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_partner_app_presigned_url_input(Arn = Arn, ExpiresInSeconds = ExpiresInSeconds, SessionExpirationDurationInSeconds = SessionExpirationDurationInSeconds)
  output <- .sagemaker$create_partner_app_presigned_url_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_partner_app_presigned_url <- sagemaker_create_partner_app_presigned_url

#' Creates a pipeline using a JSON pipeline definition
#'
#' @description
#' Creates a pipeline using a JSON pipeline definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_pipeline/](https://www.paws-r-sdk.com/docs/sagemaker_create_pipeline/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline.
#' @param PipelineDisplayName The display name of the pipeline.
#' @param PipelineDefinition The [JSON pipeline
#' definition](https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/)
#' of the pipeline.
#' @param PipelineDefinitionS3Location The location of the pipeline definition stored in Amazon S3. If
#' specified, SageMaker will retrieve the pipeline definition from this
#' location.
#' @param PipelineDescription A description of the pipeline.
#' @param ClientRequestToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than one time.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role used by the pipeline to
#' access and create resources.
#' @param Tags A list of tags to apply to the created pipeline.
#' @param ParallelismConfiguration This is the configuration that controls the parallelism of the pipeline.
#' If specified, it applies to all runs of this pipeline by default.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_pipeline
sagemaker_create_pipeline <- function(PipelineName, PipelineDisplayName = NULL, PipelineDefinition = NULL, PipelineDefinitionS3Location = NULL, PipelineDescription = NULL, ClientRequestToken, RoleArn, Tags = NULL, ParallelismConfiguration = NULL) {
  op <- new_operation(
    name = "CreatePipeline",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_pipeline_input(PipelineName = PipelineName, PipelineDisplayName = PipelineDisplayName, PipelineDefinition = PipelineDefinition, PipelineDefinitionS3Location = PipelineDefinitionS3Location, PipelineDescription = PipelineDescription, ClientRequestToken = ClientRequestToken, RoleArn = RoleArn, Tags = Tags, ParallelismConfiguration = ParallelismConfiguration)
  output <- .sagemaker$create_pipeline_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_pipeline <- sagemaker_create_pipeline

#' Creates a URL for a specified UserProfile in a Domain
#'
#' @description
#' Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to the domain, and granted access to all of the Apps and files associated with the Domain's Amazon Elastic File System volume. This operation can only be called when the authentication mode equals IAM.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_presigned_domain_url/](https://www.paws-r-sdk.com/docs/sagemaker_create_presigned_domain_url/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The name of the UserProfile to sign-in as.
#' @param SessionExpirationDurationInSeconds The session expiration duration in seconds. This value defaults to
#' 43200.
#' @param ExpiresInSeconds The number of seconds until the pre-signed URL expires. This value
#' defaults to 300.
#' @param SpaceName The name of the space.
#' @param LandingUri The landing page that the user is directed to when accessing the
#' presigned URL. Using this value, users can access Studio or Studio
#' Classic, even if it is not the default experience for the domain. The
#' supported values are:
#' 
#' -   `studio::relative/path`: Directs users to the relative path in
#'     Studio.
#' 
#' -   `app:JupyterServer:relative/path`: Directs users to the relative
#'     path in the Studio Classic application.
#' 
#' -   `app:JupyterLab:relative/path`: Directs users to the relative path
#'     in the JupyterLab application.
#' 
#' -   `app:RStudioServerPro:relative/path`: Directs users to the relative
#'     path in the RStudio application.
#' 
#' -   `app:CodeEditor:relative/path`: Directs users to the relative path
#'     in the Code Editor, based on Code-OSS, Visual Studio Code - Open
#'     Source application.
#' 
#' -   `app:Canvas:relative/path`: Directs users to the relative path in
#'     the Canvas application.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_presigned_domain_url
sagemaker_create_presigned_domain_url <- function(DomainId, UserProfileName, SessionExpirationDurationInSeconds = NULL, ExpiresInSeconds = NULL, SpaceName = NULL, LandingUri = NULL) {
  op <- new_operation(
    name = "CreatePresignedDomainUrl",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_presigned_domain_url_input(DomainId = DomainId, UserProfileName = UserProfileName, SessionExpirationDurationInSeconds = SessionExpirationDurationInSeconds, ExpiresInSeconds = ExpiresInSeconds, SpaceName = SpaceName, LandingUri = LandingUri)
  output <- .sagemaker$create_presigned_domain_url_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_presigned_domain_url <- sagemaker_create_presigned_domain_url

#' Returns a presigned URL that you can use to connect to the MLflow UI
#' attached to your tracking server
#'
#' @description
#' Returns a presigned URL that you can use to connect to the MLflow UI attached to your tracking server. For more information, see [Launch the MLflow UI using a presigned URL](https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-launch-ui.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_presigned_mlflow_tracking_server_url/](https://www.paws-r-sdk.com/docs/sagemaker_create_presigned_mlflow_tracking_server_url/) for full documentation.
#'
#' @param TrackingServerName &#91;required&#93; The name of the tracking server to connect to your MLflow UI.
#' @param ExpiresInSeconds The duration in seconds that your presigned URL is valid. The presigned
#' URL can be used only once.
#' @param SessionExpirationDurationInSeconds The duration in seconds that your MLflow UI session is valid.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_presigned_mlflow_tracking_server_url
sagemaker_create_presigned_mlflow_tracking_server_url <- function(TrackingServerName, ExpiresInSeconds = NULL, SessionExpirationDurationInSeconds = NULL) {
  op <- new_operation(
    name = "CreatePresignedMlflowTrackingServerUrl",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_presigned_mlflow_tracking_server_url_input(TrackingServerName = TrackingServerName, ExpiresInSeconds = ExpiresInSeconds, SessionExpirationDurationInSeconds = SessionExpirationDurationInSeconds)
  output <- .sagemaker$create_presigned_mlflow_tracking_server_url_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_presigned_mlflow_tracking_server_url <- sagemaker_create_presigned_mlflow_tracking_server_url

#' Returns a URL that you can use to connect to the Jupyter server from a
#' notebook instance
#'
#' @description
#' Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker AI console, when you choose `Open` next to a notebook instance, SageMaker AI opens a new tab showing the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_presigned_notebook_instance_url/](https://www.paws-r-sdk.com/docs/sagemaker_create_presigned_notebook_instance_url/) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance.
#' @param SessionExpirationDurationInSeconds The duration of the session, in seconds. The default is 12 hours.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_presigned_notebook_instance_url
sagemaker_create_presigned_notebook_instance_url <- function(NotebookInstanceName, SessionExpirationDurationInSeconds = NULL) {
  op <- new_operation(
    name = "CreatePresignedNotebookInstanceUrl",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_presigned_notebook_instance_url_input(NotebookInstanceName = NotebookInstanceName, SessionExpirationDurationInSeconds = SessionExpirationDurationInSeconds)
  output <- .sagemaker$create_presigned_notebook_instance_url_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_presigned_notebook_instance_url <- sagemaker_create_presigned_notebook_instance_url

#' Creates a processing job
#'
#' @description
#' Creates a processing job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_processing_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_processing_job/) for full documentation.
#'
#' @param ProcessingInputs An array of inputs configuring the data to download into the processing
#' container.
#' @param ProcessingOutputConfig Output configuration for the processing job.
#' @param ProcessingJobName &#91;required&#93; The name of the processing job. The name must be unique within an Amazon
#' Web Services Region in the Amazon Web Services account.
#' @param ProcessingResources &#91;required&#93; Identifies the resources, ML compute instances, and ML storage volumes
#' to deploy for a processing job. In distributed training, you specify
#' more than one instance.
#' @param StoppingCondition The time limit for how long the processing job is allowed to run.
#' @param AppSpecification &#91;required&#93; Configures the processing job to run a specified Docker container image.
#' @param Environment The environment variables to set in the Docker container. Up to 100 key
#' and values entries in the map are supported.
#' @param NetworkConfig Networking options for a processing job, such as whether to allow
#' inbound and outbound network calls to and from processing containers,
#' and the VPC subnets and security groups to use for VPC-enabled
#' processing jobs.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
#' assume to perform tasks on your behalf.
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#' @param ExperimentConfig 
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_processing_job
sagemaker_create_processing_job <- function(ProcessingInputs = NULL, ProcessingOutputConfig = NULL, ProcessingJobName, ProcessingResources, StoppingCondition = NULL, AppSpecification, Environment = NULL, NetworkConfig = NULL, RoleArn, Tags = NULL, ExperimentConfig = NULL) {
  op <- new_operation(
    name = "CreateProcessingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_processing_job_input(ProcessingInputs = ProcessingInputs, ProcessingOutputConfig = ProcessingOutputConfig, ProcessingJobName = ProcessingJobName, ProcessingResources = ProcessingResources, StoppingCondition = StoppingCondition, AppSpecification = AppSpecification, Environment = Environment, NetworkConfig = NetworkConfig, RoleArn = RoleArn, Tags = Tags, ExperimentConfig = ExperimentConfig)
  output <- .sagemaker$create_processing_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_processing_job <- sagemaker_create_processing_job

#' Creates a machine learning (ML) project that can contain one or more
#' templates that set up an ML pipeline from training to deploying an
#' approved model
#'
#' @description
#' Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_project/](https://www.paws-r-sdk.com/docs/sagemaker_create_project/) for full documentation.
#'
#' @param ProjectName &#91;required&#93; The name of the project.
#' @param ProjectDescription A description for the project.
#' @param ServiceCatalogProvisioningDetails &#91;required&#93; The product ID and provisioning artifact ID to provision a service
#' catalog. The provisioning artifact ID will default to the latest
#' provisioning artifact ID of the product, if you don't provide the
#' provisioning artifact ID. For more information, see [What is Amazon Web
#' Services Service
#' Catalog](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
#' @param Tags An array of key-value pairs that you want to use to organize and track
#' your Amazon Web Services resource costs. For more information, see
#' [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in the *Amazon Web Services General Reference Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_project
sagemaker_create_project <- function(ProjectName, ProjectDescription = NULL, ServiceCatalogProvisioningDetails, Tags = NULL) {
  op <- new_operation(
    name = "CreateProject",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_project_input(ProjectName = ProjectName, ProjectDescription = ProjectDescription, ServiceCatalogProvisioningDetails = ServiceCatalogProvisioningDetails, Tags = Tags)
  output <- .sagemaker$create_project_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_project <- sagemaker_create_project

#' Creates a private space or a space used for real time collaboration in a
#' domain
#'
#' @description
#' Creates a private space or a space used for real time collaboration in a domain.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_space/](https://www.paws-r-sdk.com/docs/sagemaker_create_space/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The ID of the associated domain.
#' @param SpaceName &#91;required&#93; The name of the space.
#' @param Tags Tags to associated with the space. Each tag consists of a key and an
#' optional value. Tag keys must be unique for each resource. Tags are
#' searchable using the [`search`][sagemaker_search] API.
#' @param SpaceSettings A collection of space settings.
#' @param OwnershipSettings A collection of ownership settings.
#' @param SpaceSharingSettings A collection of space sharing settings.
#' @param SpaceDisplayName The name of the space that appears in the SageMaker Studio UI.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_space
sagemaker_create_space <- function(DomainId, SpaceName, Tags = NULL, SpaceSettings = NULL, OwnershipSettings = NULL, SpaceSharingSettings = NULL, SpaceDisplayName = NULL) {
  op <- new_operation(
    name = "CreateSpace",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_space_input(DomainId = DomainId, SpaceName = SpaceName, Tags = Tags, SpaceSettings = SpaceSettings, OwnershipSettings = OwnershipSettings, SpaceSharingSettings = SpaceSharingSettings, SpaceDisplayName = SpaceDisplayName)
  output <- .sagemaker$create_space_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_space <- sagemaker_create_space

#' Creates a new Amazon SageMaker AI Studio Lifecycle Configuration
#'
#' @description
#' Creates a new Amazon SageMaker AI Studio Lifecycle Configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_studio_lifecycle_config/](https://www.paws-r-sdk.com/docs/sagemaker_create_studio_lifecycle_config/) for full documentation.
#'
#' @param StudioLifecycleConfigName &#91;required&#93; The name of the Amazon SageMaker AI Studio Lifecycle Configuration to
#' create.
#' @param StudioLifecycleConfigContent &#91;required&#93; The content of your Amazon SageMaker AI Studio Lifecycle Configuration
#' script. This content must be base64 encoded.
#' @param StudioLifecycleConfigAppType &#91;required&#93; The App type that the Lifecycle Configuration is attached to.
#' @param Tags Tags to be associated with the Lifecycle Configuration. Each tag
#' consists of a key and an optional value. Tag keys must be unique per
#' resource. Tags are searchable using the Search API.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_studio_lifecycle_config
sagemaker_create_studio_lifecycle_config <- function(StudioLifecycleConfigName, StudioLifecycleConfigContent, StudioLifecycleConfigAppType, Tags = NULL) {
  op <- new_operation(
    name = "CreateStudioLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_studio_lifecycle_config_input(StudioLifecycleConfigName = StudioLifecycleConfigName, StudioLifecycleConfigContent = StudioLifecycleConfigContent, StudioLifecycleConfigAppType = StudioLifecycleConfigAppType, Tags = Tags)
  output <- .sagemaker$create_studio_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_studio_lifecycle_config <- sagemaker_create_studio_lifecycle_config

#' Starts a model training job
#'
#' @description
#' Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon S3 location that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_training_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_training_job/) for full documentation.
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job. The name must be unique within an Amazon
#' Web Services Region in an Amazon Web Services account.
#' @param HyperParameters Algorithm-specific parameters that influence the quality of the model.
#' You set hyperparameters before you start the learning process. For a
#' list of hyperparameters for each training algorithm provided by
#' SageMaker, see
#' [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
#' 
#' You can specify a maximum of 100 hyperparameters. Each hyperparameter is
#' a key-value pair. Each key and value is limited to 256 characters, as
#' specified by the `Length Constraint`.
#' 
#' Do not include any security-sensitive information including account
#' access IDs, secrets or tokens in any hyperparameter field. If the use of
#' security-sensitive credentials are detected, SageMaker will reject your
#' training job request and return an exception error.
#' @param AlgorithmSpecification &#91;required&#93; The registry path of the Docker image that contains the training
#' algorithm and algorithm-specific metadata, including the input mode. For
#' more information about algorithms provided by SageMaker, see
#' [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
#' For information about providing your own algorithms, see [Using Your Own
#' Algorithms with Amazon
#' SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/docker-containers.html).
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume
#' to perform tasks on your behalf.
#' 
#' During model training, SageMaker needs your permission to read input
#' data from an S3 bucket, download a Docker image that contains training
#' code, write model artifacts to an S3 bucket, write logs to Amazon
#' CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant
#' permissions for all of these tasks to an IAM role. For more information,
#' see [SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to SageMaker, the caller of this API must
#' have the `iam:PassRole` permission.
#' @param InputDataConfig An array of `Channel` objects. Each channel is a named input source.
#' `InputDataConfig` describes the input data and its location.
#' 
#' Algorithms can accept input data from one or more channels. For example,
#' an algorithm might have two channels of input data, `training_data` and
#' `validation_data`. The configuration for each channel provides the S3,
#' EFS, or FSx location where the input data is stored. It also provides
#' information about the stored data: the MIME type, compression method,
#' and whether the data is wrapped in RecordIO format.
#' 
#' Depending on the input mode that the algorithm supports, SageMaker
#' either copies input data files from an S3 bucket to a local directory in
#' the Docker container, or makes it available as input streams. For
#' example, if you specify an EFS location, input data files are available
#' as input streams. They do not need to be downloaded.
#' 
#' Your input must be in the same Amazon Web Services region as your
#' training job.
#' @param OutputDataConfig &#91;required&#93; Specifies the path to the S3 location where you want to store model
#' artifacts. SageMaker creates subfolders for the artifacts.
#' @param ResourceConfig &#91;required&#93; The resources, including the ML compute instances and ML storage
#' volumes, to use for model training.
#' 
#' ML storage volumes store model artifacts and incremental states.
#' Training algorithms might also use ML storage volumes for scratch space.
#' If you want SageMaker to use the ML storage volume to store the training
#' data, choose `File` as the `TrainingInputMode` in the algorithm
#' specification. For distributed training algorithms, specify an instance
#' count greater than 1.
#' @param VpcConfig A
#' [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html)
#' object that specifies the VPC that you want your training job to connect
#' to. Control access to and from your training container by configuring
#' the VPC. For more information, see [Protect Training Jobs by Using an
#' Amazon Virtual Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
#' @param StoppingCondition &#91;required&#93; Specifies a limit to how long a model training job can run. It also
#' specifies how long a managed Spot training job has to complete. When the
#' job reaches the time limit, SageMaker ends the training job. Use this
#' API to cap model training costs.
#' 
#' To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which
#' delays job termination for 120 seconds. Algorithms can use this
#' 120-second window to save the model artifacts, so the results of
#' training are not lost.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' @param EnableNetworkIsolation Isolates the training container. No inbound or outbound network calls
#' can be made, except for calls between peers within a training cluster
#' for distributed training. If you enable network isolation for training
#' jobs that are configured to use a VPC, SageMaker downloads and uploads
#' customer data and model artifacts through the specified VPC, but the
#' training container does not have network access.
#' @param EnableInterContainerTrafficEncryption To encrypt all communications between ML compute instances in
#' distributed training, choose `True`. Encryption provides greater
#' security for distributed training, but training might take longer. How
#' long it takes depends on the amount of communication between compute
#' instances, especially if you use a deep learning algorithm in
#' distributed training. For more information, see [Protect Communications
#' Between ML Compute Instances in a Distributed Training
#' Job](https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html).
#' @param EnableManagedSpotTraining To train models using managed spot training, choose `True`. Managed spot
#' training provides a fully managed and scalable infrastructure for
#' training machine learning models. this option is useful when training
#' jobs can be interrupted and when there is flexibility when the training
#' job is run.
#' 
#' The complete and intermediate results of jobs are stored in an Amazon S3
#' bucket, and can be used as a starting point to train models
#' incrementally. Amazon SageMaker provides metrics and logs in CloudWatch.
#' They can be used to see when managed spot training jobs are running,
#' interrupted, resumed, or completed.
#' @param CheckpointConfig Contains information about the output location for managed spot training
#' checkpoint data.
#' @param DebugHookConfig 
#' @param DebugRuleConfigurations Configuration information for Amazon SageMaker Debugger rules for
#' debugging output tensors.
#' @param TensorBoardOutputConfig 
#' @param ExperimentConfig 
#' @param ProfilerConfig 
#' @param ProfilerRuleConfigurations Configuration information for Amazon SageMaker Debugger rules for
#' profiling system and framework metrics.
#' @param Environment The environment variables to set in the Docker container.
#' @param RetryStrategy The number of times to retry the job when the job fails due to an
#' `InternalServerError`.
#' @param RemoteDebugConfig Configuration for remote debugging. To learn more about the remote
#' debugging functionality of SageMaker, see [Access a training container
#' through Amazon Web Services Systems Manager (SSM) for remote
#' debugging](https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html).
#' @param InfraCheckConfig Contains information about the infrastructure health check configuration
#' for the training job.
#' @param SessionChainingConfig Contains information about attribute-based access control (ABAC) for the
#' training job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_training_job
sagemaker_create_training_job <- function(TrainingJobName, HyperParameters = NULL, AlgorithmSpecification, RoleArn, InputDataConfig = NULL, OutputDataConfig, ResourceConfig, VpcConfig = NULL, StoppingCondition, Tags = NULL, EnableNetworkIsolation = NULL, EnableInterContainerTrafficEncryption = NULL, EnableManagedSpotTraining = NULL, CheckpointConfig = NULL, DebugHookConfig = NULL, DebugRuleConfigurations = NULL, TensorBoardOutputConfig = NULL, ExperimentConfig = NULL, ProfilerConfig = NULL, ProfilerRuleConfigurations = NULL, Environment = NULL, RetryStrategy = NULL, RemoteDebugConfig = NULL, InfraCheckConfig = NULL, SessionChainingConfig = NULL) {
  op <- new_operation(
    name = "CreateTrainingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_training_job_input(TrainingJobName = TrainingJobName, HyperParameters = HyperParameters, AlgorithmSpecification = AlgorithmSpecification, RoleArn = RoleArn, InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, ResourceConfig = ResourceConfig, VpcConfig = VpcConfig, StoppingCondition = StoppingCondition, Tags = Tags, EnableNetworkIsolation = EnableNetworkIsolation, EnableInterContainerTrafficEncryption = EnableInterContainerTrafficEncryption, EnableManagedSpotTraining = EnableManagedSpotTraining, CheckpointConfig = CheckpointConfig, DebugHookConfig = DebugHookConfig, DebugRuleConfigurations = DebugRuleConfigurations, TensorBoardOutputConfig = TensorBoardOutputConfig, ExperimentConfig = ExperimentConfig, ProfilerConfig = ProfilerConfig, ProfilerRuleConfigurations = ProfilerRuleConfigurations, Environment = Environment, RetryStrategy = RetryStrategy, RemoteDebugConfig = RemoteDebugConfig, InfraCheckConfig = InfraCheckConfig, SessionChainingConfig = SessionChainingConfig)
  output <- .sagemaker$create_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_training_job <- sagemaker_create_training_job

#' Creates a new training plan in SageMaker to reserve compute capacity
#'
#' @description
#' Creates a new training plan in SageMaker to reserve compute capacity.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_training_plan/](https://www.paws-r-sdk.com/docs/sagemaker_create_training_plan/) for full documentation.
#'
#' @param TrainingPlanName &#91;required&#93; The name of the training plan to create.
#' @param TrainingPlanOfferingId &#91;required&#93; The unique identifier of the training plan offering to use for creating
#' this plan.
#' @param Tags An array of key-value pairs to apply to this training plan.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_training_plan
sagemaker_create_training_plan <- function(TrainingPlanName, TrainingPlanOfferingId, Tags = NULL) {
  op <- new_operation(
    name = "CreateTrainingPlan",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_training_plan_input(TrainingPlanName = TrainingPlanName, TrainingPlanOfferingId = TrainingPlanOfferingId, Tags = Tags)
  output <- .sagemaker$create_training_plan_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_training_plan <- sagemaker_create_training_plan

#' Starts a transform job
#'
#' @description
#' Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_transform_job/](https://www.paws-r-sdk.com/docs/sagemaker_create_transform_job/) for full documentation.
#'
#' @param TransformJobName &#91;required&#93; The name of the transform job. The name must be unique within an Amazon
#' Web Services Region in an Amazon Web Services account.
#' @param ModelName &#91;required&#93; The name of the model that you want to use for the transform job.
#' `ModelName` must be the name of an existing Amazon SageMaker model
#' within an Amazon Web Services Region in an Amazon Web Services account.
#' @param MaxConcurrentTransforms The maximum number of parallel requests that can be sent to each
#' instance in a transform job. If `MaxConcurrentTransforms` is set to `0`
#' or left unset, Amazon SageMaker checks the optional execution-parameters
#' to determine the settings for your chosen algorithm. If the
#' execution-parameters endpoint is not enabled, the default value is `1`.
#' For more information on execution-parameters, see [How Containers Serve
#' Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests).
#' For built-in algorithms, you don't need to set a value for
#' `MaxConcurrentTransforms`.
#' @param ModelClientConfig Configures the timeout and maximum number of retries for processing a
#' transform job invocation.
#' @param MaxPayloadInMB The maximum allowed size of the payload, in MB. A *payload* is the data
#' portion of a record (without metadata). The value in `MaxPayloadInMB`
#' must be greater than, or equal to, the size of a single record. To
#' estimate the size of a record in MB, divide the size of your dataset by
#' the number of records. To ensure that the records fit within the maximum
#' payload size, we recommend using a slightly larger value. The default
#' value is `6` MB.
#' 
#' The value of `MaxPayloadInMB` cannot be greater than 100 MB. If you
#' specify the `MaxConcurrentTransforms` parameter, the value of
#' `(MaxConcurrentTransforms * MaxPayloadInMB)` also cannot exceed 100 MB.
#' 
#' For cases where the payload might be arbitrarily large and is
#' transmitted using HTTP chunked encoding, set the value to `0`. This
#' feature works only in supported algorithms. Currently, Amazon SageMaker
#' built-in algorithms do not support HTTP chunked encoding.
#' @param BatchStrategy Specifies the number of records to include in a mini-batch for an HTTP
#' inference request. A *record* is a single unit of input data that
#' inference can be made on. For example, a single line in a CSV file is a
#' record.
#' 
#' To enable the batch strategy, you must set the `SplitType` property to
#' `Line`, `RecordIO`, or `TFRecord`.
#' 
#' To use only one record when making an HTTP invocation request to a
#' container, set `BatchStrategy` to `SingleRecord` and `SplitType` to
#' `Line`.
#' 
#' To fit as many records in a mini-batch as can fit within the
#' `MaxPayloadInMB` limit, set `BatchStrategy` to `MultiRecord` and
#' `SplitType` to `Line`.
#' @param Environment The environment variables to set in the Docker container. Don't include
#' any sensitive data in your environment variables. We support up to 16
#' key and values entries in the map.
#' @param TransformInput &#91;required&#93; Describes the input source and the way the transform job consumes it.
#' @param TransformOutput &#91;required&#93; Describes the results of the transform job.
#' @param DataCaptureConfig Configuration to control how SageMaker captures inference data.
#' @param TransformResources &#91;required&#93; Describes the resources, including ML instance types and ML instance
#' count, to use for the transform job.
#' @param DataProcessing The data structure used to specify the data to be used for inference in
#' a batch transform job and to associate the data that is relevant to the
#' prediction results in the output. The input filter provided allows you
#' to exclude input data that is not needed for inference in a batch
#' transform job. The output filter provided allows you to include input
#' data relevant to interpreting the predictions in the output from the
#' job. For more information, see [Associate Prediction Results with their
#' Corresponding Input
#' Records](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#' @param ExperimentConfig 
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_transform_job
sagemaker_create_transform_job <- function(TransformJobName, ModelName, MaxConcurrentTransforms = NULL, ModelClientConfig = NULL, MaxPayloadInMB = NULL, BatchStrategy = NULL, Environment = NULL, TransformInput, TransformOutput, DataCaptureConfig = NULL, TransformResources, DataProcessing = NULL, Tags = NULL, ExperimentConfig = NULL) {
  op <- new_operation(
    name = "CreateTransformJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_transform_job_input(TransformJobName = TransformJobName, ModelName = ModelName, MaxConcurrentTransforms = MaxConcurrentTransforms, ModelClientConfig = ModelClientConfig, MaxPayloadInMB = MaxPayloadInMB, BatchStrategy = BatchStrategy, Environment = Environment, TransformInput = TransformInput, TransformOutput = TransformOutput, DataCaptureConfig = DataCaptureConfig, TransformResources = TransformResources, DataProcessing = DataProcessing, Tags = Tags, ExperimentConfig = ExperimentConfig)
  output <- .sagemaker$create_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_transform_job <- sagemaker_create_transform_job

#' Creates an SageMaker trial
#'
#' @description
#' Creates an SageMaker *trial*. A trial is a set of steps called *trial components* that produce a machine learning model. A trial is part of a single SageMaker *experiment*.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_trial/](https://www.paws-r-sdk.com/docs/sagemaker_create_trial/) for full documentation.
#'
#' @param TrialName &#91;required&#93; The name of the trial. The name must be unique in your Amazon Web
#' Services account and is not case-sensitive.
#' @param DisplayName The name of the trial as displayed. The name doesn't need to be unique.
#' If `DisplayName` isn't specified, `TrialName` is displayed.
#' @param ExperimentName &#91;required&#93; The name of the experiment to associate the trial with.
#' @param MetadataProperties 
#' @param Tags A list of tags to associate with the trial. You can use
#' [`search`][sagemaker_search] API to search on the tags.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_trial
sagemaker_create_trial <- function(TrialName, DisplayName = NULL, ExperimentName, MetadataProperties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTrial",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_trial_input(TrialName = TrialName, DisplayName = DisplayName, ExperimentName = ExperimentName, MetadataProperties = MetadataProperties, Tags = Tags)
  output <- .sagemaker$create_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_trial <- sagemaker_create_trial

#' Creates a trial component, which is a stage of a machine learning trial
#'
#' @description
#' Creates a *trial component*, which is a stage of a machine learning *trial*. A trial is composed of one or more trial components. A trial component can be used in multiple trials.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_trial_component/](https://www.paws-r-sdk.com/docs/sagemaker_create_trial_component/) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the component. The name must be unique in your Amazon Web
#' Services account and is not case-sensitive.
#' @param DisplayName The name of the component as displayed. The name doesn't need to be
#' unique. If `DisplayName` isn't specified, `TrialComponentName` is
#' displayed.
#' @param Status The status of the component. States include:
#' 
#' -   InProgress
#' 
#' -   Completed
#' 
#' -   Failed
#' @param StartTime When the component started.
#' @param EndTime When the component ended.
#' @param Parameters The hyperparameters for the component.
#' @param InputArtifacts The input artifacts for the component. Examples of input artifacts are
#' datasets, algorithms, hyperparameters, source code, and instance types.
#' @param OutputArtifacts The output artifacts for the component. Examples of output artifacts are
#' metrics, snapshots, logs, and images.
#' @param MetadataProperties 
#' @param Tags A list of tags to associate with the component. You can use
#' [`search`][sagemaker_search] API to search on the tags.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_trial_component
sagemaker_create_trial_component <- function(TrialComponentName, DisplayName = NULL, Status = NULL, StartTime = NULL, EndTime = NULL, Parameters = NULL, InputArtifacts = NULL, OutputArtifacts = NULL, MetadataProperties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTrialComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_trial_component_input(TrialComponentName = TrialComponentName, DisplayName = DisplayName, Status = Status, StartTime = StartTime, EndTime = EndTime, Parameters = Parameters, InputArtifacts = InputArtifacts, OutputArtifacts = OutputArtifacts, MetadataProperties = MetadataProperties, Tags = Tags)
  output <- .sagemaker$create_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_trial_component <- sagemaker_create_trial_component

#' Creates a user profile
#'
#' @description
#' Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to a domain. If an administrator invites a person by email or imports them from IAM Identity Center, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user's private Amazon Elastic File System home directory.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_user_profile/](https://www.paws-r-sdk.com/docs/sagemaker_create_user_profile/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The ID of the associated Domain.
#' @param UserProfileName &#91;required&#93; A name for the UserProfile. This value is not case sensitive.
#' @param SingleSignOnUserIdentifier A specifier for the type of value specified in SingleSignOnUserValue.
#' Currently, the only supported value is "UserName". If the Domain's
#' AuthMode is IAM Identity Center, this field is required. If the Domain's
#' AuthMode is not IAM Identity Center, this field cannot be specified.
#' @param SingleSignOnUserValue The username of the associated Amazon Web Services Single Sign-On User
#' for this UserProfile. If the Domain's AuthMode is IAM Identity Center,
#' this field is required, and must match a valid username of a user in
#' your directory. If the Domain's AuthMode is not IAM Identity Center,
#' this field cannot be specified.
#' @param Tags Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource.
#' 
#' Tags that you specify for the User Profile are also added to all Apps
#' that the User Profile launches.
#' @param UserSettings A collection of settings.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_user_profile
sagemaker_create_user_profile <- function(DomainId, UserProfileName, SingleSignOnUserIdentifier = NULL, SingleSignOnUserValue = NULL, Tags = NULL, UserSettings = NULL) {
  op <- new_operation(
    name = "CreateUserProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName, SingleSignOnUserIdentifier = SingleSignOnUserIdentifier, SingleSignOnUserValue = SingleSignOnUserValue, Tags = Tags, UserSettings = UserSettings)
  output <- .sagemaker$create_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_user_profile <- sagemaker_create_user_profile

#' Use this operation to create a workforce
#'
#' @description
#' Use this operation to create a workforce. This operation will return an error if a workforce already exists in the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services Region per Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_workforce/](https://www.paws-r-sdk.com/docs/sagemaker_create_workforce/) for full documentation.
#'
#' @param CognitoConfig Use this parameter to configure an Amazon Cognito private workforce. A
#' single Cognito workforce is created using and corresponds to a single
#' [Amazon Cognito user
#' pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools.html).
#' 
#' Do not use `OidcConfig` if you specify values for `CognitoConfig`.
#' @param OidcConfig Use this parameter to configure a private workforce using your own OIDC
#' Identity Provider.
#' 
#' Do not use `CognitoConfig` if you specify values for `OidcConfig`.
#' @param SourceIpConfig 
#' @param WorkforceName &#91;required&#93; The name of the private workforce.
#' @param Tags An array of key-value pairs that contain metadata to help you categorize
#' and organize our workforce. Each tag consists of a key and a value, both
#' of which you define.
#' @param WorkforceVpcConfig Use this parameter to configure a workforce using VPC.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_workforce
sagemaker_create_workforce <- function(CognitoConfig = NULL, OidcConfig = NULL, SourceIpConfig = NULL, WorkforceName, Tags = NULL, WorkforceVpcConfig = NULL) {
  op <- new_operation(
    name = "CreateWorkforce",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_workforce_input(CognitoConfig = CognitoConfig, OidcConfig = OidcConfig, SourceIpConfig = SourceIpConfig, WorkforceName = WorkforceName, Tags = Tags, WorkforceVpcConfig = WorkforceVpcConfig)
  output <- .sagemaker$create_workforce_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_workforce <- sagemaker_create_workforce

#' Creates a new work team for labeling your data
#'
#' @description
#' Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_create_workteam/](https://www.paws-r-sdk.com/docs/sagemaker_create_workteam/) for full documentation.
#'
#' @param WorkteamName &#91;required&#93; The name of the work team. Use this name to identify the work team.
#' @param WorkforceName The name of the workforce.
#' @param MemberDefinitions &#91;required&#93; A list of `MemberDefinition` objects that contains objects that identify
#' the workers that make up the work team.
#' 
#' Workforces can be created using Amazon Cognito or your own OIDC Identity
#' Provider (IdP). For private workforces created using Amazon Cognito use
#' `CognitoMemberDefinition`. For workforces created using your own OIDC
#' identity provider (IdP) use `OidcMemberDefinition`. Do not provide input
#' for both of these parameters in a single request.
#' 
#' For workforces created using Amazon Cognito, private work teams
#' correspond to Amazon Cognito *user groups* within the user pool used to
#' create a workforce. All of the `CognitoMemberDefinition` objects that
#' make up the member definition must have the same `ClientId` and
#' `UserPool` values. To add a Amazon Cognito user group to an existing
#' worker pool, see Adding groups to a User Pool. For more information
#' about user pools, see [Amazon Cognito User
#' Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools.html).
#' 
#' For workforces created using your own OIDC IdP, specify the user groups
#' that you want to include in your private work team in
#' `OidcMemberDefinition` by listing those groups in `Groups`.
#' @param Description &#91;required&#93; A description of the work team.
#' @param NotificationConfiguration Configures notification of workers regarding available or expiring work
#' items.
#' @param WorkerAccessConfiguration Use this optional parameter to constrain access to an Amazon S3 resource
#' based on the IP address using supported IAM global condition keys. The
#' Amazon S3 resource is accessed in the worker portal using a Amazon S3
#' presigned URL.
#' @param Tags An array of key-value pairs.
#' 
#' For more information, see [Resource
#' Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html)
#' and [Using Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_workteam
sagemaker_create_workteam <- function(WorkteamName, WorkforceName = NULL, MemberDefinitions, Description, NotificationConfiguration = NULL, WorkerAccessConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWorkteam",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$create_workteam_input(WorkteamName = WorkteamName, WorkforceName = WorkforceName, MemberDefinitions = MemberDefinitions, Description = Description, NotificationConfiguration = NotificationConfiguration, WorkerAccessConfiguration = WorkerAccessConfiguration, Tags = Tags)
  output <- .sagemaker$create_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_workteam <- sagemaker_create_workteam

#' Deletes an action
#'
#' @description
#' Deletes an action.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_action/](https://www.paws-r-sdk.com/docs/sagemaker_delete_action/) for full documentation.
#'
#' @param ActionName &#91;required&#93; The name of the action to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_action
sagemaker_delete_action <- function(ActionName) {
  op <- new_operation(
    name = "DeleteAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_action_input(ActionName = ActionName)
  output <- .sagemaker$delete_action_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_action <- sagemaker_delete_action

#' Removes the specified algorithm from your account
#'
#' @description
#' Removes the specified algorithm from your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_algorithm/](https://www.paws-r-sdk.com/docs/sagemaker_delete_algorithm/) for full documentation.
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_algorithm
sagemaker_delete_algorithm <- function(AlgorithmName) {
  op <- new_operation(
    name = "DeleteAlgorithm",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_algorithm_input(AlgorithmName = AlgorithmName)
  output <- .sagemaker$delete_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_algorithm <- sagemaker_delete_algorithm

#' Used to stop and delete an app
#'
#' @description
#' Used to stop and delete an app.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_app/](https://www.paws-r-sdk.com/docs/sagemaker_delete_app/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName The user profile name. If this value is not set, then `SpaceName` must
#' be set.
#' @param SpaceName The name of the space. If this value is not set, then `UserProfileName`
#' must be set.
#' @param AppType &#91;required&#93; The type of app.
#' @param AppName &#91;required&#93; The name of the app.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_app
sagemaker_delete_app <- function(DomainId, UserProfileName = NULL, SpaceName = NULL, AppType, AppName) {
  op <- new_operation(
    name = "DeleteApp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_app_input(DomainId = DomainId, UserProfileName = UserProfileName, SpaceName = SpaceName, AppType = AppType, AppName = AppName)
  output <- .sagemaker$delete_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_app <- sagemaker_delete_app

#' Deletes an AppImageConfig
#'
#' @description
#' Deletes an AppImageConfig.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_app_image_config/](https://www.paws-r-sdk.com/docs/sagemaker_delete_app_image_config/) for full documentation.
#'
#' @param AppImageConfigName &#91;required&#93; The name of the AppImageConfig to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_app_image_config
sagemaker_delete_app_image_config <- function(AppImageConfigName) {
  op <- new_operation(
    name = "DeleteAppImageConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_app_image_config_input(AppImageConfigName = AppImageConfigName)
  output <- .sagemaker$delete_app_image_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_app_image_config <- sagemaker_delete_app_image_config

#' Deletes an artifact
#'
#' @description
#' Deletes an artifact. Either `ArtifactArn` or `Source` must be specified.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_artifact/](https://www.paws-r-sdk.com/docs/sagemaker_delete_artifact/) for full documentation.
#'
#' @param ArtifactArn The Amazon Resource Name (ARN) of the artifact to delete.
#' @param Source The URI of the source.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_artifact
sagemaker_delete_artifact <- function(ArtifactArn = NULL, Source = NULL) {
  op <- new_operation(
    name = "DeleteArtifact",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_artifact_input(ArtifactArn = ArtifactArn, Source = Source)
  output <- .sagemaker$delete_artifact_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_artifact <- sagemaker_delete_artifact

#' Deletes an association
#'
#' @description
#' Deletes an association.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_association/](https://www.paws-r-sdk.com/docs/sagemaker_delete_association/) for full documentation.
#'
#' @param SourceArn &#91;required&#93; The ARN of the source.
#' @param DestinationArn &#91;required&#93; The Amazon Resource Name (ARN) of the destination.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_association
sagemaker_delete_association <- function(SourceArn, DestinationArn) {
  op <- new_operation(
    name = "DeleteAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_association_input(SourceArn = SourceArn, DestinationArn = DestinationArn)
  output <- .sagemaker$delete_association_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_association <- sagemaker_delete_association

#' Delete a SageMaker HyperPod cluster
#'
#' @description
#' Delete a SageMaker HyperPod cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_cluster/](https://www.paws-r-sdk.com/docs/sagemaker_delete_cluster/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The string name or the Amazon Resource Name (ARN) of the SageMaker
#' HyperPod cluster to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_cluster
sagemaker_delete_cluster <- function(ClusterName) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_cluster_input(ClusterName = ClusterName)
  output <- .sagemaker$delete_cluster_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_cluster <- sagemaker_delete_cluster

#' Deletes the cluster policy of the cluster
#'
#' @description
#' Deletes the cluster policy of the cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_cluster_scheduler_config/](https://www.paws-r-sdk.com/docs/sagemaker_delete_cluster_scheduler_config/) for full documentation.
#'
#' @param ClusterSchedulerConfigId &#91;required&#93; ID of the cluster policy.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_cluster_scheduler_config
sagemaker_delete_cluster_scheduler_config <- function(ClusterSchedulerConfigId) {
  op <- new_operation(
    name = "DeleteClusterSchedulerConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_cluster_scheduler_config_input(ClusterSchedulerConfigId = ClusterSchedulerConfigId)
  output <- .sagemaker$delete_cluster_scheduler_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_cluster_scheduler_config <- sagemaker_delete_cluster_scheduler_config

#' Deletes the specified Git repository from your account
#'
#' @description
#' Deletes the specified Git repository from your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_code_repository/](https://www.paws-r-sdk.com/docs/sagemaker_delete_code_repository/) for full documentation.
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_code_repository
sagemaker_delete_code_repository <- function(CodeRepositoryName) {
  op <- new_operation(
    name = "DeleteCodeRepository",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_code_repository_input(CodeRepositoryName = CodeRepositoryName)
  output <- .sagemaker$delete_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_code_repository <- sagemaker_delete_code_repository

#' Deletes the specified compilation job
#'
#' @description
#' Deletes the specified compilation job. This action deletes only the compilation job resource in Amazon SageMaker AI. It doesn't delete other resources that are related to that job, such as the model artifacts that the job creates, the compilation logs in CloudWatch, the compiled model, or the IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_compilation_job/](https://www.paws-r-sdk.com/docs/sagemaker_delete_compilation_job/) for full documentation.
#'
#' @param CompilationJobName &#91;required&#93; The name of the compilation job to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_compilation_job
sagemaker_delete_compilation_job <- function(CompilationJobName) {
  op <- new_operation(
    name = "DeleteCompilationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_compilation_job_input(CompilationJobName = CompilationJobName)
  output <- .sagemaker$delete_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_compilation_job <- sagemaker_delete_compilation_job

#' Deletes the compute allocation from the cluster
#'
#' @description
#' Deletes the compute allocation from the cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_compute_quota/](https://www.paws-r-sdk.com/docs/sagemaker_delete_compute_quota/) for full documentation.
#'
#' @param ComputeQuotaId &#91;required&#93; ID of the compute allocation definition.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_compute_quota
sagemaker_delete_compute_quota <- function(ComputeQuotaId) {
  op <- new_operation(
    name = "DeleteComputeQuota",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_compute_quota_input(ComputeQuotaId = ComputeQuotaId)
  output <- .sagemaker$delete_compute_quota_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_compute_quota <- sagemaker_delete_compute_quota

#' Deletes an context
#'
#' @description
#' Deletes an context.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_context/](https://www.paws-r-sdk.com/docs/sagemaker_delete_context/) for full documentation.
#'
#' @param ContextName &#91;required&#93; The name of the context to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_context
sagemaker_delete_context <- function(ContextName) {
  op <- new_operation(
    name = "DeleteContext",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_context_input(ContextName = ContextName)
  output <- .sagemaker$delete_context_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_context <- sagemaker_delete_context

#' Deletes a data quality monitoring job definition
#'
#' @description
#' Deletes a data quality monitoring job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_data_quality_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_delete_data_quality_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the data quality monitoring job definition to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_data_quality_job_definition
sagemaker_delete_data_quality_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DeleteDataQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_data_quality_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$delete_data_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_data_quality_job_definition <- sagemaker_delete_data_quality_job_definition

#' Deletes a fleet
#'
#' @description
#' Deletes a fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_device_fleet/](https://www.paws-r-sdk.com/docs/sagemaker_delete_device_fleet/) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_device_fleet
sagemaker_delete_device_fleet <- function(DeviceFleetName) {
  op <- new_operation(
    name = "DeleteDeviceFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_device_fleet_input(DeviceFleetName = DeviceFleetName)
  output <- .sagemaker$delete_device_fleet_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_device_fleet <- sagemaker_delete_device_fleet

#' Used to delete a domain
#'
#' @description
#' Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again using IAM Identity Center. Use with caution. All of the members of the domain will lose access to their EFS volume, including data, notebooks, and other artifacts.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_domain/](https://www.paws-r-sdk.com/docs/sagemaker_delete_domain/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param RetentionPolicy The retention policy for this domain, which specifies whether resources
#' will be retained after the Domain is deleted. By default, all resources
#' are retained (not automatically deleted).
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_domain
sagemaker_delete_domain <- function(DomainId, RetentionPolicy = NULL) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_domain_input(DomainId = DomainId, RetentionPolicy = RetentionPolicy)
  output <- .sagemaker$delete_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_domain <- sagemaker_delete_domain

#' Deletes an edge deployment plan if (and only if) all the stages in the
#' plan are inactive or there are no stages in the plan
#'
#' @description
#' Deletes an edge deployment plan if (and only if) all the stages in the plan are inactive or there are no stages in the plan.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_edge_deployment_plan/](https://www.paws-r-sdk.com/docs/sagemaker_delete_edge_deployment_plan/) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_edge_deployment_plan
sagemaker_delete_edge_deployment_plan <- function(EdgeDeploymentPlanName) {
  op <- new_operation(
    name = "DeleteEdgeDeploymentPlan",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_edge_deployment_plan_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName)
  output <- .sagemaker$delete_edge_deployment_plan_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_edge_deployment_plan <- sagemaker_delete_edge_deployment_plan

#' Delete a stage in an edge deployment plan if (and only if) the stage is
#' inactive
#'
#' @description
#' Delete a stage in an edge deployment plan if (and only if) the stage is inactive.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_edge_deployment_stage/](https://www.paws-r-sdk.com/docs/sagemaker_delete_edge_deployment_stage/) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan from which the stage will be
#' deleted.
#' @param StageName &#91;required&#93; The name of the stage.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_edge_deployment_stage
sagemaker_delete_edge_deployment_stage <- function(EdgeDeploymentPlanName, StageName) {
  op <- new_operation(
    name = "DeleteEdgeDeploymentStage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_edge_deployment_stage_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, StageName = StageName)
  output <- .sagemaker$delete_edge_deployment_stage_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_edge_deployment_stage <- sagemaker_delete_edge_deployment_stage

#' Deletes an endpoint
#'
#' @description
#' Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_endpoint/](https://www.paws-r-sdk.com/docs/sagemaker_delete_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint that you want to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_endpoint
sagemaker_delete_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_endpoint_input(EndpointName = EndpointName)
  output <- .sagemaker$delete_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_endpoint <- sagemaker_delete_endpoint

#' Deletes an endpoint configuration
#'
#' @description
#' Deletes an endpoint configuration. The [`delete_endpoint_config`][sagemaker_delete_endpoint_config] API deletes only the specified configuration. It does not delete endpoints created using the configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_endpoint_config/](https://www.paws-r-sdk.com/docs/sagemaker_delete_endpoint_config/) for full documentation.
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration that you want to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_endpoint_config
sagemaker_delete_endpoint_config <- function(EndpointConfigName) {
  op <- new_operation(
    name = "DeleteEndpointConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_endpoint_config_input(EndpointConfigName = EndpointConfigName)
  output <- .sagemaker$delete_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_endpoint_config <- sagemaker_delete_endpoint_config

#' Deletes an SageMaker experiment
#'
#' @description
#' Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the [`list_trials`][sagemaker_list_trials] API to get a list of the trials associated with the experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_experiment/](https://www.paws-r-sdk.com/docs/sagemaker_delete_experiment/) for full documentation.
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_experiment
sagemaker_delete_experiment <- function(ExperimentName) {
  op <- new_operation(
    name = "DeleteExperiment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_experiment_input(ExperimentName = ExperimentName)
  output <- .sagemaker$delete_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_experiment <- sagemaker_delete_experiment

#' Delete the FeatureGroup and any data that was written to the OnlineStore
#' of the FeatureGroup
#'
#' @description
#' Delete the `FeatureGroup` and any data that was written to the `OnlineStore` of the `FeatureGroup`. Data cannot be accessed from the `OnlineStore` immediately after [`delete_feature_group`][sagemaker_delete_feature_group] is called.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_feature_group/](https://www.paws-r-sdk.com/docs/sagemaker_delete_feature_group/) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the `FeatureGroup` you want to delete. The name must be
#' unique within an Amazon Web Services Region in an Amazon Web Services
#' account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_feature_group
sagemaker_delete_feature_group <- function(FeatureGroupName) {
  op <- new_operation(
    name = "DeleteFeatureGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_feature_group_input(FeatureGroupName = FeatureGroupName)
  output <- .sagemaker$delete_feature_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_feature_group <- sagemaker_delete_feature_group

#' Deletes the specified flow definition
#'
#' @description
#' Deletes the specified flow definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_flow_definition/](https://www.paws-r-sdk.com/docs/sagemaker_delete_flow_definition/) for full documentation.
#'
#' @param FlowDefinitionName &#91;required&#93; The name of the flow definition you are deleting.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_flow_definition
sagemaker_delete_flow_definition <- function(FlowDefinitionName) {
  op <- new_operation(
    name = "DeleteFlowDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_flow_definition_input(FlowDefinitionName = FlowDefinitionName)
  output <- .sagemaker$delete_flow_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_flow_definition <- sagemaker_delete_flow_definition

#' Delete a hub
#'
#' @description
#' Delete a hub.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_hub/](https://www.paws-r-sdk.com/docs/sagemaker_delete_hub/) for full documentation.
#'
#' @param HubName &#91;required&#93; The name of the hub to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_hub
sagemaker_delete_hub <- function(HubName) {
  op <- new_operation(
    name = "DeleteHub",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_hub_input(HubName = HubName)
  output <- .sagemaker$delete_hub_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_hub <- sagemaker_delete_hub

#' Delete the contents of a hub
#'
#' @description
#' Delete the contents of a hub.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_hub_content/](https://www.paws-r-sdk.com/docs/sagemaker_delete_hub_content/) for full documentation.
#'
#' @param HubName &#91;required&#93; The name of the hub that you want to delete content in.
#' @param HubContentType &#91;required&#93; The type of content that you want to delete from a hub.
#' @param HubContentName &#91;required&#93; The name of the content that you want to delete from a hub.
#' @param HubContentVersion &#91;required&#93; The version of the content that you want to delete from a hub.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_hub_content
sagemaker_delete_hub_content <- function(HubName, HubContentType, HubContentName, HubContentVersion) {
  op <- new_operation(
    name = "DeleteHubContent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_hub_content_input(HubName = HubName, HubContentType = HubContentType, HubContentName = HubContentName, HubContentVersion = HubContentVersion)
  output <- .sagemaker$delete_hub_content_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_hub_content <- sagemaker_delete_hub_content

#' Delete a hub content reference in order to remove a model from a private
#' hub
#'
#' @description
#' Delete a hub content reference in order to remove a model from a private hub.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_hub_content_reference/](https://www.paws-r-sdk.com/docs/sagemaker_delete_hub_content_reference/) for full documentation.
#'
#' @param HubName &#91;required&#93; The name of the hub to delete the hub content reference from.
#' @param HubContentType &#91;required&#93; The type of hub content reference to delete. The only supported type of
#' hub content reference to delete is `ModelReference`.
#' @param HubContentName &#91;required&#93; The name of the hub content to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_hub_content_reference
sagemaker_delete_hub_content_reference <- function(HubName, HubContentType, HubContentName) {
  op <- new_operation(
    name = "DeleteHubContentReference",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_hub_content_reference_input(HubName = HubName, HubContentType = HubContentType, HubContentName = HubContentName)
  output <- .sagemaker$delete_hub_content_reference_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_hub_content_reference <- sagemaker_delete_hub_content_reference

#' Use this operation to delete a human task user interface (worker task
#' template)
#'
#' @description
#' Use this operation to delete a human task user interface (worker task template).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_human_task_ui/](https://www.paws-r-sdk.com/docs/sagemaker_delete_human_task_ui/) for full documentation.
#'
#' @param HumanTaskUiName &#91;required&#93; The name of the human task user interface (work task template) you want
#' to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_human_task_ui
sagemaker_delete_human_task_ui <- function(HumanTaskUiName) {
  op <- new_operation(
    name = "DeleteHumanTaskUi",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_human_task_ui_input(HumanTaskUiName = HumanTaskUiName)
  output <- .sagemaker$delete_human_task_ui_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_human_task_ui <- sagemaker_delete_human_task_ui

#' Deletes a hyperparameter tuning job
#'
#' @description
#' Deletes a hyperparameter tuning job. The [`delete_hyper_parameter_tuning_job`][sagemaker_delete_hyper_parameter_tuning_job] API deletes only the tuning job entry that was created in SageMaker when you called the [`create_hyper_parameter_tuning_job`][sagemaker_create_hyper_parameter_tuning_job] API. It does not delete training jobs, artifacts, or the IAM role that you specified when creating the model.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_hyper_parameter_tuning_job/](https://www.paws-r-sdk.com/docs/sagemaker_delete_hyper_parameter_tuning_job/) for full documentation.
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the hyperparameter tuning job that you want to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_hyper_parameter_tuning_job
sagemaker_delete_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName) {
  op <- new_operation(
    name = "DeleteHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName)
  output <- .sagemaker$delete_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_hyper_parameter_tuning_job <- sagemaker_delete_hyper_parameter_tuning_job

#' Deletes a SageMaker AI image and all versions of the image
#'
#' @description
#' Deletes a SageMaker AI image and all versions of the image. The container images aren't deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_image/](https://www.paws-r-sdk.com/docs/sagemaker_delete_image/) for full documentation.
#'
#' @param ImageName &#91;required&#93; The name of the image to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_image
sagemaker_delete_image <- function(ImageName) {
  op <- new_operation(
    name = "DeleteImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_image_input(ImageName = ImageName)
  output <- .sagemaker$delete_image_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_image <- sagemaker_delete_image

#' Deletes a version of a SageMaker AI image
#'
#' @description
#' Deletes a version of a SageMaker AI image. The container image the version represents isn't deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_image_version/](https://www.paws-r-sdk.com/docs/sagemaker_delete_image_version/) for full documentation.
#'
#' @param ImageName &#91;required&#93; The name of the image to delete.
#' @param Version The version to delete.
#' @param Alias The alias of the image to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_image_version
sagemaker_delete_image_version <- function(ImageName, Version = NULL, Alias = NULL) {
  op <- new_operation(
    name = "DeleteImageVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_image_version_input(ImageName = ImageName, Version = Version, Alias = Alias)
  output <- .sagemaker$delete_image_version_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_image_version <- sagemaker_delete_image_version

#' Deletes an inference component
#'
#' @description
#' Deletes an inference component.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_inference_component/](https://www.paws-r-sdk.com/docs/sagemaker_delete_inference_component/) for full documentation.
#'
#' @param InferenceComponentName &#91;required&#93; The name of the inference component to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_inference_component
sagemaker_delete_inference_component <- function(InferenceComponentName) {
  op <- new_operation(
    name = "DeleteInferenceComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_inference_component_input(InferenceComponentName = InferenceComponentName)
  output <- .sagemaker$delete_inference_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_inference_component <- sagemaker_delete_inference_component

#' Deletes an inference experiment
#'
#' @description
#' Deletes an inference experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_inference_experiment/](https://www.paws-r-sdk.com/docs/sagemaker_delete_inference_experiment/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the inference experiment you want to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_inference_experiment
sagemaker_delete_inference_experiment <- function(Name) {
  op <- new_operation(
    name = "DeleteInferenceExperiment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_inference_experiment_input(Name = Name)
  output <- .sagemaker$delete_inference_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_inference_experiment <- sagemaker_delete_inference_experiment

#' Deletes an MLflow Tracking Server
#'
#' @description
#' Deletes an MLflow Tracking Server. For more information, see [Clean up MLflow resources](https://docs.aws.amazon.com/sagemaker/latest/dg/).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_mlflow_tracking_server/](https://www.paws-r-sdk.com/docs/sagemaker_delete_mlflow_tracking_server/) for full documentation.
#'
#' @param TrackingServerName &#91;required&#93; The name of the the tracking server to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_mlflow_tracking_server
sagemaker_delete_mlflow_tracking_server <- function(TrackingServerName) {
  op <- new_operation(
    name = "DeleteMlflowTrackingServer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_mlflow_tracking_server_input(TrackingServerName = TrackingServerName)
  output <- .sagemaker$delete_mlflow_tracking_server_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_mlflow_tracking_server <- sagemaker_delete_mlflow_tracking_server

#' Deletes a model
#'
#' @description
#' Deletes a model. The [`delete_model`][sagemaker_delete_model] API deletes only the model entry that was created in SageMaker when you called the [`create_model`][sagemaker_create_model] API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_model/](https://www.paws-r-sdk.com/docs/sagemaker_delete_model/) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the model to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model
sagemaker_delete_model <- function(ModelName) {
  op <- new_operation(
    name = "DeleteModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_model_input(ModelName = ModelName)
  output <- .sagemaker$delete_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model <- sagemaker_delete_model

#' Deletes an Amazon SageMaker AI model bias job definition
#'
#' @description
#' Deletes an Amazon SageMaker AI model bias job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_model_bias_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_delete_model_bias_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model bias job definition to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_bias_job_definition
sagemaker_delete_model_bias_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DeleteModelBiasJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_model_bias_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$delete_model_bias_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_bias_job_definition <- sagemaker_delete_model_bias_job_definition

#' Deletes an Amazon SageMaker Model Card
#'
#' @description
#' Deletes an Amazon SageMaker Model Card.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_model_card/](https://www.paws-r-sdk.com/docs/sagemaker_delete_model_card/) for full documentation.
#'
#' @param ModelCardName &#91;required&#93; The name of the model card to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_card
sagemaker_delete_model_card <- function(ModelCardName) {
  op <- new_operation(
    name = "DeleteModelCard",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_model_card_input(ModelCardName = ModelCardName)
  output <- .sagemaker$delete_model_card_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_card <- sagemaker_delete_model_card

#' Deletes an Amazon SageMaker AI model explainability job definition
#'
#' @description
#' Deletes an Amazon SageMaker AI model explainability job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_model_explainability_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_delete_model_explainability_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model explainability job definition to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_explainability_job_definition
sagemaker_delete_model_explainability_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DeleteModelExplainabilityJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_model_explainability_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$delete_model_explainability_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_explainability_job_definition <- sagemaker_delete_model_explainability_job_definition

#' Deletes a model package
#'
#' @description
#' Deletes a model package.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_model_package/](https://www.paws-r-sdk.com/docs/sagemaker_delete_model_package/) for full documentation.
#'
#' @param ModelPackageName &#91;required&#93; The name or Amazon Resource Name (ARN) of the model package to delete.
#' 
#' When you specify a name, the name must have 1 to 63 characters. Valid
#' characters are a-z, A-Z, 0-9, and - (hyphen).
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_package
sagemaker_delete_model_package <- function(ModelPackageName) {
  op <- new_operation(
    name = "DeleteModelPackage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_model_package_input(ModelPackageName = ModelPackageName)
  output <- .sagemaker$delete_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_package <- sagemaker_delete_model_package

#' Deletes the specified model group
#'
#' @description
#' Deletes the specified model group.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_model_package_group/](https://www.paws-r-sdk.com/docs/sagemaker_delete_model_package_group/) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_package_group
sagemaker_delete_model_package_group <- function(ModelPackageGroupName) {
  op <- new_operation(
    name = "DeleteModelPackageGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_model_package_group_input(ModelPackageGroupName = ModelPackageGroupName)
  output <- .sagemaker$delete_model_package_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_package_group <- sagemaker_delete_model_package_group

#' Deletes a model group resource policy
#'
#' @description
#' Deletes a model group resource policy.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_model_package_group_policy/](https://www.paws-r-sdk.com/docs/sagemaker_delete_model_package_group_policy/) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group for which to delete the policy.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_package_group_policy
sagemaker_delete_model_package_group_policy <- function(ModelPackageGroupName) {
  op <- new_operation(
    name = "DeleteModelPackageGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_model_package_group_policy_input(ModelPackageGroupName = ModelPackageGroupName)
  output <- .sagemaker$delete_model_package_group_policy_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_package_group_policy <- sagemaker_delete_model_package_group_policy

#' Deletes the secified model quality monitoring job definition
#'
#' @description
#' Deletes the secified model quality monitoring job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_model_quality_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_delete_model_quality_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model quality monitoring job definition to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_quality_job_definition
sagemaker_delete_model_quality_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DeleteModelQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_model_quality_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$delete_model_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_quality_job_definition <- sagemaker_delete_model_quality_job_definition

#' Deletes a monitoring schedule
#'
#' @description
#' Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job execution history of the monitoring schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_monitoring_schedule/](https://www.paws-r-sdk.com/docs/sagemaker_delete_monitoring_schedule/) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the monitoring schedule to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_monitoring_schedule
sagemaker_delete_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "DeleteMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$delete_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_monitoring_schedule <- sagemaker_delete_monitoring_schedule

#' Deletes an SageMaker AI notebook instance
#'
#' @description
#' Deletes an SageMaker AI notebook instance. Before you can delete a notebook instance, you must call the [`stop_notebook_instance`][sagemaker_stop_notebook_instance] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_notebook_instance/](https://www.paws-r-sdk.com/docs/sagemaker_delete_notebook_instance/) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the SageMaker AI notebook instance to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_notebook_instance
sagemaker_delete_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "DeleteNotebookInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$delete_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_notebook_instance <- sagemaker_delete_notebook_instance

#' Deletes a notebook instance lifecycle configuration
#'
#' @description
#' Deletes a notebook instance lifecycle configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_notebook_instance_lifecycle_config/](https://www.paws-r-sdk.com/docs/sagemaker_delete_notebook_instance_lifecycle_config/) for full documentation.
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_notebook_instance_lifecycle_config
sagemaker_delete_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName) {
  op <- new_operation(
    name = "DeleteNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName)
  output <- .sagemaker$delete_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_notebook_instance_lifecycle_config <- sagemaker_delete_notebook_instance_lifecycle_config

#' Deletes an optimization job
#'
#' @description
#' Deletes an optimization job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_optimization_job/](https://www.paws-r-sdk.com/docs/sagemaker_delete_optimization_job/) for full documentation.
#'
#' @param OptimizationJobName &#91;required&#93; The name that you assigned to the optimization job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_optimization_job
sagemaker_delete_optimization_job <- function(OptimizationJobName) {
  op <- new_operation(
    name = "DeleteOptimizationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_optimization_job_input(OptimizationJobName = OptimizationJobName)
  output <- .sagemaker$delete_optimization_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_optimization_job <- sagemaker_delete_optimization_job

#' Deletes a SageMaker Partner AI App
#'
#' @description
#' Deletes a SageMaker Partner AI App.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_partner_app/](https://www.paws-r-sdk.com/docs/sagemaker_delete_partner_app/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the SageMaker Partner AI App to delete.
#' @param ClientToken A unique token that guarantees that the call to this API is idempotent.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_partner_app
sagemaker_delete_partner_app <- function(Arn, ClientToken = NULL) {
  op <- new_operation(
    name = "DeletePartnerApp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_partner_app_input(Arn = Arn, ClientToken = ClientToken)
  output <- .sagemaker$delete_partner_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_partner_app <- sagemaker_delete_partner_app

#' Deletes a pipeline if there are no running instances of the pipeline
#'
#' @description
#' Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all running instances of the pipeline using the [`stop_pipeline_execution`][sagemaker_stop_pipeline_execution] API. When you delete a pipeline, all instances of the pipeline are deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_pipeline/](https://www.paws-r-sdk.com/docs/sagemaker_delete_pipeline/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline to delete.
#' @param ClientRequestToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than one time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_pipeline
sagemaker_delete_pipeline <- function(PipelineName, ClientRequestToken) {
  op <- new_operation(
    name = "DeletePipeline",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_pipeline_input(PipelineName = PipelineName, ClientRequestToken = ClientRequestToken)
  output <- .sagemaker$delete_pipeline_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_pipeline <- sagemaker_delete_pipeline

#' Delete the specified project
#'
#' @description
#' Delete the specified project.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_project/](https://www.paws-r-sdk.com/docs/sagemaker_delete_project/) for full documentation.
#'
#' @param ProjectName &#91;required&#93; The name of the project to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_project
sagemaker_delete_project <- function(ProjectName) {
  op <- new_operation(
    name = "DeleteProject",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_project_input(ProjectName = ProjectName)
  output <- .sagemaker$delete_project_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_project <- sagemaker_delete_project

#' Used to delete a space
#'
#' @description
#' Used to delete a space.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_space/](https://www.paws-r-sdk.com/docs/sagemaker_delete_space/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The ID of the associated domain.
#' @param SpaceName &#91;required&#93; The name of the space.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_space
sagemaker_delete_space <- function(DomainId, SpaceName) {
  op <- new_operation(
    name = "DeleteSpace",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_space_input(DomainId = DomainId, SpaceName = SpaceName)
  output <- .sagemaker$delete_space_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_space <- sagemaker_delete_space

#' Deletes the Amazon SageMaker AI Studio Lifecycle Configuration
#'
#' @description
#' Deletes the Amazon SageMaker AI Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration, there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration from UserSettings in all Domains and UserProfiles.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_studio_lifecycle_config/](https://www.paws-r-sdk.com/docs/sagemaker_delete_studio_lifecycle_config/) for full documentation.
#'
#' @param StudioLifecycleConfigName &#91;required&#93; The name of the Amazon SageMaker AI Studio Lifecycle Configuration to
#' delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_studio_lifecycle_config
sagemaker_delete_studio_lifecycle_config <- function(StudioLifecycleConfigName) {
  op <- new_operation(
    name = "DeleteStudioLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_studio_lifecycle_config_input(StudioLifecycleConfigName = StudioLifecycleConfigName)
  output <- .sagemaker$delete_studio_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_studio_lifecycle_config <- sagemaker_delete_studio_lifecycle_config

#' Deletes the specified tags from an SageMaker resource
#'
#' @description
#' Deletes the specified tags from an SageMaker resource.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_tags/](https://www.paws-r-sdk.com/docs/sagemaker_delete_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' delete.
#' @param TagKeys &#91;required&#93; An array or one or more tag keys to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_tags
sagemaker_delete_tags <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_tags_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .sagemaker$delete_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_tags <- sagemaker_delete_tags

#' Deletes the specified trial
#'
#' @description
#' Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the [`describe_trial_component`][sagemaker_describe_trial_component] API to get the list of trial components.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_trial/](https://www.paws-r-sdk.com/docs/sagemaker_delete_trial/) for full documentation.
#'
#' @param TrialName &#91;required&#93; The name of the trial to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_trial
sagemaker_delete_trial <- function(TrialName) {
  op <- new_operation(
    name = "DeleteTrial",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_trial_input(TrialName = TrialName)
  output <- .sagemaker$delete_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_trial <- sagemaker_delete_trial

#' Deletes the specified trial component
#'
#' @description
#' Deletes the specified trial component. A trial component must be disassociated from all trials before the trial component can be deleted. To disassociate a trial component from a trial, call the [`disassociate_trial_component`][sagemaker_disassociate_trial_component] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_trial_component/](https://www.paws-r-sdk.com/docs/sagemaker_delete_trial_component/) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_trial_component
sagemaker_delete_trial_component <- function(TrialComponentName) {
  op <- new_operation(
    name = "DeleteTrialComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_trial_component_input(TrialComponentName = TrialComponentName)
  output <- .sagemaker$delete_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_trial_component <- sagemaker_delete_trial_component

#' Deletes a user profile
#'
#' @description
#' Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including data, notebooks, and other artifacts.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_user_profile/](https://www.paws-r-sdk.com/docs/sagemaker_delete_user_profile/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_user_profile
sagemaker_delete_user_profile <- function(DomainId, UserProfileName) {
  op <- new_operation(
    name = "DeleteUserProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName)
  output <- .sagemaker$delete_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_user_profile <- sagemaker_delete_user_profile

#' Use this operation to delete a workforce
#'
#' @description
#' Use this operation to delete a workforce.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_workforce/](https://www.paws-r-sdk.com/docs/sagemaker_delete_workforce/) for full documentation.
#'
#' @param WorkforceName &#91;required&#93; The name of the workforce.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_workforce
sagemaker_delete_workforce <- function(WorkforceName) {
  op <- new_operation(
    name = "DeleteWorkforce",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_workforce_input(WorkforceName = WorkforceName)
  output <- .sagemaker$delete_workforce_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_workforce <- sagemaker_delete_workforce

#' Deletes an existing work team
#'
#' @description
#' Deletes an existing work team. This operation can't be undone.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_delete_workteam/](https://www.paws-r-sdk.com/docs/sagemaker_delete_workteam/) for full documentation.
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_workteam
sagemaker_delete_workteam <- function(WorkteamName) {
  op <- new_operation(
    name = "DeleteWorkteam",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$delete_workteam_input(WorkteamName = WorkteamName)
  output <- .sagemaker$delete_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_workteam <- sagemaker_delete_workteam

#' Deregisters the specified devices
#'
#' @description
#' Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_deregister_devices/](https://www.paws-r-sdk.com/docs/sagemaker_deregister_devices/) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet the devices belong to.
#' @param DeviceNames &#91;required&#93; The unique IDs of the devices.
#'
#' @keywords internal
#'
#' @rdname sagemaker_deregister_devices
sagemaker_deregister_devices <- function(DeviceFleetName, DeviceNames) {
  op <- new_operation(
    name = "DeregisterDevices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$deregister_devices_input(DeviceFleetName = DeviceFleetName, DeviceNames = DeviceNames)
  output <- .sagemaker$deregister_devices_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$deregister_devices <- sagemaker_deregister_devices

#' Describes an action
#'
#' @description
#' Describes an action.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_action/](https://www.paws-r-sdk.com/docs/sagemaker_describe_action/) for full documentation.
#'
#' @param ActionName &#91;required&#93; The name of the action to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_action
sagemaker_describe_action <- function(ActionName) {
  op <- new_operation(
    name = "DescribeAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_action_input(ActionName = ActionName)
  output <- .sagemaker$describe_action_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_action <- sagemaker_describe_action

#' Returns a description of the specified algorithm that is in your account
#'
#' @description
#' Returns a description of the specified algorithm that is in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_algorithm/](https://www.paws-r-sdk.com/docs/sagemaker_describe_algorithm/) for full documentation.
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_algorithm
sagemaker_describe_algorithm <- function(AlgorithmName) {
  op <- new_operation(
    name = "DescribeAlgorithm",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_algorithm_input(AlgorithmName = AlgorithmName)
  output <- .sagemaker$describe_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_algorithm <- sagemaker_describe_algorithm

#' Describes the app
#'
#' @description
#' Describes the app.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_app/](https://www.paws-r-sdk.com/docs/sagemaker_describe_app/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName The user profile name. If this value is not set, then `SpaceName` must
#' be set.
#' @param SpaceName The name of the space.
#' @param AppType &#91;required&#93; The type of app.
#' @param AppName &#91;required&#93; The name of the app.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_app
sagemaker_describe_app <- function(DomainId, UserProfileName = NULL, SpaceName = NULL, AppType, AppName) {
  op <- new_operation(
    name = "DescribeApp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_app_input(DomainId = DomainId, UserProfileName = UserProfileName, SpaceName = SpaceName, AppType = AppType, AppName = AppName)
  output <- .sagemaker$describe_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_app <- sagemaker_describe_app

#' Describes an AppImageConfig
#'
#' @description
#' Describes an AppImageConfig.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_app_image_config/](https://www.paws-r-sdk.com/docs/sagemaker_describe_app_image_config/) for full documentation.
#'
#' @param AppImageConfigName &#91;required&#93; The name of the AppImageConfig to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_app_image_config
sagemaker_describe_app_image_config <- function(AppImageConfigName) {
  op <- new_operation(
    name = "DescribeAppImageConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_app_image_config_input(AppImageConfigName = AppImageConfigName)
  output <- .sagemaker$describe_app_image_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_app_image_config <- sagemaker_describe_app_image_config

#' Describes an artifact
#'
#' @description
#' Describes an artifact.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_artifact/](https://www.paws-r-sdk.com/docs/sagemaker_describe_artifact/) for full documentation.
#'
#' @param ArtifactArn &#91;required&#93; The Amazon Resource Name (ARN) of the artifact to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_artifact
sagemaker_describe_artifact <- function(ArtifactArn) {
  op <- new_operation(
    name = "DescribeArtifact",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_artifact_input(ArtifactArn = ArtifactArn)
  output <- .sagemaker$describe_artifact_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_artifact <- sagemaker_describe_artifact

#' Returns information about an AutoML job created by calling
#' CreateAutoMLJob
#'
#' @description
#' Returns information about an AutoML job created by calling [`create_auto_ml_job`][sagemaker_create_auto_ml_job].
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_auto_ml_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_auto_ml_job/) for full documentation.
#'
#' @param AutoMLJobName &#91;required&#93; Requests information about an AutoML job using its unique name.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_auto_ml_job
sagemaker_describe_auto_ml_job <- function(AutoMLJobName) {
  op <- new_operation(
    name = "DescribeAutoMLJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_auto_ml_job_input(AutoMLJobName = AutoMLJobName)
  output <- .sagemaker$describe_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_auto_ml_job <- sagemaker_describe_auto_ml_job

#' Returns information about an AutoML job created by calling
#' CreateAutoMLJobV2 or CreateAutoMLJob
#'
#' @description
#' Returns information about an AutoML job created by calling [`create_auto_ml_job_v2`][sagemaker_create_auto_ml_job_v2] or [`create_auto_ml_job`][sagemaker_create_auto_ml_job].
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_auto_ml_job_v2/](https://www.paws-r-sdk.com/docs/sagemaker_describe_auto_ml_job_v2/) for full documentation.
#'
#' @param AutoMLJobName &#91;required&#93; Requests information about an AutoML job V2 using its unique name.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_auto_ml_job_v2
sagemaker_describe_auto_ml_job_v2 <- function(AutoMLJobName) {
  op <- new_operation(
    name = "DescribeAutoMLJobV2",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_auto_ml_job_v2_input(AutoMLJobName = AutoMLJobName)
  output <- .sagemaker$describe_auto_ml_job_v2_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_auto_ml_job_v2 <- sagemaker_describe_auto_ml_job_v2

#' Retrieves information of a SageMaker HyperPod cluster
#'
#' @description
#' Retrieves information of a SageMaker HyperPod cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_cluster/](https://www.paws-r-sdk.com/docs/sagemaker_describe_cluster/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The string name or the Amazon Resource Name (ARN) of the SageMaker
#' HyperPod cluster.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_cluster
sagemaker_describe_cluster <- function(ClusterName) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_cluster_input(ClusterName = ClusterName)
  output <- .sagemaker$describe_cluster_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_cluster <- sagemaker_describe_cluster

#' Retrieves information of a node (also called a instance interchangeably)
#' of a SageMaker HyperPod cluster
#'
#' @description
#' Retrieves information of a node (also called a *instance* interchangeably) of a SageMaker HyperPod cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_cluster_node/](https://www.paws-r-sdk.com/docs/sagemaker_describe_cluster_node/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The string name or the Amazon Resource Name (ARN) of the SageMaker
#' HyperPod cluster in which the node is.
#' @param NodeId &#91;required&#93; The ID of the SageMaker HyperPod cluster node.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_cluster_node
sagemaker_describe_cluster_node <- function(ClusterName, NodeId) {
  op <- new_operation(
    name = "DescribeClusterNode",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_cluster_node_input(ClusterName = ClusterName, NodeId = NodeId)
  output <- .sagemaker$describe_cluster_node_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_cluster_node <- sagemaker_describe_cluster_node

#' Description of the cluster policy
#'
#' @description
#' Description of the cluster policy. This policy is used for task prioritization and fair-share allocation. This helps prioritize critical workloads and distributes idle compute across entities.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_cluster_scheduler_config/](https://www.paws-r-sdk.com/docs/sagemaker_describe_cluster_scheduler_config/) for full documentation.
#'
#' @param ClusterSchedulerConfigId &#91;required&#93; ID of the cluster policy.
#' @param ClusterSchedulerConfigVersion Version of the cluster policy.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_cluster_scheduler_config
sagemaker_describe_cluster_scheduler_config <- function(ClusterSchedulerConfigId, ClusterSchedulerConfigVersion = NULL) {
  op <- new_operation(
    name = "DescribeClusterSchedulerConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_cluster_scheduler_config_input(ClusterSchedulerConfigId = ClusterSchedulerConfigId, ClusterSchedulerConfigVersion = ClusterSchedulerConfigVersion)
  output <- .sagemaker$describe_cluster_scheduler_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_cluster_scheduler_config <- sagemaker_describe_cluster_scheduler_config

#' Gets details about the specified Git repository
#'
#' @description
#' Gets details about the specified Git repository.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_code_repository/](https://www.paws-r-sdk.com/docs/sagemaker_describe_code_repository/) for full documentation.
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_code_repository
sagemaker_describe_code_repository <- function(CodeRepositoryName) {
  op <- new_operation(
    name = "DescribeCodeRepository",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_code_repository_input(CodeRepositoryName = CodeRepositoryName)
  output <- .sagemaker$describe_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_code_repository <- sagemaker_describe_code_repository

#' Returns information about a model compilation job
#'
#' @description
#' Returns information about a model compilation job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_compilation_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_compilation_job/) for full documentation.
#'
#' @param CompilationJobName &#91;required&#93; The name of the model compilation job that you want information about.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_compilation_job
sagemaker_describe_compilation_job <- function(CompilationJobName) {
  op <- new_operation(
    name = "DescribeCompilationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_compilation_job_input(CompilationJobName = CompilationJobName)
  output <- .sagemaker$describe_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_compilation_job <- sagemaker_describe_compilation_job

#' Description of the compute allocation definition
#'
#' @description
#' Description of the compute allocation definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_compute_quota/](https://www.paws-r-sdk.com/docs/sagemaker_describe_compute_quota/) for full documentation.
#'
#' @param ComputeQuotaId &#91;required&#93; ID of the compute allocation definition.
#' @param ComputeQuotaVersion Version of the compute allocation definition.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_compute_quota
sagemaker_describe_compute_quota <- function(ComputeQuotaId, ComputeQuotaVersion = NULL) {
  op <- new_operation(
    name = "DescribeComputeQuota",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_compute_quota_input(ComputeQuotaId = ComputeQuotaId, ComputeQuotaVersion = ComputeQuotaVersion)
  output <- .sagemaker$describe_compute_quota_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_compute_quota <- sagemaker_describe_compute_quota

#' Describes a context
#'
#' @description
#' Describes a context.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_context/](https://www.paws-r-sdk.com/docs/sagemaker_describe_context/) for full documentation.
#'
#' @param ContextName &#91;required&#93; The name of the context to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_context
sagemaker_describe_context <- function(ContextName) {
  op <- new_operation(
    name = "DescribeContext",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_context_input(ContextName = ContextName)
  output <- .sagemaker$describe_context_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_context <- sagemaker_describe_context

#' Gets the details of a data quality monitoring job definition
#'
#' @description
#' Gets the details of a data quality monitoring job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_data_quality_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_describe_data_quality_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the data quality monitoring job definition to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_data_quality_job_definition
sagemaker_describe_data_quality_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DescribeDataQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_data_quality_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$describe_data_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_data_quality_job_definition <- sagemaker_describe_data_quality_job_definition

#' Describes the device
#'
#' @description
#' Describes the device.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_device/](https://www.paws-r-sdk.com/docs/sagemaker_describe_device/) for full documentation.
#'
#' @param NextToken Next token of device description.
#' @param DeviceName &#91;required&#93; The unique ID of the device.
#' @param DeviceFleetName &#91;required&#93; The name of the fleet the devices belong to.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_device
sagemaker_describe_device <- function(NextToken = NULL, DeviceName, DeviceFleetName) {
  op <- new_operation(
    name = "DescribeDevice",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_device_input(NextToken = NextToken, DeviceName = DeviceName, DeviceFleetName = DeviceFleetName)
  output <- .sagemaker$describe_device_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_device <- sagemaker_describe_device

#' A description of the fleet the device belongs to
#'
#' @description
#' A description of the fleet the device belongs to.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_device_fleet/](https://www.paws-r-sdk.com/docs/sagemaker_describe_device_fleet/) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_device_fleet
sagemaker_describe_device_fleet <- function(DeviceFleetName) {
  op <- new_operation(
    name = "DescribeDeviceFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_device_fleet_input(DeviceFleetName = DeviceFleetName)
  output <- .sagemaker$describe_device_fleet_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_device_fleet <- sagemaker_describe_device_fleet

#' The description of the domain
#'
#' @description
#' The description of the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_domain/](https://www.paws-r-sdk.com/docs/sagemaker_describe_domain/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_domain
sagemaker_describe_domain <- function(DomainId) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_domain_input(DomainId = DomainId)
  output <- .sagemaker$describe_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_domain <- sagemaker_describe_domain

#' Describes an edge deployment plan with deployment status per stage
#'
#' @description
#' Describes an edge deployment plan with deployment status per stage.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_edge_deployment_plan/](https://www.paws-r-sdk.com/docs/sagemaker_describe_edge_deployment_plan/) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the deployment plan to describe.
#' @param NextToken If the edge deployment plan has enough stages to require tokening, then
#' this is the response from the last list of stages returned.
#' @param MaxResults The maximum number of results to select (50 by default).
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_edge_deployment_plan
sagemaker_describe_edge_deployment_plan <- function(EdgeDeploymentPlanName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeEdgeDeploymentPlan",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_edge_deployment_plan_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$describe_edge_deployment_plan_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_edge_deployment_plan <- sagemaker_describe_edge_deployment_plan

#' A description of edge packaging jobs
#'
#' @description
#' A description of edge packaging jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_edge_packaging_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_edge_packaging_job/) for full documentation.
#'
#' @param EdgePackagingJobName &#91;required&#93; The name of the edge packaging job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_edge_packaging_job
sagemaker_describe_edge_packaging_job <- function(EdgePackagingJobName) {
  op <- new_operation(
    name = "DescribeEdgePackagingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_edge_packaging_job_input(EdgePackagingJobName = EdgePackagingJobName)
  output <- .sagemaker$describe_edge_packaging_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_edge_packaging_job <- sagemaker_describe_edge_packaging_job

#' Returns the description of an endpoint
#'
#' @description
#' Returns the description of an endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_endpoint/](https://www.paws-r-sdk.com/docs/sagemaker_describe_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_endpoint
sagemaker_describe_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DescribeEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_endpoint_input(EndpointName = EndpointName)
  output <- .sagemaker$describe_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_endpoint <- sagemaker_describe_endpoint

#' Returns the description of an endpoint configuration created using the
#' CreateEndpointConfig API
#'
#' @description
#' Returns the description of an endpoint configuration created using the [`create_endpoint_config`][sagemaker_create_endpoint_config] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_endpoint_config/](https://www.paws-r-sdk.com/docs/sagemaker_describe_endpoint_config/) for full documentation.
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_endpoint_config
sagemaker_describe_endpoint_config <- function(EndpointConfigName) {
  op <- new_operation(
    name = "DescribeEndpointConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_endpoint_config_input(EndpointConfigName = EndpointConfigName)
  output <- .sagemaker$describe_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_endpoint_config <- sagemaker_describe_endpoint_config

#' Provides a list of an experiment's properties
#'
#' @description
#' Provides a list of an experiment's properties.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_experiment/](https://www.paws-r-sdk.com/docs/sagemaker_describe_experiment/) for full documentation.
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_experiment
sagemaker_describe_experiment <- function(ExperimentName) {
  op <- new_operation(
    name = "DescribeExperiment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_experiment_input(ExperimentName = ExperimentName)
  output <- .sagemaker$describe_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_experiment <- sagemaker_describe_experiment

#' Use this operation to describe a FeatureGroup
#'
#' @description
#' Use this operation to describe a `FeatureGroup`. The response includes information on the creation time, `FeatureGroup` name, the unique identifier for each `FeatureGroup`, and more.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_feature_group/](https://www.paws-r-sdk.com/docs/sagemaker_describe_feature_group/) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name or Amazon Resource Name (ARN) of the `FeatureGroup` you want
#' described.
#' @param NextToken A token to resume pagination of the list of `Features`
#' (`FeatureDefinitions`). 2,500 `Features` are returned by default.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_feature_group
sagemaker_describe_feature_group <- function(FeatureGroupName, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeFeatureGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_feature_group_input(FeatureGroupName = FeatureGroupName, NextToken = NextToken)
  output <- .sagemaker$describe_feature_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_feature_group <- sagemaker_describe_feature_group

#' Shows the metadata for a feature within a feature group
#'
#' @description
#' Shows the metadata for a feature within a feature group.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_feature_metadata/](https://www.paws-r-sdk.com/docs/sagemaker_describe_feature_metadata/) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name or Amazon Resource Name (ARN) of the feature group containing
#' the feature.
#' @param FeatureName &#91;required&#93; The name of the feature.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_feature_metadata
sagemaker_describe_feature_metadata <- function(FeatureGroupName, FeatureName) {
  op <- new_operation(
    name = "DescribeFeatureMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_feature_metadata_input(FeatureGroupName = FeatureGroupName, FeatureName = FeatureName)
  output <- .sagemaker$describe_feature_metadata_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_feature_metadata <- sagemaker_describe_feature_metadata

#' Returns information about the specified flow definition
#'
#' @description
#' Returns information about the specified flow definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_flow_definition/](https://www.paws-r-sdk.com/docs/sagemaker_describe_flow_definition/) for full documentation.
#'
#' @param FlowDefinitionName &#91;required&#93; The name of the flow definition.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_flow_definition
sagemaker_describe_flow_definition <- function(FlowDefinitionName) {
  op <- new_operation(
    name = "DescribeFlowDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_flow_definition_input(FlowDefinitionName = FlowDefinitionName)
  output <- .sagemaker$describe_flow_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_flow_definition <- sagemaker_describe_flow_definition

#' Describes a hub
#'
#' @description
#' Describes a hub.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_hub/](https://www.paws-r-sdk.com/docs/sagemaker_describe_hub/) for full documentation.
#'
#' @param HubName &#91;required&#93; The name of the hub to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_hub
sagemaker_describe_hub <- function(HubName) {
  op <- new_operation(
    name = "DescribeHub",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_hub_input(HubName = HubName)
  output <- .sagemaker$describe_hub_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_hub <- sagemaker_describe_hub

#' Describe the content of a hub
#'
#' @description
#' Describe the content of a hub.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_hub_content/](https://www.paws-r-sdk.com/docs/sagemaker_describe_hub_content/) for full documentation.
#'
#' @param HubName &#91;required&#93; The name of the hub that contains the content to describe.
#' @param HubContentType &#91;required&#93; The type of content in the hub.
#' @param HubContentName &#91;required&#93; The name of the content to describe.
#' @param HubContentVersion The version of the content to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_hub_content
sagemaker_describe_hub_content <- function(HubName, HubContentType, HubContentName, HubContentVersion = NULL) {
  op <- new_operation(
    name = "DescribeHubContent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_hub_content_input(HubName = HubName, HubContentType = HubContentType, HubContentName = HubContentName, HubContentVersion = HubContentVersion)
  output <- .sagemaker$describe_hub_content_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_hub_content <- sagemaker_describe_hub_content

#' Returns information about the requested human task user interface
#' (worker task template)
#'
#' @description
#' Returns information about the requested human task user interface (worker task template).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_human_task_ui/](https://www.paws-r-sdk.com/docs/sagemaker_describe_human_task_ui/) for full documentation.
#'
#' @param HumanTaskUiName &#91;required&#93; The name of the human task user interface (worker task template) you
#' want information about.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_human_task_ui
sagemaker_describe_human_task_ui <- function(HumanTaskUiName) {
  op <- new_operation(
    name = "DescribeHumanTaskUi",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_human_task_ui_input(HumanTaskUiName = HumanTaskUiName)
  output <- .sagemaker$describe_human_task_ui_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_human_task_ui <- sagemaker_describe_human_task_ui

#' Returns a description of a hyperparameter tuning job, depending on the
#' fields selected
#'
#' @description
#' Returns a description of a hyperparameter tuning job, depending on the fields selected. These fields can include the name, Amazon Resource Name (ARN), job status of your tuning job and more.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_hyper_parameter_tuning_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_hyper_parameter_tuning_job/) for full documentation.
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_hyper_parameter_tuning_job
sagemaker_describe_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName) {
  op <- new_operation(
    name = "DescribeHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName)
  output <- .sagemaker$describe_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_hyper_parameter_tuning_job <- sagemaker_describe_hyper_parameter_tuning_job

#' Describes a SageMaker AI image
#'
#' @description
#' Describes a SageMaker AI image.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_image/](https://www.paws-r-sdk.com/docs/sagemaker_describe_image/) for full documentation.
#'
#' @param ImageName &#91;required&#93; The name of the image to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_image
sagemaker_describe_image <- function(ImageName) {
  op <- new_operation(
    name = "DescribeImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_image_input(ImageName = ImageName)
  output <- .sagemaker$describe_image_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_image <- sagemaker_describe_image

#' Describes a version of a SageMaker AI image
#'
#' @description
#' Describes a version of a SageMaker AI image.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_image_version/](https://www.paws-r-sdk.com/docs/sagemaker_describe_image_version/) for full documentation.
#'
#' @param ImageName &#91;required&#93; The name of the image.
#' @param Version The version of the image. If not specified, the latest version is
#' described.
#' @param Alias The alias of the image version.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_image_version
sagemaker_describe_image_version <- function(ImageName, Version = NULL, Alias = NULL) {
  op <- new_operation(
    name = "DescribeImageVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_image_version_input(ImageName = ImageName, Version = Version, Alias = Alias)
  output <- .sagemaker$describe_image_version_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_image_version <- sagemaker_describe_image_version

#' Returns information about an inference component
#'
#' @description
#' Returns information about an inference component.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_inference_component/](https://www.paws-r-sdk.com/docs/sagemaker_describe_inference_component/) for full documentation.
#'
#' @param InferenceComponentName &#91;required&#93; The name of the inference component.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_inference_component
sagemaker_describe_inference_component <- function(InferenceComponentName) {
  op <- new_operation(
    name = "DescribeInferenceComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_inference_component_input(InferenceComponentName = InferenceComponentName)
  output <- .sagemaker$describe_inference_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_inference_component <- sagemaker_describe_inference_component

#' Returns details about an inference experiment
#'
#' @description
#' Returns details about an inference experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_inference_experiment/](https://www.paws-r-sdk.com/docs/sagemaker_describe_inference_experiment/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the inference experiment to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_inference_experiment
sagemaker_describe_inference_experiment <- function(Name) {
  op <- new_operation(
    name = "DescribeInferenceExperiment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_inference_experiment_input(Name = Name)
  output <- .sagemaker$describe_inference_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_inference_experiment <- sagemaker_describe_inference_experiment

#' Provides the results of the Inference Recommender job
#'
#' @description
#' Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_inference_recommendations_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_inference_recommendations_job/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job. The name must be unique within an Amazon Web
#' Services Region in the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_inference_recommendations_job
sagemaker_describe_inference_recommendations_job <- function(JobName) {
  op <- new_operation(
    name = "DescribeInferenceRecommendationsJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_inference_recommendations_job_input(JobName = JobName)
  output <- .sagemaker$describe_inference_recommendations_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_inference_recommendations_job <- sagemaker_describe_inference_recommendations_job

#' Gets information about a labeling job
#'
#' @description
#' Gets information about a labeling job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_labeling_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_labeling_job/) for full documentation.
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job to return information for.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_labeling_job
sagemaker_describe_labeling_job <- function(LabelingJobName) {
  op <- new_operation(
    name = "DescribeLabelingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_labeling_job_input(LabelingJobName = LabelingJobName)
  output <- .sagemaker$describe_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_labeling_job <- sagemaker_describe_labeling_job

#' Provides a list of properties for the requested lineage group
#'
#' @description
#' Provides a list of properties for the requested lineage group. For more information, see [Cross-Account Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html) in the *Amazon SageMaker Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_lineage_group/](https://www.paws-r-sdk.com/docs/sagemaker_describe_lineage_group/) for full documentation.
#'
#' @param LineageGroupName &#91;required&#93; The name of the lineage group.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_lineage_group
sagemaker_describe_lineage_group <- function(LineageGroupName) {
  op <- new_operation(
    name = "DescribeLineageGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_lineage_group_input(LineageGroupName = LineageGroupName)
  output <- .sagemaker$describe_lineage_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_lineage_group <- sagemaker_describe_lineage_group

#' Returns information about an MLflow Tracking Server
#'
#' @description
#' Returns information about an MLflow Tracking Server.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_mlflow_tracking_server/](https://www.paws-r-sdk.com/docs/sagemaker_describe_mlflow_tracking_server/) for full documentation.
#'
#' @param TrackingServerName &#91;required&#93; The name of the MLflow Tracking Server to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_mlflow_tracking_server
sagemaker_describe_mlflow_tracking_server <- function(TrackingServerName) {
  op <- new_operation(
    name = "DescribeMlflowTrackingServer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_mlflow_tracking_server_input(TrackingServerName = TrackingServerName)
  output <- .sagemaker$describe_mlflow_tracking_server_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_mlflow_tracking_server <- sagemaker_describe_mlflow_tracking_server

#' Describes a model that you created using the CreateModel API
#'
#' @description
#' Describes a model that you created using the [`create_model`][sagemaker_create_model] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_model/](https://www.paws-r-sdk.com/docs/sagemaker_describe_model/) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the model.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model
sagemaker_describe_model <- function(ModelName) {
  op <- new_operation(
    name = "DescribeModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_model_input(ModelName = ModelName)
  output <- .sagemaker$describe_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model <- sagemaker_describe_model

#' Returns a description of a model bias job definition
#'
#' @description
#' Returns a description of a model bias job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_model_bias_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_describe_model_bias_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model bias job definition. The name must be unique
#' within an Amazon Web Services Region in the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_bias_job_definition
sagemaker_describe_model_bias_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DescribeModelBiasJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_model_bias_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$describe_model_bias_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_bias_job_definition <- sagemaker_describe_model_bias_job_definition

#' Describes the content, creation time, and security configuration of an
#' Amazon SageMaker Model Card
#'
#' @description
#' Describes the content, creation time, and security configuration of an Amazon SageMaker Model Card.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_model_card/](https://www.paws-r-sdk.com/docs/sagemaker_describe_model_card/) for full documentation.
#'
#' @param ModelCardName &#91;required&#93; The name or Amazon Resource Name (ARN) of the model card to describe.
#' @param ModelCardVersion The version of the model card to describe. If a version is not provided,
#' then the latest version of the model card is described.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_card
sagemaker_describe_model_card <- function(ModelCardName, ModelCardVersion = NULL) {
  op <- new_operation(
    name = "DescribeModelCard",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_model_card_input(ModelCardName = ModelCardName, ModelCardVersion = ModelCardVersion)
  output <- .sagemaker$describe_model_card_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_card <- sagemaker_describe_model_card

#' Describes an Amazon SageMaker Model Card export job
#'
#' @description
#' Describes an Amazon SageMaker Model Card export job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_model_card_export_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_model_card_export_job/) for full documentation.
#'
#' @param ModelCardExportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the model card export job to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_card_export_job
sagemaker_describe_model_card_export_job <- function(ModelCardExportJobArn) {
  op <- new_operation(
    name = "DescribeModelCardExportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_model_card_export_job_input(ModelCardExportJobArn = ModelCardExportJobArn)
  output <- .sagemaker$describe_model_card_export_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_card_export_job <- sagemaker_describe_model_card_export_job

#' Returns a description of a model explainability job definition
#'
#' @description
#' Returns a description of a model explainability job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_model_explainability_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_describe_model_explainability_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model explainability job definition. The name must be
#' unique within an Amazon Web Services Region in the Amazon Web Services
#' account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_explainability_job_definition
sagemaker_describe_model_explainability_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DescribeModelExplainabilityJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_model_explainability_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$describe_model_explainability_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_explainability_job_definition <- sagemaker_describe_model_explainability_job_definition

#' Returns a description of the specified model package, which is used to
#' create SageMaker models or list them on Amazon Web Services Marketplace
#'
#' @description
#' Returns a description of the specified model package, which is used to create SageMaker models or list them on Amazon Web Services Marketplace.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_model_package/](https://www.paws-r-sdk.com/docs/sagemaker_describe_model_package/) for full documentation.
#'
#' @param ModelPackageName &#91;required&#93; The name or Amazon Resource Name (ARN) of the model package to describe.
#' 
#' When you specify a name, the name must have 1 to 63 characters. Valid
#' characters are a-z, A-Z, 0-9, and - (hyphen).
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_package
sagemaker_describe_model_package <- function(ModelPackageName) {
  op <- new_operation(
    name = "DescribeModelPackage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_model_package_input(ModelPackageName = ModelPackageName)
  output <- .sagemaker$describe_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_package <- sagemaker_describe_model_package

#' Gets a description for the specified model group
#'
#' @description
#' Gets a description for the specified model group.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_model_package_group/](https://www.paws-r-sdk.com/docs/sagemaker_describe_model_package_group/) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_package_group
sagemaker_describe_model_package_group <- function(ModelPackageGroupName) {
  op <- new_operation(
    name = "DescribeModelPackageGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_model_package_group_input(ModelPackageGroupName = ModelPackageGroupName)
  output <- .sagemaker$describe_model_package_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_package_group <- sagemaker_describe_model_package_group

#' Returns a description of a model quality job definition
#'
#' @description
#' Returns a description of a model quality job definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_model_quality_job_definition/](https://www.paws-r-sdk.com/docs/sagemaker_describe_model_quality_job_definition/) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model quality job. The name must be unique within an
#' Amazon Web Services Region in the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_quality_job_definition
sagemaker_describe_model_quality_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DescribeModelQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_model_quality_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$describe_model_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_quality_job_definition <- sagemaker_describe_model_quality_job_definition

#' Describes the schedule for a monitoring job
#'
#' @description
#' Describes the schedule for a monitoring job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_monitoring_schedule/](https://www.paws-r-sdk.com/docs/sagemaker_describe_monitoring_schedule/) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; Name of a previously created monitoring schedule.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_monitoring_schedule
sagemaker_describe_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "DescribeMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$describe_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_monitoring_schedule <- sagemaker_describe_monitoring_schedule

#' Returns information about a notebook instance
#'
#' @description
#' Returns information about a notebook instance.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_notebook_instance/](https://www.paws-r-sdk.com/docs/sagemaker_describe_notebook_instance/) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance that you want information about.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_notebook_instance
sagemaker_describe_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "DescribeNotebookInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$describe_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_notebook_instance <- sagemaker_describe_notebook_instance

#' Returns a description of a notebook instance lifecycle configuration
#'
#' @description
#' Returns a description of a notebook instance lifecycle configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_notebook_instance_lifecycle_config/](https://www.paws-r-sdk.com/docs/sagemaker_describe_notebook_instance_lifecycle_config/) for full documentation.
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_notebook_instance_lifecycle_config
sagemaker_describe_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName) {
  op <- new_operation(
    name = "DescribeNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName)
  output <- .sagemaker$describe_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_notebook_instance_lifecycle_config <- sagemaker_describe_notebook_instance_lifecycle_config

#' Provides the properties of the specified optimization job
#'
#' @description
#' Provides the properties of the specified optimization job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_optimization_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_optimization_job/) for full documentation.
#'
#' @param OptimizationJobName &#91;required&#93; The name that you assigned to the optimization job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_optimization_job
sagemaker_describe_optimization_job <- function(OptimizationJobName) {
  op <- new_operation(
    name = "DescribeOptimizationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_optimization_job_input(OptimizationJobName = OptimizationJobName)
  output <- .sagemaker$describe_optimization_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_optimization_job <- sagemaker_describe_optimization_job

#' Gets information about a SageMaker Partner AI App
#'
#' @description
#' Gets information about a SageMaker Partner AI App.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_partner_app/](https://www.paws-r-sdk.com/docs/sagemaker_describe_partner_app/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the SageMaker Partner AI App to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_partner_app
sagemaker_describe_partner_app <- function(Arn) {
  op <- new_operation(
    name = "DescribePartnerApp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_partner_app_input(Arn = Arn)
  output <- .sagemaker$describe_partner_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_partner_app <- sagemaker_describe_partner_app

#' Describes the details of a pipeline
#'
#' @description
#' Describes the details of a pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_pipeline/](https://www.paws-r-sdk.com/docs/sagemaker_describe_pipeline/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name or Amazon Resource Name (ARN) of the pipeline to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_pipeline
sagemaker_describe_pipeline <- function(PipelineName) {
  op <- new_operation(
    name = "DescribePipeline",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_pipeline_input(PipelineName = PipelineName)
  output <- .sagemaker$describe_pipeline_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_pipeline <- sagemaker_describe_pipeline

#' Describes the details of an execution's pipeline definition
#'
#' @description
#' Describes the details of an execution's pipeline definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_pipeline_definition_for_execution/](https://www.paws-r-sdk.com/docs/sagemaker_describe_pipeline_definition_for_execution/) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_pipeline_definition_for_execution
sagemaker_describe_pipeline_definition_for_execution <- function(PipelineExecutionArn) {
  op <- new_operation(
    name = "DescribePipelineDefinitionForExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_pipeline_definition_for_execution_input(PipelineExecutionArn = PipelineExecutionArn)
  output <- .sagemaker$describe_pipeline_definition_for_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_pipeline_definition_for_execution <- sagemaker_describe_pipeline_definition_for_execution

#' Describes the details of a pipeline execution
#'
#' @description
#' Describes the details of a pipeline execution.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_pipeline_execution/](https://www.paws-r-sdk.com/docs/sagemaker_describe_pipeline_execution/) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_pipeline_execution
sagemaker_describe_pipeline_execution <- function(PipelineExecutionArn) {
  op <- new_operation(
    name = "DescribePipelineExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_pipeline_execution_input(PipelineExecutionArn = PipelineExecutionArn)
  output <- .sagemaker$describe_pipeline_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_pipeline_execution <- sagemaker_describe_pipeline_execution

#' Returns a description of a processing job
#'
#' @description
#' Returns a description of a processing job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_processing_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_processing_job/) for full documentation.
#'
#' @param ProcessingJobName &#91;required&#93; The name of the processing job. The name must be unique within an Amazon
#' Web Services Region in the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_processing_job
sagemaker_describe_processing_job <- function(ProcessingJobName) {
  op <- new_operation(
    name = "DescribeProcessingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_processing_job_input(ProcessingJobName = ProcessingJobName)
  output <- .sagemaker$describe_processing_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_processing_job <- sagemaker_describe_processing_job

#' Describes the details of a project
#'
#' @description
#' Describes the details of a project.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_project/](https://www.paws-r-sdk.com/docs/sagemaker_describe_project/) for full documentation.
#'
#' @param ProjectName &#91;required&#93; The name of the project to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_project
sagemaker_describe_project <- function(ProjectName) {
  op <- new_operation(
    name = "DescribeProject",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_project_input(ProjectName = ProjectName)
  output <- .sagemaker$describe_project_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_project <- sagemaker_describe_project

#' Describes the space
#'
#' @description
#' Describes the space.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_space/](https://www.paws-r-sdk.com/docs/sagemaker_describe_space/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The ID of the associated domain.
#' @param SpaceName &#91;required&#93; The name of the space.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_space
sagemaker_describe_space <- function(DomainId, SpaceName) {
  op <- new_operation(
    name = "DescribeSpace",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_space_input(DomainId = DomainId, SpaceName = SpaceName)
  output <- .sagemaker$describe_space_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_space <- sagemaker_describe_space

#' Describes the Amazon SageMaker AI Studio Lifecycle Configuration
#'
#' @description
#' Describes the Amazon SageMaker AI Studio Lifecycle Configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_studio_lifecycle_config/](https://www.paws-r-sdk.com/docs/sagemaker_describe_studio_lifecycle_config/) for full documentation.
#'
#' @param StudioLifecycleConfigName &#91;required&#93; The name of the Amazon SageMaker AI Studio Lifecycle Configuration to
#' describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_studio_lifecycle_config
sagemaker_describe_studio_lifecycle_config <- function(StudioLifecycleConfigName) {
  op <- new_operation(
    name = "DescribeStudioLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_studio_lifecycle_config_input(StudioLifecycleConfigName = StudioLifecycleConfigName)
  output <- .sagemaker$describe_studio_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_studio_lifecycle_config <- sagemaker_describe_studio_lifecycle_config

#' Gets information about a work team provided by a vendor
#'
#' @description
#' Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor in the Amazon Web Services Marketplace.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_subscribed_workteam/](https://www.paws-r-sdk.com/docs/sagemaker_describe_subscribed_workteam/) for full documentation.
#'
#' @param WorkteamArn &#91;required&#93; The Amazon Resource Name (ARN) of the subscribed work team to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_subscribed_workteam
sagemaker_describe_subscribed_workteam <- function(WorkteamArn) {
  op <- new_operation(
    name = "DescribeSubscribedWorkteam",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_subscribed_workteam_input(WorkteamArn = WorkteamArn)
  output <- .sagemaker$describe_subscribed_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_subscribed_workteam <- sagemaker_describe_subscribed_workteam

#' Returns information about a training job
#'
#' @description
#' Returns information about a training job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_training_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_training_job/) for full documentation.
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_training_job
sagemaker_describe_training_job <- function(TrainingJobName) {
  op <- new_operation(
    name = "DescribeTrainingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_training_job_input(TrainingJobName = TrainingJobName)
  output <- .sagemaker$describe_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_training_job <- sagemaker_describe_training_job

#' Retrieves detailed information about a specific training plan
#'
#' @description
#' Retrieves detailed information about a specific training plan.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_training_plan/](https://www.paws-r-sdk.com/docs/sagemaker_describe_training_plan/) for full documentation.
#'
#' @param TrainingPlanName &#91;required&#93; The name of the training plan to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_training_plan
sagemaker_describe_training_plan <- function(TrainingPlanName) {
  op <- new_operation(
    name = "DescribeTrainingPlan",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_training_plan_input(TrainingPlanName = TrainingPlanName)
  output <- .sagemaker$describe_training_plan_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_training_plan <- sagemaker_describe_training_plan

#' Returns information about a transform job
#'
#' @description
#' Returns information about a transform job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_transform_job/](https://www.paws-r-sdk.com/docs/sagemaker_describe_transform_job/) for full documentation.
#'
#' @param TransformJobName &#91;required&#93; The name of the transform job that you want to view details of.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_transform_job
sagemaker_describe_transform_job <- function(TransformJobName) {
  op <- new_operation(
    name = "DescribeTransformJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_transform_job_input(TransformJobName = TransformJobName)
  output <- .sagemaker$describe_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_transform_job <- sagemaker_describe_transform_job

#' Provides a list of a trial's properties
#'
#' @description
#' Provides a list of a trial's properties.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_trial/](https://www.paws-r-sdk.com/docs/sagemaker_describe_trial/) for full documentation.
#'
#' @param TrialName &#91;required&#93; The name of the trial to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_trial
sagemaker_describe_trial <- function(TrialName) {
  op <- new_operation(
    name = "DescribeTrial",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_trial_input(TrialName = TrialName)
  output <- .sagemaker$describe_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_trial <- sagemaker_describe_trial

#' Provides a list of a trials component's properties
#'
#' @description
#' Provides a list of a trials component's properties.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_trial_component/](https://www.paws-r-sdk.com/docs/sagemaker_describe_trial_component/) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the trial component to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_trial_component
sagemaker_describe_trial_component <- function(TrialComponentName) {
  op <- new_operation(
    name = "DescribeTrialComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_trial_component_input(TrialComponentName = TrialComponentName)
  output <- .sagemaker$describe_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_trial_component <- sagemaker_describe_trial_component

#' Describes a user profile
#'
#' @description
#' Describes a user profile. For more information, see [`create_user_profile`][sagemaker_create_user_profile].
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_user_profile/](https://www.paws-r-sdk.com/docs/sagemaker_describe_user_profile/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name. This value is not case sensitive.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_user_profile
sagemaker_describe_user_profile <- function(DomainId, UserProfileName) {
  op <- new_operation(
    name = "DescribeUserProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName)
  output <- .sagemaker$describe_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_user_profile <- sagemaker_describe_user_profile

#' Lists private workforce information, including workforce name, Amazon
#' Resource Name (ARN), and, if applicable, allowed IP address ranges
#' (CIDRs)
#'
#' @description
#' Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/how-it-works.html)). Allowable IP address ranges are the IP addresses that workers can use to access tasks.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_workforce/](https://www.paws-r-sdk.com/docs/sagemaker_describe_workforce/) for full documentation.
#'
#' @param WorkforceName &#91;required&#93; The name of the private workforce whose access you want to restrict.
#' `WorkforceName` is automatically set to `default` when a workforce is
#' created and cannot be modified.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_workforce
sagemaker_describe_workforce <- function(WorkforceName) {
  op <- new_operation(
    name = "DescribeWorkforce",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_workforce_input(WorkforceName = WorkforceName)
  output <- .sagemaker$describe_workforce_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_workforce <- sagemaker_describe_workforce

#' Gets information about a specific work team
#'
#' @description
#' Gets information about a specific work team. You can see information such as the creation date, the last updated date, membership information, and the work team's Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_describe_workteam/](https://www.paws-r-sdk.com/docs/sagemaker_describe_workteam/) for full documentation.
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to return a description of.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_workteam
sagemaker_describe_workteam <- function(WorkteamName) {
  op <- new_operation(
    name = "DescribeWorkteam",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$describe_workteam_input(WorkteamName = WorkteamName)
  output <- .sagemaker$describe_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_workteam <- sagemaker_describe_workteam

#' Disables using Service Catalog in SageMaker
#'
#' @description
#' Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_disable_sagemaker_servicecatalog_portfolio/](https://www.paws-r-sdk.com/docs/sagemaker_disable_sagemaker_servicecatalog_portfolio/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname sagemaker_disable_sagemaker_servicecatalog_portfolio
sagemaker_disable_sagemaker_servicecatalog_portfolio <- function() {
  op <- new_operation(
    name = "DisableSagemakerServicecatalogPortfolio",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$disable_sagemaker_servicecatalog_portfolio_input()
  output <- .sagemaker$disable_sagemaker_servicecatalog_portfolio_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$disable_sagemaker_servicecatalog_portfolio <- sagemaker_disable_sagemaker_servicecatalog_portfolio

#' Disassociates a trial component from a trial
#'
#' @description
#' Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with. Before you can delete a component, you must disassociate the component from all trials it is associated with. To associate a trial component with a trial, call the [`associate_trial_component`][sagemaker_associate_trial_component] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_disassociate_trial_component/](https://www.paws-r-sdk.com/docs/sagemaker_disassociate_trial_component/) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to disassociate from the trial.
#' @param TrialName &#91;required&#93; The name of the trial to disassociate from.
#'
#' @keywords internal
#'
#' @rdname sagemaker_disassociate_trial_component
sagemaker_disassociate_trial_component <- function(TrialComponentName, TrialName) {
  op <- new_operation(
    name = "DisassociateTrialComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$disassociate_trial_component_input(TrialComponentName = TrialComponentName, TrialName = TrialName)
  output <- .sagemaker$disassociate_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$disassociate_trial_component <- sagemaker_disassociate_trial_component

#' Enables using Service Catalog in SageMaker
#'
#' @description
#' Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_enable_sagemaker_servicecatalog_portfolio/](https://www.paws-r-sdk.com/docs/sagemaker_enable_sagemaker_servicecatalog_portfolio/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname sagemaker_enable_sagemaker_servicecatalog_portfolio
sagemaker_enable_sagemaker_servicecatalog_portfolio <- function() {
  op <- new_operation(
    name = "EnableSagemakerServicecatalogPortfolio",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$enable_sagemaker_servicecatalog_portfolio_input()
  output <- .sagemaker$enable_sagemaker_servicecatalog_portfolio_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$enable_sagemaker_servicecatalog_portfolio <- sagemaker_enable_sagemaker_servicecatalog_portfolio

#' Describes a fleet
#'
#' @description
#' Describes a fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_get_device_fleet_report/](https://www.paws-r-sdk.com/docs/sagemaker_get_device_fleet_report/) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet.
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_device_fleet_report
sagemaker_get_device_fleet_report <- function(DeviceFleetName) {
  op <- new_operation(
    name = "GetDeviceFleetReport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$get_device_fleet_report_input(DeviceFleetName = DeviceFleetName)
  output <- .sagemaker$get_device_fleet_report_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_device_fleet_report <- sagemaker_get_device_fleet_report

#' The resource policy for the lineage group
#'
#' @description
#' The resource policy for the lineage group.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_get_lineage_group_policy/](https://www.paws-r-sdk.com/docs/sagemaker_get_lineage_group_policy/) for full documentation.
#'
#' @param LineageGroupName &#91;required&#93; The name or Amazon Resource Name (ARN) of the lineage group.
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_lineage_group_policy
sagemaker_get_lineage_group_policy <- function(LineageGroupName) {
  op <- new_operation(
    name = "GetLineageGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$get_lineage_group_policy_input(LineageGroupName = LineageGroupName)
  output <- .sagemaker$get_lineage_group_policy_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_lineage_group_policy <- sagemaker_get_lineage_group_policy

#' Gets a resource policy that manages access for a model group
#'
#' @description
#' Gets a resource policy that manages access for a model group. For information about resource policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *Amazon Web Services Identity and Access Management User Guide.*.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_get_model_package_group_policy/](https://www.paws-r-sdk.com/docs/sagemaker_get_model_package_group_policy/) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group for which to get the resource policy.
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_model_package_group_policy
sagemaker_get_model_package_group_policy <- function(ModelPackageGroupName) {
  op <- new_operation(
    name = "GetModelPackageGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$get_model_package_group_policy_input(ModelPackageGroupName = ModelPackageGroupName)
  output <- .sagemaker$get_model_package_group_policy_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_model_package_group_policy <- sagemaker_get_model_package_group_policy

#' Gets the status of Service Catalog in SageMaker
#'
#' @description
#' Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_get_sagemaker_servicecatalog_portfolio_status/](https://www.paws-r-sdk.com/docs/sagemaker_get_sagemaker_servicecatalog_portfolio_status/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname sagemaker_get_sagemaker_servicecatalog_portfolio_status
sagemaker_get_sagemaker_servicecatalog_portfolio_status <- function() {
  op <- new_operation(
    name = "GetSagemakerServicecatalogPortfolioStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$get_sagemaker_servicecatalog_portfolio_status_input()
  output <- .sagemaker$get_sagemaker_servicecatalog_portfolio_status_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_sagemaker_servicecatalog_portfolio_status <- sagemaker_get_sagemaker_servicecatalog_portfolio_status

#' Starts an Amazon SageMaker Inference Recommender autoscaling
#' recommendation job
#'
#' @description
#' Starts an Amazon SageMaker Inference Recommender autoscaling recommendation job. Returns recommendations for autoscaling policies that you can apply to your SageMaker endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_get_scaling_configuration_recommendation/](https://www.paws-r-sdk.com/docs/sagemaker_get_scaling_configuration_recommendation/) for full documentation.
#'
#' @param InferenceRecommendationsJobName &#91;required&#93; The name of a previously completed Inference Recommender job.
#' @param RecommendationId The recommendation ID of a previously completed inference
#' recommendation. This ID should come from one of the recommendations
#' returned by the job specified in the `InferenceRecommendationsJobName`
#' field.
#' 
#' Specify either this field or the `EndpointName` field.
#' @param EndpointName The name of an endpoint benchmarked during a previously completed
#' inference recommendation job. This name should come from one of the
#' recommendations returned by the job specified in the
#' `InferenceRecommendationsJobName` field.
#' 
#' Specify either this field or the `RecommendationId` field.
#' @param TargetCpuUtilizationPerCore The percentage of how much utilization you want an instance to use
#' before autoscaling. The default value is 50%.
#' @param ScalingPolicyObjective An object where you specify the anticipated traffic pattern for an
#' endpoint.
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_scaling_configuration_recommendation
sagemaker_get_scaling_configuration_recommendation <- function(InferenceRecommendationsJobName, RecommendationId = NULL, EndpointName = NULL, TargetCpuUtilizationPerCore = NULL, ScalingPolicyObjective = NULL) {
  op <- new_operation(
    name = "GetScalingConfigurationRecommendation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$get_scaling_configuration_recommendation_input(InferenceRecommendationsJobName = InferenceRecommendationsJobName, RecommendationId = RecommendationId, EndpointName = EndpointName, TargetCpuUtilizationPerCore = TargetCpuUtilizationPerCore, ScalingPolicyObjective = ScalingPolicyObjective)
  output <- .sagemaker$get_scaling_configuration_recommendation_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_scaling_configuration_recommendation <- sagemaker_get_scaling_configuration_recommendation

#' An auto-complete API for the search functionality in the SageMaker
#' console
#'
#' @description
#' An auto-complete API for the search functionality in the SageMaker console. It returns suggestions of possible matches for the property name to use in [`search`][sagemaker_search] queries. Provides suggestions for `HyperParameters`, `Tags`, and `Metrics`.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_get_search_suggestions/](https://www.paws-r-sdk.com/docs/sagemaker_get_search_suggestions/) for full documentation.
#'
#' @param Resource &#91;required&#93; The name of the SageMaker resource to search for.
#' @param SuggestionQuery Limits the property names that are included in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_search_suggestions
sagemaker_get_search_suggestions <- function(Resource, SuggestionQuery = NULL) {
  op <- new_operation(
    name = "GetSearchSuggestions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$get_search_suggestions_input(Resource = Resource, SuggestionQuery = SuggestionQuery)
  output <- .sagemaker$get_search_suggestions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_search_suggestions <- sagemaker_get_search_suggestions

#' Import hub content
#'
#' @description
#' Import hub content.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_import_hub_content/](https://www.paws-r-sdk.com/docs/sagemaker_import_hub_content/) for full documentation.
#'
#' @param HubContentName &#91;required&#93; The name of the hub content to import.
#' @param HubContentVersion The version of the hub content to import.
#' @param HubContentType &#91;required&#93; The type of hub content to import.
#' @param DocumentSchemaVersion &#91;required&#93; The version of the hub content schema to import.
#' @param HubName &#91;required&#93; The name of the hub to import content into.
#' @param HubContentDisplayName The display name of the hub content to import.
#' @param HubContentDescription A description of the hub content to import.
#' @param HubContentMarkdown A string that provides a description of the hub content. This string can
#' include links, tables, and standard markdown formating.
#' @param HubContentDocument &#91;required&#93; The hub content document that describes information about the hub
#' content such as type, associated containers, scripts, and more.
#' @param HubContentSearchKeywords The searchable keywords of the hub content.
#' @param Tags Any tags associated with the hub content.
#'
#' @keywords internal
#'
#' @rdname sagemaker_import_hub_content
sagemaker_import_hub_content <- function(HubContentName, HubContentVersion = NULL, HubContentType, DocumentSchemaVersion, HubName, HubContentDisplayName = NULL, HubContentDescription = NULL, HubContentMarkdown = NULL, HubContentDocument, HubContentSearchKeywords = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ImportHubContent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$import_hub_content_input(HubContentName = HubContentName, HubContentVersion = HubContentVersion, HubContentType = HubContentType, DocumentSchemaVersion = DocumentSchemaVersion, HubName = HubName, HubContentDisplayName = HubContentDisplayName, HubContentDescription = HubContentDescription, HubContentMarkdown = HubContentMarkdown, HubContentDocument = HubContentDocument, HubContentSearchKeywords = HubContentSearchKeywords, Tags = Tags)
  output <- .sagemaker$import_hub_content_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$import_hub_content <- sagemaker_import_hub_content

#' Lists the actions in your account and their properties
#'
#' @description
#' Lists the actions in your account and their properties.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_actions/](https://www.paws-r-sdk.com/docs/sagemaker_list_actions/) for full documentation.
#'
#' @param SourceUri A filter that returns only actions with the specified source URI.
#' @param ActionType A filter that returns only actions of the specified type.
#' @param CreatedAfter A filter that returns only actions created on or after the specified
#' time.
#' @param CreatedBefore A filter that returns only actions created on or before the specified
#' time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to [`list_actions`][sagemaker_list_actions] didn't
#' return the full set of actions, the call returns a token for getting the
#' next set of actions.
#' @param MaxResults The maximum number of actions to return in the response. The default
#' value is 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_actions
sagemaker_list_actions <- function(SourceUri = NULL, ActionType = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListActions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ActionSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_actions_input(SourceUri = SourceUri, ActionType = ActionType, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_actions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_actions <- sagemaker_list_actions

#' Lists the machine learning algorithms that have been created
#'
#' @description
#' Lists the machine learning algorithms that have been created.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_algorithms/](https://www.paws-r-sdk.com/docs/sagemaker_list_algorithms/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only algorithms created after the specified time
#' (timestamp).
#' @param CreationTimeBefore A filter that returns only algorithms created before the specified time
#' (timestamp).
#' @param MaxResults The maximum number of algorithms to return in the response.
#' @param NameContains A string in the algorithm name. This filter returns only algorithms
#' whose name contains the specified string.
#' @param NextToken If the response to a previous
#' [`list_algorithms`][sagemaker_list_algorithms] request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of
#' algorithms, use the token in the next request.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_algorithms
sagemaker_list_algorithms <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListAlgorithms",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AlgorithmSummaryList"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_algorithms_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_algorithms_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_algorithms <- sagemaker_list_algorithms

#' Lists the aliases of a specified image or image version
#'
#' @description
#' Lists the aliases of a specified image or image version.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_aliases/](https://www.paws-r-sdk.com/docs/sagemaker_list_aliases/) for full documentation.
#'
#' @param ImageName &#91;required&#93; The name of the image.
#' @param Alias The alias of the image version.
#' @param Version The version of the image. If image version is not specified, the aliases
#' of all versions of the image are listed.
#' @param MaxResults The maximum number of aliases to return.
#' @param NextToken If the previous call to [`list_aliases`][sagemaker_list_aliases] didn't
#' return the full set of aliases, the call returns a token for retrieving
#' the next set of aliases.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_aliases
sagemaker_list_aliases <- function(ImageName, Alias = NULL, Version = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAliases",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SageMakerImageVersionAliases"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_aliases_input(ImageName = ImageName, Alias = Alias, Version = Version, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_aliases_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_aliases <- sagemaker_list_aliases

#' Lists the AppImageConfigs in your account and their properties
#'
#' @description
#' Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or modified time, and whether the AppImageConfig name contains a specified string.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_app_image_configs/](https://www.paws-r-sdk.com/docs/sagemaker_list_app_image_configs/) for full documentation.
#'
#' @param MaxResults The total number of items to return in the response. If the total number
#' of items available is more than the value specified, a `NextToken` is
#' provided in the response. To resume pagination, provide the `NextToken`
#' value in the as part of a subsequent call. The default value is 10.
#' @param NextToken If the previous call to [`list_images`][sagemaker_list_images] didn't
#' return the full set of AppImageConfigs, the call returns a token for
#' getting the next set of AppImageConfigs.
#' @param NameContains A filter that returns only AppImageConfigs whose name contains the
#' specified string.
#' @param CreationTimeBefore A filter that returns only AppImageConfigs created on or before the
#' specified time.
#' @param CreationTimeAfter A filter that returns only AppImageConfigs created on or after the
#' specified time.
#' @param ModifiedTimeBefore A filter that returns only AppImageConfigs modified on or before the
#' specified time.
#' @param ModifiedTimeAfter A filter that returns only AppImageConfigs modified on or after the
#' specified time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_app_image_configs
sagemaker_list_app_image_configs <- function(MaxResults = NULL, NextToken = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, ModifiedTimeBefore = NULL, ModifiedTimeAfter = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListAppImageConfigs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "AppImageConfigs"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_app_image_configs_input(MaxResults = MaxResults, NextToken = NextToken, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, ModifiedTimeBefore = ModifiedTimeBefore, ModifiedTimeAfter = ModifiedTimeAfter, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_app_image_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_app_image_configs <- sagemaker_list_app_image_configs

#' Lists apps
#'
#' @description
#' Lists apps.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_apps/](https://www.paws-r-sdk.com/docs/sagemaker_list_apps/) for full documentation.
#'
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults This parameter defines the maximum number of results that can be return
#' in a single response. The `MaxResults` parameter is an upper bound, not
#' a target. If there are more results available than the value specified,
#' a `NextToken` is provided in the response. The `NextToken` indicates
#' that the user should get the next set of results by providing this token
#' as a part of a subsequent call. The default value for `MaxResults` is
#' 10.
#' @param SortOrder The sort order for the results. The default is Ascending.
#' @param SortBy The parameter by which to sort the results. The default is CreationTime.
#' @param DomainIdEquals A parameter to search for the domain ID.
#' @param UserProfileNameEquals A parameter to search by user profile name. If `SpaceNameEquals` is set,
#' then this value cannot be set.
#' @param SpaceNameEquals A parameter to search by space name. If `UserProfileNameEquals` is set,
#' then this value cannot be set.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_apps
sagemaker_list_apps <- function(NextToken = NULL, MaxResults = NULL, SortOrder = NULL, SortBy = NULL, DomainIdEquals = NULL, UserProfileNameEquals = NULL, SpaceNameEquals = NULL) {
  op <- new_operation(
    name = "ListApps",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Apps"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_apps_input(NextToken = NextToken, MaxResults = MaxResults, SortOrder = SortOrder, SortBy = SortBy, DomainIdEquals = DomainIdEquals, UserProfileNameEquals = UserProfileNameEquals, SpaceNameEquals = SpaceNameEquals)
  output <- .sagemaker$list_apps_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_apps <- sagemaker_list_apps

#' Lists the artifacts in your account and their properties
#'
#' @description
#' Lists the artifacts in your account and their properties.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_artifacts/](https://www.paws-r-sdk.com/docs/sagemaker_list_artifacts/) for full documentation.
#'
#' @param SourceUri A filter that returns only artifacts with the specified source URI.
#' @param ArtifactType A filter that returns only artifacts of the specified type.
#' @param CreatedAfter A filter that returns only artifacts created on or after the specified
#' time.
#' @param CreatedBefore A filter that returns only artifacts created on or before the specified
#' time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to [`list_artifacts`][sagemaker_list_artifacts]
#' didn't return the full set of artifacts, the call returns a token for
#' getting the next set of artifacts.
#' @param MaxResults The maximum number of artifacts to return in the response. The default
#' value is 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_artifacts
sagemaker_list_artifacts <- function(SourceUri = NULL, ArtifactType = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListArtifacts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ArtifactSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_artifacts_input(SourceUri = SourceUri, ArtifactType = ArtifactType, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_artifacts_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_artifacts <- sagemaker_list_artifacts

#' Lists the associations in your account and their properties
#'
#' @description
#' Lists the associations in your account and their properties.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_associations/](https://www.paws-r-sdk.com/docs/sagemaker_list_associations/) for full documentation.
#'
#' @param SourceArn A filter that returns only associations with the specified source ARN.
#' @param DestinationArn A filter that returns only associations with the specified destination
#' Amazon Resource Name (ARN).
#' @param SourceType A filter that returns only associations with the specified source type.
#' @param DestinationType A filter that returns only associations with the specified destination
#' type.
#' @param AssociationType A filter that returns only associations of the specified type.
#' @param CreatedAfter A filter that returns only associations created on or after the
#' specified time.
#' @param CreatedBefore A filter that returns only associations created on or before the
#' specified time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to
#' [`list_associations`][sagemaker_list_associations] didn't return the
#' full set of associations, the call returns a token for getting the next
#' set of associations.
#' @param MaxResults The maximum number of associations to return in the response. The
#' default value is 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_associations
sagemaker_list_associations <- function(SourceArn = NULL, DestinationArn = NULL, SourceType = NULL, DestinationType = NULL, AssociationType = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "AssociationSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_associations_input(SourceArn = SourceArn, DestinationArn = DestinationArn, SourceType = SourceType, DestinationType = DestinationType, AssociationType = AssociationType, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_associations_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_associations <- sagemaker_list_associations

#' Request a list of jobs
#'
#' @description
#' Request a list of jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_auto_ml_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_auto_ml_jobs/) for full documentation.
#'
#' @param CreationTimeAfter Request a list of jobs, using a filter for time.
#' @param CreationTimeBefore Request a list of jobs, using a filter for time.
#' @param LastModifiedTimeAfter Request a list of jobs, using a filter for time.
#' @param LastModifiedTimeBefore Request a list of jobs, using a filter for time.
#' @param NameContains Request a list of jobs, using a search filter for name.
#' @param StatusEquals Request a list of jobs, using a filter for status.
#' @param SortOrder The sort order for the results. The default is `Descending`.
#' @param SortBy The parameter by which to sort the results. The default is `Name`.
#' @param MaxResults Request a list of jobs up to a specified limit.
#' @param NextToken If the previous response was truncated, you receive this token. Use it
#' in your next request to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_auto_ml_jobs
sagemaker_list_auto_ml_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortOrder = NULL, SortBy = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAutoMLJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "AutoMLJobSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_auto_ml_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortOrder = SortOrder, SortBy = SortBy, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_auto_ml_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_auto_ml_jobs <- sagemaker_list_auto_ml_jobs

#' List the candidates created for the job
#'
#' @description
#' List the candidates created for the job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_candidates_for_auto_ml_job/](https://www.paws-r-sdk.com/docs/sagemaker_list_candidates_for_auto_ml_job/) for full documentation.
#'
#' @param AutoMLJobName &#91;required&#93; List the candidates created for the job by providing the job's name.
#' @param StatusEquals List the candidates for the job and filter by status.
#' @param CandidateNameEquals List the candidates for the job and filter by candidate name.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#' @param SortBy The parameter by which to sort the results. The default is `Descending`.
#' @param MaxResults List the job's candidates up to a specified limit.
#' @param NextToken If the previous response was truncated, you receive this token. Use it
#' in your next request to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_candidates_for_auto_ml_job
sagemaker_list_candidates_for_auto_ml_job <- function(AutoMLJobName, StatusEquals = NULL, CandidateNameEquals = NULL, SortOrder = NULL, SortBy = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCandidatesForAutoMLJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Candidates"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_candidates_for_auto_ml_job_input(AutoMLJobName = AutoMLJobName, StatusEquals = StatusEquals, CandidateNameEquals = CandidateNameEquals, SortOrder = SortOrder, SortBy = SortBy, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_candidates_for_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_candidates_for_auto_ml_job <- sagemaker_list_candidates_for_auto_ml_job

#' Retrieves the list of instances (also called nodes interchangeably) in a
#' SageMaker HyperPod cluster
#'
#' @description
#' Retrieves the list of instances (also called *nodes* interchangeably) in a SageMaker HyperPod cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_cluster_nodes/](https://www.paws-r-sdk.com/docs/sagemaker_list_cluster_nodes/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The string name or the Amazon Resource Name (ARN) of the SageMaker
#' HyperPod cluster in which you want to retrieve the list of nodes.
#' @param CreationTimeAfter A filter that returns nodes in a SageMaker HyperPod cluster created
#' after the specified time. Timestamps are formatted according to the ISO
#' 8601 standard.
#' 
#' Acceptable formats include:
#' 
#' -   `YYYY-MM-DDThh:mm:ss.sssTZD` (UTC), for example,
#'     `2014-10-01T20:30:00.000Z`
#' 
#' -   `YYYY-MM-DDThh:mm:ss.sssTZD` (with offset), for example,
#'     `2014-10-01T12:30:00.000-08:00`
#' 
#' -   `YYYY-MM-DD`, for example, `2014-10-01`
#' 
#' -   Unix time in seconds, for example, `1412195400`. This is also
#'     referred to as Unix Epoch time and represents the number of seconds
#'     since midnight, January 1, 1970 UTC.
#' 
#' For more information about the timestamp format, see
#' [Timestamp](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp)
#' in the *Amazon Web Services Command Line Interface User Guide*.
#' @param CreationTimeBefore A filter that returns nodes in a SageMaker HyperPod cluster created
#' before the specified time. The acceptable formats are the same as the
#' timestamp formats for `CreationTimeAfter`. For more information about
#' the timestamp format, see
#' [Timestamp](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp)
#' in the *Amazon Web Services Command Line Interface User Guide*.
#' @param InstanceGroupNameContains A filter that returns the instance groups whose name contain a specified
#' string.
#' @param MaxResults The maximum number of nodes to return in the response.
#' @param NextToken If the result of the previous
#' [`list_cluster_nodes`][sagemaker_list_cluster_nodes] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of cluster nodes, use the token in the next request.
#' @param SortBy The field by which to sort results. The default value is
#' `CREATION_TIME`.
#' @param SortOrder The sort order for results. The default value is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_cluster_nodes
sagemaker_list_cluster_nodes <- function(ClusterName, CreationTimeAfter = NULL, CreationTimeBefore = NULL, InstanceGroupNameContains = NULL, MaxResults = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListClusterNodes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ClusterNodeSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_cluster_nodes_input(ClusterName = ClusterName, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, InstanceGroupNameContains = InstanceGroupNameContains, MaxResults = MaxResults, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_cluster_nodes_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_cluster_nodes <- sagemaker_list_cluster_nodes

#' List the cluster policy configurations
#'
#' @description
#' List the cluster policy configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_cluster_scheduler_configs/](https://www.paws-r-sdk.com/docs/sagemaker_list_cluster_scheduler_configs/) for full documentation.
#'
#' @param CreatedAfter Filter for after this creation time. The input for this parameter is a
#' Unix timestamp. To convert a date and time into a Unix timestamp, see
#' [EpochConverter](https://www.epochconverter.com/).
#' @param CreatedBefore Filter for before this creation time. The input for this parameter is a
#' Unix timestamp. To convert a date and time into a Unix timestamp, see
#' [EpochConverter](https://www.epochconverter.com/).
#' @param NameContains Filter for name containing this string.
#' @param ClusterArn Filter for ARN of the cluster.
#' @param Status Filter for status.
#' @param SortBy Filter for sorting the list by a given value. For example, sort by name,
#' creation time, or status.
#' @param SortOrder The order of the list. By default, listed in `Descending` order
#' according to by `SortBy`. To change the list order, you can specify
#' `SortOrder` to be `Ascending`.
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults The maximum number of cluster policies to list.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_cluster_scheduler_configs
sagemaker_list_cluster_scheduler_configs <- function(CreatedAfter = NULL, CreatedBefore = NULL, NameContains = NULL, ClusterArn = NULL, Status = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListClusterSchedulerConfigs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ClusterSchedulerConfigSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_cluster_scheduler_configs_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, NameContains = NameContains, ClusterArn = ClusterArn, Status = Status, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_cluster_scheduler_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_cluster_scheduler_configs <- sagemaker_list_cluster_scheduler_configs

#' Retrieves the list of SageMaker HyperPod clusters
#'
#' @description
#' Retrieves the list of SageMaker HyperPod clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_clusters/](https://www.paws-r-sdk.com/docs/sagemaker_list_clusters/) for full documentation.
#'
#' @param CreationTimeAfter Set a start time for the time range during which you want to list
#' SageMaker HyperPod clusters. Timestamps are formatted according to the
#' ISO 8601 standard.
#' 
#' Acceptable formats include:
#' 
#' -   `YYYY-MM-DDThh:mm:ss.sssTZD` (UTC), for example,
#'     `2014-10-01T20:30:00.000Z`
#' 
#' -   `YYYY-MM-DDThh:mm:ss.sssTZD` (with offset), for example,
#'     `2014-10-01T12:30:00.000-08:00`
#' 
#' -   `YYYY-MM-DD`, for example, `2014-10-01`
#' 
#' -   Unix time in seconds, for example, `1412195400`. This is also
#'     referred to as Unix Epoch time and represents the number of seconds
#'     since midnight, January 1, 1970 UTC.
#' 
#' For more information about the timestamp format, see
#' [Timestamp](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp)
#' in the *Amazon Web Services Command Line Interface User Guide*.
#' @param CreationTimeBefore Set an end time for the time range during which you want to list
#' SageMaker HyperPod clusters. A filter that returns nodes in a SageMaker
#' HyperPod cluster created before the specified time. The acceptable
#' formats are the same as the timestamp formats for `CreationTimeAfter`.
#' For more information about the timestamp format, see
#' [Timestamp](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp)
#' in the *Amazon Web Services Command Line Interface User Guide*.
#' @param MaxResults Set the maximum number of SageMaker HyperPod clusters to list.
#' @param NameContains Set the maximum number of instances to print in the list.
#' @param NextToken Set the next token to retrieve the list of SageMaker HyperPod clusters.
#' @param SortBy The field by which to sort results. The default value is
#' `CREATION_TIME`.
#' @param SortOrder The sort order for results. The default value is `Ascending`.
#' @param TrainingPlanArn The Amazon Resource Name (ARN); of the training plan to filter clusters
#' by. For more information about reserving GPU capacity for your SageMaker
#' HyperPod clusters using Amazon SageMaker Training Plan, see
#' [`create_training_plan`][sagemaker_create_training_plan].
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_clusters
sagemaker_list_clusters <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL, TrainingPlanArn = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ClusterSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_clusters_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder, TrainingPlanArn = TrainingPlanArn)
  output <- .sagemaker$list_clusters_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_clusters <- sagemaker_list_clusters

#' Gets a list of the Git repositories in your account
#'
#' @description
#' Gets a list of the Git repositories in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_code_repositories/](https://www.paws-r-sdk.com/docs/sagemaker_list_code_repositories/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only Git repositories that were created after the
#' specified time.
#' @param CreationTimeBefore A filter that returns only Git repositories that were created before the
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only Git repositories that were last modified
#' after the specified time.
#' @param LastModifiedTimeBefore A filter that returns only Git repositories that were last modified
#' before the specified time.
#' @param MaxResults The maximum number of Git repositories to return in the response.
#' @param NameContains A string in the Git repositories name. This filter returns only
#' repositories whose name contains the specified string.
#' @param NextToken If the result of a `ListCodeRepositoriesOutput` request was truncated,
#' the response includes a `NextToken`. To get the next set of Git
#' repositories, use the token in the next request.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_code_repositories
sagemaker_list_code_repositories <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListCodeRepositories",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CodeRepositorySummaryList"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_code_repositories_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_code_repositories_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_code_repositories <- sagemaker_list_code_repositories

#' Lists model compilation jobs that satisfy various filters
#'
#' @description
#' Lists model compilation jobs that satisfy various filters.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_compilation_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_compilation_jobs/) for full documentation.
#'
#' @param NextToken If the result of the previous
#' [`list_compilation_jobs`][sagemaker_list_compilation_jobs] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of model compilation jobs, use the token in the next request.
#' @param MaxResults The maximum number of model compilation jobs to return in the response.
#' @param CreationTimeAfter A filter that returns the model compilation jobs that were created after
#' a specified time.
#' @param CreationTimeBefore A filter that returns the model compilation jobs that were created
#' before a specified time.
#' @param LastModifiedTimeAfter A filter that returns the model compilation jobs that were modified
#' after a specified time.
#' @param LastModifiedTimeBefore A filter that returns the model compilation jobs that were modified
#' before a specified time.
#' @param NameContains A filter that returns the model compilation jobs whose name contains a
#' specified string.
#' @param StatusEquals A filter that retrieves model compilation jobs with a specific
#' `CompilationJobStatus` status.
#' @param SortBy The field by which to sort results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_compilation_jobs
sagemaker_list_compilation_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListCompilationJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CompilationJobSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_compilation_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_compilation_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_compilation_jobs <- sagemaker_list_compilation_jobs

#' List the resource allocation definitions
#'
#' @description
#' List the resource allocation definitions.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_compute_quotas/](https://www.paws-r-sdk.com/docs/sagemaker_list_compute_quotas/) for full documentation.
#'
#' @param CreatedAfter Filter for after this creation time. The input for this parameter is a
#' Unix timestamp. To convert a date and time into a Unix timestamp, see
#' [EpochConverter](https://www.epochconverter.com/).
#' @param CreatedBefore Filter for before this creation time. The input for this parameter is a
#' Unix timestamp. To convert a date and time into a Unix timestamp, see
#' [EpochConverter](https://www.epochconverter.com/).
#' @param NameContains Filter for name containing this string.
#' @param Status Filter for status.
#' @param ClusterArn Filter for ARN of the cluster.
#' @param SortBy Filter for sorting the list by a given value. For example, sort by name,
#' creation time, or status.
#' @param SortOrder The order of the list. By default, listed in `Descending` order
#' according to by `SortBy`. To change the list order, you can specify
#' `SortOrder` to be `Ascending`.
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults The maximum number of compute allocation definitions to list.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_compute_quotas
sagemaker_list_compute_quotas <- function(CreatedAfter = NULL, CreatedBefore = NULL, NameContains = NULL, Status = NULL, ClusterArn = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListComputeQuotas",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ComputeQuotaSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_compute_quotas_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, NameContains = NameContains, Status = Status, ClusterArn = ClusterArn, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_compute_quotas_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_compute_quotas <- sagemaker_list_compute_quotas

#' Lists the contexts in your account and their properties
#'
#' @description
#' Lists the contexts in your account and their properties.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_contexts/](https://www.paws-r-sdk.com/docs/sagemaker_list_contexts/) for full documentation.
#'
#' @param SourceUri A filter that returns only contexts with the specified source URI.
#' @param ContextType A filter that returns only contexts of the specified type.
#' @param CreatedAfter A filter that returns only contexts created on or after the specified
#' time.
#' @param CreatedBefore A filter that returns only contexts created on or before the specified
#' time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to [`list_contexts`][sagemaker_list_contexts]
#' didn't return the full set of contexts, the call returns a token for
#' getting the next set of contexts.
#' @param MaxResults The maximum number of contexts to return in the response. The default
#' value is 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_contexts
sagemaker_list_contexts <- function(SourceUri = NULL, ContextType = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListContexts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ContextSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_contexts_input(SourceUri = SourceUri, ContextType = ContextType, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_contexts_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_contexts <- sagemaker_list_contexts

#' Lists the data quality job definitions in your account
#'
#' @description
#' Lists the data quality job definitions in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_data_quality_job_definitions/](https://www.paws-r-sdk.com/docs/sagemaker_list_data_quality_job_definitions/) for full documentation.
#'
#' @param EndpointName A filter that lists the data quality job definitions associated with the
#' specified endpoint.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken If the result of the previous
#' [`list_data_quality_job_definitions`][sagemaker_list_data_quality_job_definitions]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of transform jobs, use the token in the next request.\>
#' @param MaxResults The maximum number of data quality monitoring job definitions to return
#' in the response.
#' @param NameContains A string in the data quality monitoring job definition name. This filter
#' returns only data quality monitoring job definitions whose name contains
#' the specified string.
#' @param CreationTimeBefore A filter that returns only data quality monitoring job definitions
#' created before the specified time.
#' @param CreationTimeAfter A filter that returns only data quality monitoring job definitions
#' created after the specified time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_data_quality_job_definitions
sagemaker_list_data_quality_job_definitions <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListDataQualityJobDefinitions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "JobDefinitionSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_data_quality_job_definitions_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_data_quality_job_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_data_quality_job_definitions <- sagemaker_list_data_quality_job_definitions

#' Returns a list of devices in the fleet
#'
#' @description
#' Returns a list of devices in the fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_device_fleets/](https://www.paws-r-sdk.com/docs/sagemaker_list_device_fleets/) for full documentation.
#'
#' @param NextToken The response from the last list when returning a list large enough to
#' need tokening.
#' @param MaxResults The maximum number of results to select.
#' @param CreationTimeAfter Filter fleets where packaging job was created after specified time.
#' @param CreationTimeBefore Filter fleets where the edge packaging job was created before specified
#' time.
#' @param LastModifiedTimeAfter Select fleets where the job was updated after X
#' @param LastModifiedTimeBefore Select fleets where the job was updated before X
#' @param NameContains Filter for fleets containing this name in their fleet device name.
#' @param SortBy The column to sort by.
#' @param SortOrder What direction to sort in.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_device_fleets
sagemaker_list_device_fleets <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListDeviceFleets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "DeviceFleetSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_device_fleets_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_device_fleets_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_device_fleets <- sagemaker_list_device_fleets

#' A list of devices
#'
#' @description
#' A list of devices.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_devices/](https://www.paws-r-sdk.com/docs/sagemaker_list_devices/) for full documentation.
#'
#' @param NextToken The response from the last list when returning a list large enough to
#' need tokening.
#' @param MaxResults Maximum number of results to select.
#' @param LatestHeartbeatAfter Select fleets where the job was updated after X
#' @param ModelName A filter that searches devices that contains this name in any of their
#' models.
#' @param DeviceFleetName Filter for fleets containing this name in their device fleet name.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_devices
sagemaker_list_devices <- function(NextToken = NULL, MaxResults = NULL, LatestHeartbeatAfter = NULL, ModelName = NULL, DeviceFleetName = NULL) {
  op <- new_operation(
    name = "ListDevices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "DeviceSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_devices_input(NextToken = NextToken, MaxResults = MaxResults, LatestHeartbeatAfter = LatestHeartbeatAfter, ModelName = ModelName, DeviceFleetName = DeviceFleetName)
  output <- .sagemaker$list_devices_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_devices <- sagemaker_list_devices

#' Lists the domains
#'
#' @description
#' Lists the domains.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_domains/](https://www.paws-r-sdk.com/docs/sagemaker_list_domains/) for full documentation.
#'
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults This parameter defines the maximum number of results that can be return
#' in a single response. The `MaxResults` parameter is an upper bound, not
#' a target. If there are more results available than the value specified,
#' a `NextToken` is provided in the response. The `NextToken` indicates
#' that the user should get the next set of results by providing this token
#' as a part of a subsequent call. The default value for `MaxResults` is
#' 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_domains
sagemaker_list_domains <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Domains"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_domains_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_domains_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_domains <- sagemaker_list_domains

#' Lists all edge deployment plans
#'
#' @description
#' Lists all edge deployment plans.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_edge_deployment_plans/](https://www.paws-r-sdk.com/docs/sagemaker_list_edge_deployment_plans/) for full documentation.
#'
#' @param NextToken The response from the last list when returning a list large enough to
#' need tokening.
#' @param MaxResults The maximum number of results to select (50 by default).
#' @param CreationTimeAfter Selects edge deployment plans created after this time.
#' @param CreationTimeBefore Selects edge deployment plans created before this time.
#' @param LastModifiedTimeAfter Selects edge deployment plans that were last updated after this time.
#' @param LastModifiedTimeBefore Selects edge deployment plans that were last updated before this time.
#' @param NameContains Selects edge deployment plans with names containing this name.
#' @param DeviceFleetNameContains Selects edge deployment plans with a device fleet name containing this
#' name.
#' @param SortBy The column by which to sort the edge deployment plans. Can be one of
#' `NAME`, `DEVICEFLEETNAME`, `CREATIONTIME`, `LASTMODIFIEDTIME`.
#' @param SortOrder The direction of the sorting (ascending or descending).
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_edge_deployment_plans
sagemaker_list_edge_deployment_plans <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, DeviceFleetNameContains = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListEdgeDeploymentPlans",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "EdgeDeploymentPlanSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_edge_deployment_plans_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, DeviceFleetNameContains = DeviceFleetNameContains, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_edge_deployment_plans_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_edge_deployment_plans <- sagemaker_list_edge_deployment_plans

#' Returns a list of edge packaging jobs
#'
#' @description
#' Returns a list of edge packaging jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_edge_packaging_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_edge_packaging_jobs/) for full documentation.
#'
#' @param NextToken The response from the last list when returning a list large enough to
#' need tokening.
#' @param MaxResults Maximum number of results to select.
#' @param CreationTimeAfter Select jobs where the job was created after specified time.
#' @param CreationTimeBefore Select jobs where the job was created before specified time.
#' @param LastModifiedTimeAfter Select jobs where the job was updated after specified time.
#' @param LastModifiedTimeBefore Select jobs where the job was updated before specified time.
#' @param NameContains Filter for jobs containing this name in their packaging job name.
#' @param ModelNameContains Filter for jobs where the model name contains this string.
#' @param StatusEquals The job status to filter for.
#' @param SortBy Use to specify what column to sort by.
#' @param SortOrder What direction to sort by.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_edge_packaging_jobs
sagemaker_list_edge_packaging_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, ModelNameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListEdgePackagingJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "EdgePackagingJobSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_edge_packaging_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, ModelNameContains = ModelNameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_edge_packaging_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_edge_packaging_jobs <- sagemaker_list_edge_packaging_jobs

#' Lists endpoint configurations
#'
#' @description
#' Lists endpoint configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_endpoint_configs/](https://www.paws-r-sdk.com/docs/sagemaker_list_endpoint_configs/) for full documentation.
#'
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of the previous `ListEndpointConfig` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of endpoint configurations, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return in the response.
#' @param NameContains A string in the endpoint configuration name. This filter returns only
#' endpoint configurations whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only endpoint configurations created before the
#' specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only endpoint configurations with a creation time
#' greater than or equal to the specified time (timestamp).
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_endpoint_configs
sagemaker_list_endpoint_configs <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListEndpointConfigs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "EndpointConfigs", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_endpoint_configs_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_endpoint_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_endpoint_configs <- sagemaker_list_endpoint_configs

#' Lists endpoints
#'
#' @description
#' Lists endpoints.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_endpoints/](https://www.paws-r-sdk.com/docs/sagemaker_list_endpoints/) for full documentation.
#'
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of a [`list_endpoints`][sagemaker_list_endpoints] request
#' was truncated, the response includes a `NextToken`. To retrieve the next
#' set of endpoints, use the token in the next request.
#' @param MaxResults The maximum number of endpoints to return in the response. This value
#' defaults to 10.
#' @param NameContains A string in endpoint names. This filter returns only endpoints whose
#' name contains the specified string.
#' @param CreationTimeBefore A filter that returns only endpoints that were created before the
#' specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only endpoints with a creation time greater than
#' or equal to the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only endpoints that were modified before the
#' specified timestamp.
#' @param LastModifiedTimeAfter A filter that returns only endpoints that were modified after the
#' specified timestamp.
#' @param StatusEquals A filter that returns only endpoints with the specified status.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_endpoints
sagemaker_list_endpoints <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListEndpoints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "Endpoints", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_endpoints_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals)
  output <- .sagemaker$list_endpoints_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_endpoints <- sagemaker_list_endpoints

#' Lists all the experiments in your account
#'
#' @description
#' Lists all the experiments in your account. The list can be filtered to show only experiments that were created in a specific time range. The list can be sorted by experiment name or creation time.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_experiments/](https://www.paws-r-sdk.com/docs/sagemaker_list_experiments/) for full documentation.
#'
#' @param CreatedAfter A filter that returns only experiments created after the specified time.
#' @param CreatedBefore A filter that returns only experiments created before the specified
#' time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to [`list_experiments`][sagemaker_list_experiments]
#' didn't return the full set of experiments, the call returns a token for
#' getting the next set of experiments.
#' @param MaxResults The maximum number of experiments to return in the response. The default
#' value is 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_experiments
sagemaker_list_experiments <- function(CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListExperiments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ExperimentSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_experiments_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_experiments_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_experiments <- sagemaker_list_experiments

#' List FeatureGroups based on given filter and order
#'
#' @description
#' List `FeatureGroup`s based on given filter and order.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_feature_groups/](https://www.paws-r-sdk.com/docs/sagemaker_list_feature_groups/) for full documentation.
#'
#' @param NameContains A string that partially matches one or more `FeatureGroup`s names.
#' Filters `FeatureGroup`s by name.
#' @param FeatureGroupStatusEquals A `FeatureGroup` status. Filters by `FeatureGroup` status.
#' @param OfflineStoreStatusEquals An `OfflineStore` status. Filters by `OfflineStore` status.
#' @param CreationTimeAfter Use this parameter to search for `FeatureGroups`s created after a
#' specific date and time.
#' @param CreationTimeBefore Use this parameter to search for `FeatureGroups`s created before a
#' specific date and time.
#' @param SortOrder The order in which feature groups are listed.
#' @param SortBy The value on which the feature group list is sorted.
#' @param MaxResults The maximum number of results returned by
#' [`list_feature_groups`][sagemaker_list_feature_groups].
#' @param NextToken A token to resume pagination of
#' [`list_feature_groups`][sagemaker_list_feature_groups] results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_feature_groups
sagemaker_list_feature_groups <- function(NameContains = NULL, FeatureGroupStatusEquals = NULL, OfflineStoreStatusEquals = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, SortOrder = NULL, SortBy = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFeatureGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "FeatureGroupSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_feature_groups_input(NameContains = NameContains, FeatureGroupStatusEquals = FeatureGroupStatusEquals, OfflineStoreStatusEquals = OfflineStoreStatusEquals, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, SortOrder = SortOrder, SortBy = SortBy, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_feature_groups_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_feature_groups <- sagemaker_list_feature_groups

#' Returns information about the flow definitions in your account
#'
#' @description
#' Returns information about the flow definitions in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_flow_definitions/](https://www.paws-r-sdk.com/docs/sagemaker_list_flow_definitions/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only flow definitions with a creation time greater
#' than or equal to the specified timestamp.
#' @param CreationTimeBefore A filter that returns only flow definitions that were created before the
#' specified timestamp.
#' @param SortOrder An optional value that specifies whether you want the results sorted in
#' `Ascending` or `Descending` order.
#' @param NextToken A token to resume pagination.
#' @param MaxResults The total number of items to return. If the total number of available
#' items is more than the value specified in `MaxResults`, then a
#' `NextToken` will be provided in the output that you can use to resume
#' pagination.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_flow_definitions
sagemaker_list_flow_definitions <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFlowDefinitions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "FlowDefinitionSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_flow_definitions_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_flow_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_flow_definitions <- sagemaker_list_flow_definitions

#' List hub content versions
#'
#' @description
#' List hub content versions.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_hub_content_versions/](https://www.paws-r-sdk.com/docs/sagemaker_list_hub_content_versions/) for full documentation.
#'
#' @param HubName &#91;required&#93; The name of the hub to list the content versions of.
#' @param HubContentType &#91;required&#93; The type of hub content to list versions of.
#' @param HubContentName &#91;required&#93; The name of the hub content.
#' @param MinVersion The lower bound of the hub content versions to list.
#' @param MaxSchemaVersion The upper bound of the hub content schema version.
#' @param CreationTimeBefore Only list hub content versions that were created before the time
#' specified.
#' @param CreationTimeAfter Only list hub content versions that were created after the time
#' specified.
#' @param SortBy Sort hub content versions by either name or creation time.
#' @param SortOrder Sort hub content versions by ascending or descending order.
#' @param MaxResults The maximum number of hub content versions to list.
#' @param NextToken If the response to a previous
#' [`list_hub_content_versions`][sagemaker_list_hub_content_versions]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of hub content versions, use the token in the next request.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_hub_content_versions
sagemaker_list_hub_content_versions <- function(HubName, HubContentType, HubContentName, MinVersion = NULL, MaxSchemaVersion = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, SortBy = NULL, SortOrder = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListHubContentVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$list_hub_content_versions_input(HubName = HubName, HubContentType = HubContentType, HubContentName = HubContentName, MinVersion = MinVersion, MaxSchemaVersion = MaxSchemaVersion, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, SortBy = SortBy, SortOrder = SortOrder, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_hub_content_versions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_hub_content_versions <- sagemaker_list_hub_content_versions

#' List the contents of a hub
#'
#' @description
#' List the contents of a hub.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_hub_contents/](https://www.paws-r-sdk.com/docs/sagemaker_list_hub_contents/) for full documentation.
#'
#' @param HubName &#91;required&#93; The name of the hub to list the contents of.
#' @param HubContentType &#91;required&#93; The type of hub content to list.
#' @param NameContains Only list hub content if the name contains the specified string.
#' @param MaxSchemaVersion The upper bound of the hub content schema verion.
#' @param CreationTimeBefore Only list hub content that was created before the time specified.
#' @param CreationTimeAfter Only list hub content that was created after the time specified.
#' @param SortBy Sort hub content versions by either name or creation time.
#' @param SortOrder Sort hubs by ascending or descending order.
#' @param MaxResults The maximum amount of hub content to list.
#' @param NextToken If the response to a previous
#' [`list_hub_contents`][sagemaker_list_hub_contents] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of hub content, use the token in the next request.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_hub_contents
sagemaker_list_hub_contents <- function(HubName, HubContentType, NameContains = NULL, MaxSchemaVersion = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, SortBy = NULL, SortOrder = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListHubContents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$list_hub_contents_input(HubName = HubName, HubContentType = HubContentType, NameContains = NameContains, MaxSchemaVersion = MaxSchemaVersion, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, SortBy = SortBy, SortOrder = SortOrder, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_hub_contents_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_hub_contents <- sagemaker_list_hub_contents

#' List all existing hubs
#'
#' @description
#' List all existing hubs.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_hubs/](https://www.paws-r-sdk.com/docs/sagemaker_list_hubs/) for full documentation.
#'
#' @param NameContains Only list hubs with names that contain the specified string.
#' @param CreationTimeBefore Only list hubs that were created before the time specified.
#' @param CreationTimeAfter Only list hubs that were created after the time specified.
#' @param LastModifiedTimeBefore Only list hubs that were last modified before the time specified.
#' @param LastModifiedTimeAfter Only list hubs that were last modified after the time specified.
#' @param SortBy Sort hubs by either name or creation time.
#' @param SortOrder Sort hubs by ascending or descending order.
#' @param MaxResults The maximum number of hubs to list.
#' @param NextToken If the response to a previous [`list_hubs`][sagemaker_list_hubs] request
#' was truncated, the response includes a `NextToken`. To retrieve the next
#' set of hubs, use the token in the next request.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_hubs
sagemaker_list_hubs <- function(NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, SortBy = NULL, SortOrder = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListHubs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$list_hubs_input(NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, SortBy = SortBy, SortOrder = SortOrder, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_hubs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_hubs <- sagemaker_list_hubs

#' Returns information about the human task user interfaces in your account
#'
#' @description
#' Returns information about the human task user interfaces in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_human_task_uis/](https://www.paws-r-sdk.com/docs/sagemaker_list_human_task_uis/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only human task user interfaces with a creation
#' time greater than or equal to the specified timestamp.
#' @param CreationTimeBefore A filter that returns only human task user interfaces that were created
#' before the specified timestamp.
#' @param SortOrder An optional value that specifies whether you want the results sorted in
#' `Ascending` or `Descending` order.
#' @param NextToken A token to resume pagination.
#' @param MaxResults The total number of items to return. If the total number of available
#' items is more than the value specified in `MaxResults`, then a
#' `NextToken` will be provided in the output that you can use to resume
#' pagination.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_human_task_uis
sagemaker_list_human_task_uis <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHumanTaskUis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "HumanTaskUiSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_human_task_uis_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_human_task_uis_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_human_task_uis <- sagemaker_list_human_task_uis

#' Gets a list of HyperParameterTuningJobSummary objects that describe the
#' hyperparameter tuning jobs launched in your account
#'
#' @description
#' Gets a list of [HyperParameterTuningJobSummary](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobSummary.html) objects that describe the hyperparameter tuning jobs launched in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_hyper_parameter_tuning_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_hyper_parameter_tuning_jobs/) for full documentation.
#'
#' @param NextToken If the result of the previous
#' [`list_hyper_parameter_tuning_jobs`][sagemaker_list_hyper_parameter_tuning_jobs]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of tuning jobs, use the token in the next request.
#' @param MaxResults The maximum number of tuning jobs to return. The default value is 10.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NameContains A string in the tuning job name. This filter returns only tuning jobs
#' whose name contains the specified string.
#' @param CreationTimeAfter A filter that returns only tuning jobs that were created after the
#' specified time.
#' @param CreationTimeBefore A filter that returns only tuning jobs that were created before the
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only tuning jobs that were modified after the
#' specified time.
#' @param LastModifiedTimeBefore A filter that returns only tuning jobs that were modified before the
#' specified time.
#' @param StatusEquals A filter that returns only tuning jobs with the specified status.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_hyper_parameter_tuning_jobs
sagemaker_list_hyper_parameter_tuning_jobs <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListHyperParameterTuningJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "HyperParameterTuningJobSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_hyper_parameter_tuning_jobs_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, StatusEquals = StatusEquals)
  output <- .sagemaker$list_hyper_parameter_tuning_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_hyper_parameter_tuning_jobs <- sagemaker_list_hyper_parameter_tuning_jobs

#' Lists the versions of a specified image and their properties
#'
#' @description
#' Lists the versions of a specified image and their properties. The list can be filtered by creation time or modified time.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_image_versions/](https://www.paws-r-sdk.com/docs/sagemaker_list_image_versions/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only versions created on or after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only versions created on or before the specified
#' time.
#' @param ImageName &#91;required&#93; The name of the image to list the versions of.
#' @param LastModifiedTimeAfter A filter that returns only versions modified on or after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only versions modified on or before the specified
#' time.
#' @param MaxResults The maximum number of versions to return in the response. The default
#' value is 10.
#' @param NextToken If the previous call to
#' [`list_image_versions`][sagemaker_list_image_versions] didn't return the
#' full set of versions, the call returns a token for getting the next set
#' of versions.
#' @param SortBy The property used to sort results. The default value is `CREATION_TIME`.
#' @param SortOrder The sort order. The default value is `DESCENDING`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_image_versions
sagemaker_list_image_versions <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, ImageName, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListImageVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ImageVersions"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_image_versions_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, ImageName = ImageName, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_image_versions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_image_versions <- sagemaker_list_image_versions

#' Lists the images in your account and their properties
#'
#' @description
#' Lists the images in your account and their properties. The list can be filtered by creation time or modified time, and whether the image name contains a specified string.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_images/](https://www.paws-r-sdk.com/docs/sagemaker_list_images/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only images created on or after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only images created on or before the specified
#' time.
#' @param LastModifiedTimeAfter A filter that returns only images modified on or after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only images modified on or before the specified
#' time.
#' @param MaxResults The maximum number of images to return in the response. The default
#' value is 10.
#' @param NameContains A filter that returns only images whose name contains the specified
#' string.
#' @param NextToken If the previous call to [`list_images`][sagemaker_list_images] didn't
#' return the full set of images, the call returns a token for getting the
#' next set of images.
#' @param SortBy The property used to sort results. The default value is `CREATION_TIME`.
#' @param SortOrder The sort order. The default value is `DESCENDING`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_images
sagemaker_list_images <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListImages",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Images"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_images_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_images_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_images <- sagemaker_list_images

#' Lists the inference components in your account and their properties
#'
#' @description
#' Lists the inference components in your account and their properties.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_inference_components/](https://www.paws-r-sdk.com/docs/sagemaker_list_inference_components/) for full documentation.
#'
#' @param SortBy The field by which to sort the inference components in the response. The
#' default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken A token that you use to get the next set of results following a
#' truncated response. If the response to the previous request was
#' truncated, that response provides the value for this token.
#' @param MaxResults The maximum number of inference components to return in the response.
#' This value defaults to 10.
#' @param NameContains Filters the results to only those inference components with a name that
#' contains the specified string.
#' @param CreationTimeBefore Filters the results to only those inference components that were created
#' before the specified time.
#' @param CreationTimeAfter Filters the results to only those inference components that were created
#' after the specified time.
#' @param LastModifiedTimeBefore Filters the results to only those inference components that were updated
#' before the specified time.
#' @param LastModifiedTimeAfter Filters the results to only those inference components that were updated
#' after the specified time.
#' @param StatusEquals Filters the results to only those inference components with the
#' specified status.
#' @param EndpointNameEquals An endpoint name to filter the listed inference components. The response
#' includes only those inference components that are hosted at the
#' specified endpoint.
#' @param VariantNameEquals A production variant name to filter the listed inference components. The
#' response includes only those inference components that are hosted at the
#' specified variant.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_inference_components
sagemaker_list_inference_components <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL, EndpointNameEquals = NULL, VariantNameEquals = NULL) {
  op <- new_operation(
    name = "ListInferenceComponents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "InferenceComponents"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_inference_components_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals, EndpointNameEquals = EndpointNameEquals, VariantNameEquals = VariantNameEquals)
  output <- .sagemaker$list_inference_components_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_inference_components <- sagemaker_list_inference_components

#' Returns the list of all inference experiments
#'
#' @description
#' Returns the list of all inference experiments.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_inference_experiments/](https://www.paws-r-sdk.com/docs/sagemaker_list_inference_experiments/) for full documentation.
#'
#' @param NameContains Selects inference experiments whose names contain this name.
#' @param Type Selects inference experiments of this type. For the possible types of
#' inference experiments, see
#' [`create_inference_experiment`][sagemaker_create_inference_experiment].
#' @param StatusEquals Selects inference experiments which are in this status. For the possible
#' statuses, see
#' [`describe_inference_experiment`][sagemaker_describe_inference_experiment].
#' @param CreationTimeAfter Selects inference experiments which were created after this timestamp.
#' @param CreationTimeBefore Selects inference experiments which were created before this timestamp.
#' @param LastModifiedTimeAfter Selects inference experiments which were last modified after this
#' timestamp.
#' @param LastModifiedTimeBefore Selects inference experiments which were last modified before this
#' timestamp.
#' @param SortBy The column by which to sort the listed inference experiments.
#' @param SortOrder The direction of sorting (ascending or descending).
#' @param NextToken The response from the last list when returning a list large enough to
#' need tokening.
#' @param MaxResults The maximum number of results to select.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_inference_experiments
sagemaker_list_inference_experiments <- function(NameContains = NULL, Type = NULL, StatusEquals = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListInferenceExperiments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "InferenceExperiments"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_inference_experiments_input(NameContains = NameContains, Type = Type, StatusEquals = StatusEquals, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_inference_experiments_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_inference_experiments <- sagemaker_list_inference_experiments

#' Returns a list of the subtasks for an Inference Recommender job
#'
#' @description
#' Returns a list of the subtasks for an Inference Recommender job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_inference_recommendations_job_steps/](https://www.paws-r-sdk.com/docs/sagemaker_list_inference_recommendations_job_steps/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name for the Inference Recommender job.
#' @param Status A filter to return benchmarks of a specified status. If this field is
#' left empty, then all benchmarks are returned.
#' @param StepType A filter to return details about the specified type of subtask.
#' 
#' `BENCHMARK`: Evaluate the performance of your model on different
#' instance types.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken A token that you can specify to return more results from the list.
#' Specify this field if you have a token that was returned from a previous
#' request.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_inference_recommendations_job_steps
sagemaker_list_inference_recommendations_job_steps <- function(JobName, Status = NULL, StepType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInferenceRecommendationsJobSteps",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Steps"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_inference_recommendations_job_steps_input(JobName = JobName, Status = Status, StepType = StepType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_inference_recommendations_job_steps_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_inference_recommendations_job_steps <- sagemaker_list_inference_recommendations_job_steps

#' Lists recommendation jobs that satisfy various filters
#'
#' @description
#' Lists recommendation jobs that satisfy various filters.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_inference_recommendations_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_inference_recommendations_jobs/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only jobs created after the specified time
#' (timestamp).
#' @param CreationTimeBefore A filter that returns only jobs created before the specified time
#' (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only jobs that were last modified after the
#' specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only jobs that were last modified before the
#' specified time (timestamp).
#' @param NameContains A string in the job name. This filter returns only recommendations whose
#' name contains the specified string.
#' @param StatusEquals A filter that retrieves only inference recommendations jobs with a
#' specific status.
#' @param SortBy The parameter by which to sort the results.
#' @param SortOrder The sort order for the results.
#' @param NextToken If the response to a previous `ListInferenceRecommendationsJobsRequest`
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of recommendations, use the token in the next request.
#' @param MaxResults The maximum number of recommendations to return in the response.
#' @param ModelNameEquals A filter that returns only jobs that were created for this model.
#' @param ModelPackageVersionArnEquals A filter that returns only jobs that were created for this versioned
#' model package.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_inference_recommendations_jobs
sagemaker_list_inference_recommendations_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, ModelNameEquals = NULL, ModelPackageVersionArnEquals = NULL) {
  op <- new_operation(
    name = "ListInferenceRecommendationsJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "InferenceRecommendationsJobs"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_inference_recommendations_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, ModelNameEquals = ModelNameEquals, ModelPackageVersionArnEquals = ModelPackageVersionArnEquals)
  output <- .sagemaker$list_inference_recommendations_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_inference_recommendations_jobs <- sagemaker_list_inference_recommendations_jobs

#' Gets a list of labeling jobs
#'
#' @description
#' Gets a list of labeling jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_labeling_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_labeling_jobs/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only labeling jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only labeling jobs created before the specified
#' time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only labeling jobs modified after the specified
#' time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only labeling jobs modified before the specified
#' time (timestamp).
#' @param MaxResults The maximum number of labeling jobs to return in each page of the
#' response.
#' @param NextToken If the result of the previous
#' [`list_labeling_jobs`][sagemaker_list_labeling_jobs] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of labeling jobs, use the token in the next request.
#' @param NameContains A string in the labeling job name. This filter returns only labeling
#' jobs whose name contains the specified string.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param StatusEquals A filter that retrieves only labeling jobs with a specific status.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_labeling_jobs
sagemaker_list_labeling_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NextToken = NULL, NameContains = NULL, SortBy = NULL, SortOrder = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListLabelingJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LabelingJobSummaryList"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_labeling_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NextToken = NextToken, NameContains = NameContains, SortBy = SortBy, SortOrder = SortOrder, StatusEquals = StatusEquals)
  output <- .sagemaker$list_labeling_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_labeling_jobs <- sagemaker_list_labeling_jobs

#' Gets a list of labeling jobs assigned to a specified work team
#'
#' @description
#' Gets a list of labeling jobs assigned to a specified work team.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_labeling_jobs_for_workteam/](https://www.paws-r-sdk.com/docs/sagemaker_list_labeling_jobs_for_workteam/) for full documentation.
#'
#' @param WorkteamArn &#91;required&#93; The Amazon Resource Name (ARN) of the work team for which you want to
#' see labeling jobs for.
#' @param MaxResults The maximum number of labeling jobs to return in each page of the
#' response.
#' @param NextToken If the result of the previous
#' [`list_labeling_jobs_for_workteam`][sagemaker_list_labeling_jobs_for_workteam]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of labeling jobs, use the token in the next request.
#' @param CreationTimeAfter A filter that returns only labeling jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only labeling jobs created before the specified
#' time (timestamp).
#' @param JobReferenceCodeContains A filter the limits jobs to only the ones whose job reference code
#' contains the specified string.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_labeling_jobs_for_workteam
sagemaker_list_labeling_jobs_for_workteam <- function(WorkteamArn, MaxResults = NULL, NextToken = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, JobReferenceCodeContains = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListLabelingJobsForWorkteam",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LabelingJobSummaryList"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_labeling_jobs_for_workteam_input(WorkteamArn = WorkteamArn, MaxResults = MaxResults, NextToken = NextToken, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, JobReferenceCodeContains = JobReferenceCodeContains, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_labeling_jobs_for_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_labeling_jobs_for_workteam <- sagemaker_list_labeling_jobs_for_workteam

#' A list of lineage groups shared with your Amazon Web Services account
#'
#' @description
#' A list of lineage groups shared with your Amazon Web Services account. For more information, see [Cross-Account Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html) in the *Amazon SageMaker Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_lineage_groups/](https://www.paws-r-sdk.com/docs/sagemaker_list_lineage_groups/) for full documentation.
#'
#' @param CreatedAfter A timestamp to filter against lineage groups created after a certain
#' point in time.
#' @param CreatedBefore A timestamp to filter against lineage groups created before a certain
#' point in time.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#' @param NextToken If the response is truncated, SageMaker returns this token. To retrieve
#' the next set of algorithms, use it in the subsequent request.
#' @param MaxResults The maximum number of endpoints to return in the response. This value
#' defaults to 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_lineage_groups
sagemaker_list_lineage_groups <- function(CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLineageGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "LineageGroupSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_lineage_groups_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_lineage_groups_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_lineage_groups <- sagemaker_list_lineage_groups

#' Lists all MLflow Tracking Servers
#'
#' @description
#' Lists all MLflow Tracking Servers.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_mlflow_tracking_servers/](https://www.paws-r-sdk.com/docs/sagemaker_list_mlflow_tracking_servers/) for full documentation.
#'
#' @param CreatedAfter Use the `CreatedAfter` filter to only list tracking servers created
#' after a specific date and time. Listed tracking servers are shown with a
#' date and time such as `"2024-03-16T01:46:56+00:00"`. The `CreatedAfter`
#' parameter takes in a Unix timestamp. To convert a date and time into a
#' Unix timestamp, see [EpochConverter](https://www.epochconverter.com/).
#' @param CreatedBefore Use the `CreatedBefore` filter to only list tracking servers created
#' before a specific date and time. Listed tracking servers are shown with
#' a date and time such as `"2024-03-16T01:46:56+00:00"`. The
#' `CreatedBefore` parameter takes in a Unix timestamp. To convert a date
#' and time into a Unix timestamp, see
#' [EpochConverter](https://www.epochconverter.com/).
#' @param TrackingServerStatus Filter for tracking servers with a specified creation status.
#' @param MlflowVersion Filter for tracking servers using the specified MLflow version.
#' @param SortBy Filter for trackings servers sorting by name, creation time, or creation
#' status.
#' @param SortOrder Change the order of the listed tracking servers. By default, tracking
#' servers are listed in `Descending` order by creation time. To change the
#' list order, you can specify `SortOrder` to be `Ascending`.
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults The maximum number of tracking servers to list.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_mlflow_tracking_servers
sagemaker_list_mlflow_tracking_servers <- function(CreatedAfter = NULL, CreatedBefore = NULL, TrackingServerStatus = NULL, MlflowVersion = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMlflowTrackingServers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "TrackingServerSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_mlflow_tracking_servers_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, TrackingServerStatus = TrackingServerStatus, MlflowVersion = MlflowVersion, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_mlflow_tracking_servers_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_mlflow_tracking_servers <- sagemaker_list_mlflow_tracking_servers

#' Lists model bias jobs definitions that satisfy various filters
#'
#' @description
#' Lists model bias jobs definitions that satisfy various filters.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_model_bias_job_definitions/](https://www.paws-r-sdk.com/docs/sagemaker_list_model_bias_job_definitions/) for full documentation.
#'
#' @param EndpointName Name of the endpoint to monitor for model bias.
#' @param SortBy Whether to sort results by the `Name` or `CreationTime` field. The
#' default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken The token returned if the response is truncated. To retrieve the next
#' set of job executions, use it in the next request.
#' @param MaxResults The maximum number of model bias jobs to return in the response. The
#' default value is 10.
#' @param NameContains Filter for model bias jobs whose name contains a specified string.
#' @param CreationTimeBefore A filter that returns only model bias jobs created before a specified
#' time.
#' @param CreationTimeAfter A filter that returns only model bias jobs created after a specified
#' time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_bias_job_definitions
sagemaker_list_model_bias_job_definitions <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListModelBiasJobDefinitions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "JobDefinitionSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_model_bias_job_definitions_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_model_bias_job_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_bias_job_definitions <- sagemaker_list_model_bias_job_definitions

#' List the export jobs for the Amazon SageMaker Model Card
#'
#' @description
#' List the export jobs for the Amazon SageMaker Model Card.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_model_card_export_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_model_card_export_jobs/) for full documentation.
#'
#' @param ModelCardName &#91;required&#93; List export jobs for the model card with the specified name.
#' @param ModelCardVersion List export jobs for the model card with the specified version.
#' @param CreationTimeAfter Only list model card export jobs that were created after the time
#' specified.
#' @param CreationTimeBefore Only list model card export jobs that were created before the time
#' specified.
#' @param ModelCardExportJobNameContains Only list model card export jobs with names that contain the specified
#' string.
#' @param StatusEquals Only list model card export jobs with the specified status.
#' @param SortBy Sort model card export jobs by either name or creation time. Sorts by
#' creation time by default.
#' @param SortOrder Sort model card export jobs by ascending or descending order.
#' @param NextToken If the response to a previous
#' [`list_model_card_export_jobs`][sagemaker_list_model_card_export_jobs]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of model card export jobs, use the token in the next
#' request.
#' @param MaxResults The maximum number of model card export jobs to list.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_card_export_jobs
sagemaker_list_model_card_export_jobs <- function(ModelCardName, ModelCardVersion = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, ModelCardExportJobNameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListModelCardExportJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ModelCardExportJobSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_model_card_export_jobs_input(ModelCardName = ModelCardName, ModelCardVersion = ModelCardVersion, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, ModelCardExportJobNameContains = ModelCardExportJobNameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_model_card_export_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_card_export_jobs <- sagemaker_list_model_card_export_jobs

#' List existing versions of an Amazon SageMaker Model Card
#'
#' @description
#' List existing versions of an Amazon SageMaker Model Card.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_model_card_versions/](https://www.paws-r-sdk.com/docs/sagemaker_list_model_card_versions/) for full documentation.
#'
#' @param CreationTimeAfter Only list model card versions that were created after the time
#' specified.
#' @param CreationTimeBefore Only list model card versions that were created before the time
#' specified.
#' @param MaxResults The maximum number of model card versions to list.
#' @param ModelCardName &#91;required&#93; List model card versions for the model card with the specified name or
#' Amazon Resource Name (ARN).
#' @param ModelCardStatus Only list model card versions with the specified approval status.
#' @param NextToken If the response to a previous
#' [`list_model_card_versions`][sagemaker_list_model_card_versions] request
#' was truncated, the response includes a `NextToken`. To retrieve the next
#' set of model card versions, use the token in the next request.
#' @param SortBy Sort listed model card versions by version. Sorts by version by default.
#' @param SortOrder Sort model card versions by ascending or descending order.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_card_versions
sagemaker_list_model_card_versions <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, ModelCardName, ModelCardStatus = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListModelCardVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ModelCardVersionSummaryList"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_model_card_versions_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, ModelCardName = ModelCardName, ModelCardStatus = ModelCardStatus, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_model_card_versions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_card_versions <- sagemaker_list_model_card_versions

#' List existing model cards
#'
#' @description
#' List existing model cards.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_model_cards/](https://www.paws-r-sdk.com/docs/sagemaker_list_model_cards/) for full documentation.
#'
#' @param CreationTimeAfter Only list model cards that were created after the time specified.
#' @param CreationTimeBefore Only list model cards that were created before the time specified.
#' @param MaxResults The maximum number of model cards to list.
#' @param NameContains Only list model cards with names that contain the specified string.
#' @param ModelCardStatus Only list model cards with the specified approval status.
#' @param NextToken If the response to a previous
#' [`list_model_cards`][sagemaker_list_model_cards] request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of model
#' cards, use the token in the next request.
#' @param SortBy Sort model cards by either name or creation time. Sorts by creation time
#' by default.
#' @param SortOrder Sort model cards by ascending or descending order.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_cards
sagemaker_list_model_cards <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, ModelCardStatus = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListModelCards",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ModelCardSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_model_cards_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, ModelCardStatus = ModelCardStatus, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_model_cards_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_cards <- sagemaker_list_model_cards

#' Lists model explainability job definitions that satisfy various filters
#'
#' @description
#' Lists model explainability job definitions that satisfy various filters.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_model_explainability_job_definitions/](https://www.paws-r-sdk.com/docs/sagemaker_list_model_explainability_job_definitions/) for full documentation.
#'
#' @param EndpointName Name of the endpoint to monitor for model explainability.
#' @param SortBy Whether to sort results by the `Name` or `CreationTime` field. The
#' default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken The token returned if the response is truncated. To retrieve the next
#' set of job executions, use it in the next request.
#' @param MaxResults The maximum number of jobs to return in the response. The default value
#' is 10.
#' @param NameContains Filter for model explainability jobs whose name contains a specified
#' string.
#' @param CreationTimeBefore A filter that returns only model explainability jobs created before a
#' specified time.
#' @param CreationTimeAfter A filter that returns only model explainability jobs created after a
#' specified time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_explainability_job_definitions
sagemaker_list_model_explainability_job_definitions <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListModelExplainabilityJobDefinitions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "JobDefinitionSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_model_explainability_job_definitions_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_model_explainability_job_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_explainability_job_definitions <- sagemaker_list_model_explainability_job_definitions

#' Lists the domain, framework, task, and model name of standard machine
#' learning models found in common model zoos
#'
#' @description
#' Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_model_metadata/](https://www.paws-r-sdk.com/docs/sagemaker_list_model_metadata/) for full documentation.
#'
#' @param SearchExpression One or more filters that searches for the specified resource or
#' resources in a search. All resource objects that satisfy the
#' expression's condition are included in the search results. Specify the
#' Framework, FrameworkVersion, Domain or Task to filter supported. Filter
#' names and values are case-sensitive.
#' @param NextToken If the response to a previous `ListModelMetadataResponse` request was
#' truncated, the response includes a NextToken. To retrieve the next set
#' of model metadata, use the token in the next request.
#' @param MaxResults The maximum number of models to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_metadata
sagemaker_list_model_metadata <- function(SearchExpression = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListModelMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ModelMetadataSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_model_metadata_input(SearchExpression = SearchExpression, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_model_metadata_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_metadata <- sagemaker_list_model_metadata

#' Gets a list of the model groups in your Amazon Web Services account
#'
#' @description
#' Gets a list of the model groups in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_model_package_groups/](https://www.paws-r-sdk.com/docs/sagemaker_list_model_package_groups/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only model groups created after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only model groups created before the specified
#' time.
#' @param MaxResults The maximum number of results to return in the response.
#' @param NameContains A string in the model group name. This filter returns only model groups
#' whose name contains the specified string.
#' @param NextToken If the result of the previous
#' [`list_model_package_groups`][sagemaker_list_model_package_groups]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of model groups, use the token in the next request.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param CrossAccountFilterOption A filter that returns either model groups shared with you or model
#' groups in your own account. When the value is `CrossAccount`, the
#' results show the resources made discoverable to you from other accounts.
#' When the value is `SameAccount` or `null`, the results show resources
#' from your account. The default is `SameAccount`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_package_groups
sagemaker_list_model_package_groups <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL, CrossAccountFilterOption = NULL) {
  op <- new_operation(
    name = "ListModelPackageGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ModelPackageGroupSummaryList"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_model_package_groups_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder, CrossAccountFilterOption = CrossAccountFilterOption)
  output <- .sagemaker$list_model_package_groups_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_package_groups <- sagemaker_list_model_package_groups

#' Lists the model packages that have been created
#'
#' @description
#' Lists the model packages that have been created.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_model_packages/](https://www.paws-r-sdk.com/docs/sagemaker_list_model_packages/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only model packages created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only model packages created before the specified
#' time (timestamp).
#' @param MaxResults The maximum number of model packages to return in the response.
#' @param NameContains A string in the model package name. This filter returns only model
#' packages whose name contains the specified string.
#' @param ModelApprovalStatus A filter that returns only the model packages with the specified
#' approval status.
#' @param ModelPackageGroupName A filter that returns only model versions that belong to the specified
#' model group.
#' @param ModelPackageType A filter that returns only the model packages of the specified type.
#' This can be one of the following values.
#' 
#' -   `UNVERSIONED` - List only unversioined models. This is the default
#'     value if no `ModelPackageType` is specified.
#' 
#' -   `VERSIONED` - List only versioned models.
#' 
#' -   `BOTH` - List both versioned and unversioned models.
#' @param NextToken If the response to a previous
#' [`list_model_packages`][sagemaker_list_model_packages] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of model packages, use the token in the next request.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_packages
sagemaker_list_model_packages <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, ModelApprovalStatus = NULL, ModelPackageGroupName = NULL, ModelPackageType = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListModelPackages",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ModelPackageSummaryList"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_model_packages_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, ModelApprovalStatus = ModelApprovalStatus, ModelPackageGroupName = ModelPackageGroupName, ModelPackageType = ModelPackageType, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_model_packages_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_packages <- sagemaker_list_model_packages

#' Gets a list of model quality monitoring job definitions in your account
#'
#' @description
#' Gets a list of model quality monitoring job definitions in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_model_quality_job_definitions/](https://www.paws-r-sdk.com/docs/sagemaker_list_model_quality_job_definitions/) for full documentation.
#'
#' @param EndpointName A filter that returns only model quality monitoring job definitions that
#' are associated with the specified endpoint.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken If the result of the previous
#' [`list_model_quality_job_definitions`][sagemaker_list_model_quality_job_definitions]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of model quality monitoring job definitions, use the token
#' in the next request.
#' @param MaxResults The maximum number of results to return in a call to
#' [`list_model_quality_job_definitions`][sagemaker_list_model_quality_job_definitions].
#' @param NameContains A string in the transform job name. This filter returns only model
#' quality monitoring job definitions whose name contains the specified
#' string.
#' @param CreationTimeBefore A filter that returns only model quality monitoring job definitions
#' created before the specified time.
#' @param CreationTimeAfter A filter that returns only model quality monitoring job definitions
#' created after the specified time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_quality_job_definitions
sagemaker_list_model_quality_job_definitions <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListModelQualityJobDefinitions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "JobDefinitionSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_model_quality_job_definitions_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_model_quality_job_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_quality_job_definitions <- sagemaker_list_model_quality_job_definitions

#' Lists models created with the CreateModel API
#'
#' @description
#' Lists models created with the [`create_model`][sagemaker_create_model] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_models/](https://www.paws-r-sdk.com/docs/sagemaker_list_models/) for full documentation.
#'
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the response to a previous [`list_models`][sagemaker_list_models]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of models, use the token in the next request.
#' @param MaxResults The maximum number of models to return in the response.
#' @param NameContains A string in the model name. This filter returns only models whose name
#' contains the specified string.
#' @param CreationTimeBefore A filter that returns only models created before the specified time
#' (timestamp).
#' @param CreationTimeAfter A filter that returns only models with a creation time greater than or
#' equal to the specified time (timestamp).
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_models
sagemaker_list_models <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListModels",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "Models", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_models_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_models_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_models <- sagemaker_list_models

#' Gets a list of past alerts in a model monitoring schedule
#'
#' @description
#' Gets a list of past alerts in a model monitoring schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_monitoring_alert_history/](https://www.paws-r-sdk.com/docs/sagemaker_list_monitoring_alert_history/) for full documentation.
#'
#' @param MonitoringScheduleName The name of a monitoring schedule.
#' @param MonitoringAlertName The name of a monitoring alert.
#' @param SortBy The field used to sort results. The default is `CreationTime`.
#' @param SortOrder The sort order, whether `Ascending` or `Descending`, of the alert
#' history. The default is `Descending`.
#' @param NextToken If the result of the previous
#' [`list_monitoring_alert_history`][sagemaker_list_monitoring_alert_history]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of alerts in the history, use the token in the next
#' request.
#' @param MaxResults The maximum number of results to display. The default is 100.
#' @param CreationTimeBefore A filter that returns only alerts created on or before the specified
#' time.
#' @param CreationTimeAfter A filter that returns only alerts created on or after the specified
#' time.
#' @param StatusEquals A filter that retrieves only alerts with a specific status.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_monitoring_alert_history
sagemaker_list_monitoring_alert_history <- function(MonitoringScheduleName = NULL, MonitoringAlertName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListMonitoringAlertHistory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "MonitoringAlertHistory"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_monitoring_alert_history_input(MonitoringScheduleName = MonitoringScheduleName, MonitoringAlertName = MonitoringAlertName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, StatusEquals = StatusEquals)
  output <- .sagemaker$list_monitoring_alert_history_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_monitoring_alert_history <- sagemaker_list_monitoring_alert_history

#' Gets the alerts for a single monitoring schedule
#'
#' @description
#' Gets the alerts for a single monitoring schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_monitoring_alerts/](https://www.paws-r-sdk.com/docs/sagemaker_list_monitoring_alerts/) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of a monitoring schedule.
#' @param NextToken If the result of the previous
#' [`list_monitoring_alerts`][sagemaker_list_monitoring_alerts] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of alerts in the history, use the token in the next request.
#' @param MaxResults The maximum number of results to display. The default is 100.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_monitoring_alerts
sagemaker_list_monitoring_alerts <- function(MonitoringScheduleName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMonitoringAlerts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "MonitoringAlertSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_monitoring_alerts_input(MonitoringScheduleName = MonitoringScheduleName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_monitoring_alerts_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_monitoring_alerts <- sagemaker_list_monitoring_alerts

#' Returns list of all monitoring job executions
#'
#' @description
#' Returns list of all monitoring job executions.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_monitoring_executions/](https://www.paws-r-sdk.com/docs/sagemaker_list_monitoring_executions/) for full documentation.
#'
#' @param MonitoringScheduleName Name of a specific schedule to fetch jobs for.
#' @param EndpointName Name of a specific endpoint to fetch jobs for.
#' @param SortBy Whether to sort the results by the `Status`, `CreationTime`, or
#' `ScheduledTime` field. The default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken The token returned if the response is truncated. To retrieve the next
#' set of job executions, use it in the next request.
#' @param MaxResults The maximum number of jobs to return in the response. The default value
#' is 10.
#' @param ScheduledTimeBefore Filter for jobs scheduled before a specified time.
#' @param ScheduledTimeAfter Filter for jobs scheduled after a specified time.
#' @param CreationTimeBefore A filter that returns only jobs created before a specified time.
#' @param CreationTimeAfter A filter that returns only jobs created after a specified time.
#' @param LastModifiedTimeBefore A filter that returns only jobs modified after a specified time.
#' @param LastModifiedTimeAfter A filter that returns only jobs modified before a specified time.
#' @param StatusEquals A filter that retrieves only jobs with a specific status.
#' @param MonitoringJobDefinitionName Gets a list of the monitoring job runs of the specified monitoring job
#' definitions.
#' @param MonitoringTypeEquals A filter that returns only the monitoring job runs of the specified
#' monitoring type.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_monitoring_executions
sagemaker_list_monitoring_executions <- function(MonitoringScheduleName = NULL, EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, ScheduledTimeBefore = NULL, ScheduledTimeAfter = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL, MonitoringJobDefinitionName = NULL, MonitoringTypeEquals = NULL) {
  op <- new_operation(
    name = "ListMonitoringExecutions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "MonitoringExecutionSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_monitoring_executions_input(MonitoringScheduleName = MonitoringScheduleName, EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, ScheduledTimeBefore = ScheduledTimeBefore, ScheduledTimeAfter = ScheduledTimeAfter, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals, MonitoringJobDefinitionName = MonitoringJobDefinitionName, MonitoringTypeEquals = MonitoringTypeEquals)
  output <- .sagemaker$list_monitoring_executions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_monitoring_executions <- sagemaker_list_monitoring_executions

#' Returns list of all monitoring schedules
#'
#' @description
#' Returns list of all monitoring schedules.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_monitoring_schedules/](https://www.paws-r-sdk.com/docs/sagemaker_list_monitoring_schedules/) for full documentation.
#'
#' @param EndpointName Name of a specific endpoint to fetch schedules for.
#' @param SortBy Whether to sort the results by the `Status`, `CreationTime`, or
#' `ScheduledTime` field. The default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken The token returned if the response is truncated. To retrieve the next
#' set of job executions, use it in the next request.
#' @param MaxResults The maximum number of jobs to return in the response. The default value
#' is 10.
#' @param NameContains Filter for monitoring schedules whose name contains a specified string.
#' @param CreationTimeBefore A filter that returns only monitoring schedules created before a
#' specified time.
#' @param CreationTimeAfter A filter that returns only monitoring schedules created after a
#' specified time.
#' @param LastModifiedTimeBefore A filter that returns only monitoring schedules modified before a
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only monitoring schedules modified after a
#' specified time.
#' @param StatusEquals A filter that returns only monitoring schedules modified before a
#' specified time.
#' @param MonitoringJobDefinitionName Gets a list of the monitoring schedules for the specified monitoring job
#' definition.
#' @param MonitoringTypeEquals A filter that returns only the monitoring schedules for the specified
#' monitoring type.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_monitoring_schedules
sagemaker_list_monitoring_schedules <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL, MonitoringJobDefinitionName = NULL, MonitoringTypeEquals = NULL) {
  op <- new_operation(
    name = "ListMonitoringSchedules",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "MonitoringScheduleSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_monitoring_schedules_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals, MonitoringJobDefinitionName = MonitoringJobDefinitionName, MonitoringTypeEquals = MonitoringTypeEquals)
  output <- .sagemaker$list_monitoring_schedules_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_monitoring_schedules <- sagemaker_list_monitoring_schedules

#' Lists notebook instance lifestyle configurations created with the
#' CreateNotebookInstanceLifecycleConfig API
#'
#' @description
#' Lists notebook instance lifestyle configurations created with the [`create_notebook_instance_lifecycle_config`][sagemaker_create_notebook_instance_lifecycle_config] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_notebook_instance_lifecycle_configs/](https://www.paws-r-sdk.com/docs/sagemaker_list_notebook_instance_lifecycle_configs/) for full documentation.
#'
#' @param NextToken If the result of a
#' [`list_notebook_instance_lifecycle_configs`][sagemaker_list_notebook_instance_lifecycle_configs]
#' request was truncated, the response includes a `NextToken`. To get the
#' next set of lifecycle configurations, use the token in the next request.
#' @param MaxResults The maximum number of lifecycle configurations to return in the
#' response.
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results.
#' @param NameContains A string in the lifecycle configuration name. This filter returns only
#' lifecycle configurations whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only lifecycle configurations that were created
#' before the specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only lifecycle configurations that were created
#' after the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only lifecycle configurations that were modified
#' before the specified time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only lifecycle configurations that were modified
#' after the specified time (timestamp).
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_notebook_instance_lifecycle_configs
sagemaker_list_notebook_instance_lifecycle_configs <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL) {
  op <- new_operation(
    name = "ListNotebookInstanceLifecycleConfigs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "NotebookInstanceLifecycleConfigs"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_notebook_instance_lifecycle_configs_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter)
  output <- .sagemaker$list_notebook_instance_lifecycle_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_notebook_instance_lifecycle_configs <- sagemaker_list_notebook_instance_lifecycle_configs

#' Returns a list of the SageMaker AI notebook instances in the requester's
#' account in an Amazon Web Services Region
#'
#' @description
#' Returns a list of the SageMaker AI notebook instances in the requester's account in an Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_notebook_instances/](https://www.paws-r-sdk.com/docs/sagemaker_list_notebook_instances/) for full documentation.
#'
#' @param NextToken If the previous call to the
#' [`list_notebook_instances`][sagemaker_list_notebook_instances] is
#' truncated, the response includes a `NextToken`. You can use this token
#' in your subsequent
#' [`list_notebook_instances`][sagemaker_list_notebook_instances] request
#' to fetch the next set of notebook instances.
#' 
#' You might specify a filter or a sort order in your request. When
#' response is truncated, you must use the same values for the filer and
#' sort order in the next request.
#' @param MaxResults The maximum number of notebook instances to return.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results.
#' @param NameContains A string in the notebook instances' name. This filter returns only
#' notebook instances whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only notebook instances that were created before
#' the specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only notebook instances that were created after
#' the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only notebook instances that were modified before
#' the specified time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only notebook instances that were modified after
#' the specified time (timestamp).
#' @param StatusEquals A filter that returns only notebook instances with the specified status.
#' @param NotebookInstanceLifecycleConfigNameContains A string in the name of a notebook instances lifecycle configuration
#' associated with this notebook instance. This filter returns only
#' notebook instances associated with a lifecycle configuration with a name
#' that contains the specified string.
#' @param DefaultCodeRepositoryContains A string in the name or URL of a Git repository associated with this
#' notebook instance. This filter returns only notebook instances
#' associated with a git repository with a name that contains the specified
#' string.
#' @param AdditionalCodeRepositoryEquals A filter that returns only notebook instances with associated with the
#' specified git repository.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_notebook_instances
sagemaker_list_notebook_instances <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL, NotebookInstanceLifecycleConfigNameContains = NULL, DefaultCodeRepositoryContains = NULL, AdditionalCodeRepositoryEquals = NULL) {
  op <- new_operation(
    name = "ListNotebookInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "NotebookInstances", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_notebook_instances_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals, NotebookInstanceLifecycleConfigNameContains = NotebookInstanceLifecycleConfigNameContains, DefaultCodeRepositoryContains = DefaultCodeRepositoryContains, AdditionalCodeRepositoryEquals = AdditionalCodeRepositoryEquals)
  output <- .sagemaker$list_notebook_instances_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_notebook_instances <- sagemaker_list_notebook_instances

#' Lists the optimization jobs in your account and their properties
#'
#' @description
#' Lists the optimization jobs in your account and their properties.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_optimization_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_optimization_jobs/) for full documentation.
#'
#' @param NextToken A token that you use to get the next set of results following a
#' truncated response. If the response to the previous request was
#' truncated, that response provides the value for this token.
#' @param MaxResults The maximum number of optimization jobs to return in the response. The
#' default is 50.
#' @param CreationTimeAfter Filters the results to only those optimization jobs that were created
#' after the specified time.
#' @param CreationTimeBefore Filters the results to only those optimization jobs that were created
#' before the specified time.
#' @param LastModifiedTimeAfter Filters the results to only those optimization jobs that were updated
#' after the specified time.
#' @param LastModifiedTimeBefore Filters the results to only those optimization jobs that were updated
#' before the specified time.
#' @param OptimizationContains Filters the results to only those optimization jobs that apply the
#' specified optimization techniques. You can specify either `Quantization`
#' or `Compilation`.
#' @param NameContains Filters the results to only those optimization jobs with a name that
#' contains the specified string.
#' @param StatusEquals Filters the results to only those optimization jobs with the specified
#' status.
#' @param SortBy The field by which to sort the optimization jobs in the response. The
#' default is `CreationTime`
#' @param SortOrder The sort order for results. The default is `Ascending`
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_optimization_jobs
sagemaker_list_optimization_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, OptimizationContains = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListOptimizationJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "OptimizationJobSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_optimization_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, OptimizationContains = OptimizationContains, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_optimization_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_optimization_jobs <- sagemaker_list_optimization_jobs

#' Lists all of the SageMaker Partner AI Apps in an account
#'
#' @description
#' Lists all of the SageMaker Partner AI Apps in an account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_partner_apps/](https://www.paws-r-sdk.com/docs/sagemaker_list_partner_apps/) for full documentation.
#'
#' @param MaxResults This parameter defines the maximum number of results that can be
#' returned in a single response. The `MaxResults` parameter is an upper
#' bound, not a target. If there are more results available than the value
#' specified, a `NextToken` is provided in the response. The `NextToken`
#' indicates that the user should get the next set of results by providing
#' this token as a part of a subsequent call. The default value for
#' `MaxResults` is 10.
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_partner_apps
sagemaker_list_partner_apps <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPartnerApps",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Summaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_partner_apps_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_partner_apps_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_partner_apps <- sagemaker_list_partner_apps

#' Gets a list of PipeLineExecutionStep objects
#'
#' @description
#' Gets a list of `PipeLineExecutionStep` objects.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_pipeline_execution_steps/](https://www.paws-r-sdk.com/docs/sagemaker_list_pipeline_execution_steps/) for full documentation.
#'
#' @param PipelineExecutionArn The Amazon Resource Name (ARN) of the pipeline execution.
#' @param NextToken If the result of the previous
#' [`list_pipeline_execution_steps`][sagemaker_list_pipeline_execution_steps]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of pipeline execution steps, use the token in the next
#' request.
#' @param MaxResults The maximum number of pipeline execution steps to return in the
#' response.
#' @param SortOrder The field by which to sort results. The default is `CreatedTime`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_pipeline_execution_steps
sagemaker_list_pipeline_execution_steps <- function(PipelineExecutionArn = NULL, NextToken = NULL, MaxResults = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListPipelineExecutionSteps",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "PipelineExecutionSteps"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_pipeline_execution_steps_input(PipelineExecutionArn = PipelineExecutionArn, NextToken = NextToken, MaxResults = MaxResults, SortOrder = SortOrder)
  output <- .sagemaker$list_pipeline_execution_steps_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_pipeline_execution_steps <- sagemaker_list_pipeline_execution_steps

#' Gets a list of the pipeline executions
#'
#' @description
#' Gets a list of the pipeline executions.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_pipeline_executions/](https://www.paws-r-sdk.com/docs/sagemaker_list_pipeline_executions/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name or Amazon Resource Name (ARN) of the pipeline.
#' @param CreatedAfter A filter that returns the pipeline executions that were created after a
#' specified time.
#' @param CreatedBefore A filter that returns the pipeline executions that were created before a
#' specified time.
#' @param SortBy The field by which to sort results. The default is `CreatedTime`.
#' @param SortOrder The sort order for results.
#' @param NextToken If the result of the previous
#' [`list_pipeline_executions`][sagemaker_list_pipeline_executions] request
#' was truncated, the response includes a `NextToken`. To retrieve the next
#' set of pipeline executions, use the token in the next request.
#' @param MaxResults The maximum number of pipeline executions to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_pipeline_executions
sagemaker_list_pipeline_executions <- function(PipelineName, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPipelineExecutions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "PipelineExecutionSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_pipeline_executions_input(PipelineName = PipelineName, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_pipeline_executions_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_pipeline_executions <- sagemaker_list_pipeline_executions

#' Gets a list of parameters for a pipeline execution
#'
#' @description
#' Gets a list of parameters for a pipeline execution.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_pipeline_parameters_for_execution/](https://www.paws-r-sdk.com/docs/sagemaker_list_pipeline_parameters_for_execution/) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#' @param NextToken If the result of the previous
#' [`list_pipeline_parameters_for_execution`][sagemaker_list_pipeline_parameters_for_execution]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of parameters, use the token in the next request.
#' @param MaxResults The maximum number of parameters to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_pipeline_parameters_for_execution
sagemaker_list_pipeline_parameters_for_execution <- function(PipelineExecutionArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPipelineParametersForExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "PipelineParameters"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_pipeline_parameters_for_execution_input(PipelineExecutionArn = PipelineExecutionArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_pipeline_parameters_for_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_pipeline_parameters_for_execution <- sagemaker_list_pipeline_parameters_for_execution

#' Gets a list of pipelines
#'
#' @description
#' Gets a list of pipelines.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_pipelines/](https://www.paws-r-sdk.com/docs/sagemaker_list_pipelines/) for full documentation.
#'
#' @param PipelineNamePrefix The prefix of the pipeline name.
#' @param CreatedAfter A filter that returns the pipelines that were created after a specified
#' time.
#' @param CreatedBefore A filter that returns the pipelines that were created before a specified
#' time.
#' @param SortBy The field by which to sort results. The default is `CreatedTime`.
#' @param SortOrder The sort order for results.
#' @param NextToken If the result of the previous
#' [`list_pipelines`][sagemaker_list_pipelines] request was truncated, the
#' response includes a `NextToken`. To retrieve the next set of pipelines,
#' use the token in the next request.
#' @param MaxResults The maximum number of pipelines to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_pipelines
sagemaker_list_pipelines <- function(PipelineNamePrefix = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPipelines",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "PipelineSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_pipelines_input(PipelineNamePrefix = PipelineNamePrefix, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_pipelines_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_pipelines <- sagemaker_list_pipelines

#' Lists processing jobs that satisfy various filters
#'
#' @description
#' Lists processing jobs that satisfy various filters.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_processing_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_processing_jobs/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only processing jobs created after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only processing jobs created after the specified
#' time.
#' @param LastModifiedTimeAfter A filter that returns only processing jobs modified after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only processing jobs modified before the specified
#' time.
#' @param NameContains A string in the processing job name. This filter returns only processing
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only processing jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NextToken If the result of the previous
#' [`list_processing_jobs`][sagemaker_list_processing_jobs] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of processing jobs, use the token in the next request.
#' @param MaxResults The maximum number of processing jobs to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_processing_jobs
sagemaker_list_processing_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProcessingJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ProcessingJobSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_processing_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_processing_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_processing_jobs <- sagemaker_list_processing_jobs

#' Gets a list of the projects in an Amazon Web Services account
#'
#' @description
#' Gets a list of the projects in an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_projects/](https://www.paws-r-sdk.com/docs/sagemaker_list_projects/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns the projects that were created after a specified
#' time.
#' @param CreationTimeBefore A filter that returns the projects that were created before a specified
#' time.
#' @param MaxResults The maximum number of projects to return in the response.
#' @param NameContains A filter that returns the projects whose name contains a specified
#' string.
#' @param NextToken If the result of the previous [`list_projects`][sagemaker_list_projects]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of projects, use the token in the next request.
#' @param SortBy The field by which to sort results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_projects
sagemaker_list_projects <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListProjects",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_projects_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_projects_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_projects <- sagemaker_list_projects

#' Lists Amazon SageMaker Catalogs based on given filters and orders
#'
#' @description
#' Lists Amazon SageMaker Catalogs based on given filters and orders. The maximum number of `ResourceCatalog`s viewable is 1000.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_resource_catalogs/](https://www.paws-r-sdk.com/docs/sagemaker_list_resource_catalogs/) for full documentation.
#'
#' @param NameContains A string that partially matches one or more `ResourceCatalog`s names.
#' Filters `ResourceCatalog` by name.
#' @param CreationTimeAfter Use this parameter to search for `ResourceCatalog`s created after a
#' specific date and time.
#' @param CreationTimeBefore Use this parameter to search for `ResourceCatalog`s created before a
#' specific date and time.
#' @param SortOrder The order in which the resource catalogs are listed.
#' @param SortBy The value on which the resource catalog list is sorted.
#' @param MaxResults The maximum number of results returned by
#' [`list_resource_catalogs`][sagemaker_list_resource_catalogs].
#' @param NextToken A token to resume pagination of
#' [`list_resource_catalogs`][sagemaker_list_resource_catalogs] results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_resource_catalogs
sagemaker_list_resource_catalogs <- function(NameContains = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, SortOrder = NULL, SortBy = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListResourceCatalogs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ResourceCatalogs"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_resource_catalogs_input(NameContains = NameContains, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, SortOrder = SortOrder, SortBy = SortBy, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_resource_catalogs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_resource_catalogs <- sagemaker_list_resource_catalogs

#' Lists spaces
#'
#' @description
#' Lists spaces.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_spaces/](https://www.paws-r-sdk.com/docs/sagemaker_list_spaces/) for full documentation.
#'
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults This parameter defines the maximum number of results that can be return
#' in a single response. The `MaxResults` parameter is an upper bound, not
#' a target. If there are more results available than the value specified,
#' a `NextToken` is provided in the response. The `NextToken` indicates
#' that the user should get the next set of results by providing this token
#' as a part of a subsequent call. The default value for `MaxResults` is
#' 10.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param DomainIdEquals A parameter to search for the domain ID.
#' @param SpaceNameContains A parameter by which to filter the results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_spaces
sagemaker_list_spaces <- function(NextToken = NULL, MaxResults = NULL, SortOrder = NULL, SortBy = NULL, DomainIdEquals = NULL, SpaceNameContains = NULL) {
  op <- new_operation(
    name = "ListSpaces",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Spaces"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_spaces_input(NextToken = NextToken, MaxResults = MaxResults, SortOrder = SortOrder, SortBy = SortBy, DomainIdEquals = DomainIdEquals, SpaceNameContains = SpaceNameContains)
  output <- .sagemaker$list_spaces_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_spaces <- sagemaker_list_spaces

#' Lists devices allocated to the stage, containing detailed device
#' information and deployment status
#'
#' @description
#' Lists devices allocated to the stage, containing detailed device information and deployment status.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_stage_devices/](https://www.paws-r-sdk.com/docs/sagemaker_list_stage_devices/) for full documentation.
#'
#' @param NextToken The response from the last list when returning a list large enough to
#' neeed tokening.
#' @param MaxResults The maximum number of requests to select.
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan.
#' @param ExcludeDevicesDeployedInOtherStage Toggle for excluding devices deployed in other stages.
#' @param StageName &#91;required&#93; The name of the stage in the deployment.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_stage_devices
sagemaker_list_stage_devices <- function(NextToken = NULL, MaxResults = NULL, EdgeDeploymentPlanName, ExcludeDevicesDeployedInOtherStage = NULL, StageName) {
  op <- new_operation(
    name = "ListStageDevices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "DeviceDeploymentSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_stage_devices_input(NextToken = NextToken, MaxResults = MaxResults, EdgeDeploymentPlanName = EdgeDeploymentPlanName, ExcludeDevicesDeployedInOtherStage = ExcludeDevicesDeployedInOtherStage, StageName = StageName)
  output <- .sagemaker$list_stage_devices_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_stage_devices <- sagemaker_list_stage_devices

#' Lists the Amazon SageMaker AI Studio Lifecycle Configurations in your
#' Amazon Web Services Account
#'
#' @description
#' Lists the Amazon SageMaker AI Studio Lifecycle Configurations in your Amazon Web Services Account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_studio_lifecycle_configs/](https://www.paws-r-sdk.com/docs/sagemaker_list_studio_lifecycle_configs/) for full documentation.
#'
#' @param MaxResults The total number of items to return in the response. If the total number
#' of items available is more than the value specified, a `NextToken` is
#' provided in the response. To resume pagination, provide the `NextToken`
#' value in the as part of a subsequent call. The default value is 10.
#' @param NextToken If the previous call to ListStudioLifecycleConfigs didn't return the
#' full set of Lifecycle Configurations, the call returns a token for
#' getting the next set of Lifecycle Configurations.
#' @param NameContains A string in the Lifecycle Configuration name. This filter returns only
#' Lifecycle Configurations whose name contains the specified string.
#' @param AppTypeEquals A parameter to search for the App Type to which the Lifecycle
#' Configuration is attached.
#' @param CreationTimeBefore A filter that returns only Lifecycle Configurations created on or before
#' the specified time.
#' @param CreationTimeAfter A filter that returns only Lifecycle Configurations created on or after
#' the specified time.
#' @param ModifiedTimeBefore A filter that returns only Lifecycle Configurations modified before the
#' specified time.
#' @param ModifiedTimeAfter A filter that returns only Lifecycle Configurations modified after the
#' specified time.
#' @param SortBy The property used to sort results. The default value is CreationTime.
#' @param SortOrder The sort order. The default value is Descending.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_studio_lifecycle_configs
sagemaker_list_studio_lifecycle_configs <- function(MaxResults = NULL, NextToken = NULL, NameContains = NULL, AppTypeEquals = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, ModifiedTimeBefore = NULL, ModifiedTimeAfter = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListStudioLifecycleConfigs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "StudioLifecycleConfigs"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_studio_lifecycle_configs_input(MaxResults = MaxResults, NextToken = NextToken, NameContains = NameContains, AppTypeEquals = AppTypeEquals, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, ModifiedTimeBefore = ModifiedTimeBefore, ModifiedTimeAfter = ModifiedTimeAfter, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_studio_lifecycle_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_studio_lifecycle_configs <- sagemaker_list_studio_lifecycle_configs

#' Gets a list of the work teams that you are subscribed to in the Amazon
#' Web Services Marketplace
#'
#' @description
#' Gets a list of the work teams that you are subscribed to in the Amazon Web Services Marketplace. The list may be empty if no work team satisfies the filter specified in the `NameContains` parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_subscribed_workteams/](https://www.paws-r-sdk.com/docs/sagemaker_list_subscribed_workteams/) for full documentation.
#'
#' @param NameContains A string in the work team name. This filter returns only work teams
#' whose name contains the specified string.
#' @param NextToken If the result of the previous
#' [`list_subscribed_workteams`][sagemaker_list_subscribed_workteams]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of labeling jobs, use the token in the next request.
#' @param MaxResults The maximum number of work teams to return in each page of the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_subscribed_workteams
sagemaker_list_subscribed_workteams <- function(NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSubscribedWorkteams",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "SubscribedWorkteams"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_subscribed_workteams_input(NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_subscribed_workteams_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_subscribed_workteams <- sagemaker_list_subscribed_workteams

#' Returns the tags for the specified SageMaker resource
#'
#' @description
#' Returns the tags for the specified SageMaker resource.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_tags/](https://www.paws-r-sdk.com/docs/sagemaker_list_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' retrieve.
#' @param NextToken If the response to the previous [`list_tags`][sagemaker_list_tags]
#' request is truncated, SageMaker returns this token. To retrieve the next
#' set of tags, use it in the subsequent request.
#' @param MaxResults Maximum number of tags to return.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_tags
sagemaker_list_tags <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "Tags", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_tags_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_tags <- sagemaker_list_tags

#' Lists training jobs
#'
#' @description
#' Lists training jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_training_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_training_jobs/) for full documentation.
#'
#' @param NextToken If the result of the previous
#' [`list_training_jobs`][sagemaker_list_training_jobs] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of training jobs, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return in the response.
#' @param CreationTimeAfter A filter that returns only training jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only training jobs created before the specified
#' time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only training jobs modified after the specified
#' time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only training jobs modified before the specified
#' time (timestamp).
#' @param NameContains A string in the training job name. This filter returns only training
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only training jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param WarmPoolStatusEquals A filter that retrieves only training jobs with a specific warm pool
#' status.
#' @param TrainingPlanArnEquals The Amazon Resource Name (ARN); of the training plan to filter training
#' jobs by. For more information about reserving GPU capacity for your
#' SageMaker training jobs using Amazon SageMaker Training Plan, see
#' [`create_training_plan`][sagemaker_create_training_plan].
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_training_jobs
sagemaker_list_training_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, WarmPoolStatusEquals = NULL, TrainingPlanArnEquals = NULL) {
  op <- new_operation(
    name = "ListTrainingJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "TrainingJobSummaries", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_training_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, WarmPoolStatusEquals = WarmPoolStatusEquals, TrainingPlanArnEquals = TrainingPlanArnEquals)
  output <- .sagemaker$list_training_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_training_jobs <- sagemaker_list_training_jobs

#' Gets a list of TrainingJobSummary objects that describe the training
#' jobs that a hyperparameter tuning job launched
#'
#' @description
#' Gets a list of [TrainingJobSummary](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobSummary.html) objects that describe the training jobs that a hyperparameter tuning job launched.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_training_jobs_for_hyper_parameter_tuning_job/](https://www.paws-r-sdk.com/docs/sagemaker_list_training_jobs_for_hyper_parameter_tuning_job/) for full documentation.
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job whose training jobs you want to list.
#' @param NextToken If the result of the previous
#' [`list_training_jobs_for_hyper_parameter_tuning_job`][sagemaker_list_training_jobs_for_hyper_parameter_tuning_job]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of training jobs, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return. The default value is 10.
#' @param StatusEquals A filter that returns only training jobs with the specified status.
#' @param SortBy The field to sort results by. The default is `Name`.
#' 
#' If the value of this field is `FinalObjectiveMetricValue`, any training
#' jobs that did not return an objective metric are not listed.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_training_jobs_for_hyper_parameter_tuning_job
sagemaker_list_training_jobs_for_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName, NextToken = NULL, MaxResults = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListTrainingJobsForHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TrainingJobSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_training_jobs_for_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName, NextToken = NextToken, MaxResults = MaxResults, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_training_jobs_for_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_training_jobs_for_hyper_parameter_tuning_job <- sagemaker_list_training_jobs_for_hyper_parameter_tuning_job

#' Retrieves a list of training plans for the current account
#'
#' @description
#' Retrieves a list of training plans for the current account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_training_plans/](https://www.paws-r-sdk.com/docs/sagemaker_list_training_plans/) for full documentation.
#'
#' @param NextToken A token to continue pagination if more results are available.
#' @param MaxResults The maximum number of results to return in the response.
#' @param StartTimeAfter Filter to list only training plans with an actual start time after this
#' date.
#' @param StartTimeBefore Filter to list only training plans with an actual start time before this
#' date.
#' @param SortBy The training plan field to sort the results by (e.g., StartTime,
#' Status).
#' @param SortOrder The order to sort the results (Ascending or Descending).
#' @param Filters Additional filters to apply to the list of training plans.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_training_plans
sagemaker_list_training_plans <- function(NextToken = NULL, MaxResults = NULL, StartTimeAfter = NULL, StartTimeBefore = NULL, SortBy = NULL, SortOrder = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListTrainingPlans",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "TrainingPlanSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_training_plans_input(NextToken = NextToken, MaxResults = MaxResults, StartTimeAfter = StartTimeAfter, StartTimeBefore = StartTimeBefore, SortBy = SortBy, SortOrder = SortOrder, Filters = Filters)
  output <- .sagemaker$list_training_plans_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_training_plans <- sagemaker_list_training_plans

#' Lists transform jobs
#'
#' @description
#' Lists transform jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_transform_jobs/](https://www.paws-r-sdk.com/docs/sagemaker_list_transform_jobs/) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only transform jobs created after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only transform jobs created before the specified
#' time.
#' @param LastModifiedTimeAfter A filter that returns only transform jobs modified after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only transform jobs modified before the specified
#' time.
#' @param NameContains A string in the transform job name. This filter returns only transform
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only transform jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of the previous
#' [`list_transform_jobs`][sagemaker_list_transform_jobs] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of transform jobs, use the token in the next request.
#' @param MaxResults The maximum number of transform jobs to return in the response. The
#' default value is `10`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_transform_jobs
sagemaker_list_transform_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTransformJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransformJobSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_transform_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_transform_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_transform_jobs <- sagemaker_list_transform_jobs

#' Lists the trial components in your account
#'
#' @description
#' Lists the trial components in your account. You can sort the list by trial component name or creation time. You can filter the list to show only components that were created in a specific time range. You can also filter on one of the following:
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_trial_components/](https://www.paws-r-sdk.com/docs/sagemaker_list_trial_components/) for full documentation.
#'
#' @param ExperimentName A filter that returns only components that are part of the specified
#' experiment. If you specify `ExperimentName`, you can't filter by
#' `SourceArn` or `TrialName`.
#' @param TrialName A filter that returns only components that are part of the specified
#' trial. If you specify `TrialName`, you can't filter by `ExperimentName`
#' or `SourceArn`.
#' @param SourceArn A filter that returns only components that have the specified source
#' Amazon Resource Name (ARN). If you specify `SourceArn`, you can't filter
#' by `ExperimentName` or `TrialName`.
#' @param CreatedAfter A filter that returns only components created after the specified time.
#' @param CreatedBefore A filter that returns only components created before the specified time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param MaxResults The maximum number of components to return in the response. The default
#' value is 10.
#' @param NextToken If the previous call to
#' [`list_trial_components`][sagemaker_list_trial_components] didn't return
#' the full set of components, the call returns a token for getting the
#' next set of components.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_trial_components
sagemaker_list_trial_components <- function(ExperimentName = NULL, TrialName = NULL, SourceArn = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTrialComponents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "TrialComponentSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_trial_components_input(ExperimentName = ExperimentName, TrialName = TrialName, SourceArn = SourceArn, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_trial_components_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_trial_components <- sagemaker_list_trial_components

#' Lists the trials in your account
#'
#' @description
#' Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of that experiment. Specify a trial component name to limit the list to the trials that associated with that trial component. The list can be filtered to show only trials that were created in a specific time range. The list can be sorted by trial name or creation time.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_trials/](https://www.paws-r-sdk.com/docs/sagemaker_list_trials/) for full documentation.
#'
#' @param ExperimentName A filter that returns only trials that are part of the specified
#' experiment.
#' @param TrialComponentName A filter that returns only trials that are associated with the specified
#' trial component.
#' @param CreatedAfter A filter that returns only trials created after the specified time.
#' @param CreatedBefore A filter that returns only trials created before the specified time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param MaxResults The maximum number of trials to return in the response. The default
#' value is 10.
#' @param NextToken If the previous call to [`list_trials`][sagemaker_list_trials] didn't
#' return the full set of trials, the call returns a token for getting the
#' next set of trials.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_trials
sagemaker_list_trials <- function(ExperimentName = NULL, TrialComponentName = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTrials",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "TrialSummaries"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_trials_input(ExperimentName = ExperimentName, TrialComponentName = TrialComponentName, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_trials_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_trials <- sagemaker_list_trials

#' Lists user profiles
#'
#' @description
#' Lists user profiles.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_user_profiles/](https://www.paws-r-sdk.com/docs/sagemaker_list_user_profiles/) for full documentation.
#'
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults This parameter defines the maximum number of results that can be return
#' in a single response. The `MaxResults` parameter is an upper bound, not
#' a target. If there are more results available than the value specified,
#' a `NextToken` is provided in the response. The `NextToken` indicates
#' that the user should get the next set of results by providing this token
#' as a part of a subsequent call. The default value for `MaxResults` is
#' 10.
#' @param SortOrder The sort order for the results. The default is Ascending.
#' @param SortBy The parameter by which to sort the results. The default is CreationTime.
#' @param DomainIdEquals A parameter by which to filter the results.
#' @param UserProfileNameContains A parameter by which to filter the results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_user_profiles
sagemaker_list_user_profiles <- function(NextToken = NULL, MaxResults = NULL, SortOrder = NULL, SortBy = NULL, DomainIdEquals = NULL, UserProfileNameContains = NULL) {
  op <- new_operation(
    name = "ListUserProfiles",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "UserProfiles"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_user_profiles_input(NextToken = NextToken, MaxResults = MaxResults, SortOrder = SortOrder, SortBy = SortBy, DomainIdEquals = DomainIdEquals, UserProfileNameContains = UserProfileNameContains)
  output <- .sagemaker$list_user_profiles_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_user_profiles <- sagemaker_list_user_profiles

#' Use this operation to list all private and vendor workforces in an
#' Amazon Web Services Region
#'
#' @description
#' Use this operation to list all private and vendor workforces in an Amazon Web Services Region. Note that you can only have one private workforce per Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_workforces/](https://www.paws-r-sdk.com/docs/sagemaker_list_workforces/) for full documentation.
#'
#' @param SortBy Sort workforces using the workforce name or creation date.
#' @param SortOrder Sort workforces in ascending or descending order.
#' @param NameContains A filter you can use to search for workforces using part of the
#' workforce name.
#' @param NextToken A token to resume pagination.
#' @param MaxResults The maximum number of workforces returned in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_workforces
sagemaker_list_workforces <- function(SortBy = NULL, SortOrder = NULL, NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkforces",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Workforces"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_workforces_input(SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_workforces_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_workforces <- sagemaker_list_workforces

#' Gets a list of private work teams that you have defined in a region
#'
#' @description
#' Gets a list of private work teams that you have defined in a region. The list may be empty if no work team satisfies the filter specified in the `NameContains` parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_list_workteams/](https://www.paws-r-sdk.com/docs/sagemaker_list_workteams/) for full documentation.
#'
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NameContains A string in the work team's name. This filter returns only work teams
#' whose name contains the specified string.
#' @param NextToken If the result of the previous
#' [`list_workteams`][sagemaker_list_workteams] request was truncated, the
#' response includes a `NextToken`. To retrieve the next set of labeling
#' jobs, use the token in the next request.
#' @param MaxResults The maximum number of work teams to return in each page of the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_workteams
sagemaker_list_workteams <- function(SortBy = NULL, SortOrder = NULL, NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkteams",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Workteams"),
    stream_api = FALSE
  )
  input <- .sagemaker$list_workteams_input(SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_workteams_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_workteams <- sagemaker_list_workteams

#' Adds a resouce policy to control access to a model group
#'
#' @description
#' Adds a resouce policy to control access to a model group. For information about resoure policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *Amazon Web Services Identity and Access Management User Guide.*.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_put_model_package_group_policy/](https://www.paws-r-sdk.com/docs/sagemaker_put_model_package_group_policy/) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group to add a resource policy to.
#' @param ResourcePolicy &#91;required&#93; The resource policy for the model group.
#'
#' @keywords internal
#'
#' @rdname sagemaker_put_model_package_group_policy
sagemaker_put_model_package_group_policy <- function(ModelPackageGroupName, ResourcePolicy) {
  op <- new_operation(
    name = "PutModelPackageGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$put_model_package_group_policy_input(ModelPackageGroupName = ModelPackageGroupName, ResourcePolicy = ResourcePolicy)
  output <- .sagemaker$put_model_package_group_policy_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$put_model_package_group_policy <- sagemaker_put_model_package_group_policy

#' Use this action to inspect your lineage and discover relationships
#' between entities
#'
#' @description
#' Use this action to inspect your lineage and discover relationships between entities. For more information, see [Querying Lineage Entities](https://docs.aws.amazon.com/sagemaker/latest/dg/querying-lineage-entities.html) in the *Amazon SageMaker Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_query_lineage/](https://www.paws-r-sdk.com/docs/sagemaker_query_lineage/) for full documentation.
#'
#' @param StartArns A list of resource Amazon Resource Name (ARN) that represent the
#' starting point for your lineage query.
#' @param Direction Associations between lineage entities have a direction. This parameter
#' determines the direction from the StartArn(s) that the query traverses.
#' @param IncludeEdges Setting this value to `True` retrieves not only the entities of interest
#' but also the
#' [Associations](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html)
#' and lineage entities on the path. Set to `False` to only return lineage
#' entities that match your query.
#' @param Filters A set of filtering parameters that allow you to specify which entities
#' should be returned.
#' 
#' -   Properties - Key-value pairs to match on the lineage entities'
#'     properties.
#' 
#' -   LineageTypes - A set of lineage entity types to match on. For
#'     example: `TrialComponent`, `Artifact`, or `Context`.
#' 
#' -   CreatedBefore - Filter entities created before this date.
#' 
#' -   ModifiedBefore - Filter entities modified before this date.
#' 
#' -   ModifiedAfter - Filter entities modified after this date.
#' @param MaxDepth The maximum depth in lineage relationships from the `StartArns` that are
#' traversed. Depth is a measure of the number of `Associations` from the
#' `StartArn` entity to the matched results.
#' @param MaxResults Limits the number of vertices in the results. Use the `NextToken` in a
#' response to to retrieve the next page of results.
#' @param NextToken Limits the number of vertices in the request. Use the `NextToken` in a
#' response to to retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_query_lineage
sagemaker_query_lineage <- function(StartArns = NULL, Direction = NULL, IncludeEdges = NULL, Filters = NULL, MaxDepth = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "QueryLineage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .sagemaker$query_lineage_input(StartArns = StartArns, Direction = Direction, IncludeEdges = IncludeEdges, Filters = Filters, MaxDepth = MaxDepth, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$query_lineage_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$query_lineage <- sagemaker_query_lineage

#' Register devices
#'
#' @description
#' Register devices.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_register_devices/](https://www.paws-r-sdk.com/docs/sagemaker_register_devices/) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet.
#' @param Devices &#91;required&#93; A list of devices to register with SageMaker Edge Manager.
#' @param Tags The tags associated with devices.
#'
#' @keywords internal
#'
#' @rdname sagemaker_register_devices
sagemaker_register_devices <- function(DeviceFleetName, Devices, Tags = NULL) {
  op <- new_operation(
    name = "RegisterDevices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$register_devices_input(DeviceFleetName = DeviceFleetName, Devices = Devices, Tags = Tags)
  output <- .sagemaker$register_devices_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$register_devices <- sagemaker_register_devices

#' Renders the UI template so that you can preview the worker's experience
#'
#' @description
#' Renders the UI template so that you can preview the worker's experience.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_render_ui_template/](https://www.paws-r-sdk.com/docs/sagemaker_render_ui_template/) for full documentation.
#'
#' @param UiTemplate A `Template` object containing the worker UI template to render.
#' @param Task &#91;required&#93; A `RenderableTask` object containing a representative task to render.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) that has access to the S3 objects that
#' are used by the template.
#' @param HumanTaskUiArn The `HumanTaskUiArn` of the worker UI that you want to render. Do not
#' provide a `HumanTaskUiArn` if you use the `UiTemplate` parameter.
#' 
#' See a list of available Human Ui Amazon Resource Names (ARNs) in
#' [UiConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UiConfig.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_render_ui_template
sagemaker_render_ui_template <- function(UiTemplate = NULL, Task, RoleArn, HumanTaskUiArn = NULL) {
  op <- new_operation(
    name = "RenderUiTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$render_ui_template_input(UiTemplate = UiTemplate, Task = Task, RoleArn = RoleArn, HumanTaskUiArn = HumanTaskUiArn)
  output <- .sagemaker$render_ui_template_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$render_ui_template <- sagemaker_render_ui_template

#' Retry the execution of the pipeline
#'
#' @description
#' Retry the execution of the pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_retry_pipeline_execution/](https://www.paws-r-sdk.com/docs/sagemaker_retry_pipeline_execution/) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#' @param ClientRequestToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than once.
#' @param ParallelismConfiguration This configuration, if specified, overrides the parallelism
#' configuration of the parent pipeline.
#'
#' @keywords internal
#'
#' @rdname sagemaker_retry_pipeline_execution
sagemaker_retry_pipeline_execution <- function(PipelineExecutionArn, ClientRequestToken, ParallelismConfiguration = NULL) {
  op <- new_operation(
    name = "RetryPipelineExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$retry_pipeline_execution_input(PipelineExecutionArn = PipelineExecutionArn, ClientRequestToken = ClientRequestToken, ParallelismConfiguration = ParallelismConfiguration)
  output <- .sagemaker$retry_pipeline_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$retry_pipeline_execution <- sagemaker_retry_pipeline_execution

#' Finds SageMaker resources that match a search query
#'
#' @description
#' Finds SageMaker resources that match a search query. Matching resources are returned as a list of `SearchRecord` objects in the response. You can sort the search results by any resource property in a ascending or descending order.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_search/](https://www.paws-r-sdk.com/docs/sagemaker_search/) for full documentation.
#'
#' @param Resource &#91;required&#93; The name of the SageMaker resource to search for.
#' @param SearchExpression A Boolean conditional statement. Resources must satisfy this condition
#' to be included in search results. You must provide at least one
#' subexpression, filter, or nested filter. The maximum number of recursive
#' `SubExpressions`, `NestedFilters`, and `Filters` that can be included in
#' a `SearchExpression` object is 50.
#' @param SortBy The name of the resource property used to sort the `SearchResults`. The
#' default is `LastModifiedTime`.
#' @param SortOrder How `SearchResults` are ordered. Valid values are `Ascending` or
#' `Descending`. The default is `Descending`.
#' @param NextToken If more than `MaxResults` resources match the specified
#' `SearchExpression`, the response includes a `NextToken`. The `NextToken`
#' can be passed to the next `SearchRequest` to continue retrieving
#' results.
#' @param MaxResults The maximum number of results to return.
#' @param CrossAccountFilterOption A cross account filter option. When the value is `"CrossAccount"` the
#' search results will only include resources made discoverable to you from
#' other accounts. When the value is `"SameAccount"` or `null` the search
#' results will only include resources from your account. Default is
#' `null`. For more information on searching for resources made
#' discoverable to your account, see [Search discoverable
#' resources](https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html)
#' in the SageMaker Developer Guide. The maximum number of
#' `ResourceCatalog`s viewable is 1000.
#' @param VisibilityConditions Limits the results of your search request to the resources that you can
#' access.
#'
#' @keywords internal
#'
#' @rdname sagemaker_search
sagemaker_search <- function(Resource, SearchExpression = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, CrossAccountFilterOption = NULL, VisibilityConditions = NULL) {
  op <- new_operation(
    name = "Search",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Results"),
    stream_api = FALSE
  )
  input <- .sagemaker$search_input(Resource = Resource, SearchExpression = SearchExpression, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, CrossAccountFilterOption = CrossAccountFilterOption, VisibilityConditions = VisibilityConditions)
  output <- .sagemaker$search_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$search <- sagemaker_search

#' Searches for available training plan offerings based on specified
#' criteria
#'
#' @description
#' Searches for available training plan offerings based on specified criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_search_training_plan_offerings/](https://www.paws-r-sdk.com/docs/sagemaker_search_training_plan_offerings/) for full documentation.
#'
#' @param InstanceType &#91;required&#93; The type of instance you want to search for in the available training
#' plan offerings. This field allows you to filter the search results based
#' on the specific compute resources you require for your SageMaker
#' training jobs or SageMaker HyperPod clusters. When searching for
#' training plan offerings, specifying the instance type helps you find
#' Reserved Instances that match your computational needs.
#' @param InstanceCount &#91;required&#93; The number of instances you want to reserve in the training plan
#' offerings. This allows you to specify the quantity of compute resources
#' needed for your SageMaker training jobs or SageMaker HyperPod clusters,
#' helping you find reserved capacity offerings that match your
#' requirements.
#' @param StartTimeAfter A filter to search for training plan offerings with a start time after a
#' specified date.
#' @param EndTimeBefore A filter to search for reserved capacity offerings with an end time
#' before a specified date.
#' @param DurationHours The desired duration in hours for the training plan offerings.
#' @param TargetResources &#91;required&#93; The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod)
#' to search for in the offerings.
#' 
#' Training plans are specific to their target resource.
#' 
#' -   A training plan designed for SageMaker training jobs can only be
#'     used to schedule and run training jobs.
#' 
#' -   A training plan for HyperPod clusters can be used exclusively to
#'     provide compute resources to a cluster's instance group.
#'
#' @keywords internal
#'
#' @rdname sagemaker_search_training_plan_offerings
sagemaker_search_training_plan_offerings <- function(InstanceType, InstanceCount, StartTimeAfter = NULL, EndTimeBefore = NULL, DurationHours = NULL, TargetResources) {
  op <- new_operation(
    name = "SearchTrainingPlanOfferings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$search_training_plan_offerings_input(InstanceType = InstanceType, InstanceCount = InstanceCount, StartTimeAfter = StartTimeAfter, EndTimeBefore = EndTimeBefore, DurationHours = DurationHours, TargetResources = TargetResources)
  output <- .sagemaker$search_training_plan_offerings_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$search_training_plan_offerings <- sagemaker_search_training_plan_offerings

#' Notifies the pipeline that the execution of a callback step failed,
#' along with a message describing why
#'
#' @description
#' Notifies the pipeline that the execution of a callback step failed, along with a message describing why. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_send_pipeline_execution_step_failure/](https://www.paws-r-sdk.com/docs/sagemaker_send_pipeline_execution_step_failure/) for full documentation.
#'
#' @param CallbackToken &#91;required&#93; The pipeline generated token from the Amazon SQS queue.
#' @param FailureReason A message describing why the step failed.
#' @param ClientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than one time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_send_pipeline_execution_step_failure
sagemaker_send_pipeline_execution_step_failure <- function(CallbackToken, FailureReason = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "SendPipelineExecutionStepFailure",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$send_pipeline_execution_step_failure_input(CallbackToken = CallbackToken, FailureReason = FailureReason, ClientRequestToken = ClientRequestToken)
  output <- .sagemaker$send_pipeline_execution_step_failure_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$send_pipeline_execution_step_failure <- sagemaker_send_pipeline_execution_step_failure

#' Notifies the pipeline that the execution of a callback step succeeded
#' and provides a list of the step's output parameters
#'
#' @description
#' Notifies the pipeline that the execution of a callback step succeeded and provides a list of the step's output parameters. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_send_pipeline_execution_step_success/](https://www.paws-r-sdk.com/docs/sagemaker_send_pipeline_execution_step_success/) for full documentation.
#'
#' @param CallbackToken &#91;required&#93; The pipeline generated token from the Amazon SQS queue.
#' @param OutputParameters A list of the output parameters of the callback step.
#' @param ClientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than one time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_send_pipeline_execution_step_success
sagemaker_send_pipeline_execution_step_success <- function(CallbackToken, OutputParameters = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "SendPipelineExecutionStepSuccess",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$send_pipeline_execution_step_success_input(CallbackToken = CallbackToken, OutputParameters = OutputParameters, ClientRequestToken = ClientRequestToken)
  output <- .sagemaker$send_pipeline_execution_step_success_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$send_pipeline_execution_step_success <- sagemaker_send_pipeline_execution_step_success

#' Starts a stage in an edge deployment plan
#'
#' @description
#' Starts a stage in an edge deployment plan.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_start_edge_deployment_stage/](https://www.paws-r-sdk.com/docs/sagemaker_start_edge_deployment_stage/) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan to start.
#' @param StageName &#91;required&#93; The name of the stage to start.
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_edge_deployment_stage
sagemaker_start_edge_deployment_stage <- function(EdgeDeploymentPlanName, StageName) {
  op <- new_operation(
    name = "StartEdgeDeploymentStage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$start_edge_deployment_stage_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, StageName = StageName)
  output <- .sagemaker$start_edge_deployment_stage_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_edge_deployment_stage <- sagemaker_start_edge_deployment_stage

#' Starts an inference experiment
#'
#' @description
#' Starts an inference experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_start_inference_experiment/](https://www.paws-r-sdk.com/docs/sagemaker_start_inference_experiment/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the inference experiment to start.
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_inference_experiment
sagemaker_start_inference_experiment <- function(Name) {
  op <- new_operation(
    name = "StartInferenceExperiment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$start_inference_experiment_input(Name = Name)
  output <- .sagemaker$start_inference_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_inference_experiment <- sagemaker_start_inference_experiment

#' Programmatically start an MLflow Tracking Server
#'
#' @description
#' Programmatically start an MLflow Tracking Server.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_start_mlflow_tracking_server/](https://www.paws-r-sdk.com/docs/sagemaker_start_mlflow_tracking_server/) for full documentation.
#'
#' @param TrackingServerName &#91;required&#93; The name of the tracking server to start.
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_mlflow_tracking_server
sagemaker_start_mlflow_tracking_server <- function(TrackingServerName) {
  op <- new_operation(
    name = "StartMlflowTrackingServer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$start_mlflow_tracking_server_input(TrackingServerName = TrackingServerName)
  output <- .sagemaker$start_mlflow_tracking_server_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_mlflow_tracking_server <- sagemaker_start_mlflow_tracking_server

#' Starts a previously stopped monitoring schedule
#'
#' @description
#' Starts a previously stopped monitoring schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_start_monitoring_schedule/](https://www.paws-r-sdk.com/docs/sagemaker_start_monitoring_schedule/) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the schedule to start.
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_monitoring_schedule
sagemaker_start_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "StartMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$start_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$start_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_monitoring_schedule <- sagemaker_start_monitoring_schedule

#' Launches an ML compute instance with the latest version of the libraries
#' and attaches your ML storage volume
#'
#' @description
#' Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume. After configuring the notebook instance, SageMaker AI sets the notebook instance status to `InService`. A notebook instance's status must be `InService` before you can connect to your Jupyter notebook.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_start_notebook_instance/](https://www.paws-r-sdk.com/docs/sagemaker_start_notebook_instance/) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to start.
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_notebook_instance
sagemaker_start_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "StartNotebookInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$start_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$start_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_notebook_instance <- sagemaker_start_notebook_instance

#' Starts a pipeline execution
#'
#' @description
#' Starts a pipeline execution.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_start_pipeline_execution/](https://www.paws-r-sdk.com/docs/sagemaker_start_pipeline_execution/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name or Amazon Resource Name (ARN) of the pipeline.
#' @param PipelineExecutionDisplayName The display name of the pipeline execution.
#' @param PipelineParameters Contains a list of pipeline parameters. This list can be empty.
#' @param PipelineExecutionDescription The description of the pipeline execution.
#' @param ClientRequestToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than once.
#' @param ParallelismConfiguration This configuration, if specified, overrides the parallelism
#' configuration of the parent pipeline for this specific run.
#' @param SelectiveExecutionConfig The selective execution configuration applied to the pipeline run.
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_pipeline_execution
sagemaker_start_pipeline_execution <- function(PipelineName, PipelineExecutionDisplayName = NULL, PipelineParameters = NULL, PipelineExecutionDescription = NULL, ClientRequestToken, ParallelismConfiguration = NULL, SelectiveExecutionConfig = NULL) {
  op <- new_operation(
    name = "StartPipelineExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$start_pipeline_execution_input(PipelineName = PipelineName, PipelineExecutionDisplayName = PipelineExecutionDisplayName, PipelineParameters = PipelineParameters, PipelineExecutionDescription = PipelineExecutionDescription, ClientRequestToken = ClientRequestToken, ParallelismConfiguration = ParallelismConfiguration, SelectiveExecutionConfig = SelectiveExecutionConfig)
  output <- .sagemaker$start_pipeline_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_pipeline_execution <- sagemaker_start_pipeline_execution

#' A method for forcing a running job to shut down
#'
#' @description
#' A method for forcing a running job to shut down.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_auto_ml_job/](https://www.paws-r-sdk.com/docs/sagemaker_stop_auto_ml_job/) for full documentation.
#'
#' @param AutoMLJobName &#91;required&#93; The name of the object you are requesting.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_auto_ml_job
sagemaker_stop_auto_ml_job <- function(AutoMLJobName) {
  op <- new_operation(
    name = "StopAutoMLJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_auto_ml_job_input(AutoMLJobName = AutoMLJobName)
  output <- .sagemaker$stop_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_auto_ml_job <- sagemaker_stop_auto_ml_job

#' Stops a model compilation job
#'
#' @description
#' Stops a model compilation job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_compilation_job/](https://www.paws-r-sdk.com/docs/sagemaker_stop_compilation_job/) for full documentation.
#'
#' @param CompilationJobName &#91;required&#93; The name of the model compilation job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_compilation_job
sagemaker_stop_compilation_job <- function(CompilationJobName) {
  op <- new_operation(
    name = "StopCompilationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_compilation_job_input(CompilationJobName = CompilationJobName)
  output <- .sagemaker$stop_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_compilation_job <- sagemaker_stop_compilation_job

#' Stops a stage in an edge deployment plan
#'
#' @description
#' Stops a stage in an edge deployment plan.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_edge_deployment_stage/](https://www.paws-r-sdk.com/docs/sagemaker_stop_edge_deployment_stage/) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan to stop.
#' @param StageName &#91;required&#93; The name of the stage to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_edge_deployment_stage
sagemaker_stop_edge_deployment_stage <- function(EdgeDeploymentPlanName, StageName) {
  op <- new_operation(
    name = "StopEdgeDeploymentStage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_edge_deployment_stage_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, StageName = StageName)
  output <- .sagemaker$stop_edge_deployment_stage_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_edge_deployment_stage <- sagemaker_stop_edge_deployment_stage

#' Request to stop an edge packaging job
#'
#' @description
#' Request to stop an edge packaging job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_edge_packaging_job/](https://www.paws-r-sdk.com/docs/sagemaker_stop_edge_packaging_job/) for full documentation.
#'
#' @param EdgePackagingJobName &#91;required&#93; The name of the edge packaging job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_edge_packaging_job
sagemaker_stop_edge_packaging_job <- function(EdgePackagingJobName) {
  op <- new_operation(
    name = "StopEdgePackagingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_edge_packaging_job_input(EdgePackagingJobName = EdgePackagingJobName)
  output <- .sagemaker$stop_edge_packaging_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_edge_packaging_job <- sagemaker_stop_edge_packaging_job

#' Stops a running hyperparameter tuning job and all running training jobs
#' that the tuning job launched
#'
#' @description
#' Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_hyper_parameter_tuning_job/](https://www.paws-r-sdk.com/docs/sagemaker_stop_hyper_parameter_tuning_job/) for full documentation.
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_hyper_parameter_tuning_job
sagemaker_stop_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName) {
  op <- new_operation(
    name = "StopHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName)
  output <- .sagemaker$stop_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_hyper_parameter_tuning_job <- sagemaker_stop_hyper_parameter_tuning_job

#' Stops an inference experiment
#'
#' @description
#' Stops an inference experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_inference_experiment/](https://www.paws-r-sdk.com/docs/sagemaker_stop_inference_experiment/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the inference experiment to stop.
#' @param ModelVariantActions &#91;required&#93; Array of key-value pairs, with names of variants mapped to actions. The
#' possible actions are the following:
#' 
#' -   `Promote` - Promote the shadow variant to a production variant
#' 
#' -   `Remove` - Delete the variant
#' 
#' -   `Retain` - Keep the variant as it is
#' @param DesiredModelVariants An array of `ModelVariantConfig` objects. There is one for each variant
#' that you want to deploy after the inference experiment stops. Each
#' `ModelVariantConfig` describes the infrastructure configuration for
#' deploying the corresponding variant.
#' @param DesiredState The desired state of the experiment after stopping. The possible states
#' are the following:
#' 
#' -   `Completed`: The experiment completed successfully
#' 
#' -   `Cancelled`: The experiment was canceled
#' @param Reason The reason for stopping the experiment.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_inference_experiment
sagemaker_stop_inference_experiment <- function(Name, ModelVariantActions, DesiredModelVariants = NULL, DesiredState = NULL, Reason = NULL) {
  op <- new_operation(
    name = "StopInferenceExperiment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_inference_experiment_input(Name = Name, ModelVariantActions = ModelVariantActions, DesiredModelVariants = DesiredModelVariants, DesiredState = DesiredState, Reason = Reason)
  output <- .sagemaker$stop_inference_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_inference_experiment <- sagemaker_stop_inference_experiment

#' Stops an Inference Recommender job
#'
#' @description
#' Stops an Inference Recommender job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_inference_recommendations_job/](https://www.paws-r-sdk.com/docs/sagemaker_stop_inference_recommendations_job/) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job you want to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_inference_recommendations_job
sagemaker_stop_inference_recommendations_job <- function(JobName) {
  op <- new_operation(
    name = "StopInferenceRecommendationsJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_inference_recommendations_job_input(JobName = JobName)
  output <- .sagemaker$stop_inference_recommendations_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_inference_recommendations_job <- sagemaker_stop_inference_recommendations_job

#' Stops a running labeling job
#'
#' @description
#' Stops a running labeling job. A job that is stopped cannot be restarted. Any results obtained before the job is stopped are placed in the Amazon S3 output bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_labeling_job/](https://www.paws-r-sdk.com/docs/sagemaker_stop_labeling_job/) for full documentation.
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_labeling_job
sagemaker_stop_labeling_job <- function(LabelingJobName) {
  op <- new_operation(
    name = "StopLabelingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_labeling_job_input(LabelingJobName = LabelingJobName)
  output <- .sagemaker$stop_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_labeling_job <- sagemaker_stop_labeling_job

#' Programmatically stop an MLflow Tracking Server
#'
#' @description
#' Programmatically stop an MLflow Tracking Server.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_mlflow_tracking_server/](https://www.paws-r-sdk.com/docs/sagemaker_stop_mlflow_tracking_server/) for full documentation.
#'
#' @param TrackingServerName &#91;required&#93; The name of the tracking server to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_mlflow_tracking_server
sagemaker_stop_mlflow_tracking_server <- function(TrackingServerName) {
  op <- new_operation(
    name = "StopMlflowTrackingServer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_mlflow_tracking_server_input(TrackingServerName = TrackingServerName)
  output <- .sagemaker$stop_mlflow_tracking_server_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_mlflow_tracking_server <- sagemaker_stop_mlflow_tracking_server

#' Stops a previously started monitoring schedule
#'
#' @description
#' Stops a previously started monitoring schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_monitoring_schedule/](https://www.paws-r-sdk.com/docs/sagemaker_stop_monitoring_schedule/) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the schedule to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_monitoring_schedule
sagemaker_stop_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "StopMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$stop_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_monitoring_schedule <- sagemaker_stop_monitoring_schedule

#' Terminates the ML compute instance
#'
#' @description
#' Terminates the ML compute instance. Before terminating the instance, SageMaker AI disconnects the ML storage volume from it. SageMaker AI preserves the ML storage volume. SageMaker AI stops charging you for the ML compute instance when you call [`stop_notebook_instance`][sagemaker_stop_notebook_instance].
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_notebook_instance/](https://www.paws-r-sdk.com/docs/sagemaker_stop_notebook_instance/) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to terminate.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_notebook_instance
sagemaker_stop_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "StopNotebookInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$stop_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_notebook_instance <- sagemaker_stop_notebook_instance

#' Ends a running inference optimization job
#'
#' @description
#' Ends a running inference optimization job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_optimization_job/](https://www.paws-r-sdk.com/docs/sagemaker_stop_optimization_job/) for full documentation.
#'
#' @param OptimizationJobName &#91;required&#93; The name that you assigned to the optimization job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_optimization_job
sagemaker_stop_optimization_job <- function(OptimizationJobName) {
  op <- new_operation(
    name = "StopOptimizationJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_optimization_job_input(OptimizationJobName = OptimizationJobName)
  output <- .sagemaker$stop_optimization_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_optimization_job <- sagemaker_stop_optimization_job

#' Stops a pipeline execution
#'
#' @description
#' Stops a pipeline execution.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_pipeline_execution/](https://www.paws-r-sdk.com/docs/sagemaker_stop_pipeline_execution/) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#' @param ClientRequestToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than once.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_pipeline_execution
sagemaker_stop_pipeline_execution <- function(PipelineExecutionArn, ClientRequestToken) {
  op <- new_operation(
    name = "StopPipelineExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_pipeline_execution_input(PipelineExecutionArn = PipelineExecutionArn, ClientRequestToken = ClientRequestToken)
  output <- .sagemaker$stop_pipeline_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_pipeline_execution <- sagemaker_stop_pipeline_execution

#' Stops a processing job
#'
#' @description
#' Stops a processing job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_processing_job/](https://www.paws-r-sdk.com/docs/sagemaker_stop_processing_job/) for full documentation.
#'
#' @param ProcessingJobName &#91;required&#93; The name of the processing job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_processing_job
sagemaker_stop_processing_job <- function(ProcessingJobName) {
  op <- new_operation(
    name = "StopProcessingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_processing_job_input(ProcessingJobName = ProcessingJobName)
  output <- .sagemaker$stop_processing_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_processing_job <- sagemaker_stop_processing_job

#' Stops a training job
#'
#' @description
#' Stops a training job. To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms might use this 120-second window to save the model artifacts, so the results of the training is not lost.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_training_job/](https://www.paws-r-sdk.com/docs/sagemaker_stop_training_job/) for full documentation.
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_training_job
sagemaker_stop_training_job <- function(TrainingJobName) {
  op <- new_operation(
    name = "StopTrainingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_training_job_input(TrainingJobName = TrainingJobName)
  output <- .sagemaker$stop_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_training_job <- sagemaker_stop_training_job

#' Stops a batch transform job
#'
#' @description
#' Stops a batch transform job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_stop_transform_job/](https://www.paws-r-sdk.com/docs/sagemaker_stop_transform_job/) for full documentation.
#'
#' @param TransformJobName &#91;required&#93; The name of the batch transform job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_transform_job
sagemaker_stop_transform_job <- function(TransformJobName) {
  op <- new_operation(
    name = "StopTransformJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$stop_transform_job_input(TransformJobName = TransformJobName)
  output <- .sagemaker$stop_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_transform_job <- sagemaker_stop_transform_job

#' Updates an action
#'
#' @description
#' Updates an action.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_action/](https://www.paws-r-sdk.com/docs/sagemaker_update_action/) for full documentation.
#'
#' @param ActionName &#91;required&#93; The name of the action to update.
#' @param Description The new description for the action.
#' @param Status The new status for the action.
#' @param Properties The new list of properties. Overwrites the current property list.
#' @param PropertiesToRemove A list of properties to remove.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_action
sagemaker_update_action <- function(ActionName, Description = NULL, Status = NULL, Properties = NULL, PropertiesToRemove = NULL) {
  op <- new_operation(
    name = "UpdateAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_action_input(ActionName = ActionName, Description = Description, Status = Status, Properties = Properties, PropertiesToRemove = PropertiesToRemove)
  output <- .sagemaker$update_action_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_action <- sagemaker_update_action

#' Updates the properties of an AppImageConfig
#'
#' @description
#' Updates the properties of an AppImageConfig.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_app_image_config/](https://www.paws-r-sdk.com/docs/sagemaker_update_app_image_config/) for full documentation.
#'
#' @param AppImageConfigName &#91;required&#93; The name of the AppImageConfig to update.
#' @param KernelGatewayImageConfig The new KernelGateway app to run on the image.
#' @param JupyterLabAppImageConfig The JupyterLab app running on the image.
#' @param CodeEditorAppImageConfig The Code Editor app running on the image.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_app_image_config
sagemaker_update_app_image_config <- function(AppImageConfigName, KernelGatewayImageConfig = NULL, JupyterLabAppImageConfig = NULL, CodeEditorAppImageConfig = NULL) {
  op <- new_operation(
    name = "UpdateAppImageConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_app_image_config_input(AppImageConfigName = AppImageConfigName, KernelGatewayImageConfig = KernelGatewayImageConfig, JupyterLabAppImageConfig = JupyterLabAppImageConfig, CodeEditorAppImageConfig = CodeEditorAppImageConfig)
  output <- .sagemaker$update_app_image_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_app_image_config <- sagemaker_update_app_image_config

#' Updates an artifact
#'
#' @description
#' Updates an artifact.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_artifact/](https://www.paws-r-sdk.com/docs/sagemaker_update_artifact/) for full documentation.
#'
#' @param ArtifactArn &#91;required&#93; The Amazon Resource Name (ARN) of the artifact to update.
#' @param ArtifactName The new name for the artifact.
#' @param Properties The new list of properties. Overwrites the current property list.
#' @param PropertiesToRemove A list of properties to remove.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_artifact
sagemaker_update_artifact <- function(ArtifactArn, ArtifactName = NULL, Properties = NULL, PropertiesToRemove = NULL) {
  op <- new_operation(
    name = "UpdateArtifact",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_artifact_input(ArtifactArn = ArtifactArn, ArtifactName = ArtifactName, Properties = Properties, PropertiesToRemove = PropertiesToRemove)
  output <- .sagemaker$update_artifact_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_artifact <- sagemaker_update_artifact

#' Updates a SageMaker HyperPod cluster
#'
#' @description
#' Updates a SageMaker HyperPod cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_cluster/](https://www.paws-r-sdk.com/docs/sagemaker_update_cluster/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; Specify the name of the SageMaker HyperPod cluster you want to update.
#' @param InstanceGroups &#91;required&#93; Specify the instance groups to update.
#' @param NodeRecovery The node recovery mode to be applied to the SageMaker HyperPod cluster.
#' @param InstanceGroupsToDelete Specify the names of the instance groups to delete. Use a single `,` as
#' the separator between multiple names.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_cluster
sagemaker_update_cluster <- function(ClusterName, InstanceGroups, NodeRecovery = NULL, InstanceGroupsToDelete = NULL) {
  op <- new_operation(
    name = "UpdateCluster",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_cluster_input(ClusterName = ClusterName, InstanceGroups = InstanceGroups, NodeRecovery = NodeRecovery, InstanceGroupsToDelete = InstanceGroupsToDelete)
  output <- .sagemaker$update_cluster_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_cluster <- sagemaker_update_cluster

#' Update the cluster policy configuration
#'
#' @description
#' Update the cluster policy configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_cluster_scheduler_config/](https://www.paws-r-sdk.com/docs/sagemaker_update_cluster_scheduler_config/) for full documentation.
#'
#' @param ClusterSchedulerConfigId &#91;required&#93; ID of the cluster policy.
#' @param TargetVersion &#91;required&#93; Target version.
#' @param SchedulerConfig Cluster policy configuration.
#' @param Description Description of the cluster policy.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_cluster_scheduler_config
sagemaker_update_cluster_scheduler_config <- function(ClusterSchedulerConfigId, TargetVersion, SchedulerConfig = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateClusterSchedulerConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_cluster_scheduler_config_input(ClusterSchedulerConfigId = ClusterSchedulerConfigId, TargetVersion = TargetVersion, SchedulerConfig = SchedulerConfig, Description = Description)
  output <- .sagemaker$update_cluster_scheduler_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_cluster_scheduler_config <- sagemaker_update_cluster_scheduler_config

#' Updates the platform software of a SageMaker HyperPod cluster for
#' security patching
#'
#' @description
#' Updates the platform software of a SageMaker HyperPod cluster for security patching. To learn how to use this API, see [Update the SageMaker HyperPod platform software of a cluster](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_cluster_software/](https://www.paws-r-sdk.com/docs/sagemaker_update_cluster_software/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; Specify the name or the Amazon Resource Name (ARN) of the SageMaker
#' HyperPod cluster you want to update for security patching.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_cluster_software
sagemaker_update_cluster_software <- function(ClusterName) {
  op <- new_operation(
    name = "UpdateClusterSoftware",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_cluster_software_input(ClusterName = ClusterName)
  output <- .sagemaker$update_cluster_software_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_cluster_software <- sagemaker_update_cluster_software

#' Updates the specified Git repository with the specified values
#'
#' @description
#' Updates the specified Git repository with the specified values.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_code_repository/](https://www.paws-r-sdk.com/docs/sagemaker_update_code_repository/) for full documentation.
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to update.
#' @param GitConfig The configuration of the git repository, including the URL and the
#' Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager
#' secret that contains the credentials used to access the repository. The
#' secret must have a staging label of `AWSCURRENT` and must be in the
#' following format:
#' 
#' `{"username": UserName, "password": Password}`
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_code_repository
sagemaker_update_code_repository <- function(CodeRepositoryName, GitConfig = NULL) {
  op <- new_operation(
    name = "UpdateCodeRepository",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_code_repository_input(CodeRepositoryName = CodeRepositoryName, GitConfig = GitConfig)
  output <- .sagemaker$update_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_code_repository <- sagemaker_update_code_repository

#' Update the compute allocation definition
#'
#' @description
#' Update the compute allocation definition.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_compute_quota/](https://www.paws-r-sdk.com/docs/sagemaker_update_compute_quota/) for full documentation.
#'
#' @param ComputeQuotaId &#91;required&#93; ID of the compute allocation definition.
#' @param TargetVersion &#91;required&#93; Target version.
#' @param ComputeQuotaConfig Configuration of the compute allocation definition. This includes the
#' resource sharing option, and the setting to preempt low priority tasks.
#' @param ComputeQuotaTarget The target entity to allocate compute resources to.
#' @param ActivationState The state of the compute allocation being described. Use to enable or
#' disable compute allocation.
#' 
#' Default is `Enabled`.
#' @param Description Description of the compute allocation definition.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_compute_quota
sagemaker_update_compute_quota <- function(ComputeQuotaId, TargetVersion, ComputeQuotaConfig = NULL, ComputeQuotaTarget = NULL, ActivationState = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateComputeQuota",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_compute_quota_input(ComputeQuotaId = ComputeQuotaId, TargetVersion = TargetVersion, ComputeQuotaConfig = ComputeQuotaConfig, ComputeQuotaTarget = ComputeQuotaTarget, ActivationState = ActivationState, Description = Description)
  output <- .sagemaker$update_compute_quota_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_compute_quota <- sagemaker_update_compute_quota

#' Updates a context
#'
#' @description
#' Updates a context.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_context/](https://www.paws-r-sdk.com/docs/sagemaker_update_context/) for full documentation.
#'
#' @param ContextName &#91;required&#93; The name of the context to update.
#' @param Description The new description for the context.
#' @param Properties The new list of properties. Overwrites the current property list.
#' @param PropertiesToRemove A list of properties to remove.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_context
sagemaker_update_context <- function(ContextName, Description = NULL, Properties = NULL, PropertiesToRemove = NULL) {
  op <- new_operation(
    name = "UpdateContext",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_context_input(ContextName = ContextName, Description = Description, Properties = Properties, PropertiesToRemove = PropertiesToRemove)
  output <- .sagemaker$update_context_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_context <- sagemaker_update_context

#' Updates a fleet of devices
#'
#' @description
#' Updates a fleet of devices.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_device_fleet/](https://www.paws-r-sdk.com/docs/sagemaker_update_device_fleet/) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet.
#' @param RoleArn The Amazon Resource Name (ARN) of the device.
#' @param Description Description of the fleet.
#' @param OutputConfig &#91;required&#93; Output configuration for storing sample data collected by the fleet.
#' @param EnableIotRoleAlias Whether to create an Amazon Web Services IoT Role Alias during device
#' fleet creation. The name of the role alias generated will match this
#' pattern: "SageMakerEdge-\{DeviceFleetName\}".
#' 
#' For example, if your device fleet is called "demo-fleet", the name of
#' the role alias will be "SageMakerEdge-demo-fleet".
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_device_fleet
sagemaker_update_device_fleet <- function(DeviceFleetName, RoleArn = NULL, Description = NULL, OutputConfig, EnableIotRoleAlias = NULL) {
  op <- new_operation(
    name = "UpdateDeviceFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_device_fleet_input(DeviceFleetName = DeviceFleetName, RoleArn = RoleArn, Description = Description, OutputConfig = OutputConfig, EnableIotRoleAlias = EnableIotRoleAlias)
  output <- .sagemaker$update_device_fleet_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_device_fleet <- sagemaker_update_device_fleet

#' Updates one or more devices in a fleet
#'
#' @description
#' Updates one or more devices in a fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_devices/](https://www.paws-r-sdk.com/docs/sagemaker_update_devices/) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet the devices belong to.
#' @param Devices &#91;required&#93; List of devices to register with Edge Manager agent.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_devices
sagemaker_update_devices <- function(DeviceFleetName, Devices) {
  op <- new_operation(
    name = "UpdateDevices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_devices_input(DeviceFleetName = DeviceFleetName, Devices = Devices)
  output <- .sagemaker$update_devices_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_devices <- sagemaker_update_devices

#' Updates the default settings for new user profiles in the domain
#'
#' @description
#' Updates the default settings for new user profiles in the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_domain/](https://www.paws-r-sdk.com/docs/sagemaker_update_domain/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The ID of the domain to be updated.
#' @param DefaultUserSettings A collection of settings.
#' @param DomainSettingsForUpdate A collection of `DomainSettings` configuration values to update.
#' @param AppSecurityGroupManagement The entity that creates and manages the required security groups for
#' inter-app communication in `VPCOnly` mode. Required when
#' `CreateDomain.AppNetworkAccessType` is `VPCOnly` and
#' `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`
#' is provided. If setting up the domain for use with RStudio, this value
#' must be set to `Service`.
#' @param DefaultSpaceSettings The default settings for shared spaces that users create in the domain.
#' @param SubnetIds The VPC subnets that Studio uses for communication.
#' 
#' If removing subnets, ensure there are no apps in the `InService`,
#' `Pending`, or `Deleting` state.
#' @param AppNetworkAccessType Specifies the VPC used for non-EFS traffic.
#' 
#' -   `PublicInternetOnly` - Non-EFS traffic is through a VPC managed by
#'     Amazon SageMaker AI, which allows direct internet access.
#' 
#' -   `VpcOnly` - All Studio traffic is through the specified VPC and
#'     subnets.
#' 
#' This configuration can only be modified if there are no apps in the
#' `InService`, `Pending`, or `Deleting` state. The configuration cannot be
#' updated if
#' `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`
#' is already set or
#' `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`
#' is provided as part of the same request.
#' @param TagPropagation Indicates whether custom tag propagation is supported for the domain.
#' Defaults to `DISABLED`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_domain
sagemaker_update_domain <- function(DomainId, DefaultUserSettings = NULL, DomainSettingsForUpdate = NULL, AppSecurityGroupManagement = NULL, DefaultSpaceSettings = NULL, SubnetIds = NULL, AppNetworkAccessType = NULL, TagPropagation = NULL) {
  op <- new_operation(
    name = "UpdateDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_domain_input(DomainId = DomainId, DefaultUserSettings = DefaultUserSettings, DomainSettingsForUpdate = DomainSettingsForUpdate, AppSecurityGroupManagement = AppSecurityGroupManagement, DefaultSpaceSettings = DefaultSpaceSettings, SubnetIds = SubnetIds, AppNetworkAccessType = AppNetworkAccessType, TagPropagation = TagPropagation)
  output <- .sagemaker$update_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_domain <- sagemaker_update_domain

#' Deploys the EndpointConfig specified in the request to a new fleet of
#' instances
#'
#' @description
#' Deploys the `EndpointConfig` specified in the request to a new fleet of instances. SageMaker shifts endpoint traffic to the new instances with the updated endpoint configuration and then deletes the old instances using the previous `EndpointConfig` (there is no availability loss). For more information about how to control the update and traffic shifting process, see [Update models in production](https://docs.aws.amazon.com/sagemaker/latest/dg/deployment-guardrails.html).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_endpoint/](https://www.paws-r-sdk.com/docs/sagemaker_update_endpoint/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint whose configuration you want to update.
#' @param EndpointConfigName &#91;required&#93; The name of the new endpoint configuration.
#' @param RetainAllVariantProperties When updating endpoint resources, enables or disables the retention of
#' [variant
#' properties](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html),
#' such as the instance count or the variant weight. To retain the variant
#' properties of an endpoint when updating it, set
#' `RetainAllVariantProperties` to `true`. To use the variant properties
#' specified in a new `EndpointConfig` call when updating an endpoint, set
#' `RetainAllVariantProperties` to `false`. The default is `false`.
#' @param ExcludeRetainedVariantProperties When you are updating endpoint resources with
#' `RetainAllVariantProperties`, whose value is set to `true`,
#' `ExcludeRetainedVariantProperties` specifies the list of type
#' [VariantProperty](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html)
#' to override with the values provided by `EndpointConfig`. If you don't
#' specify a value for `ExcludeRetainedVariantProperties`, no variant
#' properties are overridden.
#' @param DeploymentConfig The deployment configuration for an endpoint, which contains the desired
#' deployment strategy and rollback configurations.
#' @param RetainDeploymentConfig Specifies whether to reuse the last deployment configuration. The
#' default value is false (the configuration is not reused).
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_endpoint
sagemaker_update_endpoint <- function(EndpointName, EndpointConfigName, RetainAllVariantProperties = NULL, ExcludeRetainedVariantProperties = NULL, DeploymentConfig = NULL, RetainDeploymentConfig = NULL) {
  op <- new_operation(
    name = "UpdateEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_endpoint_input(EndpointName = EndpointName, EndpointConfigName = EndpointConfigName, RetainAllVariantProperties = RetainAllVariantProperties, ExcludeRetainedVariantProperties = ExcludeRetainedVariantProperties, DeploymentConfig = DeploymentConfig, RetainDeploymentConfig = RetainDeploymentConfig)
  output <- .sagemaker$update_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_endpoint <- sagemaker_update_endpoint

#' Updates variant weight of one or more variants associated with an
#' existing endpoint, or capacity of one variant associated with an
#' existing endpoint
#'
#' @description
#' Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant associated with an existing endpoint. When it receives the request, SageMaker sets the endpoint status to `Updating`. After updating the endpoint, it sets the status to `InService`. To check the status of an endpoint, use the [`describe_endpoint`][sagemaker_describe_endpoint] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_endpoint_weights_and_capacities/](https://www.paws-r-sdk.com/docs/sagemaker_update_endpoint_weights_and_capacities/) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of an existing SageMaker endpoint.
#' @param DesiredWeightsAndCapacities &#91;required&#93; An object that provides new capacity and weight values for a variant.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_endpoint_weights_and_capacities
sagemaker_update_endpoint_weights_and_capacities <- function(EndpointName, DesiredWeightsAndCapacities) {
  op <- new_operation(
    name = "UpdateEndpointWeightsAndCapacities",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_endpoint_weights_and_capacities_input(EndpointName = EndpointName, DesiredWeightsAndCapacities = DesiredWeightsAndCapacities)
  output <- .sagemaker$update_endpoint_weights_and_capacities_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_endpoint_weights_and_capacities <- sagemaker_update_endpoint_weights_and_capacities

#' Adds, updates, or removes the description of an experiment
#'
#' @description
#' Adds, updates, or removes the description of an experiment. Updates the display name of an experiment.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_experiment/](https://www.paws-r-sdk.com/docs/sagemaker_update_experiment/) for full documentation.
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment to update.
#' @param DisplayName The name of the experiment as displayed. The name doesn't need to be
#' unique. If `DisplayName` isn't specified, `ExperimentName` is displayed.
#' @param Description The description of the experiment.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_experiment
sagemaker_update_experiment <- function(ExperimentName, DisplayName = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateExperiment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_experiment_input(ExperimentName = ExperimentName, DisplayName = DisplayName, Description = Description)
  output <- .sagemaker$update_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_experiment <- sagemaker_update_experiment

#' Updates the feature group by either adding features or updating the
#' online store configuration
#'
#' @description
#' Updates the feature group by either adding features or updating the online store configuration. Use one of the following request parameters at a time while using the [`update_feature_group`][sagemaker_update_feature_group] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_feature_group/](https://www.paws-r-sdk.com/docs/sagemaker_update_feature_group/) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name or Amazon Resource Name (ARN) of the feature group that you're
#' updating.
#' @param FeatureAdditions Updates the feature group. Updating a feature group is an asynchronous
#' operation. When you get an HTTP 200 response, you've made a valid
#' request. It takes some time after you've made a valid request for
#' Feature Store to update the feature group.
#' @param OnlineStoreConfig Updates the feature group online store configuration.
#' @param ThroughputConfig 
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_feature_group
sagemaker_update_feature_group <- function(FeatureGroupName, FeatureAdditions = NULL, OnlineStoreConfig = NULL, ThroughputConfig = NULL) {
  op <- new_operation(
    name = "UpdateFeatureGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_feature_group_input(FeatureGroupName = FeatureGroupName, FeatureAdditions = FeatureAdditions, OnlineStoreConfig = OnlineStoreConfig, ThroughputConfig = ThroughputConfig)
  output <- .sagemaker$update_feature_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_feature_group <- sagemaker_update_feature_group

#' Updates the description and parameters of the feature group
#'
#' @description
#' Updates the description and parameters of the feature group.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_feature_metadata/](https://www.paws-r-sdk.com/docs/sagemaker_update_feature_metadata/) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name or Amazon Resource Name (ARN) of the feature group containing
#' the feature that you're updating.
#' @param FeatureName &#91;required&#93; The name of the feature that you're updating.
#' @param Description A description that you can write to better describe the feature.
#' @param ParameterAdditions A list of key-value pairs that you can add to better describe the
#' feature.
#' @param ParameterRemovals A list of parameter keys that you can specify to remove parameters that
#' describe your feature.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_feature_metadata
sagemaker_update_feature_metadata <- function(FeatureGroupName, FeatureName, Description = NULL, ParameterAdditions = NULL, ParameterRemovals = NULL) {
  op <- new_operation(
    name = "UpdateFeatureMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_feature_metadata_input(FeatureGroupName = FeatureGroupName, FeatureName = FeatureName, Description = Description, ParameterAdditions = ParameterAdditions, ParameterRemovals = ParameterRemovals)
  output <- .sagemaker$update_feature_metadata_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_feature_metadata <- sagemaker_update_feature_metadata

#' Update a hub
#'
#' @description
#' Update a hub.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_hub/](https://www.paws-r-sdk.com/docs/sagemaker_update_hub/) for full documentation.
#'
#' @param HubName &#91;required&#93; The name of the hub to update.
#' @param HubDescription A description of the updated hub.
#' @param HubDisplayName The display name of the hub.
#' @param HubSearchKeywords The searchable keywords for the hub.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_hub
sagemaker_update_hub <- function(HubName, HubDescription = NULL, HubDisplayName = NULL, HubSearchKeywords = NULL) {
  op <- new_operation(
    name = "UpdateHub",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_hub_input(HubName = HubName, HubDescription = HubDescription, HubDisplayName = HubDisplayName, HubSearchKeywords = HubSearchKeywords)
  output <- .sagemaker$update_hub_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_hub <- sagemaker_update_hub

#' Updates the properties of a SageMaker AI image
#'
#' @description
#' Updates the properties of a SageMaker AI image. To change the image's tags, use the [`add_tags`][sagemaker_add_tags] and [`delete_tags`][sagemaker_delete_tags] APIs.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_image/](https://www.paws-r-sdk.com/docs/sagemaker_update_image/) for full documentation.
#'
#' @param DeleteProperties A list of properties to delete. Only the `Description` and `DisplayName`
#' properties can be deleted.
#' @param Description The new description for the image.
#' @param DisplayName The new display name for the image.
#' @param ImageName &#91;required&#93; The name of the image to update.
#' @param RoleArn The new ARN for the IAM role that enables Amazon SageMaker AI to perform
#' tasks on your behalf.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_image
sagemaker_update_image <- function(DeleteProperties = NULL, Description = NULL, DisplayName = NULL, ImageName, RoleArn = NULL) {
  op <- new_operation(
    name = "UpdateImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_image_input(DeleteProperties = DeleteProperties, Description = Description, DisplayName = DisplayName, ImageName = ImageName, RoleArn = RoleArn)
  output <- .sagemaker$update_image_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_image <- sagemaker_update_image

#' Updates the properties of a SageMaker AI image version
#'
#' @description
#' Updates the properties of a SageMaker AI image version.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_image_version/](https://www.paws-r-sdk.com/docs/sagemaker_update_image_version/) for full documentation.
#'
#' @param ImageName &#91;required&#93; The name of the image.
#' @param Alias The alias of the image version.
#' @param Version The version of the image.
#' @param AliasesToAdd A list of aliases to add.
#' @param AliasesToDelete A list of aliases to delete.
#' @param VendorGuidance The availability of the image version specified by the maintainer.
#' 
#' -   `NOT_PROVIDED`: The maintainers did not provide a status for image
#'     version stability.
#' 
#' -   `STABLE`: The image version is stable.
#' 
#' -   `TO_BE_ARCHIVED`: The image version is set to be archived. Custom
#'     image versions that are set to be archived are automatically
#'     archived after three months.
#' 
#' -   `ARCHIVED`: The image version is archived. Archived image versions
#'     are not searchable and are no longer actively supported.
#' @param JobType Indicates SageMaker AI job type compatibility.
#' 
#' -   `TRAINING`: The image version is compatible with SageMaker AI
#'     training jobs.
#' 
#' -   `INFERENCE`: The image version is compatible with SageMaker AI
#'     inference jobs.
#' 
#' -   `NOTEBOOK_KERNEL`: The image version is compatible with SageMaker AI
#'     notebook kernels.
#' @param MLFramework The machine learning framework vended in the image version.
#' @param ProgrammingLang The supported programming language and its version.
#' @param Processor Indicates CPU or GPU compatibility.
#' 
#' -   `CPU`: The image version is compatible with CPU.
#' 
#' -   `GPU`: The image version is compatible with GPU.
#' @param Horovod Indicates Horovod compatibility.
#' @param ReleaseNotes The maintainer description of the image version.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_image_version
sagemaker_update_image_version <- function(ImageName, Alias = NULL, Version = NULL, AliasesToAdd = NULL, AliasesToDelete = NULL, VendorGuidance = NULL, JobType = NULL, MLFramework = NULL, ProgrammingLang = NULL, Processor = NULL, Horovod = NULL, ReleaseNotes = NULL) {
  op <- new_operation(
    name = "UpdateImageVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_image_version_input(ImageName = ImageName, Alias = Alias, Version = Version, AliasesToAdd = AliasesToAdd, AliasesToDelete = AliasesToDelete, VendorGuidance = VendorGuidance, JobType = JobType, MLFramework = MLFramework, ProgrammingLang = ProgrammingLang, Processor = Processor, Horovod = Horovod, ReleaseNotes = ReleaseNotes)
  output <- .sagemaker$update_image_version_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_image_version <- sagemaker_update_image_version

#' Updates an inference component
#'
#' @description
#' Updates an inference component.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_inference_component/](https://www.paws-r-sdk.com/docs/sagemaker_update_inference_component/) for full documentation.
#'
#' @param InferenceComponentName &#91;required&#93; The name of the inference component.
#' @param Specification Details about the resources to deploy with this inference component,
#' including the model, container, and compute resources.
#' @param RuntimeConfig Runtime settings for a model that is deployed with an inference
#' component.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_inference_component
sagemaker_update_inference_component <- function(InferenceComponentName, Specification = NULL, RuntimeConfig = NULL) {
  op <- new_operation(
    name = "UpdateInferenceComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_inference_component_input(InferenceComponentName = InferenceComponentName, Specification = Specification, RuntimeConfig = RuntimeConfig)
  output <- .sagemaker$update_inference_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_inference_component <- sagemaker_update_inference_component

#' Runtime settings for a model that is deployed with an inference
#' component
#'
#' @description
#' Runtime settings for a model that is deployed with an inference component.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_inference_component_runtime_config/](https://www.paws-r-sdk.com/docs/sagemaker_update_inference_component_runtime_config/) for full documentation.
#'
#' @param InferenceComponentName &#91;required&#93; The name of the inference component to update.
#' @param DesiredRuntimeConfig &#91;required&#93; Runtime settings for a model that is deployed with an inference
#' component.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_inference_component_runtime_config
sagemaker_update_inference_component_runtime_config <- function(InferenceComponentName, DesiredRuntimeConfig) {
  op <- new_operation(
    name = "UpdateInferenceComponentRuntimeConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_inference_component_runtime_config_input(InferenceComponentName = InferenceComponentName, DesiredRuntimeConfig = DesiredRuntimeConfig)
  output <- .sagemaker$update_inference_component_runtime_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_inference_component_runtime_config <- sagemaker_update_inference_component_runtime_config

#' Updates an inference experiment that you created
#'
#' @description
#' Updates an inference experiment that you created. The status of the inference experiment has to be either `Created`, `Running`. For more information on the status of an inference experiment, see [`describe_inference_experiment`][sagemaker_describe_inference_experiment].
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_inference_experiment/](https://www.paws-r-sdk.com/docs/sagemaker_update_inference_experiment/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the inference experiment to be updated.
#' @param Schedule The duration for which the inference experiment will run. If the status
#' of the inference experiment is `Created`, then you can update both the
#' start and end dates. If the status of the inference experiment is
#' `Running`, then you can update only the end date.
#' @param Description The description of the inference experiment.
#' @param ModelVariants An array of `ModelVariantConfig` objects. There is one for each variant,
#' whose infrastructure configuration you want to update.
#' @param DataStorageConfig The Amazon S3 location and configuration for storing inference request
#' and response data.
#' @param ShadowModeConfig The configuration of `ShadowMode` inference experiment type. Use this
#' field to specify a production variant which takes all the inference
#' requests, and a shadow variant to which Amazon SageMaker replicates a
#' percentage of the inference requests. For the shadow variant also
#' specify the percentage of requests that Amazon SageMaker replicates.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_inference_experiment
sagemaker_update_inference_experiment <- function(Name, Schedule = NULL, Description = NULL, ModelVariants = NULL, DataStorageConfig = NULL, ShadowModeConfig = NULL) {
  op <- new_operation(
    name = "UpdateInferenceExperiment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_inference_experiment_input(Name = Name, Schedule = Schedule, Description = Description, ModelVariants = ModelVariants, DataStorageConfig = DataStorageConfig, ShadowModeConfig = ShadowModeConfig)
  output <- .sagemaker$update_inference_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_inference_experiment <- sagemaker_update_inference_experiment

#' Updates properties of an existing MLflow Tracking Server
#'
#' @description
#' Updates properties of an existing MLflow Tracking Server.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_mlflow_tracking_server/](https://www.paws-r-sdk.com/docs/sagemaker_update_mlflow_tracking_server/) for full documentation.
#'
#' @param TrackingServerName &#91;required&#93; The name of the MLflow Tracking Server to update.
#' @param ArtifactStoreUri The new S3 URI for the general purpose bucket to use as the artifact
#' store for the MLflow Tracking Server.
#' @param TrackingServerSize The new size for the MLflow Tracking Server.
#' @param AutomaticModelRegistration Whether to enable or disable automatic registration of new MLflow models
#' to the SageMaker Model Registry. To enable automatic model registration,
#' set this value to `True`. To disable automatic model registration, set
#' this value to `False`. If not specified, `AutomaticModelRegistration`
#' defaults to `False`
#' @param WeeklyMaintenanceWindowStart The new weekly maintenance window start day and time to update. The
#' maintenance window day and time should be in Coordinated Universal Time
#' (UTC) 24-hour standard time. For example: TUE:03:30.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_mlflow_tracking_server
sagemaker_update_mlflow_tracking_server <- function(TrackingServerName, ArtifactStoreUri = NULL, TrackingServerSize = NULL, AutomaticModelRegistration = NULL, WeeklyMaintenanceWindowStart = NULL) {
  op <- new_operation(
    name = "UpdateMlflowTrackingServer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_mlflow_tracking_server_input(TrackingServerName = TrackingServerName, ArtifactStoreUri = ArtifactStoreUri, TrackingServerSize = TrackingServerSize, AutomaticModelRegistration = AutomaticModelRegistration, WeeklyMaintenanceWindowStart = WeeklyMaintenanceWindowStart)
  output <- .sagemaker$update_mlflow_tracking_server_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_mlflow_tracking_server <- sagemaker_update_mlflow_tracking_server

#' Update an Amazon SageMaker Model Card
#'
#' @description
#' Update an Amazon SageMaker Model Card.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_model_card/](https://www.paws-r-sdk.com/docs/sagemaker_update_model_card/) for full documentation.
#'
#' @param ModelCardName &#91;required&#93; The name or Amazon Resource Name (ARN) of the model card to update.
#' @param Content The updated model card content. Content must be in [model card JSON
#' schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema)
#' and provided as a string.
#' 
#' When updating model card content, be sure to include the full content
#' and not just updated content.
#' @param ModelCardStatus The approval status of the model card within your organization.
#' Different organizations might have different criteria for model card
#' review and approval.
#' 
#' -   `Draft`: The model card is a work in progress.
#' 
#' -   `PendingReview`: The model card is pending review.
#' 
#' -   `Approved`: The model card is approved.
#' 
#' -   `Archived`: The model card is archived. No more updates should be
#'     made to the model card, but it can still be exported.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_model_card
sagemaker_update_model_card <- function(ModelCardName, Content = NULL, ModelCardStatus = NULL) {
  op <- new_operation(
    name = "UpdateModelCard",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_model_card_input(ModelCardName = ModelCardName, Content = Content, ModelCardStatus = ModelCardStatus)
  output <- .sagemaker$update_model_card_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_model_card <- sagemaker_update_model_card

#' Updates a versioned model
#'
#' @description
#' Updates a versioned model.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_model_package/](https://www.paws-r-sdk.com/docs/sagemaker_update_model_package/) for full documentation.
#'
#' @param ModelPackageArn &#91;required&#93; The Amazon Resource Name (ARN) of the model package.
#' @param ModelApprovalStatus The approval status of the model.
#' @param ApprovalDescription A description for the approval status of the model.
#' @param CustomerMetadataProperties The metadata properties associated with the model package versions.
#' @param CustomerMetadataPropertiesToRemove The metadata properties associated with the model package versions to
#' remove.
#' @param AdditionalInferenceSpecificationsToAdd An array of additional Inference Specification objects to be added to
#' the existing array additional Inference Specification. Total number of
#' additional Inference Specifications can not exceed 15. Each additional
#' Inference Specification specifies artifacts based on this model package
#' that can be used on inference endpoints. Generally used with SageMaker
#' Neo to store the compiled artifacts.
#' @param InferenceSpecification Specifies details about inference jobs that you can run with models
#' based on this model package, including the following information:
#' 
#' -   The Amazon ECR paths of containers that contain the inference code
#'     and model artifacts.
#' 
#' -   The instance types that the model package supports for transform
#'     jobs and real-time endpoints used for inference.
#' 
#' -   The input and output content formats that the model package supports
#'     for inference.
#' @param SourceUri The URI of the source for the model package.
#' @param ModelCard The model card associated with the model package. Since
#' `ModelPackageModelCard` is tied to a model package, it is a specific
#' usage of a model card and its schema is simplified compared to the
#' schema of `ModelCard`. The `ModelPackageModelCard` schema does not
#' include `model_package_details`, and `model_overview` is composed of the
#' `model_creator` and `model_artifact` properties. For more information
#' about the model package model card schema, see [Model package model card
#' schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema).
#' For more information about the model card associated with the model
#' package, see [View the Details of a Model
#' Version](https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html).
#' @param ModelLifeCycle A structure describing the current state of the model in its life cycle.
#' @param ClientToken A unique token that guarantees that the call to this API is idempotent.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_model_package
sagemaker_update_model_package <- function(ModelPackageArn, ModelApprovalStatus = NULL, ApprovalDescription = NULL, CustomerMetadataProperties = NULL, CustomerMetadataPropertiesToRemove = NULL, AdditionalInferenceSpecificationsToAdd = NULL, InferenceSpecification = NULL, SourceUri = NULL, ModelCard = NULL, ModelLifeCycle = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "UpdateModelPackage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_model_package_input(ModelPackageArn = ModelPackageArn, ModelApprovalStatus = ModelApprovalStatus, ApprovalDescription = ApprovalDescription, CustomerMetadataProperties = CustomerMetadataProperties, CustomerMetadataPropertiesToRemove = CustomerMetadataPropertiesToRemove, AdditionalInferenceSpecificationsToAdd = AdditionalInferenceSpecificationsToAdd, InferenceSpecification = InferenceSpecification, SourceUri = SourceUri, ModelCard = ModelCard, ModelLifeCycle = ModelLifeCycle, ClientToken = ClientToken)
  output <- .sagemaker$update_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_model_package <- sagemaker_update_model_package

#' Update the parameters of a model monitor alert
#'
#' @description
#' Update the parameters of a model monitor alert.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_monitoring_alert/](https://www.paws-r-sdk.com/docs/sagemaker_update_monitoring_alert/) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of a monitoring schedule.
#' @param MonitoringAlertName &#91;required&#93; The name of a monitoring alert.
#' @param DatapointsToAlert &#91;required&#93; Within `EvaluationPeriod`, how many execution failures will raise an
#' alert.
#' @param EvaluationPeriod &#91;required&#93; The number of most recent monitoring executions to consider when
#' evaluating alert status.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_monitoring_alert
sagemaker_update_monitoring_alert <- function(MonitoringScheduleName, MonitoringAlertName, DatapointsToAlert, EvaluationPeriod) {
  op <- new_operation(
    name = "UpdateMonitoringAlert",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_monitoring_alert_input(MonitoringScheduleName = MonitoringScheduleName, MonitoringAlertName = MonitoringAlertName, DatapointsToAlert = DatapointsToAlert, EvaluationPeriod = EvaluationPeriod)
  output <- .sagemaker$update_monitoring_alert_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_monitoring_alert <- sagemaker_update_monitoring_alert

#' Updates a previously created schedule
#'
#' @description
#' Updates a previously created schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_monitoring_schedule/](https://www.paws-r-sdk.com/docs/sagemaker_update_monitoring_schedule/) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the monitoring schedule. The name must be unique within an
#' Amazon Web Services Region within an Amazon Web Services account.
#' @param MonitoringScheduleConfig &#91;required&#93; The configuration object that specifies the monitoring schedule and
#' defines the monitoring job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_monitoring_schedule
sagemaker_update_monitoring_schedule <- function(MonitoringScheduleName, MonitoringScheduleConfig) {
  op <- new_operation(
    name = "UpdateMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName, MonitoringScheduleConfig = MonitoringScheduleConfig)
  output <- .sagemaker$update_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_monitoring_schedule <- sagemaker_update_monitoring_schedule

#' Updates a notebook instance
#'
#' @description
#' Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance used for your notebook instance to accommodate changes in your workload requirements.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_notebook_instance/](https://www.paws-r-sdk.com/docs/sagemaker_update_notebook_instance/) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to update.
#' @param InstanceType The Amazon ML compute instance type.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM role that SageMaker AI can
#' assume to access the notebook instance. For more information, see
#' [SageMaker AI
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to SageMaker AI, the caller of this API
#' must have the `iam:PassRole` permission.
#' @param LifecycleConfigName The name of a lifecycle configuration to associate with the notebook
#' instance. For information about lifestyle configurations, see [Step 2.1:
#' (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#' @param DisassociateLifecycleConfig Set to `true` to remove the notebook instance lifecycle configuration
#' currently associated with the notebook instance. This operation is
#' idempotent. If you specify a lifecycle configuration that is not
#' associated with the notebook instance when you call this method, it does
#' not throw an error.
#' @param VolumeSizeInGB The size, in GB, of the ML storage volume to attach to the notebook
#' instance. The default value is 5 GB. ML storage volumes are encrypted,
#' so SageMaker AI can't determine the amount of available free space on
#' the volume. Because of this, you can increase the volume size when you
#' update a notebook instance, but you can't decrease the volume size. If
#' you want to decrease the size of the ML storage volume in use, create a
#' new notebook instance with the desired size.
#' @param DefaultCodeRepository The Git repository to associate with the notebook instance as its
#' default code repository. This can be either the name of a Git repository
#' stored as a resource in your account, or the URL of a Git repository in
#' [Amazon Web Services
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. When you open a notebook instance, it
#' opens in the directory that contains this repository. For more
#' information, see [Associating Git Repositories with SageMaker AI
#' Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AdditionalCodeRepositories An array of up to three Git repositories to associate with the notebook
#' instance. These can be either the names of Git repositories stored as
#' resources in your account, or the URL of Git repositories in [Amazon Web
#' Services
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. These repositories are cloned at the
#' same level as the default repository of your notebook instance. For more
#' information, see [Associating Git Repositories with SageMaker AI
#' Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AcceleratorTypes This parameter is no longer supported. Elastic Inference (EI) is no
#' longer available.
#' 
#' This parameter was used to specify a list of the EI instance types to
#' associate with this notebook instance.
#' @param DisassociateAcceleratorTypes This parameter is no longer supported. Elastic Inference (EI) is no
#' longer available.
#' 
#' This parameter was used to specify a list of the EI instance types to
#' remove from this notebook instance.
#' @param DisassociateDefaultCodeRepository The name or URL of the default Git repository to remove from this
#' notebook instance. This operation is idempotent. If you specify a Git
#' repository that is not associated with the notebook instance when you
#' call this method, it does not throw an error.
#' @param DisassociateAdditionalCodeRepositories A list of names or URLs of the default Git repositories to remove from
#' this notebook instance. This operation is idempotent. If you specify a
#' Git repository that is not associated with the notebook instance when
#' you call this method, it does not throw an error.
#' @param RootAccess Whether root access is enabled or disabled for users of the notebook
#' instance. The default value is `Enabled`.
#' 
#' If you set this to `Disabled`, users don't have root access on the
#' notebook instance, but lifecycle configuration scripts still run with
#' root permissions.
#' @param InstanceMetadataServiceConfiguration Information on the IMDS configuration of the notebook instance
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_notebook_instance
sagemaker_update_notebook_instance <- function(NotebookInstanceName, InstanceType = NULL, RoleArn = NULL, LifecycleConfigName = NULL, DisassociateLifecycleConfig = NULL, VolumeSizeInGB = NULL, DefaultCodeRepository = NULL, AdditionalCodeRepositories = NULL, AcceleratorTypes = NULL, DisassociateAcceleratorTypes = NULL, DisassociateDefaultCodeRepository = NULL, DisassociateAdditionalCodeRepositories = NULL, RootAccess = NULL, InstanceMetadataServiceConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateNotebookInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_notebook_instance_input(NotebookInstanceName = NotebookInstanceName, InstanceType = InstanceType, RoleArn = RoleArn, LifecycleConfigName = LifecycleConfigName, DisassociateLifecycleConfig = DisassociateLifecycleConfig, VolumeSizeInGB = VolumeSizeInGB, DefaultCodeRepository = DefaultCodeRepository, AdditionalCodeRepositories = AdditionalCodeRepositories, AcceleratorTypes = AcceleratorTypes, DisassociateAcceleratorTypes = DisassociateAcceleratorTypes, DisassociateDefaultCodeRepository = DisassociateDefaultCodeRepository, DisassociateAdditionalCodeRepositories = DisassociateAdditionalCodeRepositories, RootAccess = RootAccess, InstanceMetadataServiceConfiguration = InstanceMetadataServiceConfiguration)
  output <- .sagemaker$update_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_notebook_instance <- sagemaker_update_notebook_instance

#' Updates a notebook instance lifecycle configuration created with the
#' CreateNotebookInstanceLifecycleConfig API
#'
#' @description
#' Updates a notebook instance lifecycle configuration created with the [`create_notebook_instance_lifecycle_config`][sagemaker_create_notebook_instance_lifecycle_config] API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_notebook_instance_lifecycle_config/](https://www.paws-r-sdk.com/docs/sagemaker_update_notebook_instance_lifecycle_config/) for full documentation.
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration.
#' @param OnCreate The shell script that runs only once, when you create a notebook
#' instance. The shell script must be a base64-encoded string.
#' @param OnStart The shell script that runs every time you start a notebook instance,
#' including when you create the notebook instance. The shell script must
#' be a base64-encoded string.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_notebook_instance_lifecycle_config
sagemaker_update_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName, OnCreate = NULL, OnStart = NULL) {
  op <- new_operation(
    name = "UpdateNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName, OnCreate = OnCreate, OnStart = OnStart)
  output <- .sagemaker$update_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_notebook_instance_lifecycle_config <- sagemaker_update_notebook_instance_lifecycle_config

#' Updates all of the SageMaker Partner AI Apps in an account
#'
#' @description
#' Updates all of the SageMaker Partner AI Apps in an account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_partner_app/](https://www.paws-r-sdk.com/docs/sagemaker_update_partner_app/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the SageMaker Partner AI App to update.
#' @param MaintenanceConfig Maintenance configuration settings for the SageMaker Partner AI App.
#' @param Tier Indicates the instance type and size of the cluster attached to the
#' SageMaker Partner AI App.
#' @param ApplicationConfig Configuration settings for the SageMaker Partner AI App.
#' @param EnableIamSessionBasedIdentity When set to `TRUE`, the SageMaker Partner AI App sets the Amazon Web
#' Services IAM session name or the authenticated IAM user as the identity
#' of the SageMaker Partner AI App user.
#' @param ClientToken A unique token that guarantees that the call to this API is idempotent.
#' @param Tags Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_partner_app
sagemaker_update_partner_app <- function(Arn, MaintenanceConfig = NULL, Tier = NULL, ApplicationConfig = NULL, EnableIamSessionBasedIdentity = NULL, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "UpdatePartnerApp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_partner_app_input(Arn = Arn, MaintenanceConfig = MaintenanceConfig, Tier = Tier, ApplicationConfig = ApplicationConfig, EnableIamSessionBasedIdentity = EnableIamSessionBasedIdentity, ClientToken = ClientToken, Tags = Tags)
  output <- .sagemaker$update_partner_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_partner_app <- sagemaker_update_partner_app

#' Updates a pipeline
#'
#' @description
#' Updates a pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_pipeline/](https://www.paws-r-sdk.com/docs/sagemaker_update_pipeline/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline to update.
#' @param PipelineDisplayName The display name of the pipeline.
#' @param PipelineDefinition The JSON pipeline definition.
#' @param PipelineDefinitionS3Location The location of the pipeline definition stored in Amazon S3. If
#' specified, SageMaker will retrieve the pipeline definition from this
#' location.
#' @param PipelineDescription The description of the pipeline.
#' @param RoleArn The Amazon Resource Name (ARN) that the pipeline uses to execute.
#' @param ParallelismConfiguration If specified, it applies to all executions of this pipeline by default.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_pipeline
sagemaker_update_pipeline <- function(PipelineName, PipelineDisplayName = NULL, PipelineDefinition = NULL, PipelineDefinitionS3Location = NULL, PipelineDescription = NULL, RoleArn = NULL, ParallelismConfiguration = NULL) {
  op <- new_operation(
    name = "UpdatePipeline",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_pipeline_input(PipelineName = PipelineName, PipelineDisplayName = PipelineDisplayName, PipelineDefinition = PipelineDefinition, PipelineDefinitionS3Location = PipelineDefinitionS3Location, PipelineDescription = PipelineDescription, RoleArn = RoleArn, ParallelismConfiguration = ParallelismConfiguration)
  output <- .sagemaker$update_pipeline_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_pipeline <- sagemaker_update_pipeline

#' Updates a pipeline execution
#'
#' @description
#' Updates a pipeline execution.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_pipeline_execution/](https://www.paws-r-sdk.com/docs/sagemaker_update_pipeline_execution/) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#' @param PipelineExecutionDescription The description of the pipeline execution.
#' @param PipelineExecutionDisplayName The display name of the pipeline execution.
#' @param ParallelismConfiguration This configuration, if specified, overrides the parallelism
#' configuration of the parent pipeline for this specific run.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_pipeline_execution
sagemaker_update_pipeline_execution <- function(PipelineExecutionArn, PipelineExecutionDescription = NULL, PipelineExecutionDisplayName = NULL, ParallelismConfiguration = NULL) {
  op <- new_operation(
    name = "UpdatePipelineExecution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_pipeline_execution_input(PipelineExecutionArn = PipelineExecutionArn, PipelineExecutionDescription = PipelineExecutionDescription, PipelineExecutionDisplayName = PipelineExecutionDisplayName, ParallelismConfiguration = ParallelismConfiguration)
  output <- .sagemaker$update_pipeline_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_pipeline_execution <- sagemaker_update_pipeline_execution

#' Updates a machine learning (ML) project that is created from a template
#' that sets up an ML pipeline from training to deploying an approved model
#'
#' @description
#' Updates a machine learning (ML) project that is created from a template that sets up an ML pipeline from training to deploying an approved model.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_project/](https://www.paws-r-sdk.com/docs/sagemaker_update_project/) for full documentation.
#'
#' @param ProjectName &#91;required&#93; The name of the project.
#' @param ProjectDescription The description for the project.
#' @param ServiceCatalogProvisioningUpdateDetails The product ID and provisioning artifact ID to provision a service
#' catalog. The provisioning artifact ID will default to the latest
#' provisioning artifact ID of the product, if you don't provide the
#' provisioning artifact ID. For more information, see [What is Amazon Web
#' Services Service
#' Catalog](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html).
#' In addition, the project must have tag update constraints set in order
#' to include this parameter in the request. For more information, see
#' [Amazon Web Services Service Catalog Tag Update
#' Constraints](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/constraints-resourceupdate.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_project
sagemaker_update_project <- function(ProjectName, ProjectDescription = NULL, ServiceCatalogProvisioningUpdateDetails = NULL, Tags = NULL) {
  op <- new_operation(
    name = "UpdateProject",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_project_input(ProjectName = ProjectName, ProjectDescription = ProjectDescription, ServiceCatalogProvisioningUpdateDetails = ServiceCatalogProvisioningUpdateDetails, Tags = Tags)
  output <- .sagemaker$update_project_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_project <- sagemaker_update_project

#' Updates the settings of a space
#'
#' @description
#' Updates the settings of a space.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_space/](https://www.paws-r-sdk.com/docs/sagemaker_update_space/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The ID of the associated domain.
#' @param SpaceName &#91;required&#93; The name of the space.
#' @param SpaceSettings A collection of space settings.
#' @param SpaceDisplayName The name of the space that appears in the Amazon SageMaker Studio UI.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_space
sagemaker_update_space <- function(DomainId, SpaceName, SpaceSettings = NULL, SpaceDisplayName = NULL) {
  op <- new_operation(
    name = "UpdateSpace",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_space_input(DomainId = DomainId, SpaceName = SpaceName, SpaceSettings = SpaceSettings, SpaceDisplayName = SpaceDisplayName)
  output <- .sagemaker$update_space_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_space <- sagemaker_update_space

#' Update a model training job to request a new Debugger profiling
#' configuration or to change warm pool retention length
#'
#' @description
#' Update a model training job to request a new Debugger profiling configuration or to change warm pool retention length.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_training_job/](https://www.paws-r-sdk.com/docs/sagemaker_update_training_job/) for full documentation.
#'
#' @param TrainingJobName &#91;required&#93; The name of a training job to update the Debugger profiling
#' configuration.
#' @param ProfilerConfig Configuration information for Amazon SageMaker Debugger system
#' monitoring, framework profiling, and storage paths.
#' @param ProfilerRuleConfigurations Configuration information for Amazon SageMaker Debugger rules for
#' profiling system and framework metrics.
#' @param ResourceConfig The training job `ResourceConfig` to update warm pool retention length.
#' @param RemoteDebugConfig Configuration for remote debugging while the training job is running.
#' You can update the remote debugging configuration when the
#' `SecondaryStatus` of the job is `Downloading` or `Training`.To learn
#' more about the remote debugging functionality of SageMaker, see [Access
#' a training container through Amazon Web Services Systems Manager (SSM)
#' for remote
#' debugging](https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_training_job
sagemaker_update_training_job <- function(TrainingJobName, ProfilerConfig = NULL, ProfilerRuleConfigurations = NULL, ResourceConfig = NULL, RemoteDebugConfig = NULL) {
  op <- new_operation(
    name = "UpdateTrainingJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_training_job_input(TrainingJobName = TrainingJobName, ProfilerConfig = ProfilerConfig, ProfilerRuleConfigurations = ProfilerRuleConfigurations, ResourceConfig = ResourceConfig, RemoteDebugConfig = RemoteDebugConfig)
  output <- .sagemaker$update_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_training_job <- sagemaker_update_training_job

#' Updates the display name of a trial
#'
#' @description
#' Updates the display name of a trial.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_trial/](https://www.paws-r-sdk.com/docs/sagemaker_update_trial/) for full documentation.
#'
#' @param TrialName &#91;required&#93; The name of the trial to update.
#' @param DisplayName The name of the trial as displayed. The name doesn't need to be unique.
#' If `DisplayName` isn't specified, `TrialName` is displayed.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_trial
sagemaker_update_trial <- function(TrialName, DisplayName = NULL) {
  op <- new_operation(
    name = "UpdateTrial",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_trial_input(TrialName = TrialName, DisplayName = DisplayName)
  output <- .sagemaker$update_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_trial <- sagemaker_update_trial

#' Updates one or more properties of a trial component
#'
#' @description
#' Updates one or more properties of a trial component.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_trial_component/](https://www.paws-r-sdk.com/docs/sagemaker_update_trial_component/) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to update.
#' @param DisplayName The name of the component as displayed. The name doesn't need to be
#' unique. If `DisplayName` isn't specified, `TrialComponentName` is
#' displayed.
#' @param Status The new status of the component.
#' @param StartTime When the component started.
#' @param EndTime When the component ended.
#' @param Parameters Replaces all of the component's hyperparameters with the specified
#' hyperparameters or add new hyperparameters. Existing hyperparameters are
#' replaced if the trial component is updated with an identical
#' hyperparameter key.
#' @param ParametersToRemove The hyperparameters to remove from the component.
#' @param InputArtifacts Replaces all of the component's input artifacts with the specified
#' artifacts or adds new input artifacts. Existing input artifacts are
#' replaced if the trial component is updated with an identical input
#' artifact key.
#' @param InputArtifactsToRemove The input artifacts to remove from the component.
#' @param OutputArtifacts Replaces all of the component's output artifacts with the specified
#' artifacts or adds new output artifacts. Existing output artifacts are
#' replaced if the trial component is updated with an identical output
#' artifact key.
#' @param OutputArtifactsToRemove The output artifacts to remove from the component.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_trial_component
sagemaker_update_trial_component <- function(TrialComponentName, DisplayName = NULL, Status = NULL, StartTime = NULL, EndTime = NULL, Parameters = NULL, ParametersToRemove = NULL, InputArtifacts = NULL, InputArtifactsToRemove = NULL, OutputArtifacts = NULL, OutputArtifactsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateTrialComponent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_trial_component_input(TrialComponentName = TrialComponentName, DisplayName = DisplayName, Status = Status, StartTime = StartTime, EndTime = EndTime, Parameters = Parameters, ParametersToRemove = ParametersToRemove, InputArtifacts = InputArtifacts, InputArtifactsToRemove = InputArtifactsToRemove, OutputArtifacts = OutputArtifacts, OutputArtifactsToRemove = OutputArtifactsToRemove)
  output <- .sagemaker$update_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_trial_component <- sagemaker_update_trial_component

#' Updates a user profile
#'
#' @description
#' Updates a user profile.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_user_profile/](https://www.paws-r-sdk.com/docs/sagemaker_update_user_profile/) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#' @param UserSettings A collection of settings.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_user_profile
sagemaker_update_user_profile <- function(DomainId, UserProfileName, UserSettings = NULL) {
  op <- new_operation(
    name = "UpdateUserProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName, UserSettings = UserSettings)
  output <- .sagemaker$update_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_user_profile <- sagemaker_update_user_profile

#' Use this operation to update your workforce
#'
#' @description
#' Use this operation to update your workforce. You can use this operation to require that workers use specific IP addresses to work on tasks and to update your OpenID Connect (OIDC) Identity Provider (IdP) workforce configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_workforce/](https://www.paws-r-sdk.com/docs/sagemaker_update_workforce/) for full documentation.
#'
#' @param WorkforceName &#91;required&#93; The name of the private workforce that you want to update. You can find
#' your workforce name by using the
#' [`list_workforces`][sagemaker_list_workforces] operation.
#' @param SourceIpConfig A list of one to ten worker IP address ranges
#' ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/how-it-works.html))
#' that can be used to access tasks assigned to this workforce.
#' 
#' Maximum: Ten CIDR values
#' @param OidcConfig Use this parameter to update your OIDC Identity Provider (IdP)
#' configuration for a workforce made using your own IdP.
#' @param WorkforceVpcConfig Use this parameter to update your VPC configuration for a workforce.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_workforce
sagemaker_update_workforce <- function(WorkforceName, SourceIpConfig = NULL, OidcConfig = NULL, WorkforceVpcConfig = NULL) {
  op <- new_operation(
    name = "UpdateWorkforce",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_workforce_input(WorkforceName = WorkforceName, SourceIpConfig = SourceIpConfig, OidcConfig = OidcConfig, WorkforceVpcConfig = WorkforceVpcConfig)
  output <- .sagemaker$update_workforce_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_workforce <- sagemaker_update_workforce

#' Updates an existing work team with new member definitions or description
#'
#' @description
#' Updates an existing work team with new member definitions or description.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemaker_update_workteam/](https://www.paws-r-sdk.com/docs/sagemaker_update_workteam/) for full documentation.
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to update.
#' @param MemberDefinitions A list of `MemberDefinition` objects that contains objects that identify
#' the workers that make up the work team.
#' 
#' Workforces can be created using Amazon Cognito or your own OIDC Identity
#' Provider (IdP). For private workforces created using Amazon Cognito use
#' `CognitoMemberDefinition`. For workforces created using your own OIDC
#' identity provider (IdP) use `OidcMemberDefinition`. You should not
#' provide input for both of these parameters in a single request.
#' 
#' For workforces created using Amazon Cognito, private work teams
#' correspond to Amazon Cognito *user groups* within the user pool used to
#' create a workforce. All of the `CognitoMemberDefinition` objects that
#' make up the member definition must have the same `ClientId` and
#' `UserPool` values. To add a Amazon Cognito user group to an existing
#' worker pool, see Adding groups to a User Pool. For more information
#' about user pools, see [Amazon Cognito User
#' Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools.html).
#' 
#' For workforces created using your own OIDC IdP, specify the user groups
#' that you want to include in your private work team in
#' `OidcMemberDefinition` by listing those groups in `Groups`. Be aware
#' that user groups that are already in the work team must also be listed
#' in `Groups` when you make this request to remain on the work team. If
#' you do not include these user groups, they will no longer be associated
#' with the work team you update.
#' @param Description An updated description for the work team.
#' @param NotificationConfiguration Configures SNS topic notifications for available or expiring work items
#' @param WorkerAccessConfiguration Use this optional parameter to constrain access to an Amazon S3 resource
#' based on the IP address using supported IAM global condition keys. The
#' Amazon S3 resource is accessed in the worker portal using a Amazon S3
#' presigned URL.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_workteam
sagemaker_update_workteam <- function(WorkteamName, MemberDefinitions = NULL, Description = NULL, NotificationConfiguration = NULL, WorkerAccessConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateWorkteam",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemaker$update_workteam_input(WorkteamName = WorkteamName, MemberDefinitions = MemberDefinitions, Description = Description, NotificationConfiguration = NotificationConfiguration, WorkerAccessConfiguration = WorkerAccessConfiguration)
  output <- .sagemaker$update_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_workteam <- sagemaker_update_workteam
