% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_list_model_copy_jobs}
\alias{bedrock_list_model_copy_jobs}
\title{Returns a list of model copy jobs that you have submitted}
\usage{
bedrock_list_model_copy_jobs(
  creationTimeAfter = NULL,
  creationTimeBefore = NULL,
  statusEquals = NULL,
  sourceAccountEquals = NULL,
  sourceModelArnEquals = NULL,
  targetModelNameContains = NULL,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  sortOrder = NULL
)
}
\arguments{
\item{creationTimeAfter}{Filters for model copy jobs created after the specified time.}

\item{creationTimeBefore}{Filters for model copy jobs created before the specified time.}

\item{statusEquals}{Filters for model copy jobs whose status matches the value that you
specify.}

\item{sourceAccountEquals}{Filters for model copy jobs in which the account that the source model
belongs to is equal to the value that you specify.}

\item{sourceModelArnEquals}{Filters for model copy jobs in which the Amazon Resource Name (ARN) of
the source model to is equal to the value that you specify.}

\item{targetModelNameContains}{Filters for model copy jobs in which the name of the copied model
contains the string that you specify.}

\item{maxResults}{The maximum number of results to return in the response. If the total
number of results is greater than this value, use the token returned in
the response in the \code{nextToken} field when making another request to
return the next batch of results.}

\item{nextToken}{If the total number of results is greater than the \code{maxResults} value
provided in the request, enter the token returned in the \code{nextToken}
field in the response in this field to return the next batch of results.}

\item{sortBy}{The field to sort by in the returned list of model copy jobs.}

\item{sortOrder}{Specifies whether to sort the results in ascending or descending order.}
}
\description{
Returns a list of model copy jobs that you have submitted. You can filter the jobs to return based on one or more criteria. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html}{Copy models to be used in other regions} in the \href{https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html}{Amazon Bedrock User Guide}.

See \url{https://www.paws-r-sdk.com/docs/bedrock_list_model_copy_jobs/} for full documentation.
}
\keyword{internal}
