% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_service.R
\name{bedrockagent}
\alias{bedrockagent}
\title{Agents for Amazon Bedrock}
\usage{
bedrockagent(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Describes the API operations for creating and managing Amazon Bedrock
agents.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- bedrockagent(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=bedrockagent_associate_agent_collaborator]{associate_agent_collaborator} \tab Makes an agent a collaborator for another agent\cr
\link[=bedrockagent_associate_agent_knowledge_base]{associate_agent_knowledge_base} \tab Associates a knowledge base with an agent\cr
\link[=bedrockagent_create_agent]{create_agent} \tab Creates an agent that orchestrates interactions between foundation models, data sources, software applications, user conversations, and APIs to carry out tasks to help customers\cr
\link[=bedrockagent_create_agent_action_group]{create_agent_action_group} \tab Creates an action group for an agent\cr
\link[=bedrockagent_create_agent_alias]{create_agent_alias} \tab Creates an alias of an agent that can be used to deploy the agent\cr
\link[=bedrockagent_create_data_source]{create_data_source} \tab Connects a knowledge base to a data source\cr
\link[=bedrockagent_create_flow]{create_flow} \tab Creates a prompt flow that you can use to send an input through various steps to yield an output\cr
\link[=bedrockagent_create_flow_alias]{create_flow_alias} \tab Creates an alias of a flow for deployment\cr
\link[=bedrockagent_create_flow_version]{create_flow_version} \tab Creates a version of the flow that you can deploy\cr
\link[=bedrockagent_create_knowledge_base]{create_knowledge_base} \tab Creates a knowledge base\cr
\link[=bedrockagent_create_prompt]{create_prompt} \tab Creates a prompt in your prompt library that you can add to a flow\cr
\link[=bedrockagent_create_prompt_version]{create_prompt_version} \tab Creates a static snapshot of your prompt that can be deployed to production\cr
\link[=bedrockagent_delete_agent]{delete_agent} \tab Deletes an agent\cr
\link[=bedrockagent_delete_agent_action_group]{delete_agent_action_group} \tab Deletes an action group in an agent\cr
\link[=bedrockagent_delete_agent_alias]{delete_agent_alias} \tab Deletes an alias of an agent\cr
\link[=bedrockagent_delete_agent_version]{delete_agent_version} \tab Deletes a version of an agent\cr
\link[=bedrockagent_delete_data_source]{delete_data_source} \tab Deletes a data source from a knowledge base\cr
\link[=bedrockagent_delete_flow]{delete_flow} \tab Deletes a flow\cr
\link[=bedrockagent_delete_flow_alias]{delete_flow_alias} \tab Deletes an alias of a flow\cr
\link[=bedrockagent_delete_flow_version]{delete_flow_version} \tab Deletes a version of a flow\cr
\link[=bedrockagent_delete_knowledge_base]{delete_knowledge_base} \tab Deletes a knowledge base\cr
\link[=bedrockagent_delete_knowledge_base_documents]{delete_knowledge_base_documents} \tab Deletes documents from a data source and syncs the changes to the knowledge base that is connected to it\cr
\link[=bedrockagent_delete_prompt]{delete_prompt} \tab Deletes a prompt or a version of it, depending on whether you include the promptVersion field or not\cr
\link[=bedrockagent_disassociate_agent_collaborator]{disassociate_agent_collaborator} \tab Disassociates an agent collaborator\cr
\link[=bedrockagent_disassociate_agent_knowledge_base]{disassociate_agent_knowledge_base} \tab Disassociates a knowledge base from an agent\cr
\link[=bedrockagent_get_agent]{get_agent} \tab Gets information about an agent\cr
\link[=bedrockagent_get_agent_action_group]{get_agent_action_group} \tab Gets information about an action group for an agent\cr
\link[=bedrockagent_get_agent_alias]{get_agent_alias} \tab Gets information about an alias of an agent\cr
\link[=bedrockagent_get_agent_collaborator]{get_agent_collaborator} \tab Retrieves information about an agent's collaborator\cr
\link[=bedrockagent_get_agent_knowledge_base]{get_agent_knowledge_base} \tab Gets information about a knowledge base associated with an agent\cr
\link[=bedrockagent_get_agent_version]{get_agent_version} \tab Gets details about a version of an agent\cr
\link[=bedrockagent_get_data_source]{get_data_source} \tab Gets information about a data source\cr
\link[=bedrockagent_get_flow]{get_flow} \tab Retrieves information about a flow\cr
\link[=bedrockagent_get_flow_alias]{get_flow_alias} \tab Retrieves information about a flow\cr
\link[=bedrockagent_get_flow_version]{get_flow_version} \tab Retrieves information about a version of a flow\cr
\link[=bedrockagent_get_ingestion_job]{get_ingestion_job} \tab Gets information about a data ingestion job\cr
\link[=bedrockagent_get_knowledge_base]{get_knowledge_base} \tab Gets information about a knoweldge base\cr
\link[=bedrockagent_get_knowledge_base_documents]{get_knowledge_base_documents} \tab Retrieves specific documents from a data source that is connected to a knowledge base\cr
\link[=bedrockagent_get_prompt]{get_prompt} \tab Retrieves information about the working draft (DRAFT version) of a prompt or a version of it, depending on whether you include the promptVersion field or not\cr
\link[=bedrockagent_ingest_knowledge_base_documents]{ingest_knowledge_base_documents} \tab Ingests documents directly into the knowledge base that is connected to the data source\cr
\link[=bedrockagent_list_agent_action_groups]{list_agent_action_groups} \tab Lists the action groups for an agent and information about each one\cr
\link[=bedrockagent_list_agent_aliases]{list_agent_aliases} \tab Lists the aliases of an agent and information about each one\cr
\link[=bedrockagent_list_agent_collaborators]{list_agent_collaborators} \tab Retrieve a list of an agent's collaborators\cr
\link[=bedrockagent_list_agent_knowledge_bases]{list_agent_knowledge_bases} \tab Lists knowledge bases associated with an agent and information about each one\cr
\link[=bedrockagent_list_agents]{list_agents} \tab Lists the agents belonging to an account and information about each agent\cr
\link[=bedrockagent_list_agent_versions]{list_agent_versions} \tab Lists the versions of an agent and information about each version\cr
\link[=bedrockagent_list_data_sources]{list_data_sources} \tab Lists the data sources in a knowledge base and information about each one\cr
\link[=bedrockagent_list_flow_aliases]{list_flow_aliases} \tab Returns a list of aliases for a flow\cr
\link[=bedrockagent_list_flows]{list_flows} \tab Returns a list of flows and information about each flow\cr
\link[=bedrockagent_list_flow_versions]{list_flow_versions} \tab Returns a list of information about each flow\cr
\link[=bedrockagent_list_ingestion_jobs]{list_ingestion_jobs} \tab Lists the data ingestion jobs for a data source\cr
\link[=bedrockagent_list_knowledge_base_documents]{list_knowledge_base_documents} \tab Retrieves all the documents contained in a data source that is connected to a knowledge base\cr
\link[=bedrockagent_list_knowledge_bases]{list_knowledge_bases} \tab Lists the knowledge bases in an account\cr
\link[=bedrockagent_list_prompts]{list_prompts} \tab Returns either information about the working draft (DRAFT version) of each prompt in an account, or information about of all versions of a prompt, depending on whether you include the promptIdentifier field or not\cr
\link[=bedrockagent_list_tags_for_resource]{list_tags_for_resource} \tab List all the tags for the resource you specify\cr
\link[=bedrockagent_prepare_agent]{prepare_agent} \tab Creates a DRAFT version of the agent that can be used for internal testing\cr
\link[=bedrockagent_prepare_flow]{prepare_flow} \tab Prepares the DRAFT version of a flow so that it can be invoked\cr
\link[=bedrockagent_start_ingestion_job]{start_ingestion_job} \tab Begins a data ingestion job\cr
\link[=bedrockagent_stop_ingestion_job]{stop_ingestion_job} \tab Stops a currently running data ingestion job\cr
\link[=bedrockagent_tag_resource]{tag_resource} \tab Associate tags with a resource\cr
\link[=bedrockagent_untag_resource]{untag_resource} \tab Remove tags from a resource\cr
\link[=bedrockagent_update_agent]{update_agent} \tab Updates the configuration of an agent\cr
\link[=bedrockagent_update_agent_action_group]{update_agent_action_group} \tab Updates the configuration for an action group for an agent\cr
\link[=bedrockagent_update_agent_alias]{update_agent_alias} \tab Updates configurations for an alias of an agent\cr
\link[=bedrockagent_update_agent_collaborator]{update_agent_collaborator} \tab Updates an agent's collaborator\cr
\link[=bedrockagent_update_agent_knowledge_base]{update_agent_knowledge_base} \tab Updates the configuration for a knowledge base that has been associated with an agent\cr
\link[=bedrockagent_update_data_source]{update_data_source} \tab Updates the configurations for a data source connector\cr
\link[=bedrockagent_update_flow]{update_flow} \tab Modifies a flow\cr
\link[=bedrockagent_update_flow_alias]{update_flow_alias} \tab Modifies the alias of a flow\cr
\link[=bedrockagent_update_knowledge_base]{update_knowledge_base} \tab Updates the configuration of a knowledge base with the fields that you specify\cr
\link[=bedrockagent_update_prompt]{update_prompt} \tab Modifies a prompt in your prompt library\cr
\link[=bedrockagent_validate_flow_definition]{validate_flow_definition} \tab Validates the definition of a flow
}
}

\examples{
\dontrun{
svc <- bedrockagent()
svc$associate_agent_collaborator(
  Foo = 123
)
}

}
