% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_batch_detect_syntax}
\alias{comprehend_batch_detect_syntax}
\title{Inspects the text of a batch of documents for the syntax and part of
speech of the words in the document and returns information about them}
\usage{
comprehend_batch_detect_syntax(TextList, LanguageCode)
}
\arguments{
\item{TextList}{[required] A list containing the UTF-8 encoded text of the input documents. The
list can contain a maximum of 25 documents. The maximum size for each
document is 5 KB.}

\item{LanguageCode}{[required] The language of the input documents. You can specify any of the
following languages supported by Amazon Comprehend: German ("de"),
English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), or
Portuguese ("pt"). All documents must be in the same language.}
}
\description{
Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and returns information about them. For more information, see \href{https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html}{Syntax} in the Comprehend Developer Guide.

See \url{https://www.paws-r-sdk.com/docs/comprehend_batch_detect_syntax/} for full documentation.
}
\keyword{internal}
