% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_create_document_classifier}
\alias{comprehend_create_document_classifier}
\title{Creates a new document classifier that you can use to categorize
documents}
\usage{
comprehend_create_document_classifier(
  DocumentClassifierName,
  VersionName = NULL,
  DataAccessRoleArn,
  Tags = NULL,
  InputDataConfig,
  OutputDataConfig = NULL,
  ClientRequestToken = NULL,
  LanguageCode,
  VolumeKmsKeyId = NULL,
  VpcConfig = NULL,
  Mode = NULL,
  ModelKmsKeyId = NULL,
  ModelPolicy = NULL
)
}
\arguments{
\item{DocumentClassifierName}{[required] The name of the document classifier.}

\item{VersionName}{The version name given to the newly created classifier. Version names
can have a maximum of 256 characters. Alphanumeric characters, hyphens
(-) and underscores (_) are allowed. The version name must be unique
among all models with the same classifier name in the Amazon Web
Services account/Amazon Web Services Region.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that grants Amazon
Comprehend read access to your input data.}

\item{Tags}{Tags to associate with the document classifier. A tag is a key-value
pair that adds as a metadata to a resource used by Amazon Comprehend.
For example, a tag with "Sales" as the key might be added to a resource
to indicate its use by the sales department.}

\item{InputDataConfig}{[required] Specifies the format and location of the input data for the job.}

\item{OutputDataConfig}{Specifies the location for the output files from a custom classifier
job. This parameter is required for a request that creates a native
document model.}

\item{ClientRequestToken}{A unique identifier for the request. If you don't set the client request
token, Amazon Comprehend generates one.}

\item{LanguageCode}{[required] The language of the input documents. You can specify any of the
languages supported by Amazon Comprehend. All documents must be in the
same language.}

\item{VolumeKmsKeyId}{ID for the Amazon Web Services Key Management Service (KMS) key that
Amazon Comprehend uses to encrypt data on the storage volume attached to
the ML compute instance(s) that process the analysis job. The
VolumeKmsKeyId can be either of the following formats:
\itemize{
\item KMS Key ID: \code{"1234abcd-12ab-34cd-56ef-1234567890ab"}
\item Amazon Resource Name (ARN) of a KMS Key:
\code{"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"}
}}

\item{VpcConfig}{Configuration parameters for an optional private Virtual Private Cloud
(VPC) containing the resources you are using for your custom classifier.
For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html}{Amazon VPC}.}

\item{Mode}{Indicates the mode in which the classifier will be trained. The
classifier can be trained in multi-class (single-label) mode or
multi-label mode. Multi-class mode identifies a single class label for
each document and multi-label mode identifies one or more class labels
for each document. Multiple labels for an individual document are
separated by a delimiter. The default delimiter between labels is a pipe
(|).}

\item{ModelKmsKeyId}{ID for the KMS key that Amazon Comprehend uses to encrypt trained custom
models. The ModelKmsKeyId can be either of the following formats:
\itemize{
\item KMS Key ID: \code{"1234abcd-12ab-34cd-56ef-1234567890ab"}
\item Amazon Resource Name (ARN) of a KMS Key:
\code{"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"}
}}

\item{ModelPolicy}{The resource-based policy to attach to your custom document classifier
model. You can use this policy to allow another Amazon Web Services
account to import your custom model.

Provide your policy as a JSON body that you enter as a UTF-8 encoded
string without line breaks. To provide valid JSON, enclose the attribute
names and values in double quotes. If the JSON body is also enclosed in
double quotes, then you must escape the double quotes that are inside
the policy:

\verb{"\{\\"attribute\\": \\"value\\", \\"attribute\\": [\\"value\\"]\}"}

To avoid escaping quotes, you can use single quotes to enclose the
policy and double quotes to enclose the JSON names and values:

\code{'{"attribute": "value", "attribute": ["value"]}'}}
}
\description{
Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a set of training documents that are labeled with the categories that you want to use. For more information, see \href{https://docs.aws.amazon.com/comprehend/latest/dg/training-classifier-model.html}{Training classifier models} in the Comprehend Developer Guide.

See \url{https://www.paws-r-sdk.com/docs/comprehend_create_document_classifier/} for full documentation.
}
\keyword{internal}
