% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_create_project}
\alias{rekognition_create_project}
\title{Creates a new Amazon Rekognition project}
\usage{
rekognition_create_project(
  ProjectName,
  Feature = NULL,
  AutoUpdate = NULL,
  Tags = NULL
)
}
\arguments{
\item{ProjectName}{[required] The name of the project to create.}

\item{Feature}{Specifies feature that is being customized. If no value is provided
CUSTOM_LABELS is used as a default.}

\item{AutoUpdate}{Specifies whether automatic retraining should be attempted for the
versions of the project. Automatic retraining is done as a best effort.
Required argument for Content Moderation. Applicable only to adapters.}

\item{Tags}{A set of tags (key-value pairs) that you want to attach to the project.}
}
\description{
Creates a new Amazon Rekognition project. A project is a group of resources (datasets, model versions) that you use to create and manage a Amazon Rekognition Custom Labels Model or custom adapter. You can specify a feature to create the project with, if no feature is specified then Custom Labels is used by default. For adapters, you can also choose whether or not to have the project auto update by using the AutoUpdate argument. This operation requires permissions to perform the \code{rekognition:CreateProject} action.

See \url{https://www.paws-r-sdk.com/docs/rekognition_create_project/} for full documentation.
}
\keyword{internal}
