% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_text_detection}
\alias{rekognition_start_text_detection}
\title{Starts asynchronous detection of text in a stored video}
\usage{
rekognition_start_text_detection(
  Video,
  ClientRequestToken = NULL,
  NotificationChannel = NULL,
  JobTag = NULL,
  Filters = NULL
)
}
\arguments{
\item{Video}{[required]}

\item{ClientRequestToken}{Idempotent token used to identify the start request. If you use the same
token with multiple
\code{\link[=rekognition_start_text_detection]{start_text_detection}} requests, the
same \code{JobId} is returned. Use \code{ClientRequestToken} to prevent the same
job from being accidentaly started more than once.}

\item{NotificationChannel}{}

\item{JobTag}{An identifier returned in the completion status published by your Amazon
Simple Notification Service topic. For example, you can use \code{JobTag} to
group related jobs and identify them in the completion notification.}

\item{Filters}{Optional parameters that let you set criteria the text must meet to be
included in your response.}
}
\description{
Starts asynchronous detection of text in a stored video.

See \url{https://www.paws-r-sdk.com/docs/rekognition_start_text_detection/} for full documentation.
}
\keyword{internal}
