% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_edge_packaging_job}
\alias{sagemaker_create_edge_packaging_job}
\title{Starts a SageMaker Edge Manager model packaging job}
\usage{
sagemaker_create_edge_packaging_job(
  EdgePackagingJobName,
  CompilationJobName,
  ModelName,
  ModelVersion,
  RoleArn,
  OutputConfig,
  ResourceKey = NULL,
  Tags = NULL
)
}
\arguments{
\item{EdgePackagingJobName}{[required] The name of the edge packaging job.}

\item{CompilationJobName}{[required] The name of the SageMaker Neo compilation job that will be used to
locate model artifacts for packaging.}

\item{ModelName}{[required] The name of the model.}

\item{ModelVersion}{[required] The version of the model.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that enables Amazon
SageMaker to download and upload the model, and to contact SageMaker
Neo.}

\item{OutputConfig}{[required] Provides information about the output location for the packaged model.}

\item{ResourceKey}{The Amazon Web Services KMS key to use when encrypting the EBS volume
the edge packaging job runs on.}

\item{Tags}{Creates tags for the packaging job.}
}
\description{
Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the resulting artifacts to an S3 bucket that you specify.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_edge_packaging_job/} for full documentation.
}
\keyword{internal}
