% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_stats.R
\name{expectedHomozygosity}
\alias{expectedHomozygosity}
\alias{expectedHeterozygosity}
\title{Expected homozygosity and heterozygosity}
\usage{
expectedHomozygosity(p)

expectedHeterozygosity(p)
}
\arguments{
\item{p}{A numeric vector of allele frequencies, or a \code{marker} object (from
which the frequencies are extracted with \code{\link[=afreq]{afreq()}}).}
}
\value{
A numeric value giving the expected homozygosity or heterozygosity.
}
\description{
Computes the expected homozygosity and heterozygosity for a marker from its
allele frequencies. The homozygosity is \eqn{\sum_i p_i^2} and the
heterozygosity is one minus this.
}
\examples{
p = c(0.2, 0.5, 0.3)
expectedHomozygosity(p)
expectedHeterozygosity(p)

}
