% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-modifications.R
\name{phint_invert}
\alias{phint_invert}
\title{Get the gaps in a phinterval as time spans}
\usage{
phint_invert(phint, hole_to = c("hole", "inf", "na"))
}
\arguments{
\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector.}

\item{hole_to}{\verb{["hole" / "inf" / "na"]}

How to handle holes (empty phinterval elements):
\itemize{
\item \code{"hole"} (default): Holes remain as holes
\item \code{"inf"}: Return a span from \code{-Inf} to \code{Inf} (all time)
\item \code{"na"}: Return an \code{NA} phinterval
}}
}
\value{
A \verb{<phinterval>} vector the same length as \code{phint}.
}
\description{
\code{phint_invert()} returns the gaps within a phinterval as a \verb{<phinterval>} vector.
For phintervals with multiple disjoint spans, the gaps between those spans are
returned. Contiguous time spans (e.g., \code{\link[lubridate:interval]{lubridate::interval()}} vectors) have no
gaps and are inverted to holes.

\code{phint_invert()} is similar to \code{phint_complement()}, except that time occurring
outside the extent of \code{phint} (before its earliest start or after its latest
end) is not included in the result.
}
\examples{
monday <- interval(as.Date("2025-11-10"), as.Date("2025-11-11"))
friday <- interval(as.Date("2025-11-14"), as.Date("2025-11-15"))
sunday <- interval(as.Date("2025-11-16"), as.Date("2025-11-17"))

# Contiguous intervals have no gaps (inverted to holes)
phint_invert(monday)

# Disjoint intervals: gaps between spans are returned
phint_invert(phint_squash(c(monday, friday, sunday)))

# The gap between Monday and Friday is Tuesday through Thursday
tues_to_thurs <- interval(as.Date("2025-11-11"), as.Date("2025-11-14"))
phint_invert(phint_union(monday, friday)) == tues_to_thurs

# Invert vs complement: time before and after is excluded from invert
mon_and_fri <- phint_union(monday, friday)
phint_invert(mon_and_fri)
phint_complement(mon_and_fri)

# How to invert holes
hole <- phint_intersect(monday, friday)
phint_invert(hole, hole_to = "hole")
phint_invert(hole, hole_to = "inf")
phint_invert(hole, hole_to = "na")

}
