% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsetplot.R
\name{detect_upset_datatype}
\alias{detect_upset_datatype}
\title{Detect the type of the input data for Upset plot}
\usage{
detect_upset_datatype(data, group_by = NULL, id_by = NULL)
}
\arguments{
\item{data}{A data frame or a list}

\item{group_by}{A character string specifying the column name of the data frame to group the data.}

\item{id_by}{A character string specifying the column name of the data frame to identify the instances.
Required when \code{group_by} is a single column and data is a data frame.}
}
\value{
A character string indicating the datatype of the input data or error message if invalid.
Possible values are "long", "wide", "list" and "upset".
"long" indicates the data is in long format.
"wide" indicates the data is in wide format.
"list" indicates the data is a list.
"upset" indicates the data is a UpsetPlotData object.
}
\description{
Detect the type of the input data for Upset plot
}
\keyword{internal}
