% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stpls.R
\name{stpls}
\alias{stpls}
\title{Soft-Threshold PLS (ST-PLS)}
\usage{
stpls(..., method = c("stpls", "model.frame"))
}
\arguments{
\item{...}{arguments for the underlying \code{stpls.fit} (see Details) and argumetns passed on to \code{mvrV}).}

\item{method}{choice between the default \code{stpls} and alternative \code{model.frame}.}
}
\value{
Returns an object of class mvrV, simliar to to mvr object of the pls package.
}
\description{
A soft-thresholding step in PLS algorithm (ST-PLS) based on
ideas from the nearest shrunken centroid method.
}
\details{
The ST-PLS approach is more or less identical to the Sparse-PLS presented
independently by Lè Cao et al. This implementation is an expansion of code from the
pls package. Arguments for \code{stpls.fit} include \code{ncomp} and \code{shrink}, where
the forme sets then number of components and the latter is the shrinkage parameter
indicating how large proportion of the maximum absolute value of the loadings that
should be subtracted from the loadings in the nearest shrunken centroid method.
}
\examples{
data(yarn, package = "pls")
st <- stpls(density~NIR, ncomp=5, shrink=c(0.1,0.2), validation="CV", data=yarn)
summary(st)

}
\references{
S. Sæbø, T. Almøy, J. Aarøe, A.H. Aastveit, ST-PLS: a multi-dimensional 
nearest shrunken centroid type classifier via pls, Journal of Chemometrics 20 (2007) 54-62.
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}},
\code{\link{lda_from_pls}}, \code{\link{lda_from_pls_cv}}, \code{\link{setDA}}.
}
\author{
Solve Sæbø, Tahir Mehmood, Kristian Hovde Liland.
}
