% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{plot.dataRes}
\alias{plot.dataRes}
\title{Plot dataRes object}
\usage{
\method{plot}{dataRes}(
  x,
  metric = NULL,
  density = FALSE,
  ncols = NULL,
  interactive = FALSE,
  x_lab = NULL,
  x_lab_sd = NULL,
  x_lab_median = NULL,
  y_lab = NULL,
  y_lab_sd = NULL,
  y_lab_median = NULL,
  x_lab_size = 11,
  y_lab_size = 11,
  x_lab_angle = NULL,
  title_lab = NULL,
  title_lab_sd = NULL,
  title_lab_median = NULL,
  title_lab_size = 14,
  legend_lab = NULL,
  legend_position = "right",
  point_size = 2,
  bin_width = 1,
  bw_theme = TRUE,
  palette = NULL,
  ...
)
}
\arguments{
\item{x}{object of class dataRes, created by the
\code{\link{edata_summary}} function}

\item{metric}{character string indicating which metric to use in plot:
'mean', 'median', 'sd, 'pct_obs', 'min', or 'max'}

\item{density}{logical value, defaults to FALSE. If TRUE, a density plot of
the specified metric is returned.}

\item{ncols}{integer value specifying the number columns for the histogram
facet_wrap. This argument is used when \code{metric} is not null. The
default is NULL.}

\item{interactive}{logical value. If TRUE, produces an interactive plot.}

\item{x_lab}{character string specifying the x-axis label when the metric
argument is NULL. The default is NULL in which case the x-axis label will
be "count".}

\item{x_lab_sd}{character string used for the x-axis label for the
mean/standard deviation plot when the \code{metric} argument is not NULL.}

\item{x_lab_median}{character string used for the x-axis label for the
mean/median plot when the \code{metric} argument is not NULL.}

\item{y_lab}{character string specifying the y-axis label. The default is
NULL in which case the y-axis label will be the metric selected for the
\code{metric} argument.}

\item{y_lab_sd}{character string used for the y-axis label for the
mean/standard deviation plot when the \code{metric} argument is not NULL.}

\item{y_lab_median}{character string used for the y-axis label for the
mean/median plot when the \code{metric} argument is not NULL.}

\item{x_lab_size}{integer value indicating the font size for the x-axis. The
default is 11.}

\item{y_lab_size}{integer value indicating the font size for the y-axis. The
default is 11.}

\item{x_lab_angle}{integer value indicating the angle of x-axis labels}

\item{title_lab}{character string specifying the plot title when the
\code{metric} argument is NULL.}

\item{title_lab_sd}{character string used for the plot title for the
mean/standard deviation plot when the \code{metric} argument is not NULL.}

\item{title_lab_median}{character string used for the plot title for the
mean/median plot when the \code{metric} argument is not NULL.}

\item{title_lab_size}{integer value indicating the font size of the plot
title. The default is 14.}

\item{legend_lab}{character string specifying the legend title.}

\item{legend_position}{character string specifying the position of the
legend. Can be one of "right", "left", "top", or "bottom". The default is
"right".}

\item{point_size}{integer specifying the size of the points. The default is
2.}

\item{bin_width}{integer indicating the bin width in a histogram. The default
is 0.5.}

\item{bw_theme}{logical value. If TRUE, uses the ggplot2 black and white
theme.}

\item{palette}{character string indicating the name of the RColorBrewer
palette to use. For a list of available options see the details section in
\code{\link[RColorBrewer]{RColorBrewer}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
ggplot2 plot object if interactive is FALSE, or plotly plot object if
  interactive is TRUE
}
\description{
For plotting an S3 object of type dataRes
}
\details{
This function can only create plots for dataRes objects whose 'by' =
  'molecule' and 'groupvar' attribute is non NULL
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mylipid <- edata_transform(omicsData = lipid_pos_object, data_scale = "log2")
result <- edata_summary(
  omicsData = mylipid,
  by = "molecule",
  groupvar = "Virus"
)
plot(result)
\dontshow{\}) # examplesIf}
}
