% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_plot.R
\name{classification_stability}
\alias{classification_stability}
\title{Classification instability plot}
\usage{
classification_stability(
  x,
  threshold,
  xlim,
  ylim,
  xlab,
  ylab,
  pch,
  cex,
  col,
  subset,
  plot = TRUE
)
}
\arguments{
\item{x}{an object produced by \code{\link{validate}} with method = "boot_*" (or \code{\link{boot_optimism}} with method="boot")}

\item{threshold}{estimated risks above the threshold get a predicted 'class' of 1, otherwise 0.}

\item{xlim}{x limits (default = range of estimated risks)}

\item{ylim}{y limits (default = c(0, maximum CII))}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{pch}{plotting character (default = 16)}

\item{cex}{controls point size (default = 1)}

\item{col}{color of points (default = grDevices::grey(.5, .5))}

\item{subset}{vector of observations to include (row indices). This can be used to select a random subset of observations.}

\item{plot}{if FALSE just returns CII values (see value)}
}
\value{
plots classification (in)stability.
Invisibly returns estimates of CII for each observation.
}
\description{
Classification instability plot shows the relationship between original model estimated risk
and the classification instability index (CII). The CII is the proportion of bootstrap replicates
where the predicted class (0 if p <= threshold; 1 if p > threshold) is different to that
obtained from the original model. Those with risk predictions around the threshold will exhibit
elevated CII but an unstable model will exhibit high CII across a range of risk predictions.
See Riley and Collins (2023).
}
\examples{
set.seed(456)
# simulate data with two predictors that interact
dat <- pmcalibration::sim_dat(N = 2000, a1 = -2, a3 = -.3)
mean(dat$y)
dat$LP <- NULL # remove linear predictor

# fit a (misspecified) logistic regression model
m1 <- glm(y ~ ., data=dat, family="binomial")

# internal validation of m1 via bootstrap optimism with 10 resamples
# B = 10 for example but should be >= 200 in practice
m1_iv <- validate(m1, method="boot_optimism", B=10)

classification_stability(m1_iv, threshold=.2)

}
\references{
Riley, R. D., & Collins, G. S. (2023). Stability of clinical prediction models developed using statistical or machine learning methods. Biometrical Journal, 65(8), 2200302. doi:10.1002/bimj.202200302
}
