% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_plot.R
\name{dcurve_stability}
\alias{dcurve_stability}
\title{Plot decision curve stability across bootstrap replicates}
\usage{
dcurve_stability(
  x,
  thresholds = seq(0, 0.99, by = 0.01),
  xlim,
  ylim,
  xlab,
  ylab,
  col,
  subset,
  plot = TRUE
)
}
\arguments{
\item{x}{an object produced by \code{\link{validate}} with method = "boot_*" (or \code{\link{boot_optimism}} with method="boot")}

\item{thresholds}{points at which to evaluate the decision curves (see \code{dcurves::dca})}

\item{xlim}{x limits (default = range of thresholds)}

\item{ylim}{y limits (default = range of net benefit)}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{col}{color of points (default = grDevices::grey(.5, .5))}

\item{subset}{vector of observations to include (row indices). This can be used to select a random subset of observations.}

\item{plot}{if FALSE just returns curves (see value)}
}
\value{
plots decision curve (in)stability.
Invisibly returns a list containing data for each curve. These are returned from \code{dcurves::dca}.
The first element of this list is the apparent curve (original model on original outcome).
}
\description{
A decision curve (in)stability plot shows decision curves for bootstrap
models evaluated on original outcome. A stable model should produce
curves that differ minimally from the 'apparent' curve.
See Riley and Collins (2023).
}
\examples{
\donttest{
set.seed(456)
# simulate data with two predictors that interact
dat <- pmcalibration::sim_dat(N = 2000, a1 = -2, a3 = -.3)
mean(dat$y)
dat$LP <- NULL # remove linear predictor

# fit a (misspecified) logistic regression model
m1 <- glm(y ~ ., data=dat, family="binomial")

# internal validation of m1 via bootstrap optimism with 10 resamples
# B = 10 for example but should be >= 200 in practice
m1_iv <- validate(m1, method="boot_optimism", B=10)

dcurve_stability(m1_iv)
}
}
\references{
Riley, R. D., & Collins, G. S. (2023). Stability of clinical prediction models developed using statistical or machine learning methods. Biometrical Journal, 65(8), 2200302. doi:10.1002/bimj.202200302
}
