% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildBubleyDyerEvaluationGenerator.R
\name{BuildBubleyDyerEvaluationGenerator}
\alias{BuildBubleyDyerEvaluationGenerator}
\title{Generator for the approximated computation of the mean value of functions over linear
extensions.}
\usage{
BuildBubleyDyerEvaluationGenerator(poset, seed, f1, ...)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet} representing the poset from which linear extensions are generated.
Object \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{seed}{Positive integer to initialize random linear extension generation. Set \code{seed=NULL} for random initialization.}

\item{f1}{The function whose mean value is to be computed.
\code{f1} must be an R-function having as a single parameter a linear extension of \code{poset} and returning a numerical matrix.}

\item{...}{Further functions whose mean values are to be computed.}
}
\value{
An object of S4-class \code{BuildBubleyDyerEvaluationGenerator}.
}
\description{
\code{BuildBubleyDyerEvaluationGenerator}
creates an object of S4 class \code{BuildBubleyDyerEvaluationGenerator}, for the estimation of
the mean values of the input functions, over linear extensions sampled according to the Bubley-Dyer procedure.
Actually, this function does not perform the computation of mean values, but just generates the object that will compute them
by using function \code{BubleyDyerEvaluation}.
}
\examples{
el1 <- c("a", "b", "c", "d")
el2 <- c("x", "y")
el3 <- c("h", "k")
dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos1 <- POSet(elements = el1, dom = dom)

pos2 <- LinearPOSet(elements = el2)

pos3 <- LinearPOSet(elements = el3)

pos <- ProductPOSet(pos1, pos2, pos3)

# median_distr computes the frequency distribution of median profile

elements <- POSetElements(pos)

median_distr <- function(le) {
  n <- length(elements)
  if (n \%\% 2 != 0) {
    res <- (elements == le[(n + 1) / 2])
  } else {
    res <- (elements == le[n / 2])
  }
  res <- as.matrix(res)
  rownames(res) <- elements
  colnames(res) <- "median_distr"
  return (as.matrix(res))
}

BDgen <- BuildBubleyDyerEvaluationGenerator(poset = pos, seed = NULL, median_distr)

}
