% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Fit a Model to a List of Datasets}
\usage{
fit_model(
  data_all = NULL,
  model = NULL,
  fit_function = "lavaan",
  arg_data_name = "data",
  arg_model_name = "model",
  arg_group_name = "group",
  ...,
  fit_out = NULL,
  parallel = FALSE,
  progress = FALSE,
  ncores = max(1, parallel::detectCores(logical = FALSE) - 1)
)
}
\arguments{
\item{data_all}{The output
of \code{\link[=sim_data]{sim_data()}}, or a \code{sim_data}
class object.}

\item{model}{The model to be fitted.
If \code{NULL}, the default, the model
stored in \code{data_all}, which should
be the data generation model,
will be used.}

\item{fit_function}{The function to
be used to fit the model. Can also
be a string: \code{"lavaan"} (the default) for
\code{\link[lavaan:sem]{lavaan::sem()}}, and \code{"lm"} or \code{many_lm}
for \code{\link[lmhelprs:many_lm]{lmhelprs::many_lm()}}.
Other functions can also be used
if necessary.}

\item{arg_data_name}{The name of the
argument of \code{fit_function} expecting
the dataset. Default is \code{"data"}.}

\item{arg_model_name}{The name of
the argument of \code{fit_function}
expecting the model definition.
Default is \code{"model"}.}

\item{arg_group_name}{The name of
the argument of \code{fit_function}
expecting the name of the group
variable. Used only for multigroup
models. Default is \code{"group"}.}

\item{...}{Optional arguments to be
passed to \code{fit_function} when
fitting the model.}

\item{fit_out}{If set to a \code{fit_out}
object (the output of \code{\link[=fit_model]{fit_model()}}),
then all missing arguments will be
retrieved from \code{fit_out}. That is,
users can use \code{fit_model(data_all = new_data, fit_out = old_out)}
to re-fit a model originally fitted
in \code{old_out} on a new list of dataset
(\code{new_data}). No need to include
all other arguments.}

\item{parallel}{If \code{TRUE}, parallel
processing will be used to fit the
models. Default is \code{FALSE}.}

\item{progress}{If \code{TRUE}, the progress
of model fitting will be displayed.
Default is `FALSE.}

\item{ncores}{The number of CPU
cores to use if parallel processing
is used.}
}
\value{
An object of the class \code{fit_out},
which is a list of the output of
\code{fit_function} (\code{\link[lavaan:sem]{lavaan::sem()}}
by default). If an error occurred
when fitting the model to a dataset,
then this element will be the error
message from the fit function.
}
\description{
Get the output of
\code{\link[=sim_data]{sim_data()}} and fit a model to each
of the stored datasets.
}
\details{
By default, the function \code{\link[=fit_model]{fit_model()}}
\itemize{
\item extracts the model
stored in the output of \code{\link[=sim_data]{sim_data()}},
\item fits the model to each dataset
simulated using \code{fit_function},
default to \code{"lavaan"} and
\code{\link[lavaan:sem]{lavaan::sem()}} will be called,
\item and returns the results.
}

If the datasets
were generated from a multigroup
model when calling \code{\link[=sim_data]{sim_data()}},
a multigroup model is fitted.
}
\section{The role of \code{fit_model()}}{
This function is used by the
all-in-one function \code{\link[=power4test]{power4test()}}.
Users usually do not call this
function directly, though
developers can use this function to
customize the model fitting step in
power analysis.
}

\examples{

# Specify the population model

mod <-
"m ~ x
 y ~ m + x"

# Specify the effect sizes (population parameter values)

es <-
"
y ~ m: m
m ~ x: m
y ~ x: n
"

# Generate several simulated datasets

data_all <- sim_data(nrep = 5,
                     model = mod,
                     pop_es = es,
                     n = 100,
                     iseed = 1234)

# Fit the population model to each datasets

fit_all <- fit_model(data_all)
fit_all[[1]]

# Fit the population model using the MLR estimator

fit_all_mlr <- fit_model(data_all,
                         estimator = "MLR")
fit_all_mlr[[1]]

# Fit a model different from the population model,
# with the MLR estimator

mod2 <-
"m ~ x
 y ~ m"

fit_all_mlr2 <- fit_model(data_all,
                          mod2,
                          estimator = "MLR")
fit_all_mlr2[[1]]

}
\seealso{
See \code{\link[=power4test]{power4test()}} for
the all-in-one function that uses
this function, and \code{\link[=sim_data]{sim_data()}}
for the function generating datasets
for this function.
}
